// C Source File
// Created 2/13/2004; 8:40:36 PM
#include "Definitions.h"

#include <tigcclib.h>

	asm(".ascii \"UNPACK_0\"");
// Main Function
void _main(void)
{
	//4000
	static unsigned long LofZ_Title_Screen[5][2][100]= {	//Read in EXE as LofZ_Title_Screen[5][200]
		{	//[0] (0-31)
			{	//[0] Light
				0x00000000,0x88000000,0xFF000000,0xEF800020,0x638000D3,0xE70001A5,0xF7000007,0x77800064,0x438000F4,0x73C00029,
				0x5F800071,0x7F0000B0,0xEF800020,0xD38000C0,0x83C00000,0xE3C00140,0xF3800060,0x72000010,0x420006E0,0x73C00400,
				0xE1800410,0xF7F800D0,0x778401A0,0x470E00C0,0x773E0100,0xF73C0140,0x79BE0060,0xEBBC0010,0xD39E00C8,0x831E00D0,
				0xE79E003C,0x7F1C00C0,0xEF9001C0,0xD39000C0,0x87DC0100,0xE3CE0140,0xF7BE0140,0x73BC0010,0x439E00E0,0x77DE00E0,
				0xF7DE0010,0x7FBE0070,0xE7BC01E0,0xD4DE00C0,0x83DE0100,0xE3DE0140,0xF79C0140,0x73980010,0x439000E0,0x77DC00E0,
				0xF7CE0010,0x7FBE0070,0xE3BC01E0,0xD39C0040,0x939E0020,0xE7DE0160,0x7FBE0161,0xE3BC001A,0xD39C0074,0x939E01CE,
				0xE7DE00EF,0x7FFFC095,0xE7FFE049,0xD739F040,0x9718F000,0xCF01F000,0xCF17F000,0xEBB9E000,0xD3BA7BD0,0xF1BFFFFF,
				0x3B9DEBDF,0x9B91C9CF,0x7BDDC04F,0xD7BAC7B7,0xF7BE777B,0x3B9CE87F,0x9B90EFBE,0x7FDCCAFF,0x7FFDEA7E,0x779E7EE3,
				0x53B8E4B7,0x7BB6E0F7,0x5FE2C4B7,0x5FFBECBF,0x37FFCF7F,0x77BBF5EF,0x7738F1CF,0x7F19F5C2,0xFF00FDC0,0x31BE7E77,
				0x33BE646F,0x73A6F0EC,0x7B1EF4CC,0xFF9FFDEE,0x31BFFE77,0x33BFFE6F,0x73A7C8EC,0x7B1FC0CC,0xFF9FC1EE,0x371C767E
			},
			{	//[1] Dark
				0x00000000,0x00000000,0x61000000,0x5F800020,0x9F8000BC,0x1F00006B,0x0F0000F3,0x8F800078,0xBF8000F8,0x8FC00083,
				0xAF8001C3,0x8F0000C0,0x178001D0,0x2F800040,0x7FC00080,0x1FC000F0,0x0F800030,0x8E000070,0xBE0006B0,0x8FC00780,
				0x1EC007C0,0x0C400260,0x8C7C0050,0xB8FE0040,0x88FE00C0,0x08FC00F0,0x8E7E0030,0x147C0070,0x2C7E00B8,0x7CFE00B0,
				0x187E01FE,0x88FC0074,0x13F00078,0x2FF00040,0x7FFC00C0,0x1FFE00F0,0x0FFE0030,0x8FFC0070,0xBFFE00B0,0x8FFE00A0,
				0x0FFE01C0,0x8FFE0020,0x1BFC0050,0x2FFE0040,0x7FFE00C0,0x1FFE00F0,0x0FFC0030,0x8FF80070,0xBFF000B0,0x8FFC00A0,
				0x0FFE01C0,0x8FFE0020,0x1FFC0050,0x2FFC0040,0x6FFE01C0,0x1FFE00D0,0x8FFE0053,0x1FFC0071,0x2FFC0078,0x6FFE0075,
				0x1FFE0103,0x8C58006B,0x1C3060BE,0x28FFF024,0x68FFF000,0x3FFFF000,0x77E9F000,0xFFC7E000,0xFFC5B420,0xFFC110C0,
				0xFFE31DAF,0xFFEE3FFF,0xFFE23FFF,0xFFC539FF,0xFFC18BFF,0xFFE317FF,0xFFEF11FF,0xFFE335FF,0xFFC215FF,0xFFE381FF,
				0xFFC71BFF,0xFFC91FFF,0xFFDD3BFF,0xFFC413FF,0xFC58319F,0xFC74FB1F,0xF8FFFE3F,0xF8FFFA3F,0xF8FFF23F,0xFE7FF188,
				0xFC5FFB90,0xFC7FFF13,0xFCFFFB33,0xF87FF211,0xFE7F1188,0xFC5F0990,0xFC7E3F13,0xFCFE3F33,0xF87E3E11,0xF8FF8B81
			}
		},
		{	//[1] (32-63)
			{	//[0] Light
				0x00000000,0x00000000,0x00000000,0x00001000,0x9BC6719C,0x1364711E,0x20080200,0x00000000,0x00000000,0x00000000,
				0x80000000,0x00000000,0x000001FF,0x075723FF,0x025422FF,0x0276237F,0x02573BFF,0x0000003F,0x00000000,0x00000C00,
				0x00000E00,0x00001F00,0x00003E07,0x07E07C0F,0x0FC0F81F,0x0781F000,0x0203E000,0x0007C000,0x000F803F,0x001F003F,
				0x003E007F,0x00000800,0x00000800,0x00001000,0x00001000,0x00002000,0x7FFFFFFF,0x3FFFFFFF,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x000FFFFF,0x00000000,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x80000000,0x80000000,0x00000000,0x00000000,0x19C6709C,
				0x1364791E,0x6519E773,0x20086A08,0x00004C00,0x00005800,0x00000800,0x00000000,0x00724E90,0x004A5090,0x00724CF0,
				0x00424290,0x80419C90,0x80000000,0x84300000,0xE73C0000,0x7FF20000,0x7BD70000,0x108F0000,0x000E0000,0xBEEF0000,
				0x78F60000,0x677F0000,0x65FF8000,0x74FF8000,0xF9CF0000,0xFD260000,0x3DBF0000,0x7D3F8000,0x3D7F8000,0xFEEF0000,
				0x3BEE0000,0xBF7F0000,0xFDFF8000,0xFCFF8000,0xFDCF0000,0x396E0000,0xBDBF0000,0xFD3F8000,0xFD7F8000,0xFEEF0000
			},
			{	//[1] Dark
				0x00000000,0x00000000,0x00000000,0x00005000,0x2E8B5EC2,0xB8FEFEA5,0xD5657956,0x01006018,0x00000000,0x00000000,
				0x80000000,0x00000000,0x00000000,0x0757239B,0x02542222,0x0276232B,0x02573BBB,0x00000000,0x00FFFBFF,0x01FFFDFF,
				0x03FFFFFF,0x07FFFFFF,0x0FFFFFFF,0x1FFFFDFF,0x0FFFF9FF,0x07FFF3FF,0x02FFE3FF,0x01FFC3FF,0x03FF83FF,0x07FF07FF,
				0x0FFE17FF,0x1FFFFFFF,0x3FFFFFFF,0x7FFFFFFF,0x7FFFFFFF,0x7FFFFFFF,0x7FFFFFFF,0x3FFFFFFF,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x3FFFFFFF,0x7FFFFFFF,0x003FFFFF,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x80000000,0x80000000,0x00000000,0x00000000,0x83204912,
				0xB8FE9EA5,0xD8D6B5AF,0xA4A9734A,0x01007018,0x00006C00,0x00002800,0x00000000,0x00724E90,0x004A5090,0x00724CF0,
				0x00424290,0x80419C90,0x80000000,0x80000000,0x80000000,0x909E0808,0xA53F4280,0xEF7F0011,0xFFFE3FFC,0xFFFF7FFE,
				0xFFFFFFFF,0xFBFFFFFF,0xFBFFFFFF,0xFBFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF9FFF,0xFFFF8FFF,0xFFFFCF01,
				0xFCFFEF00,0x7FFFE010,0x7FFFE078,0x7FFFF078,0xFFFFF078,0xFFFFF0FC,0x7FFFFFFE,0x7FFF9FFF,0x7FFF8FFF,0x7FFFCF01
			}
		},
		{	//[2] (64-95)
			{	//[0] Light
				0x00000000,0x00000000,0x00000000,0x00000000,0x6719C671,0x4791A66D,0x90040100,0x00000000,0x00000000,0x00000000,
				0x00000000,0x00000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0303C000,0x030FF000,
				0x030FF800,0x020FF800,0xC60FF800,0xF61FF83F,0xFE1FFC1F,0x7E1FFC1F,0xFC1FFE0F,0xFC1FFE0F,0xFC3FFE0F,0xFC3FFE0E,
				0xEC3FF60E,0x08000700,0x08000700,0x10000700,0x10000200,0x20000200,0xFFFFFFFF,0xFFFFFFFF,0x0FFFFFC0,0x07FFFF80,
				0x03FFFF80,0x03FFFF00,0x01FFFF00,0x01FFFE00,0x00FFFE00,0x00000000,0xFFFFFFFF,0x00000000,0x007FF000,0x003FF000,
				0x003FE000,0x001FE000,0x001FC000,0x000FC000,0x000F8000,0x00078000,0x00070020,0x00030040,0x00000000,0x2308C258,
				0x4791A66D,0xC8F23C8B,0x82008020,0x00000000,0x00000000,0x00000000,0x00000000,0x3B99CE0E,0x41252409,0x3125C40E,
				0x093D4409,0x7125240E,0x00000000,0x01C21000,0x03F73E00,0x07FFFF00,0x07BBDF00,0x07804F80,0x07000F80,0x019FE367,
				0x03BA777F,0x03B53773,0x0320F790,0x07B0FF80,0x019FFFF1,0x03BBEEFF,0x03B5CE3F,0x0321C67E,0x07B1C03F,0x01B467FF,
				0x0394EE39,0x0398ED3D,0x031CC87D,0x07B5EE7F,0x01BFC7FD,0x03BFCE3B,0x03B0ED3F,0x0339F87E,0x07B0FE7F,0x018C6F7F
			},
			{	//[1] Dark
				0x00000000,0x00000000,0x00000000,0x00000000,0xB48D6158,0xB94E5394,0x51B42F0F,0x02008020,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0xAB09C000,0x3A950000,0x3A95BFFF,0xAB090000,0x00000001,0xFCFC3FFF,0xFEFEFFFF,
				0xFFFE7FFF,0xFFFE3FFF,0xFFFC3FFF,0xFFFC1FFF,0xFFFC1FFF,0xC3FC1FE7,0xE3F80FF9,0xF3F80FF9,0xF3F00FF3,0xE3F007F2,
				0xF3F00FF6,0xFFFFFFFF,0xFFFFFBFF,0xFFFFFBFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x010004C0,0x01800480,
				0x00800980,0x00C00900,0x00401300,0x00601200,0x00202600,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00189000,0x0008B000,
				0x000D2000,0x00056000,0x00024000,0x0000C000,0x00008000,0x00018000,0x00010030,0x00030070,0x00000030,0x44912425,
				0xB94E5394,0x6BFAFEBB,0xD294E53D,0x00000000,0x00000000,0x00000000,0x00000000,0x3B99CE0E,0x41252409,0x3125C40E,
				0x093D4409,0x7125240E,0x00000000,0x00000000,0x00000000,0x0012DF00,0x0056BF00,0x407FBF80,0x00FFFF80,0x7E63FF80,
				0xFC45FFB1,0xFC4BFFAD,0xFCDFFFEF,0xF84FFFFF,0xFE63160E,0xFC451D3C,0xFC4A3FFC,0xF4DE3FFD,0xE04E3FFC,0x8E4B98FC,
				0x0C6B11FE,0x0C6712FE,0x0CE337FE,0x184A11FC,0x1E6238FE,0x3C6071FC,0xFC4FF2FC,0xF4C7F7FD,0xE04FF1FC,0x8E73F0C5
			}
		},
		{	//[3] (96-127)
			{	//[0] Light
				0x00000000,0x00000000,0x00000000,0x00000000,0x9C278DE7,0x9B26C9B2,0x44501003,0x1E000000,0x16000000,0x00000002,
				0x00000006,0x00000000,0xFC000000,0xFC000000,0xFC000000,0xF8000000,0xF8000000,0xF0000000,0x30000000,0x0C000000,
				0x0C000000,0x06000000,0x06000000,0x02000000,0x82000000,0x83000000,0xC3080000,0xC10C0000,0xC10E0000,0xC1030000,
				0x81000001,0x01800000,0x03800000,0x03800000,0x07800000,0x1703FC00,0xE7FFFFF0,0xC7C07F80,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0x00006000,0x00009000,0x000288A8,0xFFF864A8,0x000492A8,0x00060A00,0x00000500,
				0x0000E500,0x00001A00,0x00000700,0x00000200,0x00000000,0x00000004,0x00000106,0x00000301,0x00000780,0x8C238C61,
				0x9B26C9B3,0x2ACA328A,0x00401006,0x00000000,0x00000000,0x00000000,0x00000000,0x25DCC900,0x24892900,0x24892D00,
				0x24892B00,0x1888C900,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x3C01F39C,
				0xE203FFFF,0x8707BDEF,0x9F078842,0x1E078000,0xF7DF9F73,0x9EFFFC7B,0x7CE3F3BD,0x3C27F2FF,0xBC03FA7B,0xE7B9DEFB,
				0xC6F9BDE7,0x0EDBF395,0xCC7BF397,0xDE3FFBD3,0xE7BFFDD7,0x86BFFCC5,0x6EE79E26,0x2CE13EE4,0xBEE01FC5,0xFFE3FFD3
			},
			{	//[1] Dark
				0x00000000,0x00000000,0x00000000,0x00000000,0x765D1740,0xC571DC7F,0xFFBAEAB7,0x1B020080,0x17000000,0x1C000003,
				0x0C000007,0x00000000,0x00000000,0x04000000,0x0C000000,0x88000000,0x98000000,0x10000000,0xF3E00000,0xEFF00000,
				0xFFF80000,0xFFFC0000,0xFFFE0000,0xFFFF0000,0xFFFF8000,0xFFFFC000,0xFFFFE000,0xFFFFF000,0xFFFFF800,0xFFFBFC00,
				0xFFFFFE01,0xFFFFFF00,0xFFFFFF80,0xFFFFFFC0,0xFFFFFFE0,0xF7FFFFF0,0xE7FFFFF0,0xC7C07F80,0x00000000,0x00000000,
				0x00000000,0x00000000,0x00000000,0x00006000,0x00009000,0xFFFFFFF8,0xFFFFFFF8,0xFFFFFFF8,0x00078A10,0x00018510,
				0x0001E720,0x0000DE60,0x00006740,0x00003F80,0x00000000,0x00000004,0x00000107,0x000001C2,0x000007C0,0x1B064396,
				0xC571DE7F,0x86A1AC6F,0x67595254,0x00020080,0x00000000,0x00000000,0x00000000,0x25DCC900,0x24892900,0x24892D00,
				0x24892B00,0x1888C900,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
				0x9E00084A,0x7F00529C,0x7F0077BD,0xFE007FFF,0x390063FF,0x7121C3FF,0x835FCDFF,0xC3DFCDFF,0x43FFC5FF,0x18FFE31F,
				0x393FC21B,0xF1FFCC6F,0x33FFCC6F,0x21FFC42F,0x38CB022F,0x79C60F3F,0x911F7FDF,0xD31FFF1F,0x411FFE3F,0x8C1C7E2C
			}
		},
		{	//[4] (128-159)
			{	//[0] Light
				0x00000000,0x000001E1,0x000001FB,0x000003DD,0x360003C8,0x140003BE,0x8200033E,0x980001AE,0xB800018E,0x580001DF,
				0x180003AE,0x3400032E,0x100001AA,0x2800010B,0x100001CB,0x040003BE,0x3400033E,0x300001AE,0x2000010E,0x180001DF,
				0x080003AE,0x1000032E,0x1C0001AA,0x2800010B,0x200001CB,0x040000CF,0x34001F9E,0x30003FCE,0xE00079CE,0x80007BFF,
				0x180071FF,0x300067CE,0x3C0075CA,0x280061CB,0x20003BEB,0x04003BEF,0x160067DE,0x300075CE,0x200061CE,0x00003BFF,
				0x08007BFF,0x180067CE,0x1C0075CE,0x280061CB,0x20003BEB,0x04003BEF,0x160067DE,0x300075CE,0x200061CE,0x00003BFF,
				0x08003BFF,0x180067CE,0x1C0075CE,0x080061CB,0x300031C9,0x1C003BEF,0x1E0067DE,0x700075CE,0xB80061CE,0x480031CE,
				0x1C003BFF,0xA403FF9E,0x5807FF9E,0x180F71D7,0x000F33EF,0x000E01EF,0x000EEFCE,0x000EF1CE,0x000EF3CE,0x000C9BC6,
				0x000EF8EE,0x00047AEE,0x000771EF,0x1E0E71DE,0x3F8319DE,0x3E4F794E,0x386F796E,0x39EE717F,0x39CF79FF,0xF9E319DE,
				0xFCCF794E,0x7DEF796E,0x3FFE717F,0x3FFF79FF,0x9FFFF3C6,0xF9FEF8EE,0xF1CE7AEE,0xF8847DEF,0xF0007DFF,0x8DFFFBC6,
				0x99CE7BC6,0xF9AD7AEE,0xF9287DEF,0xF9AC7DFF,0x0CFFFF9F,0x98FFFF9F,0xF98E71DC,0xF9C423E8,0xF98001E0,0xFFC73BCF
			},
			{	//[1] Dark
				0x00000000,0x00000000,0x00000008,0x0000002B,0xEE000037,0x6000007F,0x3C0000FF,0x7800007F,0x7800007F,0x2800003F,
				0x2E00007F,0x0E0000FF,0x0E00007F,0x340000FF,0x3800003F,0x3000007F,0x080000FF,0x0C00007F,0x100000FF,0x2800003F,
				0x2600007F,0x0E0000FF,0x0E00007F,0x340000FF,0x3800003F,0x3000003F,0x0800007F,0x0C0001FF,0xD00007FF,0xF00007FF,
				0xE6000FFF,0xFE001FFF,0x9E000FFF,0x34001FFF,0x380007FF,0x300007FF,0x18001FFF,0x0C000FFF,0x10001FFF,0x300007FF,
				0x260007FF,0x0C001FFF,0x0E000FFF,0x34001FFF,0x380007FF,0x300007FF,0x18001FFF,0x0C000FFF,0x10001FFF,0x300007FF,
				0x260007FF,0x0C001FFF,0x0E000FFF,0x0A001FFF,0x2E000FFF,0x280007FF,0x08001FFF,0x2C000FFF,0x78001FFF,0x3A000FFF,
				0x600007FF,0x5000607F,0xEE0060EF,0x1800EFFF,0x0000EFFF,0x0001FFFF,0x000197FF,0x00018FFF,0x00018FFF,0x0003E7FF,
				0x000187FF,0x000387FF,0x00008FFF,0x00018FFF,0x000CE7FF,0x01C087FF,0x07E087FF,0x07E18FFF,0x07C087FF,0x07FCE7FF,
				0x5FF087FF,0xFFF087FF,0xFFF18FFF,0xFFF087FF,0xE78C0FFF,0xC78D3FFF,0xCFBDFFFF,0xC7FFFFFF,0xCFFFFFFF,0xF230FFFF,
				0xE631FDFF,0xC652FFFF,0xC6D7FFFF,0xC653FFFF,0xF33C6068,0xE70C60F8,0xC67DEFFB,0xC63FFFFF,0xC67FFFFF,0xF03FFFF1
			}
		}
	};
	
	//2880
	static unsigned long LofZ_Triforce[4][2][2][45]= {	//Read in EXE as LofZ_Triforce[4][2][90]
		{	//[0] White
			{	//[0] (0-31)
				{	//[0] Light
					0x00000000,0xCDD584E0,0x111D4A80,0x959D4ADF,0xDDD58480,0x00000000,0x00000000,0x00010778,0x0001873C,
					0x8001071C,0x03E3061C,0x07FB0E0C,0x0FFF0E0E,0x00210E0E,0x00700C07,0x00780C07,0x1FF81807,0x1FF01803,
					0x3FF01803,0x00040003,0x00040001,0x00080001,0x00080001,0x00100001,0xFFFFFFFF,0xFFFFFFFF,0x00008002,
					0x0000C002,0x00004004,0x00006004,0x00002009,0x00003009,0x00001013,0x00000000,0xFFFFFFFF,0x00000000,
					0x00000C48,0x00000458,0x00000690,0x000002B0,0x00000120,0x00000060,0x00000040,0x000000C0,0x00000080
				},
				{	//[1]_Dark
					0x00000000,0xCDD584E0,0x111D4A80,0x959D4ADF,0xDDD58480,0x00000000,0xFFFE7E1F,0xFFFF7F7F,0xFFFFFF3F,
					0xFFFFFF1F,0xFFFFFE1F,0xFFFFFE0F,0xFFFFFE0F,0xFFE1FE0F,0xFFF1FC07,0xFFF9FC07,0xFFF9F807,0xFFF1F803,
					0xFFF9F807,0xFFFFFFFF,0xFFFFFFFD,0xFFFFFFFD,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00008002,
					0x0000C002,0x00004004,0x00006004,0x00002009,0x00003009,0x00001013,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x00000C48,0x00000458,0x00000690,0x000002B0,0x00000120,0x00000060,0x00000040,0x000000C0,0x00000080
				}
			},
			{	//[1] (32-63)
				{	//[0] Light
					0x00000000,0x00020000,0x00060000,0xFFC40000,0x004C0000,0x00880000,0x00180000,0x00060000,0x00060000,
					0x00030000,0x00030000,0x1F810000,0x0FC10000,0x03C18000,0x04E18400,0x04E08600,0x01E08700,0x01608180,
					0x03408000,0x8000C000,0x8001C000,0x8001C000,0x0003C000,0x000B81FE,0xFFF3FFFF,0xFFE3E03F,0x60000000,
					0x40000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0x00000144,0xFFFFFC32,0x00000249,
					0x00000305,0x00000002,0x00000072,0x0000000D,0x00000003,0x00000001,0x00000000,0x00000000,0x10000000
				},
				{	//[1] Dark
					0x00000000,0x00020000,0x00060000,0xFFC40000,0x004C0000,0x00880000,0xFFF9F000,0xFFF7F800,0xFFFFFC00,
					0xFFFFFE00,0xFFFFFF00,0xFFFFFF80,0xFFFFFFC0,0xF3FFFFE0,0xFCFFFFF0,0xFCFFFFF8,0xF9FFFFFC,0xF97FFDFE,
					0xFB7FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFBFFFF,0xFFF3FFFF,0xFFE3E03F,0x60000000,
					0x40000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x000003C5,0x000000C2,0x000000F3,0x0000006F,0x00000033,0x0000001F,0x00000000,0x00000000,0x18000000
				}
			}
		},
		{	//[1] Light_Gray
			{	//[0] (0-31)
				{	//[0] Light
					0xFFFFFFFF,0xFFFFFFFF,0x7FFFFFFF,0xBFFFFFFF,0xFFFFFFFF,0x1FFFFFFF,0x000181E0,0x000187F8,0x000187FC,
					0x800107FC,0x03E307FC,0x07FB0FFC,0x0FFF0FFE,0x003F0FFE,0x007E0FFF,0x007E0FFF,0x1FFE1FFF,0x1FFE1FFF,
					0x3FF61FFB,0x00040003,0x00040003,0x00080003,0x00080001,0x00100001,0xFFFFFFFF,0xFFFFFFFF,0x0007FFFF,
					0x0003FFFF,0x0001FFFF,0x0001FFFF,0x0000FFFF,0x0000FFFF,0x00007FFF,0x00000000,0xFFFFFFFF,0x00000000,
					0x00003FF8,0x00001FF8,0x00001FF0,0x00000FF0,0x00000FE0,0x000007E0,0x000007C0,0x000003C0,0x00000380
				},
				{	//[1]_Dark
					0x00000000,0xCDD584E0,0x111D4A80,0x959D4ADF,0xDDD58480,0x00000000,0xFFFE7E1F,0xFFFF7F7F,0xFFFFFF3F,
					0xFFFFFF1F,0xFFFFFE1F,0xFFFFFE0F,0xFFFFFE0F,0xFFE1FE0F,0xFFF1FC07,0xFFF9FC07,0xFFF9F807,0xFFF1F803,
					0xFFF9F807,0xFFFFFFFF,0xFFFFFFFD,0xFFFFFFFD,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00008002,
					0x0000C002,0x00004004,0x00006004,0x00002009,0x00003009,0x00001013,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x00000C48,0x00000458,0x00000690,0x000002B0,0x00000120,0x00000060,0x00000040,0x000000C0,0x00000080
				}
			},
			{	//[1] (32-63)
				{	//[0] Light
					0xFFFE0000,0xFFFE0000,0xFFFE0000,0xFFFC0000,0xFFFC0000,0xFFF80000,0x00180000,0x00060000,0x00060000,
					0x00030000,0x00030000,0x1F810000,0x0FC10000,0x0FC18000,0x07E18400,0x07E08600,0x07E08700,0x07608180,
					0x07408000,0x8000C000,0x8001C000,0x8001C000,0x0003C000,0x000B81FE,0xFFF3FFFF,0xFFE3E03F,0xE0000000,
					0xC0000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0x00000144,0xFFFFFC32,0x00000249,
					0x00000305,0x00000002,0x00000072,0x0000000D,0x00000003,0x00000001,0x00000000,0x00000000,0x10000000
				},
				{	//[1] Dark
					0x00000000,0x00020000,0x00060000,0xFFC40000,0x004C0000,0x00880000,0xFFF9F000,0xFFF7F800,0xFFFFFC00,
					0xFFFFFE00,0xFFFFFF00,0xFFFFFF80,0xFFFFFFC0,0xF3FFFFE0,0xFCFFFFF0,0xFCFFFFF8,0xF9FFFFFC,0xF97FFDFE,
					0xFB7FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFBFFFF,0xFFF3FFFF,0xFFE3E03F,0x60000000,
					0x40000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x000003C5,0x000000C2,0x000000F3,0x0000006F,0x00000033,0x0000001F,0x00000000,0x00000000,0x18000000
				}
			}
		},
		{	//[2] Dark_Gray
			{	//[0] (0-31)
				{	//[0] Light
					0x00000000,0xCDD584E0,0x111D4A80,0x959D4ADF,0xDDD58480,0x00000000,0x00000000,0x00010778,0x0001873C,
					0x8001071C,0x03E3061C,0x07FB0E0C,0x0FFF0E0E,0x00210E0E,0x00700C07,0x00780C07,0x1FF81807,0x1FF01803,
					0x3FF01803,0x00040003,0x00040001,0x00080001,0x00080001,0x00100001,0xFFFFFFFF,0xFFFFFFFF,0x00008002,
					0x0000C002,0x00004004,0x00006004,0x00002009,0x00003009,0x00001013,0x00000000,0xFFFFFFFF,0x00000000,
					0x00000C48,0x00000458,0x00000690,0x000002B0,0x00000120,0x00000060,0x00000040,0x000000C0,0x00000080
				},
				{	//[1] Dark
					0xFFFFFFFF,0xFFFFFFFF,0x7FFFFFFF,0xBFFFFFFF,0xFFFFFFFF,0x1FFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0007FFFF,
					0x0003FFFF,0x0001FFFF,0x0001FFFF,0x0000FFFF,0x0000FFFF,0x00007FFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x00003FF8,0x00001FF8,0x00001FF0,0x00000FF0,0x00000FE0,0x000007E0,0x000007C0,0x000003C0,0x00000380
				}
			},
			{	//[1] (32-63)
				{	//[0] Light
					0x00000000,0x00020000,0x00060000,0xFFC40000,0x004C0000,0x00880000,0x00180000,0x00060000,0x00060000,
					0x00030000,0x00030000,0x1F810000,0x0FC10000,0x03C18000,0x04E18400,0x04E08600,0x01E08700,0x01608180,
					0x03408000,0x8000C000,0x8001C000,0x8001C000,0x0003C000,0x000B81FE,0xFFF3FFFF,0xFFE3E03F,0x60000000,
					0x40000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0x00000144,0xFFFFFC32,0x00000249,
					0x00000305,0x00000002,0x00000072,0x0000000D,0x00000003,0x00000001,0x00000000,0x00000000,0x10000000
				},
				{	//[1] Dark
					0xFFFE0000,0xFFFE0000,0xFFFE0000,0xFFFC0000,0xFFFC0000,0xFFF80000,0xFFF9F000,0xFFF7F800,0xFFFFFC00,
					0xFFFFFE00,0xFFFFFF00,0xFFFFFF80,0xFFFFFFC0,0xFFFFFFE0,0xFFFFFFF0,0xFFFFFFF8,0xFFFFFFFC,0xFF7FFDFE,
					0xFF7FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFBFFFF,0xFFF3FFFF,0xFFE3E03F,0xE0000000,
					0xC0000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x000003C5,0x000000C2,0x000000F3,0x0000006F,0x00000033,0x0000001F,0x00000000,0x00000000,0x18000000
				}
			}
		},
		{	//[3] Black
			{	//[0] (0-31)
				{	//[0] Light
					0xFFFFFFFF,0xFFFFFFFF,0x7FFFFFFF,0xBFFFFFFF,0xFFFFFFFF,0x1FFFFFFF,0x000181E0,0x000187F8,0x000187FC,
					0x800107FC,0x03E307FC,0x07FB0FFC,0x0FFF0FFE,0x003F0FFE,0x007E0FFF,0x007E0FFF,0x1FFE1FFF,0x1FFE1FFF,
					0x3FF61FFB,0x00040003,0x00040003,0x00080003,0x00080001,0x00100001,0xFFFFFFFF,0xFFFFFFFF,0x0007FFFF,
					0x0003FFFF,0x0001FFFF,0x0001FFFF,0x0000FFFF,0x0000FFFF,0x00007FFF,0x00000000,0xFFFFFFFF,0x00000000,
					0x00003FF8,0x00001FF8,0x00001FF0,0x00000FF0,0x00000FE0,0x000007E0,0x000007C0,0x000003C0,0x00000380
				},
				{	//[1] Dark
					0xFFFFFFFF,0xFFFFFFFF,0x7FFFFFFF,0xBFFFFFFF,0xFFFFFFFF,0x1FFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0007FFFF,
					0x0003FFFF,0x0001FFFF,0x0001FFFF,0x0000FFFF,0x0000FFFF,0x00007FFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x00003FF8,0x00001FF8,0x00001FF0,0x00000FF0,0x00000FE0,0x000007E0,0x000007C0,0x000003C0,0x00000380
				}
			},
			{	//[1] (32-63)
				{	//[0] Light
					0xFFFE0000,0xFFFE0000,0xFFFE0000,0xFFFC0000,0xFFFC0000,0xFFF80000,0x00180000,0x00060000,0x00060000,
					0x00030000,0x00030000,0x1F810000,0x0FC10000,0x0FC18000,0x07E18400,0x07E08600,0x07E08700,0x07608180,
					0x07408000,0x8000C000,0x8001C000,0x8001C000,0x0003C000,0x000B81FE,0xFFF3FFFF,0xFFE3E03F,0xE0000000,
					0xC0000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0x00000144,0xFFFFFC32,0x00000249,
					0x00000305,0x00000002,0x00000072,0x0000000D,0x00000003,0x00000001,0x00000000,0x00000000,0x10000000
				},
				{	//[1] Dark
					0xFFFE0000,0xFFFE0000,0xFFFE0000,0xFFFC0000,0xFFFC0000,0xFFF80000,0xFFF9F000,0xFFF7F800,0xFFFFFC00,
					0xFFFFFE00,0xFFFFFF00,0xFFFFFF80,0xFFFFFFC0,0xFFFFFFE0,0xFFFFFFF0,0xFFFFFFF8,0xFFFFFFFC,0xFF7FFDFE,
					0xFF7FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFBFFFF,0xFFF3FFFF,0xFFE3E03F,0xE0000000,
					0xC0000000,0xC0000000,0x80000000,0x80000000,0x00000030,0x00000048,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
					0x000003C5,0x000000C2,0x000000F3,0x0000006F,0x00000033,0x0000001F,0x00000000,0x00000000,0x18000000
				}
			}
		}
	};
	
	//1000
	static unsigned long LofZ_Waterfall[5][2][25]= {	//Read in EXE as LofZ_Waterfall[5][50]
		{	//[0] Animation 1
			{	//[0] Light
				0x00000FFF,0x00000F77,0x00000F00,0x00000E00,0x0000033F,0x00000774,0x0000076A,0x00000641,0x00000F61,0x0000033F,
				0x00000777,0x0000076B,0x00000643,0x00000F63,0x00000368,0x00000729,0x00000731,0x00000639,0x00000F6B,0x0000037F,
				0x0000077F,0x00000761,0x00000673,0x00000F61,0x00000318
			},
			{	//[1] Dark
				0x44208025,0x900850AD,0x000000FF,0x7FF8E1FF,0xC0FFFCC7,0x0000088B,0x00000897,0x800009BF,0xE180709F,0xFBC3FCC6,
				0xFFFFF88A,0xFFFFF894,0xFFFFF9BC,0xFFFFE09C,0x3FFFCC97,0x3F0F98D6,0x9C0018CE,0x8C0019C6,0xC0601094,0xC0F03CC4,
				0xC0F038C0,0xE1F8789F,0xFFFFF98F,0xFFFFF09F,0xFFFFFCE7
			}
		},
		{	//[1] Animation 2
			{	//[0] Light
				0x00000FFF,0x00000F77,0x00000F00,0x00000E00,0x0000033F,0x00000774,0x0000076A,0x00000641,0x00000F61,0x0000033F,
				0x00000777,0x0000076B,0x00000643,0x00000F63,0x00000368,0x00000729,0x00000731,0x00000639,0x00000F6B,0x0000037F,
				0x0000077F,0x00000761,0x00000673,0x00000F61,0x00000318
			},
			{	//[1] Dark
				0x44208025,0x900850AD,0x000000FF,0x7FF8E1FF,0xFFFFFCC7,0xFFFFF88B,0xC0FFF897,0x000009BF,0x0000009F,0x80000CC6,
				0xE180788A,0xFBC3F894,0xFFFFF9BC,0xFFFFF09C,0xFFFFFC97,0xFFFFE8D6,0x3FFFC8CE,0x3F0F99C6,0x9C001094,0x8C001CC4,
				0xC06018C0,0xC0F0389F,0xC0F0398F,0xE1F8709F,0xFFFFFCE7
			}
		},
		{	//[2] Animation 3
			{	//[0] Light
				0x00000FFF,0x00000F77,0x00000F00,0x00000E00,0x0000033F,0x00000774,0x0000076A,0x00000641,0x00000F61,0x0000033F,
				0x00000777,0x0000076B,0x00000643,0x00000F63,0x00000368,0x00000729,0x00000731,0x00000639,0x00000F6B,0x0000037F,
				0x0000077F,0x00000761,0x00000673,0x00000F61,0x00000318
			},
			{	//[1] Dark
				0x44208025,0x900850AD,0x000000FF,0x7FF8E1FF,0xFFFFFCC7,0xFFFFF88B,0xFFFFF897,0xFFFFF9BF,0x7FFFE09F,0x003C0CC6,
				0x0000088A,0xC0000894,0xE00019BC,0xE018109C,0xF03C3C97,0xFFFF38D6,0xFFFFF8CE,0xFFFFF9C6,0xFFFFE094,0x3FFFCCC4,
				0x3F0F98C0,0x9C00189F,0x8C00198F,0xC060109F,0xC0F03CE7
			}
		},
		{	//[3] Animation 4
			{	//[0] Light
				0x00000FFF,0x00000F77,0x00000F00,0x00000E00,0x0000033F,0x00000774,0x0000076A,0x00000641,0x00000F61,0x0000033F,
				0x00000777,0x0000076B,0x00000643,0x00000F63,0x00000368,0x00000729,0x00000731,0x00000639,0x00000F6B,0x0000037F,
				0x0000077F,0x00000761,0x00000673,0x00000F61,0x00000318
			},
			{	//[1] Dark
				0x08081025,0x428020AD,0x001100FF,0x000001FF,0x3F81ECC7,0xFFFFF88B,0xFFFFF897,0xFFFFF9BF,0xFFFFF09F,0xFFFFFCC6,
				0x7FFFE88A,0x003C0894,0x000009BC,0xC000009C,0xE0001C97,0xE01818D6,0xF03C38CE,0xFFFF39C6,0xFFFFF094,0xFFFFFCC4,
				0xFFFFE8C0,0x3FFFC89F,0x3F0F998F,0x9C00109F,0x8C001CE7
			}
		},
		{	//[4] Animation 5
			{	//[0] Light
				0x00000FFF,0x00000F77,0x00000F00,0x00000E00,0x0000033F,0x00000774,0x0000076A,0x00000641,0x00000F61,0x0000033F,
				0x00000777,0x0000076B,0x00000643,0x00000F63,0x00000368,0x00000729,0x00000731,0x00000639,0x00000F6B,0x0000037F,
				0x0000077F,0x00000761,0x00000673,0x00000F61,0x00000318
			},
			{	//[1] Dark
				0x08081025,0x428020AD,0x001100FF,0x000001FF,0x80000CC7,0xE180788B,0xFBC3F897,0xFFFFF9BF,0xFFFFF09F,0xFFFFFCC6,
				0xFFFFF88A,0xFFFFF894,0x7FFFE9BC,0x003C009C,0x00000C97,0xC00008D6,0xE00018CE,0xE01819C6,0xF03C3094,0xFFFF3CC4,
				0xFFFFF8C0,0xFFFFF89F,0xFFFFE98F,0x3FFFC09F,0x3F0F9CE7
			}
		}
	};

	//6876
	static unsigned short Map_Tiles[191][2][9]= {	//Read in EXE and DLL as Map_Tiles[191][18]
		{	//[0]Null
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[0]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[1]Dark
		},
		{	//[1]Cave
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[2]Sand
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[0]Light
			{0x8000,0x1000,0x0100,0x8000,0x1000,0x4000,0x0080,0x0400,0x2000}	//[1]Dark
		},
		{	//[3]Dock
			{0xF780,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFBC0},	//[0]Light
			{0x0840,0x4A40,0x0840,0x0840,0x0840,0x0840,0x4A40,0x0840,0xFFC0}	//[1]Dark
		},
		{	//[4]Ladder
			{0xFFC0,0xC0C0,0xC0C0,0xFFC0,0xC0C0,0xC0C0,0xFFC0,0xC0C0,0xC0C0},	//[0]Light
			{0x7F40,0x7F40,0x7F40,0x7F40,0x7F40,0x7F40,0x7F40,0x7F40,0x7F40}	//[1]Dark
		},
		{	//[5]Ladder_RIP
			{0x6040,0x7F40,0x7F40,0x6040,0x7F40,0x7F40,0x6040,0x7F40,0x7F40},	//[0]Light
			{0xE0C0,0xC0C0,0xC0C0,0xE0C0,0xC0C0,0xC0C0,0xE0C0,0xC0C0,0xC0C0}	//[1]Dark
		},
		{	//[6]Dark Path
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0},	//[0]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[1]Dark
		},
		{	//[7]Stair
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0},	//[0]Light
			{0xFFC0,0x9FC0,0x93C0,0x9240,0x9240,0x9240,0x9240,0x9240,0xFFC0}	//[1]Dark
		},
		{	//[8]Water_Null_Dry (W_0_D)
			{0xFFC0,0xEF80,0xFFC0,0xBDC0,0xFFC0,0xFFC0,0xEF40,0xFFC0,0x7BC0},	//[0]Light
			{0x0000,0x1040,0x0000,0x4200,0x0000,0x0000,0x1080,0x0000,0x8400}	//[1]Dark
		},
		{	//[9]Water_North_Dry (W_N_D)
			{0xCD80,0xFFC0,0xFFC0,0xFFC0,0xF780,0xDEC0,0xFFC0,0xFFC0,0x7BC0},	//[0]Light
			{0xCD80,0xFFC0,0x3340,0x0000,0x0840,0x2100,0x0000,0x0000,0x8400}	//[1]Dark
		},
		{	//[10]Water_West_Dry (W_W_D)
			{0x3FC0,0x7F40,0x7FC0,0x75C0,0x7FC0,0xFBC0,0xFFC0,0x5F40,0x7FC0},	//[0]Light
			{0x2000,0x6080,0x4000,0x0A00,0x0000,0x0400,0x0000,0x2080,0x0000}	//[1]Dark
		},
		{	//[11]Water_South_Dry (W_S_D)
			{0xFFC0,0xFEC0,0xEFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0x7EC0,0xE700},	//[0]Light
			{0x0000,0x0100,0x1000,0x0000,0x0840,0x0000,0x0000,0x8100,0x0000}	//[1]Dark
		},
		{	//[12]Water_East_Dry (W_E_D)
			{0xFDC0,0xBFC0,0xFB80,0xFF00,0xDD00,0xFF80,0xFF80,0xBBC0,0xFFC0},	//[0]Light
			{0x0240,0x4040,0x0400,0x0000,0x2200,0x0080,0x0080,0x44C0,0x0040}	//[1]Dark
		},
		{	//[13]Water_North_West_Dry (W_NW_D)
			{0x06C0,0x0FC0,0x7FC0,0x3EC0,0x7FC0,0xEFC0,0xFDC0,0xFF80,0xBFC0},	//[0]Light
			{0x06C0,0x0FC0,0x7840,0x2100,0x4000,0xD000,0x8200,0x0040,0x4000}	//[1]Dark
		},
		{	//[14]Water_South_West_Dry (W_SW_D)
			{0xDFC0,0xFF40,0x7FC0,0x6FC0,0x3DC0,0x1F80,0x3FC0,0x7B40,0x0600},	//[0]Light
			{0x2000,0x0080,0x0000,0x1000,0x0200,0x0040,0x2000,0x6400,0x0000}	//[1]Dark
		},
		{	//[15]Water_South_East_Dry (W_SE_D)
			{0xFD80,0xFF80,0xDFC0,0xFFC0,0xF680,0x7F00,0xFF00,0x5780,0xA000},	//[0]Light
			{0x0280,0x0080,0x20C0,0x0040,0x0900,0x8000,0x0100,0xA180,0x0000}	//[1]Dark
		},
		{	//[16]Water_North_East_Dry (W_NE_D)
			{0x4C00,0xFF80,0xFF00,0xEF00,0xFF80,0xFBC0,0xDFC0,0xFE80,0x7F80},	//[0]Light
			{0x4C00,0xFF80,0x0100,0x1000,0x0080,0x0440,0x2040,0x0100,0x8000}	//[1]Dark
		},
		{	//[17]Water_NorthEast_Inverted (W_NE_I)
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0080,0x0000,0x0000,0x0000},	//[0]Light
			{0x07C0,0x02C0,0x00C0,0x0040,0x0040,0x00C0,0x0000,0x0000,0x0000}	//[1]Dark
		},
		{	//[18]Water_NorthWest_Inverted (W_NW_I)
			{0x0000,0x0000,0x0000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[0]Light
			{0xF800,0xE000,0x8000,0xC000,0x8000,0x8000,0x0000,0x0000,0x0000}	//[1]Dark
		},
		{	//[19]Water_SouthEast_Inverted (W_SE_I)
			{0x0000,0x0000,0x0000,0x0000,0x0040,0x0080,0x0080,0x0180,0x0600},	//[0]Light
			{0x0000,0x0000,0x0000,0x0000,0x0040,0x00C0,0x00C0,0x01C0,0x07C0}	//[1]Dark
		},
		{	//[20]Water_SouthWest_Inverted (W_SW_I)
			{0x0000,0x0000,0x0000,0x8000,0x8000,0x4000,0x4000,0x7000,0x0800},	//[0]Light
			{0x0000,0x0000,0x0000,0x8000,0x8000,0xC000,0xC000,0xF000,0xF800}	//[1]Dark
		},
		{	//[21]Ladder_Dungeon (L_D)
			{0x0000,0x0000,0xFFC0,0x0000,0x0000,0xFFC0,0x0000,0x0000,0xFFC0},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0x0000}	//[1]Dark
		},
		{	//[22]Dungeon_Sand (D_Sand)
			{0x7FC0,0xEFC0,0xFEC0,0x7FC0,0xEFC0,0xBFC0,0xFF40,0xFBC0,0xDFC0},	//[0]Light
			{0x8000,0x1000,0x0100,0x8000,0x1000,0x4000,0x0080,0x0400,0x2000}	//[1]Dark
		},
		{	//[23]Dungeon_Tile (D_Tile)
			{0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0xFF80},	//[0]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[1]Dark
		},
		{	//[24]East_4_Door (E_4_D)
			{0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0xFFC0},	//[0]Light
			{0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0,0x07C0}	//[1]Dark
		},
		{	//[25]EastEast_5_Door (EE_5_D)
			{0x60C0,0x6080,0x67C0,0x6300,0x6200,0x67C0,0x60C0,0x6080,0x67C0},	//[0]Light
			{0xBF80,0xBFC0,0xBFC0,0xBEC0,0xBFC0,0xBFC0,0xBF80,0xBFC0,0xBFC0}	//[1]Dark
		},
		{	//[26]West_4_Door (W_4_D)
			{0xF840,0xF840,0xF840,0xF840,0xF840,0xF840,0xF840,0xF840,0xFF80},	//[0]Light
			{0xF800,0xF800,0xF800,0xF800,0xF800,0xF800,0xF800,0xF800,0xF800}	//[1]Dark
		},
		{	//[27]WestWest_5_Door (WW_5_D)
			{0x1980,0x1180,0xF980,0x6180,0x4180,0xF980,0x1980,0x1180,0xF980},	//[0]Light
			{0xF740,0xFF40,0xFF40,0xDF40,0xFF40,0xFF40,0xF740,0xFF40,0xFF40}	//[1]Dark
		},
		{	//[28]Dungeon_Water (D_W)
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[29]Rock_Null (R_0)
			{0x3D80,0x1CC0,0x9900,0x18C0,0x3940,0x3900,0xF340,0x4240,0xCEC0},	//[0]Light
			{0xEBC0,0xFB80,0x77C0,0xF740,0xF6C0,0xF6C0,0x4EC0,0xBFC0,0xB780}	//[1]Dark
		},
		{	//[30]Rock_North (R_N)
			{0x1000,0x0880,0x0840,0x8E40,0x9C40,0x84C0,0x8840,0x8700,0xCC40},	//[0]Light
			{0x3000,0x7980,0xFBC0,0x7DC0,0x7B80,0xFB80,0x7FC0,0xFDC0,0xFBC0}, //[1]Dark
		},
		{	//[31]Rock_North_Cave (R_N_C)
			{0xDFC0,0x8EC0,0x0C40,0x8E40,0x9C40,0x84C0,0x8840,0x8700,0xCC40},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0x7DC0,0x7B80,0xFB80,0x7FC0,0xFDC0,0xFBC0}	//[1]Dark
		},
		{	//[32]Snail
			{0x1000,0x0800,0x0880,0x1000,0x15C0,0x1540,0x1340,0x10C0,0x7F80}, //[0]Light
			{0x3000,0x7800,0xBF80,0xBFC0,0xFFC0,0x7FC0,0x7FC0,0xFFC0,0x7F80}	//[1]Dark
		},
		{	//[33]Bush
			{0x0600,0x1380,0x00C0,0x2540,0x01C0,0x0B40,0x2280,0x0700,0x7FC0},	//[0]Light
			{0x1600,0x7F80,0x7FC0,0xFFC0,0xFFC0,0xFFC0,0x7F80,0x3F00,0x7FC0}	//[1]Dark
		},
		{	//[34]Water_Null (W_0)
			{0x0000,0x1040,0x0000,0x4200,0x0000,0x0000,0x1080,0x0000,0x8400},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[35]Water_North (W_N)
			{0xCD80,0xFFC0,0x3340,0x0000,0x0840,0x2100,0x0000,0x0000,0x8400},	//[0]Light
			{0xCD80,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[36]Water_West (W_W)
			{0x2000,0x6080,0x4000,0x0A00,0x0000,0x0400,0x0000,0x2080,0x0000},	//[0]Light
			{0x3FC0,0x7FC0,0x7FC0,0x7FC0,0x7FC0,0xFFC0,0xFFC0,0x7FC0,0x7FC0}	//[1]Dark
		},
		{	//[37]Water_South (W_S)
			{0x0000,0x0100,0x1000,0x0000,0x0840,0x0000,0x0000,0x8100,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xE700}	//[1]Dark
		},
		{	//[38]Water_East (W_E)
			{0x0240,0x4040,0x0400,0x0000,0x2200,0x0080,0x0080,0x44C0,0x0040},	//[0]Light
			{0xFFC0,0xFFC0,0xFF80,0xFF00,0xFF00,0xFF80,0xFF80,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[39]Water_South_West (W_SW)
			{0x2000,0x0080,0x0000,0x1000,0x0200,0x0040,0x2000,0x6400,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x7FC0,0x7FC0,0x3FC0,0x1FC0,0x3FC0,0x7F40,0x0600}	//[1]Dark
		},
		{	//[40]Water_South_East (W_SE)
			{0x0280,0x0080,0x20C0,0x0040,0x0900,0x8000,0x0100,0xA180,0x0000},	//[0]Light
			{0xFF80,0xFF80,0xFFC0,0xFFC0,0xFF80,0xFF00,0xFF00,0xF780,0xA000}	//[1]Dark
		},
		{	//[41]Waterfall (W_F)
			{0xD100,0x5140,0x0040,0x0100,0x4340,0x0800,0x0080,0xA000,0x0000},	//[0]Light
			{0x3A00,0x1000,0x2500,0x6F40,0xBD80,0xF7C0,0xFF40,0x5FC0,0xA540}	//[1]Dark
		},
		{	//[42]Tree_North (T_N)
			{0x6380,0xF7C0,0x1C00,0x3B80,0x3B80,0x1100,0x0000,0x3780,0x7FC0},	//[0]Light
			{0x6380,0xF7C0,0xFFC0,0xFFC0,0xEEC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//43]Tree_North_West (T_NW)
			{0x10C0,0x0240,0xA280,0xB080,0xD900,0x0C80,0x0E80,0x1F80,0x3F00},	//[0]Light[
			{0x63C0,0x73C0,0xFBC0,0x7BC0,0x1FC0,0x0FC0,0x0FC0,0x03C0,0x07C0}	//[1]Dark
		},
		{	//[44]Tree_South_East (T_SE)
			{0x4440,0x64C0,0x6680,0x49C0,0x5600,0x5400,0x9600,0x7E00,0x0D00},	//[0]Light
			{0xFCC0,0xFDC0,0xFF80,0xFF00,0xFE00,0xFC00,0xFE00,0xFE00,0xFF00}	//[1]Dark
		},
		{	//[45]Guard
			{0x1C00,0x7700,0x1E00,0x5F00,0x1F00,0x1E00,0x5E00,0x1F00,0xFF80},	//[0]Light
			{0x5D40,0x6BC0,0xE280,0xFF80,0xF780,0xE880,0xF680,0xFF80,0xFF80}	//[1]Dark
		},
		{	//[46]Dungeon_North (D_N)
			{0x9E40,0xA140,0x5E80,0x1E00,0x0C00,0x7380,0x8C40,0xAD40,0xBF40},	//[0]Light
			{0x8040,0x9F40,0xBFC0,0xFFC0,0xF3C0,0x8C40,0x7380,0x7F80,0xFFC0}	//[1]Dark
		},
		{	//[47]Dungeon_South_West (D_SW)
			{0x0240,0xFF40,0x0BC0,0x1340,0x1340,0x07C0,0x0640,0x0640,0xFFC0},	//[0]Light
			{0xFD80,0xFD80,0x7880,0x3180,0x3180,0x7C80,0x7D80,0x7F80,0xFFC0}	//[1]Dark
		},
		{	//[48]Dungeon_South_East (D_SE)
			{0x2800,0x2FC0,0xE840,0xE880,0x2880,0xEC40,0xCC40,0x8C40,0xFFC0},	//[0]Light
			{0xFFC0,0xFFC0,0xDBC0,0x3980,0xF980,0xDBC0,0x3BC0,0x7BC0,0xFFC0}	//[1]Dark
		},
		{	//[49]Rock_Null_RIP (R_0_RIP)
			{0x2980,0x1880,0x1100,0x1040,0x3040,0x3000,0x4240,0x0240,0x8680},	//[0]Light
			{0x3D80,0x1CC0,0x9900,0x18C0,0x3940,0x3900,0xF340,0x4240,0xCEC0}	//[1]Dark
		},
		{	//[50]Rock_North_RIP (R_N_RIP)
			{0xDFC0,0x8EC0,0x0C40,0x0C40,0x1800,0x8080,0x0840,0x8500,0xC840},	//[0]Light
			{0x1000,0x0880,0x0840,0x8E40,0x9C40,0x84C0,0x8840,0x8700,0xCC40}	//[1]Dark
		},
		{	//[51]Bush_RIP
			{0xEFC0,0x93C0,0x80C0,0x2540,0x01C0,0x0B40,0xA2C0,0xC7C0,0xFFC0},	//[0]Light
			{0x0600,0x1380,0x00C0,0x2540,0x01C0,0x0B40,0x2280,0x0700,0x7FC0}	//[1]Dark
		},
		{	//[52]Grave_Stone (RIP)
			{0xE3C0,0xE1C0,0xCCC0,0x9E40,0x0C40,0x0C40,0x0040,0x0040,0xFFC0},	//[0]Light
			{0x0000,0x0200,0x0900,0x1C80,0x8880,0x88C0,0xFFC0,0x0040,0xFFC0}	//[1]Dark
		},
		{	//[53]Guard_RIP
			{0xE3C0,0x9DC0,0xFDC0,0xA0C0,0xE0C0,0xE1C0,0xA1C0,0xE0C0,0x0040},	//[0]Light
			{0x4140,0x09C0,0xE080,0xA080,0xE880,0xF680,0xA880,0xE080,0x0000}	//[1]Dark
		},
		{	//[54]Dungeon_North_RIP (D_N_RIP)
			{0xE1C0,0xC1C0,0x1E80,0x1E00,0x0000,0x0000,0x0000,0x2D00,0xBF40},	//[0]Light
			{0x9E40,0xA140,0x5E80,0x1E00,0x0C00,0x7380,0x8C40,0xAD40,0xBF40}	//[1]Dark
		},
		{	//[55]Dungeon_South_West_RIP (D_SW_RIP)
			{0x0000,0xFD00,0x8880,0xD100,0xD100,0x8480,0x8400,0x8600,0xFFC0},	//[0]Light
			{0x0240,0xFF40,0x0FC0,0x1F40,0x1F40,0x07C0,0x0640,0x0640,0xFFC0}	//[1]Dark
		},
		{	//[56]Dungeon_South_East_RIP (D_SE_RIP)
			{0x2800,0x2FC0,0xC840,0x28C0,0x28C0,0xC840,0x0840,0x0840,0xFFC0},	//[0]Light
			{0x2800,0x2FC0,0xEC40,0xEE80,0x2E80,0xEC40,0xCC40,0x8C40,0xFFC0}	//[1]Dark
		},
		{	//[57]Block
			{0x7FC0,0xBFC0,0xC1C0,0xC1C0,0xC1C0,0xC1C0,0xFEC0,0xFF40,0xFF80},	//[0]Light
			{0x8040,0x40C0,0x3FC0,0x3FC0,0x3FC0,0x3FC0,0x3FC0,0x7FC0,0xFFC0}	//[1]Dark
		},
		{	//[58]BombWall_SouthEast (BW_SE)
			{0xF800,0xF800,0xFFC0,0xFFC0,0xF800,0xF000,0xF7C0,0xCFC0,0xA800},	//[0]Light
			{0xFFC0,0xFFC0,0xF800,0xFFC0,0xFFC0,0xFFC0,0xF800,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[59]Bombwall_West (BW_W)
			{0x2FC0,0x1FC0,0xBFC0,0x7FC0,0x3FC0,0x7FC0,0x9FC0,0x2FC0,0x47C0},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[60]BombWall_SouthWest (BW_SW)
			{0x07C0,0x07C0,0xFFC0,0xFFC0,0x07C0,0x03C0,0xFBC0,0xFCC0,0x0500},	//[0]Light
			{0xFFC0,0xFFC0,0x07C0,0xFFC0,0xFFC0,0xFFC0,0x07C0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[61]Bombwall_East (BW_E)
			{0xFD00,0xFE00,0xFF40,0xFF80,0xFF00,0xFF80,0xFE40,0xFD00,0xF880},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[62]Brick_1 (BR_1)
			{0x0840,0x7BC0,0xFFC0,0x1080,0xF780,0xFFC0,0x2100,0xEF40,0xFFC0},	//[0]Light
			{0xFFC0,0x8C40,0xFFC0,0xFFC0,0x18C0,0xFFC0,0xFFC0,0x3180,0xFFC0}	//[1]Dark
		},
		{	//[63]Brick_2 (BR_2)
			{0x4200,0xDEC0,0xFFC0,0x8400,0xBDC0,0xFFC0,0x2100,0xEF40,0xFFC0},	//[0]Light
			{0xFFC0,0x6300,0xFFC0,0xFFC0,0xC600,0xFFC0,0xFFC0,0x3180,0xFFC0}	//[1]Dark
		},
		{	//[64]East_1 (E_1)
			{0x3300,0x3300,0x3300,0x3300,0x3300,0x3700,0x3F00,0x3B00,0x3300},	//[0]Light
			{0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDFC0,0xD9C0,0xD5C0,0xDDC0}	//[1]Dark
		},
		{	//[65]East_2 (E_2)
			{0x3300,0x3300,0x3340,0x33C0,0x3380,0x3300,0x7300,0xF300,0xB300},	//[0]Light
			{0xDDC0,0xDDC0,0xDDC0,0xDD80,0xDD40,0xDDC0,0xFDC0,0x9DC0,0x5DC0}	//[1]Dark
		},
		{	//[66]East_4 (E_4)
			{0x3300,0x3300,0x3300,0x3300,0x3300,0x3300,0x3300,0x3300,0x3300},	//[0]Light
			{0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0}	//[1]Dark
		},
		{	//[67]East_4_DoorClosed (E_4_DC)
			{0x8040,0x8C40,0x9240,0xF540,0xABC0,0xA140,0x9240,0x8C40,0x8040},	//[0]Light
			{0xFFC0,0xF3C0,0xEDC0,0xDFC0,0xFEC0,0xDEC0,0xEDC0,0xF3C0,0xFFC0}	//[1]Dark
		},
		{	//[68]East_4_DoorLocked (E_4_DL)
			{0x8F40,0xF140,0x8540,0xBF40,0xBF40,0x8540,0x8140,0xF140,0x8F40},	//[0]Light
			{0xF0C0,0x8EC0,0xFEC0,0xFEC0,0xFEC0,0xFEC0,0xFEC0,0x8EC0,0xF0C0}	//[1]Dark
		},
		{	//[69]East_5 (E_5)
			{0x3300,0x3300,0x3300,0x3300,0x3300,0x3F00,0x3F00,0x3300,0x3300},	//[0]Light
			{0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xD3C0,0xDDC0,0xDDC0}	//[1]Dark
		},
		{	//[70]East_5_Door (E_5_D)
			{0xFFC0,0x1FC0,0xE1C0,0x3E00,0x33C0,0x3F00,0x3F00,0x3700,0x3300},	//[0]Light
			{0xFFC0,0xFFC0,0x1FC0,0xC1C0,0xDC00,0xDDC0,0xD7C0,0xD9C0,0xDDC0}	//[1]Dark
		},
		{	//[71]East_5_DoorClosedLocked (E_5_DCL)
			{0xF040,0x1F40,0xE1C0,0x3E00,0x33C0,0x3F00,0x3F00,0x3700,0x3300},	//[0]Light
			{0xFFC0,0xFFC0,0x1FC0,0xC1C0,0xDC00,0xDDC0,0xD7C0,0xD9C0,0xDDC0}	//[1]Dark
		},
		{	//[72]East_6 (E_6)
			{0xB300,0xF300,0x7300,0x3300,0x3380,0x33C0,0x3340,0x3300,0x3300},	//[0]Light
			{0xDDC0,0x7DC0,0x9DC0,0xDDC0,0xDDC0,0xDD40,0xDD80,0xDDC0,0xDDC0}	//[1]Dark	
		},
		{	//[73]East_7 (E_7)
			{0x3300,0x3300,0x3B00,0x3F00,0x3700,0x3300,0x3300,0x3300,0x3300},	//[0]Light
			{0xDDC0,0xDDC0,0xDDC0,0xD7C0,0xD9C0,0xDDC0,0xDDC0,0xDDC0,0xDDC0}	//[1]Dark
		},
		{	//[74]EastEast_1 (EE_1)
			{0x00C0,0x0080,0x07C0,0x0300,0x0200,0x07C0,0x00C0,0x0080,0x07C0},	//[0]Light
			{0xFF80,0xFFC0,0xFFC0,0xFEC0,0xFFC0,0xFFC0,0xFF80,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[75]EastEast_2 (EE_2)
			{0x0300,0x0200,0x07C0,0x00C0,0x0080,0x07C0,0x0300,0x0200,0x07C0},	//[0]Light
			{0xFEC0,0xFFC0,0xFFC0,0xFF80,0xFFC0,0xFFC0,0xFEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[76]EastEast_3 (EE_3)
			{0x18C0,0x7880,0xE7C0,0x8300,0x0200,0x07C0,0x00C0,0x0080,0x07C0},	//[0]Light
			{0xFF80,0xE7C0,0x9FC0,0x7EC0,0xFFC0,0xFFC0,0xFF80,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[77]EastEast_4 (EE_4)
			{0x6300,0x7200,0xF7C0,0xF0C0,0xE080,0x07C0,0x0300,0x0200,0x07C0},	//[0]Light
			{0xDEC0,0xCFC0,0xCFC0,0xFF80,0xFFC0,0xFFC0,0xFEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[78]EastEast_6 (EE_6)
			{0x0300,0x0200,0x07C0,0x00C0,0xF080,0xF7C0,0xF300,0x7200,0x67C0},	//[0]Light
			{0xFEC0,0xFFC0,0xFFC0,0xFF80,0x8FC0,0x9FC0,0xEEC0,0xCFC0,0xDFC0}	//[1]Dark
		},
		{	//[79]EastEast_6_Door (EE_6_D)
			{0x6300,0x6200,0x67C0,0x60C0,0xF080,0xF7C0,0xF300,0x7200,0x67C0},	//[0]Light
			{0xBEC0,0xBFC0,0xBFC0,0xBF80,0x8FC0,0x9FC0,0xEEC0,0xCFC0,0xDFC0}	//[1]Dark
		},
		{	//[80]EastEast_7 (EE_7)
			{0x00C0,0x0080,0x07C0,0x0300,0x0200,0x87C0,0xE0C0,0x7880,0x1FC0},	//[0]Light
			{0xFF80,0xFFC0,0xFFC0,0xFEC0,0xFFC0,0xFFC0,0x7F80,0x9FC0,0xE7C0}	//[1]Dark
		},
		{	//[81]Head_Closed (H_C)
			{0x7D80,0x8240,0xE980,0x4580,0x8840,0xF140,0x7280,0xEA80,0xE440},	//[0]Light
			{0x7DC0,0xFFC0,0xF600,0x7A80,0xFFC0,0xFFC0,0x4F80,0xFF80,0x9FC0}	//[1]Dark
		},
		{	//[82]Head_Open (H_O)
			{0xE040,0x9280,0x4640,0xA440,0xB980,0xAB00,0xBF80,0x4F40,0x4440},	//[0]Light
			{0xFAC0,0xFF80,0x7DC0,0xFFC0,0xE700,0xF700,0xE780,0x77C0,0x7BC0}	//[1]Dark
		},
		{	//[83]NorthEast_Corner (NE_C)
			{0x0080,0xFF00,0xFF00,0x0700,0x0B00,0xF300,0xF300,0x7300,0xB300},	//[0]Light
			{0xFFC0,0xFFC0,0x03C0,0xFDC0,0xFDC0,0xFDC0,0x3DC0,0xDDC0,0xDDC0}	//[1]Dark
		},
		{	//[84]NorthEastNorthEast_Corner (NENE_C)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x4300,0x8200,0x07C0},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[85]NorthNorth_1 (NN_1)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0000,0x0000,0x8000},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[86]NorthNorth_2 (NN_2)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0600,0x0600,0x0300},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFDC0,0xFDC0,0xFEC0}	//[1]Dark
		},
		{	//[87]NorthNorth_3 (NN_3)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0000,0x0000,0x0000},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[88]NorthNorth_5 (NN_5)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0xC000,0xC000,0x6000},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xBFC0,0xBFC0,0xDFC0}	//[1]Dark
		},
		{	//[89]NorthNorth_6 (NN_6)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0180,0x03C0,0x03C0},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFE40,0xFCC0,0xFFC0}	//[1]Dark
		},
		{	//[90]NorthNorth_9 (NN_9)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x7000,0xF800,0xF800},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xCFC0,0x27C0,0x7FC0}	//[1]Dark
		},
		{	//[91]NorthNorth_10 (NN_10)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x00C0,0x00C0,0x0180},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFF80,0xFF80,0xFF40}	//[1]Dark
		},
		{	//[92]NorthNorth_13 (NN_13)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0C00,0x0C00,0x1800},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFBC0,0xFBC0,0xF7C0}	//[1]Dark
		},
		{	//[93]NorthNorth_14 (NN_14)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0000,0x0000,0x0040},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[94]NorthWest_Corner (NW_C)
			{0x4000,0x3FC0,0x3FC0,0x3800,0x3400,0x33C0,0x33C0,0x3380,0x3340},	//[0]Light
			{0xFFC0,0xFFC0,0xF000,0xEFC0,0xEFC0,0xEFC0,0xEF00,0xEEC0,0xEEC0}	//[1]Dark
		},
		{	//[95]NorthWestNorthWest_Corner (NWNW_C)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x6080,0x4040,0xF800},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[96]South_1 (S_1)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0180},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFF40}	//[1]Dark
		},
		{	//[97]South_2 (S_2)
			{0x3000,0x3000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xEFC0,0xEFC0,0x4000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[98]South_3 (S_3)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x3000,0x6000,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xEFC0,0xDFC0,0x4000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[99]South_4 (S_4)
			{0x0180,0x0300,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x3000},	//[0]Light
			{0xFF40,0xFEC0,0x0200,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xEFC0}	//[1]Dark
		},
		{	//[100]South_5 (S_5)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x0180,0x0180,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFF40,0xFF40,0x0200,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[101]South_6 (S_6)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[102]South_6_DoorClosed (S_6_DC)
			{0x17C0,0x28C0,0xE900,0xEA40,0x5A00,0x5140,0x50C0,0xB040,0xBFC0},	//[0]Light
			{0xEFC0,0xDF40,0x1EC0,0xDDC0,0xBDC0,0xBEC0,0xBF00,0x7FC0,0x7FC0}	//[1]Dark
		},
		{	//[103]South_6_DoorLocked (S_6_DL)
			{0x17C0,0x2900,0xE940,0xE940,0x5A40,0x52C0,0x5240,0xB3C0,0xBFC0},	//[0]Light
			{0xEFC0,0xDEC0,0x1EC0,0xDEC0,0xBDC0,0xBDC0,0xBDC0,0x7C00,0x7FC0}	//[1]Dark
		},
		{	//[104]South_7_DoorClosed (S_7_DC)
			{0xFA00,0xC500,0xA5C0,0x15C0,0x9680,0x2280,0xC280,0x0340,0xFF40},	//[0]Light
			{0xFDC0,0x3EC0,0xDE00,0xEEC0,0xEF40,0xDF40,0xBF40,0xFF80,0xFF80}	//[1]Dark
		},
		{	//[105]South_7_DoorLocked (S_7_DL)
			{0xFA00,0x2500,0xA5C0,0xA5C0,0x9680,0xD280,0x9280,0xF340,0xFF40},	//[0]Light
			{0xFDC0,0xDEC0,0xDE00,0xDEC0,0xEF40,0xEF40,0xEF40,0x0F80,0xFF80}	//[1]Dark
		},
		{	//[106]South_8 (S_8)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x6000,0x6000,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xDFC0,0xDFC0,0x2000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[107]South_9 (S_9)
			{0x6000,0x3000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0300},	//[0]Light
			{0xDFC0,0xEFC0,0x2000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFEC0}	//[1]Dark
		},
		{	//[108]South_10 (S_10)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x0300,0x0180,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFEC0,0xFF40,0x0100,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[109]South_11 (S_11)
			{0x0300,0x0300,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0000},	//[0]Light
			{0xFEC0,0xFEC0,0x0100,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[110]South_12 (S_12)
			{0x0000,0x0000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x3000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xEFC0}	//[1]Dark
		},
		{	//[111]SouthEast_Corner (SE_C)
			{0xB300,0x7300,0xF300,0xF300,0x0B00,0x0700,0xFF00,0xFF00,0x0080},	//[0]Light
			{0xDDC0,0xDDC0,0x3DC0,0xFDC0,0xFDC0,0xFDC0,0x03C0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[112]SouthEastSouthEast_Corner (SESE_C)
			{0x0300,0x8200,0x47C0,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[113]SouthSouth_1 (SS_1)
			{0x8000,0x0000,0x0000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[114]SouthSouth_2 (SS_2)
			{0x0300,0x0600,0x0600,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFEC0,0xFDC0,0xFDC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[115]SouthSouth_3 (SS_3)
			{0x0000,0x0000,0x0000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[116]SouthSouth_5 (SS_5)
			{0x6000,0xC000,0xC000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xDFC0,0xBFC0,0xBFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[117]SouthSouth_6 (SS_6)
			{0x03C0,0x03C0,0x0180,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFFC0,0xFCC0,0xFEC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[118]SouthSouth_9 (SS_9)
			{0xF800,0xF800,0x7000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0x7FC0,0x27C0,0xAFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[119]SouthSouth_10 (SS_10)
			{0x0180,0x00C0,0x00C0,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFF40,0xFF80,0xFF80,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[120]SouthSouth_13 (SS_13)
			{0x1800,0x0C00,0x0C00,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xF7C0,0xFBC0,0xFBC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[121]SouthSouth_14 (SS_14)
			{0x0040,0x0000,0x0000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xFFC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[122]SouthWest_Corner (SW_C)
			{0x3340,0x3380,0x33C0,0x33C0,0x3400,0x3800,0x3FC0,0x3FC0,0x4000},	//[0]Light
			{0xEEC0,0xEEC0,0xEF00,0xEFC0,0xEFC0,0xEFC0,0xF000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[123]SouthWestSouthWest_Corner (SWSW_C)
			{0x6000,0x4040,0xF880,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0xDFC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[124]West_1 (W_1)
			{0x3300,0x3300,0x3300,0x3300,0x3300,0x3B00,0x3F00,0x3700,0x3300},	//[0]Light
			{0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xFEC0,0xE6C0,0xEAC0,0xEEC0}	//[1]Dark
		},
		{	//[125]West_2 (W_2)
			{0x3300,0x3300,0xB300,0xF300,0x7300,0x3300,0x3380,0x33C0,0x3340},	//[0]Light
			{0xEEC0,0xEEC0,0xEEC0,0x6EC0,0xAEC0,0xEEC0,0xEFC0,0xEE40,0xEE80}	//[1]Dark
		},
		{	//[126]West_4 (W_4)
			{0x3300,0x3300,0x3300,0x3300,0x3300,0x3300,0x3300,0x3300,0x3300},	//[0]Light
			{0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0}	//[1]Dark
		},
		{	//[127]West_4_DoorClosed (W_4_DC)
			{0x8040,0x8C40,0x9240,0xABC0,0xF540,0xA140,0x9240,0x8C40,0x8040},	//[0]Light
			{0xFFC0,0xF3C0,0xEDC0,0xFEC0,0xDFC0,0xDEC0,0xEDC0,0xF3C0,0xFFC0}	//[1]Dark
		},
		{	//[128]West_4_DoorLocked (W_4_DL)
			{0xBC40,0xA3C0,0xA840,0xBF40,0xBF40,0xA840,0xA040,0xA3C0,0xBC40},	//[0]Light
			{0xC3C0,0xDC40,0xDFC0,0xDFC0,0xDFC0,0xDFC0,0xDFC0,0xDC40,0xC3C0}	//[1]Dark
		},
		{	//[129]West_5 (W_5)
			{0x3300,0x3300,0x3300,0x3300,0x3300,0x3F00,0x3F00,0x3300,0x3300},	//[0]Light
			{0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xF2C0,0xEEC0,0xEEC0}	//[1]Dark
		},
		{	//[130]West_5_Door (W_5_D)
			{0xFFC0,0xFE00,0xE1C0,0x1F00,0xF300,0x3F00,0x3F00,0x3B00,0x3300},	//[0]Light
			{0xFFC0,0xFFC0,0xFE00,0xE0C0,0x0EC0,0xEEC0,0xFAC0,0xE6C0,0xEEC0}	//[1]Dark
		},
		{	//[131]West_5_DoorClosedLocked (W_5_DCL)
			{0x83C0,0xBE00,0xE1C0,0x1F00,0xF300,0x3F00,0x3F00,0x3B00,0x3300},	//[0]Light
			{0xFFC0,0xFFC0,0xFE00,0xE0C0,0x0EC0,0xEEC0,0xFAC0,0xE6C0,0xEEC0}	//[1]Dark
		},
		{	//[132]West_6 (W_6)
			{0x3340,0x33C0,0x3380,0x3300,0x7300,0xF300,0xB300,0x3300,0x3300},	//[0]Light
			{0xEEC0,0xEF80,0xEE40,0xEEC0,0xEEC0,0xAEC0,0x6EC0,0xEEC0,0xEEC0}	//[1]Dark
		},
		{	//[133]West_7 (W_7)
			{0x3300,0x3300,0x3700,0x3F00,0x3B00,0x3300,0x3300,0x3300,0x3300},	//[0]Light
			{0xEEC0,0xEEC0,0xEEC0,0xFAC0,0xE6C0,0xEEC0,0xEEC0,0xEEC0,0xEEC0}	//[1]Dark
		},
		{	//[134]WestWest_1 (WW_1)
			{0x1800,0x1000,0xF800,0x6000,0x4000,0xF800,0x1800,0x1000,0xF800},	//[0]Light
			{0xF7C0,0xFFC0,0xFFC0,0xDFC0,0xFFC0,0xFFC0,0xF7C0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[135]WestWest_2 (WW_2)
			{0x6000,0x4000,0xF800,0x1800,0x1000,0xF800,0x6000,0x4000,0xF800},	//[0]Light
			{0xDFC0,0xFFC0,0xFFC0,0xF7C0,0xFFC0,0xFFC0,0xDFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[136]WestWest_3 (WW_3)
			{0x1E00,0x1780,0xF9C0,0x6040,0x4000,0xF800,0x1800,0x1000,0xF800},	//[0]Light
			{0xF7C0,0xF9C0,0xFE40,0xDF80,0xFFC0,0xFFC0,0xF7C0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[137]WestWest_4 (WW_4)
			{0x6180,0x4380,0xFBC0,0x1BC0,0x11C0,0xF800,0x6000,0x4000,0xF800},	//[0]Light
			{0xDEC0,0xFCC0,0xFCC0,0xF7C0,0xFFC0,0xFFC0,0xDFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[138]WestWest_6 (WW_6)
			{0x6000,0x4000,0xF800,0x1800,0x13C0,0xFBC0,0x63C0,0x4380,0xF980},	//[0]Light
			{0xDFC0,0xFFC0,0xFFC0,0xF7C0,0xFC40,0xFE40,0xDDC0,0xFCC0,0xFEC0}	//[1]Dark
		},
		{	//[139]WestWest_6_Door (WW_6_D)
			{0x6180,0x4180,0xF980,0x1980,0x13C0,0xFBC0,0x63C0,0x4380,0xF980},	//[0]Light
			{0xDF40,0xFF40,0xFF40,0xF740,0xFC40,0xFE40,0xDDC0,0xFCC0,0xFEC0}	//[1]Dark
		},
		{	//[140]WestWest_7 (WW_7)
			{0x1800,0x1000,0xF800,0x6000,0x4000,0xF840,0x19C0,0x1780,0xFE00},	//[0]Light
			{0xF7C0,0xFFC0,0xFFC0,0xDFC0,0xFFC0,0xFFC0,0xF780,0xFE40,0xF9C0}	//[1]Dark
		},
		{	//[141]Rock_North_West (R_NW)
			{0x0080,0x0040,0x0040,0x0C40,0x0440,0x30C0,0x1440,0x1440,0x1CC0},	//[0]Light
			{0x0180,0x03C0,0x03C0,0x0FC0,0x0F80,0x3F80,0x7BC0,0x6FC0,0xEF80}	//[1]Dark
		},
		{	//[142]Rock_North_West_RIP (R_NW_RIP)
			{0xFEC0,0xFC40,0xFC40,0xFC40,0xF400,0xF080,0x9040,0x8440,0x0C80},	//[0]Light
			{0x0080,0x0040,0x0040,0x0C40,0x0440,0x30C0,0x1440,0x1440,0x1CC0}	//[1]Dark
		},
		{	//[143]Water_North_West (W_NW)
			{0x06C0,0x0FC0,0x7840,0x2100,0x4000,0xD000,0x8200,0x0040,0x4000},	//[0]Light
			{0x06C0,0x0FC0,0x7FC0,0x3FC0,0x7FC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[144]Dungeon_North_West (D_NW)
			{0x0000,0x0000,0x0040,0x0340,0x0340,0x0B00,0x1A00,0x7A00,0x7040},	//[0]Light
			{0x0040,0x00C0,0x0180,0x6180,0xF180,0xF9C0,0xE9C0,0x99C0,0x7380}	//[1]Dark
		},
		{	//[145]Dungeon_North_West_RIP (D_NW_RIP)
			{0xFF80,0xFF00,0xFE00,0x9D00,0x0D00,0x0D00,0x0C00,0x1C00,0xFC00},	//[0]Light
			{0x0000,0x0000,0x0140,0x0340,0x0340,0x0B00,0x1A00,0x7A00,0x7040}	//[1]Dark
		},
		{	//[146]Rock_South_West (R_SW)
			{0x1740,0x1300,0x3300,0xB300,0x7380,0x3380,0x0F80,0x0080,0x0040},	//[0]Light
			{0xEEC0,0xEEC0,0xEEC0,0xEEC0,0x6F40,0x3F40,0x0F40,0x00C0,0x0040}	//[1]Dark
		},
		{	//[147]Rock_South_West_RIP (R_SW_RIP)
			{0x0640,0x0200,0x2200,0xA200,0xE300,0xF300,0xFF00,0xFF80,0xFFC0},	//[0]Light
			{0x1740,0x1300,0x3300,0xB300,0x7380,0x3380,0x0F80,0x0080,0x0040}	//[1]Dark
		},
		{	//[148]Rock_South_East (R_SE)
			{0x8740,0xE340,0xD340,0x9780,0x9600,0x9400,0xD400,0xD800,0xC000},	//[0]Light
			{0x7EC0,0x7EC0,0x3EC0,0x7F80,0x7E00,0x7C00,0xBC00,0xB800,0xC000}	//[1]Dark
		},
		{	//[149]Rock_South_East_RIP (R_SE_RIP)
			{0x0640,0x6240,0x1240,0x17C0,0x17C0,0x17C0,0x97C0,0x9FC0,0xFFC0},	//[0]Light
			{0x8740,0xE340,0xD340,0x9780,0x9600,0x9400,0xD400,0xD800,0xC000}	//[1]Dark
		},
		{	//[150]Rock_North_East (R_NE)
			{0x0000,0x1000,0x0800,0x8800,0x8B00,0x1C00,0x9880,0xCC80,0x1E80}, //
			{0x0000,0x3000,0x7800,0xFC00,0x7F00,0xF780,0x7780,0xBB80,0xFB80}, //[1]Dark
		},
		{	//[151]Rock_North_East_RIP (R_NE_RIP)
			{0xFFC0,0xDFC0,0x8FC0,0x8BC0,0x0BC0,0x1440,0x10C0,0x88C0,0x1AC0},	//[0]Light
			{0x0000,0x1000,0x0800,0x8800,0x8B00,0x1C00,0x9880,0xCC80,0x1E80}	//[1]Dark
		},
		{	//[152]Water_North_East (W_NE)
			{0x4C00,0xFF80,0x0100,0x1000,0x0080,0x0440,0x2040,0x0100,0x8000},	//[0]Light
			{0x4C00,0xFF80,0xFF00,0xFF00,0xFF80,0xFFC0,0xFFC0,0xFF80,0xFF80}	//[1]Dark
		},
		{	//[153]Dungeon_North_East (D_NE)
			{0x8000,0xC000,0x6000,0x3000,0xB000,0xB040,0x30C0,0x13C0,0x9B80},	//[0]Light
			{0x8000,0xC000,0xE000,0xF300,0xD780,0xD7C0,0xF740,0xF4C0,0x7B80}	//[1]Dark
		},
		{	//[154]Dungeon_North_East_RIP (D_NE_RIP)
			{0xFFC0,0xFFC0,0x7FC0,0x3CC0,0x9840,0x9840,0x3840,0x18C0,0x1FC0},	//[0]Light
			{0x8000,0xC000,0x6000,0x3000,0xB000,0xB040,0x30C0,0x13C0,0x9B80}	//[1]Dark
		},
		{	//[155]BombWall_NorthWest (BW_NW)
			{0x0500,0xFCC0,0xFBC0,0x03C0,0x07C0,0xFFC0,0xFFC0,0x07C0,0x07C0},	//[0]Light
			{0xFFC0,0xFFC0,0x07C0,0xFFC0,0xFFC0,0xFFC0,0x07C0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[156]BombWall_NorthEast (BW_NE)
			{0xA800,0xCFC0,0xF7C0,0xF000,0xF800,0xFFC0,0xFFC0,0xF800,0xF800},	//[0]Light
			{0xFFC0,0xFFC0,0xF800,0xFFC0,0xFFC0,0xFFC0,0xF800,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[157]East_3 (E_3)
			{0x3300,0x3300,0x3F00,0x3F00,0x3300,0x3300,0x3300,0x3300,0x3300},	//[0]Light
			{0xDDC0,0xDFC0,0xDDC0,0xD1C0,0xDDC0,0xDDC0,0xDDC0,0xDDC0,0xDDC0}	//[1]Dark
		},
		{	//[158]East_3_Door (E_3_D)
			{0x3300,0x3700,0x3F00,0x3F00,0x33C0,0x3E00,0xE1C0,0x1FC0,0xFFC0},	//[0]Light
			{0xDDC0,0xDFC0,0xDDC0,0xD1C0,0xDC00,0xC1C0,0x1FC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[159]East_3_DoorClosedLocked (E_3_DCL)
			{0x3300,0x3700,0x3F00,0x3F00,0x33C0,0x3E00,0xE1C0,0x1F40,0xF040},	//[0]Light
			{0xDDC0,0xDFC0,0xDDC0,0xD1C0,0xDC00,0xC1C0,0x1FC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[160]EastEast_4_Door(EE_4_D)
			{0x6300,0x7200,0xF7C0,0xF0C0,0xE080,0x67C0,0x6300,0x6200,0x67C0},	//[0]Light
			{0xDEC0,0xCFC0,0xCFC0,0xFF80,0xFFC0,0xBFC0,0xBEC0,0xBFC0,0xBFC0}	//[1]Dark
		},
		{	//[161]North_1(N_1)
			{0x0180,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xFF40,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[162]North_2 (N_2)
			{0x0000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x3000,0x3000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x4000,0xEFC0,0xEFC0}	//[1]Dark
		},
		{	//[163]North_3 (N_3)
			{0x0000,0xFFC0,0xFFC0,0x6000,0x3000,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x4000,0xDFC0,0xEFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[164]North_4 (N_4)
			{0x3000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0300,0x0180},	//[0]Light
			{0xEFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0200,0xFEC0,0xFF40}	//[1]Dark
		},
		{	//[165]North_5 (N_5)
			{0x0000,0xFFC0,0xFFC0,0x0180,0x0180,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0200,0xFF40,0xFF40,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[166]North_6 (N_6)
			{0x0000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[167]North_6_DoorClosed (N_6_DC)
			{0xBFC0,0xB040,0x50C0,0x5140,0x5A00,0xEA40,0xE900,0x28C0,0x17C0},	//[0]Light
			{0x7FC0,0x7FC0,0xBF00,0xBEC0,0xBDC0,0xDDC0,0x1EC0,0xDF40,0xEFC0}	//[1]Dark
		},
		{	//[168]North_6_DoorLocked (N_6_DL)
			{0xBFC0,0xB3C0,0x5240,0x52C0,0x5A40,0xE940,0xE940,0x2900,0x17C0},	//[0]Light
			{0x7FC0,0x7C00,0xBDC0,0xBDC0,0xBDC0,0xDEC0,0x1EC0,0xDEC0,0xEFC0}	//[1]Dark
		},
		{	//[169]North_7_DoorClosed (N_7_DC)
			{0xFF40,0x0340,0xC280,0x2280,0x9680,0x15C0,0xA5C0,0xC500,0xFA00},	//[0]Light
			{0xFF80,0xFF80,0xBF40,0xDF40,0xEF40,0xEEC0,0xDE00,0x3EC0,0xFDC0}	//[1]Dark
		},
		{	//[170]North_7_DoorLocked (N_7_DL)
			{0xFF40,0xF340,0x9280,0xD280,0x9680,0xA5C0,0xA5C0,0x2500,0xFA00},	//[0]Light
			{0xFF80,0x0F80,0xEF40,0xEF40,0xEF40,0xDEC0,0xDE00,0xDEC0,0xFDC0}	//[1]Dark
		},
		{	//[171]North_8 (N_8)
			{0x0000,0xFFC0,0xFFC0,0x6000,0x6000,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x2000,0xDFC0,0xDFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[172]North_9 (N_9)
			{0x0300,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x3000,0x6000},	//[0]Light
			{0xFEC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x2000,0xEFC0,0xDFC0}	//[1]Dark
		},
		{	//[173]North_10 (N_10)
			{0x0000,0xFFC0,0xFFC0,0x0180,0x0300,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xFFC0,0xFFC0,0x0100,0xFF40,0xFEC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[174]North_11` (N_11)
			{0x0000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0300,0x0300},	//[0]Light
			{0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0100,0xFEC0,0xFEC0}	//[1]Dark
		},
		{	//[175]North_12 (N_12)
			{0x3000,0xFFC0,0xFFC0,0x0000,0x0000,0xFFC0,0xFFC0,0x0000,0x0000},	//[0]Light
			{0xEFC0,0xFFC0,0x0000,0xFFC0,0xFFC0,0xFFC0,0x0000,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[176]West_3 (W_3)
			{0x3300,0x3300,0x3F00,0x3F00,0x3300,0x3300,0x3300,0x3300,0x3300},	//[0]Light
			{0xEEC0,0xFEC0,0xEEC0,0xE2C0,0xEEC0,0xEEC0,0xEEC0,0xEEC0,0xEEC0}	//[1]Dark
		},
		{	//[177]West_3_Door (W_3_D)
			{0x3300,0x3B00,0x3F00,0x3F00,0xF300,0x1F00,0xE1C0,0xFE00,0xFFC0},	//[0]Light
			{0xEEC0,0xFEC0,0xEEC0,0xE2C0,0x0EC0,0xE0C0,0xFE00,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[178]West_3_DoorClosedLocked (W_3_DCL)
			{0x3300,0x3B00,0x3F00,0x3F00,0xF300,0x1F00,0xE1C0,0xBE00,0x83C0},	//[0]Light
			{0xEEC0,0xFEC0,0xEEC0,0xE2C0,0x0EC0,0xE0C0,0xFE00,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[179]WestWest_4_Door (WW_4_D)
			{0x6180,0x4380,0xFBC0,0x1BC0,0x11C0,0xF980,0x6180,0x4180,0xF980},	//[0]Light
			{0xDEC0,0xFCC0,0xFCC0,0xF7C0,0xFFC0,0xFF40,0xDF40,0xFF40,0xFF40}	//[1]Dark
		},
		{	//[180]North_6_D (N_6_D)
			{0xBFC0,0xBFC0,0x5FC0,0x5FC0,0x5840,0xE840,0xE840,0x2840,0x1780},	//[0]Light
			{0x7FC0,0x7FC0,0xBFC0,0xBFC0,0xB800,0xD800,0x1800,0xD800,0xE800}	//[1]Dark
		},
		{	//[181]NN_7_D (NN_7_D)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0000,0xFFC0,0xFFC0},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0x0000}	//[1]Dark
		},
		{	//[182]South_6_Door (S_6_D)
			{0x1040,0x2840,0xE840,0xE840,0x5840,0x5FC0,0x5FC0,0xBFC0,0xBFC0},	//[0]Light
			{0xE800,0xD800,0x1800,0xD800,0xB800,0xBFC0,0xBFC0,0x7FC0,0x7FC0}	//[1]Dark
		},
		{	//[183]SouthSouth_7_Door (SS_7_D)
			{0xFFC0,0xFFC0,0x0000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0x0000,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[184]North_7_Door (N_7_D)
			{0xFF40,0xFF40,0xFE80,0xFE80,0x0680,0x05C0,0x05C0,0x0500,0xFA00},	//[0]Light
			{0xFF80,0xFF80,0xFF40,0xFF40,0x0740,0x06C0,0x0600,0x06C0,0x05C0}	//[1]Dark
		},
		{	//[185]North_North_8_Door (NN_8_D)
			{0x6300,0x4200,0xFFC0,0x18C0,0x1080,0xFFC0,0x0000,0xFFC0,0xFFC0},	//[0]Light
			{0xDEC0,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0x0000}	//[1]Dark
		},
		{	//[186]South_7_Door (S_7_D)
			{0x0200,0x0500,0x05C0,0x05C0,0x0680,0xFE80,0xFE80,0xFF40,0xFF40},	//[0]Light
			{0x05C0,0x06C0,0x0600,0x06C0,0x0740,0xFF40,0xFF40,0xFF80,0xFF80}	//[1]Dark
		},
		{	//[187]SouthSouth_8_Door (SS_8_D)
			{0xFFC0,0xFFC0,0x0000,0x18C0,0x1080,0xFFC0,0x6300,0x4200,0xFFC0},	//[0]Light
			{0x0000,0xFFC0,0xFFC0,0xF780,0xFFC0,0xFFC0,0xDEC0,0xFFC0,0xFFC0}	//[1]Dark
		},
		{	//[188]Tree_South_West (T_SW)
			{0x0680,0x0680,0x0280,0x0280,0x0600,0x0400,0x0400,0x0100,0x0000},	//[0]Light
			{0x07C0,0x07C0,0x07C0,0x0FC0,0x0FC0,0x0FC0,0x0FC0,0x0FC0,0x0B40}	//[1]Dark
		},
		{	//[189]Tree_North_East (T_NE)
			{0x0400,0x8C00,0xFC00,0x7400,0x4C00,0x1800,0x9800,0x5800,0x5800},	//[0]Light
			{0x0400,0x8C00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00}	//[1]Dark
		},
		{	//[190]Stair_G
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[0]Light
			{0xFFC0,0x9FC0,0x93C0,0x9240,0x9240,0x9240,0x9240,0x9240,0xFFC0}	//[1]Dark
		}
	};
	
	//22528
	static unsigned char Screen_Map[128][176]=
	{
		{	//(1,1) [0] North-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(2,1) [1] East of North-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_SE,R_SW,R_SE,R_SW,R_0,R_0,
			R_0,R_0,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_SE,Null,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,Null,Null,R_SW,R_SE,R_SW,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,R_SW,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_NE,R_NW,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(3,1) [2] East-East of North-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_SW,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,R_SW,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_NE,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_NE,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(4,1) [3] West-West of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SE,Null,Null,Null,Null,R_SW,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,R_NW,R_N,R_N,R_N,R_N,Ladder,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,R_NW,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,
			R_N,R_N,R_N,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0
		},
		{	//(5,1) [4] West of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,R_SW,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_SE,Null,Null,Null,Null,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_NE,Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,R_NW,
			R_0,R_0,R_N,R_N,R_N,R_N,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(6,1) [5] Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SE,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,R_0,
			Null,Null,Null,R_NW,R_0,R_0,R_NE,Null,Null,R_NW,R_0,R_0,R_NE,Null,Null,R_SW,
			Null,Null,Null,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,Null,Null,Null,
			Null,Null,Null,R_SW,R_0,Cave,R_SE,Null,Null,R_SW,R_0,R_0,R_SE,Null,Null,R_NW,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_NE,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(7,1) [6] East of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_SE,R_SW,R_SE,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SE,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,R_SW,R_SE,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NE,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,R_NW,R_NE,R_NW,R_N,
			R_0,R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_NE,R_NW,R_NE,Null,Null,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_NE,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(8,1) [7] East-East of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,R_SW,Cave,R_0,R_SE,R_SW,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_N,Ladder,R_N,R_NE,Null,Null,R_NW,R_N,R_N,R_NE,R_NW,R_N,R_N,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_NE,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(9,1) [8] East-East-East of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_SE,R_SW,R_SE,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SE,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,R_SW,R_SE,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NE,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,R_NW,R_NE,R_NW,R_N,
			R_0,R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_NE,R_NW,R_NE,Null,Null,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_NE,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(10,1) [9] West-West of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,
			R_0,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_SE,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Snail,Null,Snail,Null,Snail,Null,Snail,Null,Snail,Null,Null,R_0,
			R_NE,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_NE,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,
			R_0,R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(11,1) [10] West of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_NE,Null,Null,Null,R_0,
			R_0,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,R_0,
			R_0,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,R_0,
			R_0,Null,Null,W_SW,W_S,W_0,W_0,W_0,W_S,W_S,W_S,W_SE,Null,Null,Null,R_0,
			R_0,Null,Null,Null,Null,W_NE_I,W_0,W_NW_I,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,W_0,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,W_0,R_N,R_N,R_N,R_N,R_N,R_N,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,W_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0
		},
		{	//(12,1) [11] Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,R_SE,Null,Null,Null,Null,D_NW,D_N,D_NE,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Guard,Null,Guard,D_SW,Cave,D_SE,Guard,Null,Stair,Null,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Guard,Null,Guard,Null,Null,Null,Guard,Null,Guard,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(13,1) [12] East of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,R_0,R_0,R_SE,Null,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,R_SW,R_SE,Null,Null,
			R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,Null,Null,Null,Null,Null,R_NW,R_NE,Null,Null,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_NE,Null,Null,Null,Null,R_0,R_0,R_NE,Null,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_N,R_N,R_NE,R_NW,R_0,R_0,R_0,R_N,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(14,1) [13] East-East of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,R_SW,R_0,R_0,R_SE,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,R_SW,R_SE,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,R_NW,R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_N,R_N,R_0,R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0
		},
		{	//(15,1) [14] West of North-East Corner
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(16,1) [15] North-East Corner
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,D_NW,D_NE,Null,D_NW,D_N,D_NE,Null,D_NW,D_NE,Null,R_0,W_0,
			W_0,R_0,Null,Null,D_SW,D_SE,Null,D_SW,Cave,D_SE,Null,D_SW,D_SE,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_0,W_0,
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,W_0
		},
		{	//(1,2) [16] South of North-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_SE,Null,Null,Snail,Null,Null,Null,Null,Null,Null,T_NW,T_NE,Null,Null,T_NW,
			R_0,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,T_SW,T_SE,Null,Null,T_SW,
			R_0,Null,Null,Null,Snail,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,T_NW,T_NE,Null,Null,
			R_0,R_NE,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,T_SW,T_SE,Null,Null,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(2,2) [17] South-East of North-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			T_NE,Null,Null,T_NW,T_NE,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,R_0,
			T_SE,Null,Null,T_SW,T_SE,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Snail,Null,Null,R_0,
			Null,Null,T_NW,T_NE,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,R_0,
			Null,Null,T_SW,T_SE,Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
		},
		{	//(3,2) [18] North of Level 6
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_SE,Null,Null,T_NW,T_NE,Null,T_NW,T_NE,Null,T_NW,
			R_0,R_0,R_0,Ladder,R_0,R_SE,Null,Null,Null,T_SW,T_SE,Null,T_SW,T_SE,Null,T_SW,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,T_NW,T_NE,Null,T_NW,T_NE,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,T_SW,T_SE,Null,T_SW,T_SE,Null,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(4,2) [19] North-East of Level 6
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_SE,Null,
			T_NE,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_SE,Null,Null,
			T_SE,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,Ladder,R_0,R_SE,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(5,2) [20] South-West of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Null,Guard,Null,R_SW,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Null,Guard,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_NE,R_NW,R_N,R_N,R_N,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0
		},
		{	//(6,2) [21] South of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_SW,R_SE,Null,Null,R_SW,R_SE,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,R_SW,R_SE,Null,Null,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,R_NW,R_NE,Null,Null,R_NW,R_NE,Null,Null,Null,R_NW,R_NE,Null,Null,R_NW,R_NE,
			R_N,R_0,R_0,Ladder,R_N,R_0,R_0,R_N,R_NE,R_NW,R_0,R_0,R_N,Ladder,R_0,R_0,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0
		},
		{	//(7,2) [22] South-East of Level 9
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,R_SW,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SW,R_SE,Null,Null,R_SW,R_SE,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_SE,R_SW,R_SE,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_NE,Null,Null,
			R_NW,R_NE,Null,Null,R_NW,R_NE,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_NE,Null,
			R_0,R_0,R_NE,R_NW,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,R_0,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(8,2) [23] North-North of Level 1
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SE,R_SW,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,R_SW,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,R_SW,Ladder,R_0,W_NW,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Null,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_N,R_N,R_N,W_0,Null,Null,Null,Null,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,W_0,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0
		},
		{	//(9,2) [24] North-North-West of Level 1
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(10,2) [25] North-North of East Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(11,2) [26] South-West of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,W_F,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,W_F,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,W_F,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,W_F,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			W_S,W_S,W_S,W_S,W_S,W_S,W_F,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_N,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(12,2) [27] South of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,
			R_0,R_0,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_SE,Null,Snail,Null,Null,Null,Null,Snail,Null,Snail,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,
			R_N,R_NE,Null,Snail,Null,Null,Null,Null,Snail,Null,Snail,Null,Null,Null,R_NW,R_N,
			R_0,R_0,Null,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(13,2) [28] South-East of Level 5
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_SE,Null,Null,Null,Null,Null,Null,Guard,Null,Guard,Null,Stair,Null,Guard,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NE,Null,Null,Null,Null,Null,Null,Guard,Null,Guard,Null,Guard,Null,Guard,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(14,2) [29] South-East-East of Level 5
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			Null,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			Null,Null,Null,Null,Null,Stair,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,Ladder,R_0,R_0,
			Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Snail,Null,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,R_0,Null,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_N,W_N,
			Null,Null,Null,Null,Null,R_0,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,R_NW,R_0,R_NE,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_N,R_N,Ladder,R_N,R_0,R_0,R_0,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Ladder,R_0,R_0,R_0,R_0,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(15,2) [30] South-West of North-East Corner
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_N,R_N,R_N,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(16,2) [31] South of North-East Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			Null,Null,T_NW,T_NE,Null,T_NW,T_N,T_NE,Null,Null,T_NW,T_NE,Null,Null,R_0,W_0,
			Null,Null,T_SW,T_SE,Null,T_SW,Cave,T_SE,Null,Null,T_SW,T_SE,Null,Null,R_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			Null,Null,Null,Null,T_NW,T_NE,Null,Null,T_NW,T_NE,Null,T_NW,T_NE,Null,R_0,W_0,
			Null,Null,Null,Null,T_SW,T_SE,Null,Null,T_SW,T_SE,Null,T_SW,T_SE,Null,R_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0
		},
		{	//(1,3) [32] West-West of Level 6
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_SE_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_N_RIP,R_N_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP
		},
		{	//(2,3) [33] West of Level 6
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Bush_RIP,Bush_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_N_RIP,R_N_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
		},
		{	//(3,3) [34] Level 6
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,D_NW_RIP,D_N_RIP,D_N_RIP,D_NE_RIP,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Stair,Guard_RIP,Guard_RIP,D_SW_RIP,Cave,Cave,D_SE_RIP,Guard_RIP,Guard_RIP,Guard_RIP,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Guard_RIP,Guard_RIP,Guard_RIP,Dark,Dark,Dark,Dark,Guard_RIP,Guard_RIP,Guard_RIP,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(4,3) [35] East of Level 6
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_SE,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Snail,Null,Null,Null,R_0,R_0,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Snail,Stair,Snail,Null,Null,R_0,R_0,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Snail,Null,Null,Null,R_0,R_0,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,Null,Null,Null,Null,Null,Null,
			R_0,R_NE,Null,Null,Null,Null,Null,R_NW,R_0,R_0,R_NE,Null,Null,Null,Null,Null,
			R_0,R_0,R_N,R_N,R_N,R_N,Ladder,R_0,R_0,R_0,R_0,R_N,R_N,Ladder,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0
		},
		{	//(5,3) [36] East-East of Level 6
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,Ladder,R_0,R_SE,R_SW,R_0,R_0,
			Null,Null,Null,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_0,R_0,R_N,R_NE,R_NW,R_N,R_N,R_N,R_N,R_NE,R_NW,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
		},
		{	//(6,3) [37] South-South of Level 9
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_SE,R_SW,R_0,R_0,Cave,R_0,R_0,Ladder,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Guard,Null,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_N,R_N,R_N,R_N,Ladder,R_N,R_NE,R_NW,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
		},
		{	//(7,3) [38] North-West of Level 1
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,R_SW,R_0,R_0,R_SE,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,Null,Null,Null,Null,Null,R_SW,R_SE,Null,Null,R_SW,R_0,R_SE,R_SW,R_0,R_SE,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_N,W_N,
			R_0,Null,Null,Null,Null,Null,R_NW,R_NE,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_NE,Null,Null,Null,R_NW,R_0,R_0,R_NE,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,R_N,R_0,R_0,R_0,R_0,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(8,3) [39] North of Level 1
			R_0,R_0,R_0,R_0,R_0,R_0,W_0,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,W_0,Null,Null,Null,Null,R_0,R_0,R_0,Cave,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,W_0,Null,Null,Null,Null,R_0,R_0,R_0,Null,Null,
			R_SW,R_0,R_SE,R_SW,R_0,R_SE,W_0,Null,Null,Null,Null,R_SW,R_0,R_SE,Null,Null,
			Null,Null,Null,Null,Null,Null,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,W_0,W_SW_I,Null,Null,Null,Null,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_0,W_0,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(9,3) [40] North-East of Level 1
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_NE,Null,Null,Null,Null,Null,Null,Stair,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Bush,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Bush,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(10,3) [41] North of East Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(11,3) [42] North-East of East Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_N,R_N,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_N,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0
		},
		{	//(12,3) [43] North-West of Level 2
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_N,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_N,R_N,
			R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0
		},
		{	//(13,3) [44] North of Level 2
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,R_NE,Null,Null,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,R_NW,R_0,R_0,R_0,R_0,R_NE,Null,R_SW,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,Cave,R_SE,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(14,3) [45] North-East of Level 2
			R_0,R_0,Ladder,R_0,R_0,R_0,R_0,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Ladder,R_0,R_0,Cave,R_SE,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Ladder,R_0,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Ladder,R_0,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Ladder,R_SE,Null,Null,Null,Null,Null,W_SW,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,Null,Null,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(15,3) [46] North-East-East of Level 2
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,W_NE_I,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_N,R_N,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(16,3) [47] South-South of North-East Corner
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,D_NW_RIP,D_NE_RIP,Dark,D_NW_RIP,D_N_RIP,D_NE_RIP,Dark,D_NW_RIP,D_NE_RIP,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,D_SW_RIP,D_SE_RIP,Dark,D_SW_RIP,Cave,D_SE_RIP,Dark,D_SW_RIP,D_SE_RIP,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,Ladder_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_0_RIP,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP
		},
		{	//(1,4) [48] South-West-West of Level 6
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_SW_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_NW_RIP,R_N_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP
		},
		{	//(2,4) [49] South-West of Level 6
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_0_RIP,R_SE_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_0_RIP,R_NE_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP
		},
	
		{	//(3,4) [50] South of Level 6
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,Ladder,R_0,Null,Null,R_SW,R_0,R_0,R_0,R_0,
			R_SW,R_SE,Null,Null,R_SW,R_0,R_0,Ladder,R_0,Null,Null,Null,R_SW,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,R_SW,R_0,Ladder,R_SE,Null,Null,Null,Null,R_SW,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,
			R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(4,4) [51] South-East of Level 6
			R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,Cave,R_0,R_0,Ladder,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_SE,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Dark,R_0,R_0,
			Null,Null,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_NE,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Guard_RIP,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(5,4) [52] North-West of Level 4
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,Null,Guard,Null,Stair,Null,Guard,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Guard,Null,Guard,Null,Guard,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_N,W_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(6,4) [53] North of Level 4
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Ladder,R_0,R_SE,R_SW,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_SE,
			R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
		},
		{	//(7,4) [54] West of Level 1
			R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_SW,R_SE,Null,Null,R_SW,R_0,R_SE,R_SW,R_SE,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(8,4) [55] Level 1
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,T_NW,T_NE,Null,T_NW,T_N,T_NE,Null,T_NW,T_NE,Null,Null,R_0,W_0,
			W_0,R_0,Null,T_SW,T_SE,Null,T_SW,Cave,T_SE,Null,T_SW,T_SE,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Dock,
			W_0,R_0,Null,T_NW,T_NE,Null,Null,Null,Null,Null,T_NW,T_NE,Null,Null,R_N,W_0,
			W_0,R_0,Null,T_SW,T_SE,Null,Null,Null,Null,Null,T_SW,T_SE,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,W_0,
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0
		},
		{	//(9,4) [56] East of Level 1
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Bush,Null,Null,Bush,
			Dock,Dock,Dock,Dock,Dock,Dock,Dock,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Bush,Null,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(10,4) [57] East Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,Null,Null,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_NE,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Bush,Null,W_W,W_0,W_0,W_0,W_0,W_E,Null,Bush,Null,Null,R_0,
			R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Bush,Null,W_SW,W_S,W_S,W_S,W_S,W_SE,Null,Bush,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Null,Null,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(11,4) [58] East of East Fairy Pond
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Sand,Sand,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Sand,Sand,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(12,4) [59] East-East of East Fairy Pond
			R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			R_0,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,Sand,R_0,R_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,Sand,Sand,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Sand,Sand,R_0,R_0
		},
		{	//(13,4) [60] Level 2
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,R_SE,Null,Null,Null,Null,D_NW,D_N,D_NE,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Guard,Null,Guard,D_SW,Cave,D_SE,Guard,Null,Guard,Null,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Guard,Null,Guard,Null,Null,Null,Guard,Null,Guard,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(14,4) [61] East of Level 2
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Guard,Null,Null,Stair,Null,Null,Null,Bush,Null,Bush,
			Bush,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Bush,
			Bush,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Null,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			Bush,Null,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush
		},
		{	//(15,4) [62] East-East of Level 2
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_SW,W_S,W_S,W_S,W_S,W_S,W_S,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(16,4) [63] South-South-South of North-East Corner
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_S,W_S,W_S,W_S,W_S,W_S,Dock,W_S,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,W_NE_I,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_N,R_N,R_N,R_N,R_N,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
		},
		{	//(1,5) [64] South-South-West-West of Level 6
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,R_NE_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,
			R_0_RIP,R_0_RIP,R_0_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,Ladder_RIP,R_N_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP
		},
	{	//(2,5) [65] South-South-West of Level 6
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Dark,RIP,Dark,Bush_RIP,Bush_RIP,
			Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Bush_RIP,Bush_RIP,
			R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,R_N_RIP,Bush_RIP,Bush_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Bush_RIP,Bush_RIP
		},
	
		{	//(3,5) [66] West of West Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,Null,Null,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_NE,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Bush,Null,W_W,W_0,W_0,W_0,W_0,W_E,Null,Bush,Null,Null,R_0,
			R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Bush,Null,W_SW,W_S,W_S,W_S,W_S,W_SE,Null,Bush,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Null,Null,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(4,5) [67] West Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_0,Null,Null,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_NE,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Bush,Null,W_W,W_0,W_0,W_0,W_0,W_E,Null,Bush,Null,Null,R_0,
			R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,R_0,
			R_0,Null,Null,Bush,Null,W_SW,W_S,W_S,W_S,W_S,W_SE,Null,Bush,Null,Null,R_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Null,Null,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(5,5) [68] West of Level 4
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,Null,Null,Bush,Null,Bush,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,Null,Null,Bush,Null,Bush,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(6,5) [69] Level 4
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,D_NW,D_NE,Null,D_NW,D_N,D_NE,Null,D_NW,D_NE,Null,R_0,W_0,
			W_0,R_0,Null,Null,D_SW,D_SE,Null,D_SW,Cave,D_SE,Null,D_SW,D_SE,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,W_0,
			W_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,Ladder,R_N,R_N,R_N,R_N,R_N,R_0,W_0,
			W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,W_0
		},
		{	//(7,5) [70] South-West of Level 1
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_NW_I,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Stair,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(8,5) [71] South of Level 1
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Stair,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(9,5) [72] South-East of Level 1
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Stair,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			W_S,W_S,W_S,W_S,W_S,W_S,W_SE,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},	
		{	//(10,5) [73] South of East Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Stair,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Snail,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(11,5) [74] South-East of East Fairy Pond
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,Null,Null,R_0,R_0,Cave,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,
			R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,
			R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,
			R_0,R_0,R_0,R_NE,R_NW,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(12,5) [75] South-West of Level 2
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Stair,Null,Null,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Bush,Bush,Null,Null,Bush,Bush,
			Null,Null,Bush,Null,Null,Null,Bush,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Null,Bush,Bush
		},
		{	//(13,5) [76] South of Level 2
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Ladder,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,R_SW,R_SE,R_SW,R_0,Ladder,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,
			R_0,R_0,Null,Null,Null,Null,R_0,Ladder,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,R_0,Ladder,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,
			R_0,Null,Null,Null,Null,Null,R_SW,Ladder,R_0,R_0,R_SE,Null,Null,R_SW,R_0,R_SE,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_N,R_NE,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,
			R_0,R_0,R_NE,R_NW,R_NE,R_NW,R_N,R_N,R_N,R_N,R_N,R_NE,R_NW,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(14,5) [77] South-East of Level 2
			Bush,Null,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			Bush,Null,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,
			Null,Null,Bush,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,Null,Null,
			Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Null,
			Null,Null,Bush,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Stair,Null,Null,
			Bush,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush
		},
		{	//(15,5) [78] South-East-East of Level 2
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Guard,Null,Null,Null,Null,Stair,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(16,5) [79] North-North-North of South-East Corner
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,W_W,Dock,W_0,Dock,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_N,R_NE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(1,6) [80] North-North of South-West Corner
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,R_0_RIP,Ladder_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_N_RIP,R_0_RIP,
			R_0_RIP,R_0_RIP,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,Dark,R_0_RIP,R_0_RIP
		},
		{	//(2,6) [81] South-West-West of West Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Stair,Null,Null,Null,Null,Null,Null,
			Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush
		},
		{	//(3,6) [82] South-West of West Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Null,Null,Null,Null,Null,Bush,Bush
		},
		{	//(4,6) [83] South of West Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush
		},
		{	//(5,6) [84] South-West of Level 4
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Null,Null,Null,Bush,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_SW,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_N,R_N,
			Bush,Bush,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Null,R_0,R_0,
			Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Null,R_0,R_0
		},
		{	//(6,6) [85] South of Level 4
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_S,W_S,W_S,W_S,W_0,W_0,W_0,W_0,Dock,W_S,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,W_NE_I	,W_0,W_0,W_NW_I,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,R_N,R_N,
			R_0,R_0,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_0,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_0,Null,Null,Null,W_0,W_0,Null,Null,Null,R_N,Null,R_N,Null,R_0,R_0,
			R_0,R_0,Null,Null,Null,W_0,W_0,Null,Null,Null,R_0,Null,R_0,Null,R_0,R_0,
		},
		{	//(7,6) [86] South-East of Level 4
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_S,W_S,W_S,W_S,W_S,W_S,W_SE,Null,Null,Null,Bush,Null,Bush,Bush,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,Null,Null,Null,Null,Null,Null,Null,Stair,Null,Bush,Bush,Null,Null,
			R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			R_0,R_0,R_0,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(8,6) [87] South-East-East of Level 4
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(9,6) [88] South-South-East of Level 1
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Null,Bush,Null,Bush,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Null,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Null,Bush,Null,Bush,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			Bush,Bush,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush
		},
		{	//(10,6) [89] South-South-South of East Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_N,W_N,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(11,6) [90] South-South-South-East of East Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_NE,Null,Null,Null,Null,Null,Null,Bush,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Bush,Bush,Bush,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Bush,Bush,Bush,Null,Bush
		},
		{	//(12,6) [91] South-South-West of Level 2
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Null,Bush,Bush,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Null,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Null,Null,Stair,Null,Null,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Bush,Bush,Bush
		},
		{	//(13,6) [92] South-South of Level 2
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush
		},
		{	//(14,6) [93] South-South-East of Level 2
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush
		},
		{	//(15,6) [94] North-North-West of South-East Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_SE,Null,Null,R_SW,R_0,
			R_SE,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,R_0,
			R_NE,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,R_NE,Null,Null,R_NW,R_0,
			R_0,R_0,R_N,R_N,R_N,R_NE,R_NW,R_N,R_0,R_0,R_0,R_0,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(16,6) [95] North-North of South-East Corner
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,W_W,Dock,W_0,Dock,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_N,R_NE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(1,7) [96] North of South-West Corner
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
		},
		{	//(2,7) [97] North-East of South-West Corner
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush
		},
		{	//(3,7) [98] South-South-West of West Fairy Pond
			Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Stair,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
	
		},
		{	//(4,7) [99] South-South of West Fairy Pond
			Bush,Bush,Bush,Bush,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,Null,Bush,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Stair,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush
		},
		{	//(5,7) [100] North of Level 3
			R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,Null,R_0,R_0,
			R_0,R_0,R_0,Null,Null,R_SW,R_0,Cave,R_SE,Null,Null,R_SW,R_SE,Null,R_SW,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(6,7) [101] South-South of Level 4
			R_0,R_0,Null,Null,Null,W_0,W_0,Null,Null,Null,R_0,Null,R_0,Null,R_0,R_0,
			R_0,R_SE,Null,Null,Null,W_0,W_0,Null,Null,Null,R_0,Null,R_0,Null,R_SW,R_0,
			Null,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Snail,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Snail,Null,Null,Null,
			Null,Null,Null,Null,Null,Dock,Dock,Null,Null,Null,Snail,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Snail,Null,Null,Null,
			Null,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Snail,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_N,R_N,R_NE,Null,W_0,W_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,Null,W_0,W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(7,7) [102] North-West of Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Snail,Snail,Snail,Snail,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,
			Null,Null,Null,Null,Null,Null,Null,Null,Snail,Snail,Snail,Null,Null,Null,Null,Null,
			Null,Null,Null,Snail,Snail,Snail,Snail,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Snail,Snail,Snail,Null,Null,Null,Null,Null,
			Null,Null,Null,Snail,Snail,Snail,Snail,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,Null,Null,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0
		},
		{	//(8,7) [103] North of Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,Null,Null,Null,R_SW,R_0,
			R_SE,Null,Null,Snail,Null,Snail,Null,Null,Null,Null,Null,Null,Snail,Null,Null,R_SW,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Snail,Null,Snail,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NE,Null,Null,Snail,Null,Snail,Null,Null,Null,Null,Null,Null,Snail,Null,Null,R_NW,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,R_NW,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,Null,Null,R_0,R_0,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(9,7) [104] North-East of Home Screen
			R_0,R_0,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			R_0,R_0,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			R_SE,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,
			Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Null,
			Null,Null,Stair,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NE,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			R_0,R_0,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			R_0,R_0,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush
		},
		{	//(10,7) [105] North-East_East of Home Screen
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Bush,Null,Null,Null,Null,Bush,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Bush,Null,Null,Null,Null,Null,Null,W_SW,W_S,W_S,W_S,W_S,W_S,W_S,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(11,7) [106] South_South_South_East of East Fairy Pond
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Bush,Bush,Bush,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Bush,Bush,Bush,Null,Bush,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_0,W_0,W_0,W_0,W_0,W_0,W_E,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_S,W_S,W_S,W_S,W_S,W_S,W_SE,Null,Null,Null,Null,Bush,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Stair,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(12,7) [107] South_South_South_West of Level 2
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Null,Null,Bush,Null,Null,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,
			Null,Null,Bush,Null,Null,Null,Bush,Null,Stair,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Bush,Bush
		},
		{	//(13,7) [108] South_South_South of Level 2
			Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Null,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(14,7) [109] North-West-West of South-East Corner
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Bush,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Stair,Null,Null,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(15,7) [110] North-West of South-East Corner
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Null,Null,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,Null,Null,
			Null,Null,Null,Bush,Bush,Bush,Null,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,Null,Null,
			Bush,Null,Null,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(16,7) [111] North of South-East Corner
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_SW,R_0,R_0,Cave,R_SE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_NW,R_N,R_N,R_N,R_NE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(1,8) [112] South-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_SE,Null,Null,T_NW,T_NE,Null,T_NW,T_NE,Null,Null,Null,Null,Null,Null,
			R_0,R_SE,Null,Null,Null,T_SW,T_SE,Null,T_SW,T_SE,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_NE,Null,Null,Null,Null,T_NW,T_NE,Null,T_NW,T_NE,Null,Null,Null,Null,Null,
			R_0,R_0,R_NE,Null,Null,Null,T_SW,T_SE,Null,T_SW,T_SE,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(2,8) [113] East of South-West Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,R_SW,Cave,R_0,R_0,R_0,R_SE,Null,Null,R_SW,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(3,8) [114] West-West of Level 3
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
		},
		{	//(4,8) [115] West of Level 3
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Bush,Null,Bush,Null,Bush,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Bush,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Bush,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(5,8) [116] Level 3
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,
			R_SE,Null,Null,Null,Null,Null,Null,D_NW,D_N,D_NE,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Guard,Null,Guard,D_SW,Cave,D_SE,Guard,Null,Guard,Null,Null,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			Null,Null,Null,Null,Guard,Null,Guard,Null,Null,Null,Guard,Null,Guard,Null,Null,R_0,
			R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(6,8) [117] West-West of Home Screen
			R_0,R_0,R_0,R_0,Null,W_0,W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,Cave,R_SE,Null,W_0,W_0,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,W_0,W_0,Null,Snail,Null,Null,Null,Snail,Null,Null,Null,
			R_0,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Snail,Null,Null,Null,Null,Null,
			R_0,Null,Null,Snail,Null,W_0,W_0,Null,Snail,Null,Null,Null,Snail,Null,Null,Null,
			R_0,Null,Null,Null,Null,W_0,W_0,Null,Null,Null,Snail,Null,Null,Null,Null,Null,
			R_0,Null,Null,Null,Null,W_0,W_0,Null,Snail,Null,Null,Null,Snail,Null,Null,Null,
			R_0,R_NE,Null,Null,Null,W_0,W_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_N,R_N,R_NE,W_0,W_0,R_NW,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,
			R_0,R_0,R_0,R_0,R_0,W_0,W_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
		},
		{	//(7,8) [118] West of Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_SE,Null,Null,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,R_SW,
			Null,Null,Snail,Null,Null,Snail,Null,Null,Snail,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,R_NW,
			Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,Null,Null,R_NW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(8,8) [119] Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,Cave,R_0,R_SE,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_NE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_N,R_N,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,
			R_0,R_0,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_N,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(9,8) [120] East of Home Screen
			R_0,R_0,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			R_0,R_0,Bush,Null,Bush,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Bush,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_SE,Null,Null,Null,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Null,
			R_SE,Null,Bush,Null,Bush,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Null,
			R_NE,Null,Bush,Null,Stair,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_NE,Null,Null,Null,Null,Bush,Null,Null,Bush,Null,Bush,Null,Bush,Null,Null,
			R_0,R_0,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,
			R_0,R_0,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush,Bush
		},
		{	//(10,8) [121] East-East of Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SW,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,R_SW,R_0,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,R_SW,R_0,R_0,R_0,
			Null,Null,R_SW,R_0,R_0,R_0,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,
			Null,Null,Null,R_SW,R_0,R_0,Null,Null,Null,Snail,Null,Null,Null,R_SW,R_0,R_0,
			Null,Null,Null,Null,R_SW,R_SE,Null,Null,Snail,Stair,Snail,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Snail,Null,Null,Null,R_NW,R_N,R_N,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,
			Null,Null,Null,Null,R_NW,R_NE,Null,Null,Null,Null,Null,Null,R_NW,R_0,R_0,R_0,
			R_NW,R_N,R_N,R_N,R_0,R_0,R_NE,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(11,8) [122] East-East-East of Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_SE,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_SE,R_SW,R_SE,Null,Null,R_SW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_SE,R_SW,R_SE,Null,Null,Null,Null,Null,Null,Null,R_SW,R_SE,R_SW,R_SE,R_SW,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_NE,R_NW,R_NE,Null,Null,Null,Null,Null,Null,Null,R_NW,R_NE,R_NW,R_NE,R_NW,R_N,
			R_0,R_0,R_0,R_NE,Null,Null,Null,Null,Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_NE,R_NW,R_NE,Null,Null,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_NE,R_NW,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0
		},
		{	//(12,8) [123] East-East-East-East of Home Screen
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Null,Null,Null,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,Null,Null,Null,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_0,R_0,R_0,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_0,R_SE,R_SW,R_0,R_SE,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			R_N,R_NE,R_NW,R_N,R_NE,Null,Null,W_NW,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,
			R_0,R_0,R_0,R_0,R_0,R_NE,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_NE,W_W,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_W,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,W_W,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(13,8) [124] West-West-West of South-East Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(14,8) [125] West-West of South-East Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,Cave,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(15,8) [126] West of South-East Corner
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,R_0,
			Null,Null,R_SW,R_0,R_SE,R_SW,R_0,R_0,R_0,R_SE,R_SW,R_0,R_SE,R_SW,R_SE,R_SW,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,Null,
			W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		},
		{	//(16,8) [127] South-East Corner
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_0,R_0,R_0,R_0,R_0,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			R_SE,R_SW,R_0,R_0,R_SE,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,Null,W_W,W_0,W_0,W_0,W_0,W_0,W_0,
			Null,Null,Null,Null,Null,Null,Null,Null,W_SE_I,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_N,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,
			W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0,W_0
		}
	};
	
	//864
	static unsigned short Link[2][4][2][27]=
	{
		{	//[0] Small Shield
			{	//[0] Up
				{	//[0] Static
					0xC1FF,0x007F,0x007F,0x80FF,0x00FF,0x007F,0x807F,0x80FF,0x88FF,	//Mask
					0x0000,0xC180,0xE380,0x7F00,0x8100,0xC180,0x3F80,0x4000,0x7700,	//Light
					0x3E00,0x7F00,0x3E00,0x3E00,0xFF00,0xFF00,0x7E00,0x7F00,0x7700	//Dark
				},
				{	//[1] Walking
					0xC1FF,0x007F,0x007F,0x80FF,0x807F,0x007F,0x00FF,0x80FF,0x88FF,	//Mask
					0x0000,0xC180,0xE380,0x7F00,0x4080,0xC180,0xFE00,0x0100,0x7700,	//Light
					0x3E00,0x7F00,0x3E00,0x3E00,0x7F80,0x7F80,0x3F00,0x7F00,0x7700	//Dark
				}
			},
			{	//[1] Left
				{	//[0] Static
					0xC07F,0xE03F,0x807F,0x60FF,0x007F,0x007F,0x607F,0xF83F,0xF0FF,	//Mask
					0x3E00,0x1700,0x7F80,0x9C00,0xE380,0xFF00,0x8000,0x0700,0x0F00,	//Light
					0x3F80,0x0AC0,0x0980,0x8300,0xBD80,0xBD80,0x9F80,0x07C0,0x0F00	//Dark
				},
				{	//[1] Walking
					0x807F,0xC03F,0x80BF,0x41FF,0x00FF,0x00FF,0x40FF,0xC07F,0x8E7F,	//Mask
					0x7C00,0x2E00,0x7F00,0xB800,0xC700,0xE700,0x9C00,0x2080,0x7180,	//Light
					0x7F80,0x15C0,0x1340,0x8600,0xBB00,0xBB00,0xBF00,0x3F80,0x7180	//Dark
				}
			},
			{	//[2] Down
				{	//[0] Static
					0xC0FF,0x807F,0x803F,0xC03F,0xC03F,0x003F,0x007F,0x00FF,0x9CFF,	//Mask
					0x3F00,0x6D80,0x7FC0,0x3FC0,0x1EC0,0xF0C0,0xFF00,0xF000,0x6300,	//Light
					0x3F00,0x3300,0x1240,0x00C0,0x2D00,0xFF80,0xFF80,0xFF00,0x6300	//Dark
				},
				{	//[1] Walking
					0xC0FF,0x807F,0x803F,0xC0BF,0xC03F,0x003F,0x003F,0x007F,0x9FFF,	//Mask
					0x3F00,0x6D80,0x7FC0,0x3F40,0x1EC0,0xF0C0,0xFFC0,0xF000,0x6000,	//Light
					0x3F00,0x3300,0x1240,0x0040,0x2DC0,0xFF40,0xFF00,0xFF80,0x6000	//Dark
				}
			},
			{	//[3] Right
				{	//[0] Static
					0x80FF,0x01FF,0x807F,0xC1BF,0x803F,0x803F,0x81BF,0x07FF,0xC3FF,	//Mask
					0x1F00,0x3A00,0x7F80,0x0E40,0x71C0,0x3FC0,0x0040,0x3800,0x3C00,	//Light
					0x7F00,0xD400,0x6400,0x3040,0x6F40,0x6F40,0x7E40,0xF800,0x3C00	//Dark
				},
				{	//
					0x807F,0x00FF,0x407F,0xE0BF,0xC03F,0xC03F,0xC0BF,0x80FF,0x9C7F,	//Mask
					0x0F80,0x1D00,0x3F80,0x0740,0x38C0,0x39C0,0x2E40,0x4100,0x6380,	//Light
					0x7F80,0xEA00,0xB200,0x1840,0x3740,0x3740,0x3F40,0x7F00,0x6380	//Dark
				}
			}
		},
		{	//[1] Magic Shield
			{	//[0] Up
				{	//[0] Static
					0xC1FF,0x007F,0x007F,0x80FF,0x00FF,0x007F,0x807F,0x80FF,0x88FF,	//Mask
					0x0000,0xC180,0xE380,0x7F00,0x8100,0xC180,0x3F80,0x4000,0x7700,	//Light
					0x3E00,0x7F00,0x3E00,0x3E00,0xFF00,0xFF00,0x7E00,0x7F00,0x7700	//Dark
				},
				{	//[1] Walking
					0xC1FF,0x007F,0x007F,0x80FF,0x807F,0x007F,0x00FF,0x80FF,0x88FF,	//Mask
					0x0000,0xC180,0xE380,0x7F00,0x4080,0xC180,0xFE00,0x0100,0x7700,	//Light
					0x3E00,0x7F00,0x3E00,0x3E00,0x7F80,0x7F80,0x3F00,0x7F00,0x7700	//Dark
				}
			},
			{	//[1] Left
				{	//[0] Static
					0xC07F,0xE03F,0x007F,0x60FF,0x007F,0x007F,0x607F,0x783F,0xF0FF,	//Mask
					0x3E00,0x1700,0xFF80,0x9C00,0xE380,0xFF00,0x8000,0x8700,0x0F00,	//Light
					0x3F80,0x0AC0,0x8980,0x8300,0xBD80,0xBD80,0x9F80,0x87C0,0x0F00	//Dark
				},
				{	//[1] Walking
					0x807F,0xC03F,0x00BF,0x41FF,0x00FF,0x00FF,0x40FF,0x407F,0x8E7F,	//Mask
					0x7C00,0x2E00,0xFF00,0xB800,0xC700,0xE700,0x9C00,0xA080,0x7180,	//Light
					0x7F80,0x15C0,0x9340,0x8600,0xBB00,0xBB00,0xBF00,0xBF80,0x7180	//Dark
				}
			},
			{	//[2] Down
				{	//[0] Static
					0xC0FF,0x807F,0x803F,0xC03F,0x003F,0x003F,0x007F,0x00FF,0x8CFF,	//Mask
					0x3F00,0x6D80,0x7FC0,0x3FC0,0xFEC0,0xF8C0,0xFF00,0xF800,0x7300,	//Light
					0x3F00,0x3300,0x1240,0x00C0,0xFD00,0xDF80,0x8F80,0xDF00,0x7300	//Dark
				},
				{	//[1] Walking
					0xC0FF,0x807F,0x803F,0xC0BF,0x003F,0x003F,0x003F,0x007F,0x8FFF,	//Mask
					0x3F00,0x6D80,0x7FC0,0x3F40,0xFEC0,0xF8C0,0xFFC0,0xF800,0x7000,	//Light
					0x3F00,0x3300,0x1240,0x0040,0xFDC0,0xDF40,0x8F00,0xDF80,0x7000	//Dark
				}
			},
			{	//[3]Right
				{	//[0] Static
					0x80FF,0x01FF,0x803F,0xC1BF,0x803F,0x803F,0x81BF,0x07BF,0xC3FF,	//Mask
					0x1F00,0x3A00,0x7FC0,0x0E40,0x71C0,0x3FC0,0x0040,0x3840,0x3C00,	//Light
					0x7F00,0xD400,0x6440,0x3040,0x6F40,0x6F40,0x7E40,0xF840,0x3C00	//Dark
				},
				{	//[1] Walking
					0x807F,0x00FF,0x403F,0xE0BF,0xC03F,0xC03F,0xC0BF,0x80BF,0x9C7F,	//Mask
					0x0F80,0x1D00,0x3FC0,0x0740,0x38C0,0x39C0,0x2E40,0x4140,0x6380,	//Light
					0x7F80,0xEA00,0xB240,0x1840,0x3740,0x3740,0x3F40,0x7F40,0x6380	//Dark
				}
			}
		}
	};
	
	//270
	static unsigned short Link_Strike[6][3][9]= {	//Read in EXE and DLL as Link_Strike[6][27]
		{	//[0]Up
			{0xC1FF,0x007F,0x007F,0x00BF,0x003F,0x803F,0x003F,0x00FF,0xFC7F},	//[0]Mask
			{0x0000,0xC180,0xE380,0xFF40,0x81C0,0x41C0,0xBFC0,0xC000,0x0380},	//[1]]Light
			{0x3E00,0x7F00,0x3E00,0xBE40,0xFFC0,0x7FC0,0xFEC0,0xFF00,0x0380}	//[2]Dark
		},
		{	//[1]Left
			{0x00FF,0x807F,0x017F,0x81FF,0x00FF,0x007F,0xC07F,0x803F,0x1F3F},	//[0]Mask
			{0xF800,0x5C00,0xFE00,0x7000,0xFE00,0xFC00,0x0780,0x4040,0xE0C0},	//[1]]Light
			{0xFF00,0x2B80,0x2680,0x0E00,0x3F00,0x3F80,0x3F80,0x7FC0,0xE0C0}	//[2]Dark
		},
		{	//[2]Down
			{0xC0FF,0x007F,0x007F,0x00FF,0x80FF,0x807F,0x807F,0x007F,0xF03F},	//[0]Mask
			{0x3F00,0xED80,0xBF80,0xBF00,0x1E00,0x4380,0x3F00,0xC600,0x0FC0},	//[1]]Light
			{0x3F00,0xF300,0xD200,0xCC00,0x6D00,0x7F80,0x7F80,0xF980,0x01C0}	//[2]Dark
		},
		{	//[3]Right
			{0xC03F,0x807F,0xA03F,0xE07F,0xC03F,0x803F,0x80FF,0x007F,0x3E3F},	//[0]Mask
			{0x07C0,0x0E80,0x1FC0,0x0380,0x1FC0,0x0FC0,0x7800,0x8080,0xC1C0},	//[1]]Light
			{0x3FC0,0x7500,0x5900,0x1C00,0x3F00,0x7F00,0x7F00,0xFF80,0xC1C0}	//[2]Dark
		},
		{	//[4]Lift_Item
			{0x207F,0x003F,0x003F,0x803F,0x803F,0x803F,0xC07F,0xC0FF,0xCCFF},	//[0]Mask
			{0xCF80,0x3DC0,0x3FC0,0x3FC0,0x1EC0,0x40C0,0x3F00,0x0000,0x3300},	//[1]]Light
			{0x1780,0xD280,0xC240,0x48C0,0x6D00,0x7F80,0x3F80,0x3F00,0x3300}	//[2]Dark
		},
		{	//[4]Lift_Triforce
			{0x003F,0x003F,0x003F,0x807F,0x807F,0x807F,0x807F,0xC0FF,0xCCFF},	//[0]Mask
			{0xFFC0,0x3F00,0x3F00,0x3F00,0x1E00,0x4080,0x3F00,0x0000,0x3300},	//[1]]Light
			{0x3F00,0xD2C0,0xC0C0,0x4C80,0x6D80,0x7F80,0x7F80,0x3F00,0x3300}	//[2]Dark
		}
	};
	
	
	//3960
	static unsigned long Menu_Tiles[5][2][99]= {	//Read in EXE and DLL as Menu_Tiles[5][198]
		{	//[0] (0-31)
			{	//[0] Light
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFE2D68,0xFFFF656B,0xFFFF6968,0xFFFF6D5B,0xFFFE2D38,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFDB10FC7,0xFDAF7FDB,0xFDB31FC7,0xFDBD7FDB,0xFE630FC7,0xFFFFFFFF,0xFFFF0CC7,
				0xFFFF7B5B,0xFFFF1B47,0xFFFF7B5B,0xFFFF7CDB,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			},
			{	//[1] Dark
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFC,
				0xFFFFFFF8,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,0xFFFFFFF9,
				0xFFFFFFF9,0xFFFFFFF8,0xFFFFFFFC,0xFFFFFFFF,0xFDB10FC7,0xFDAF7FDB,0xFDB31FC7,0xFDBD7FDB,0xFE630FC7,0xFFFFFFFF,0xFFFF0CC7,
				0xFFFF7B5B,0xFFFF1B47,0xFFFF7B5B,0xFFFF7CDB,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		},
		{	//[0] (32-63)
			{	//[0] Light
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x5A331AFF,0xCB6D6AFF,0xD36D18FF,0xDB6D6DFF,0x5B736DFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF1B4466D,0xF6B6EDA5,0xF1B6EDA9,0xF6B6EDAD,0xF1CEEE6D,0xFFFFFFFF,0xF8B463FF,
				0xFDB6DFFF,0xFD86E7FF,0xFDB6FBFF,0xFDB447FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFF6FF,0xFFFFE3FF,0xFFFFE4FF,0xFFFFF9FF,0xFFFFEBFF,0xFFFFFFFF,0xFFFFFF97,0xFFFFFFC7,0xFFFFFFEF,
				0xFFFFFFC7,0xFFFFFF97,0xFFFFFFFF,0xFFFFF397,0xFFFFE9C7,0xFFFFD1EF,0xFFFFC1C7,0xFFFFE397,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			},
			{	//[1] Dark
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x003FFFFF,
				0x001FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,0xFF9FFFFF,
				0xFF9FFFFF,0x001FFFFF,0x003FFFFF,0xFFFFFFFF,0xF1B4466D,0xF6B6EDA5,0xF1B6EDA9,0xF6B6EDAD,0xF1CEEE6D,0xFFFFFFFF,0xF8B463FF,
				0xFDB6DFFF,0xFD86E7FF,0xFDB6FBFF,0xFDB447FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFF9FF,0xFFFFFEFF,0xFFFFDFFF,0xFFFFDFFF,0xFFFFDFFF,0xFFFFFFFF,0xFFFFFA97,0xFFFFF4C7,0xFFFFEFEF,
				0xFFFFD7C7,0xFFFFEF97,0xFFFFFFFF,0xFFFFEF97,0xFFFFC7C7,0xFFFFEFEF,0xFFFFFFC7,0xFFFFFF97,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		},
		{	//[0] (64-95)
			{	//[0] Light
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFF1FFF,0xFFFF6FFE,0xFFFF1FFE,0xFFFF6FFE,0xFFFF1FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			},
			{	//[1] Dark
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFC00,0xFFFFF800,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,
				0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,0xFFFFF9FF,
				0xFFFFF9FF,0xFFFFF9FF,0xFFFFF800,0xFFFFFC00,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFF1FFF,0xFFFF6FFE,0xFFF919F2,0xFFF168E2,0xFFF31CE6,0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,
				0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,0xFFF3FCE7,0xFFF000E0,0xFFF801F0,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		},
		{	//[0] (96-127)
			{	//[0] Light
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0x3FFFFFFF,0xDFFFFFEF,0xDFFFFFEF,0x1FFFF86F,0xDFFFFFEF,0xFFFFFFE1,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			},
			{	//[1] Dark
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0x00000000,0x00000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0x00000000,0x00000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0x3FFFFFFF,0xDFFFFFFF,0xD3FFFFFF,0x11FFFFFF,0xD9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,
				0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0xF9FFFFFF,0x01FFFFFF,0x03FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		},
		{	//[0] (128-159)
			{	//[0] Light
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0x1087FFFF,0xB7BFFFFF,0xB18E1FFF,0xB7BFFFFF,0x1787FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			},
			{	//[1] Dark
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0x0001FFFF,0x0000FFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,
				0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,0xFFFCFFFF,
				0xFFFCFFFF,0xFFFCFFFF,0x0000FFFF,0x0001FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		}
	};

	//576
	static unsigned long Triforce_Template[2][2][36]= {	//Read in EXE as Triforce_Template[2][72]
		{	//[0] (0-31)
			{	//[0] Light
				0xFFFFFFF3,0xFFFFFFED,0xFFFFFFDE,0xFFFFFFBF,0xFFFFFF7F,0xFFFFFEF3,0xFFFFFDED,0xFFFFFBDE,0xFFFFF7BF,
				0xFFFFEF7F,0xFFFFDEFF,0xFFFFBDFF,0xFFFF7BFF,0xFFFEF7FF,0xFFFDEFFF,0xFFFBDFFF,0xFFF7BFFF,0xFFEF7FFF,
				0xFFDEFFFF,0xFFBDFFFF,0xFF7BFFFF,0xFEF7FFFF,0xFDEFFFFF,0xFBDFFFFF,0xF7800000,0xEFFFFFFF,0xDFFFFFFF,
				0xBFFFFFFF,0x00000000,0xFFFFFFFF,0xFFFFFFFF,0xFFE2310C,0xFFF6DB7B,0xFFF63B1B,0xFFF6DB7B,0xFFF6D17C
			},
			{	//[1] Dark
				0xFFFFFFF3,0xFFFFFFED,0xFFFFFFDE,0xFFFFFFBF,0xFFFFFF7F,0xFFFFFEF3,0xFFFFFDED,0xFFFFFBDE,0xFFFFF7BF,
				0xFFFFEF7F,0xFFFFDEFF,0xFFFFBDFF,0xFFFF7BFF,0xFFFEF7FF,0xFFFDEFFF,0xFFFBDFFF,0xFFF7BFFF,0xFFEF7FFF,
				0xFFDEFFFF,0xFFBDFFFF,0xFF7BFFFF,0xFEF7FFFF,0xFDEFFFFF,0xFBDFFFFF,0xF7800000,0xEFFFFFFF,0xDFFFFFFF,
				0xBFFFFFFF,0x00000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		},
		{	//[1] (32-60)
			{	//[0] Light
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x7FFFFFFF,0xBFFFFFFF,0xDFFFFFFF,0xEFFFFFFF,0xF7FFFFFF,0x7BFFFFFF,
				0xBDFFFFFF,0xDEFFFFFF,0xEF7FFFFF,0xF7BFFFFF,0xFBDFFFFF,0xFDEFFFFF,0xFEF7FFFF,0xFF7BFFFF,0xFFBDFFFF,
				0xFFDEFFFF,0xFFEF7FFF,0xFFF7BFFF,0xFFFBDFFF,0xFFFDEFFF,0xFFFEF7FF,0x00007BFF,0xFFFFFDFF,0xFFFFFEFF,
				0xFFFFFF7F,0x0000003F,0xFFFFFFFF,0xFFFFFFFF,0xC730FFFF,0x5AD7FFFF,0x46F1FFFF,0x5AD7FFFF,0xDB30FFFF
			},
			{	//[1] Dark
				0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x7FFFFFFF,0xBFFFFFFF,0xDFFFFFFF,0xEFFFFFFF,0xF7FFFFFF,0x7BFFFFFF,
				0xBDFFFFFF,0xDEFFFFFF,0xEF7FFFFF,0xF7BFFFFF,0xFBDFFFFF,0xFDEFFFFF,0xFEF7FFFF,0xFF7BFFFF,0xFFBDFFFF,
				0xFFDEFFFF,0xFFEF7FFF,0xFFF7BFFF,0xFFFBDFFF,0xFFFDEFFF,0xFFFEF7FF,0x00007BFF,0xFFFFFDFF,0xFFFFFEFF,
				0xFFFFFF7F,0x0000003F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
			}
		}
	};
	
	//864
	static unsigned short Triforces[8][2][3][9]=	{
		{	//[0] Triforce_1
			{	//[0] Triforce Absent
				{0xFF7F,0xFE7F,0xFC7F,0xF87F,0xF07F,0xE07F,0xC07F,0x807F,0x007F},	//[0]Mask
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80},	//[1]Light
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0xFF7F,0xFE7F,0xFC7F,0xF87F,0xF07F,0xE07F,0xC07F,0x807F,0x007F},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80}	//[2]Dark
			}
		},
		{	//[1] Triforce_2
			{	//[0] Triforce Absent
				{0x7FFF,0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F},	//[0]Mask
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80},	//[1]Light
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0x7FFF,0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80}	//[2]Dark
			}
		},
		{	//[2] Triforce_3
			{	//[0] Triforce Absent
				{0xFF7F,0xFE7F,0xFC7F,0xF87F,0xF07F,0xE07F,0xC07F,0x807F,0x007F},	//[0]Mask
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80},	//[1]Light
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0xFF7F,0xFE7F,0xFC7F,0xF87F,0xF07F,0xE07F,0xC07F,0x807F,0x007F},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80}	//[2]Dark
			}
		},
		{	//[3] Triforce_4
			{	//[0] Triforce Absent
				{0x7FFF,0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F},	//[0]Mask
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80},	//[1]Light
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0x7FFF,0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80}	//[2]Dark
			}
		},
		{	//[4] Triforce_5
			{	//[0] Triforce Absent
				{0x807F,0xC07F,0xE07F,0xF07F,0xF87F,0xFC7F,0xFE7F,0xFF7F,0xFFFF},	//[0]Mask
				{0x7F80,0x3F80,0x1F80,0x0F80,0x0780,0x0380,0x0180,0x0080,0x0000},	//[1]Light
				{0x7F80,0x3F80,0x1F80,0x0F80,0x0780,0x0380,0x0180,0x0080,0x0000}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0x807F,0xC07F,0xE07F,0xF07F,0xF87F,0xFC7F,0xFE7F,0xFF7F,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x7F80,0x3F80,0x1F80,0x0F80,0x0780,0x0380,0x0180,0x0080,0x0000}	//[2]Dark
			}
		},
		{	//[5] Triforce_6
			{	//[0] Triforce Absent
				{0x7FFF,0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F},	//[0]Mask
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80},	//[1]Light
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0x7FFF,0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xFF00,0xFF80}	//[2]Dark
			}
		},
		{	//[6] Triforce_7
			{	//[0] Triforce Absent
				{0x00FF,0x01FF,0x03FF,0x07FF,0x0FFF,0x1FFF,0x3FFF,0x7FFF,0xFFFF},	//[0]Mask
				{0xFF00,0xFE00,0xFC00,0xF800,0xF000,0xE000,0xC000,0x8000,0x0000},	//[1]Light
				{0xFF00,0xFE00,0xFC00,0xF800,0xF000,0xE000,0xC000,0x8000,0x0000}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0x00FF,0x01FF,0x03FF,0x07FF,0x0FFF,0x1FFF,0x3FFF,0x7FFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0xFF00,0xFE00,0xFC00,0xF800,0xF000,0xE000,0xC000,0x8000,0x0000}	//[2]Dark
			}
		},
		{	//[7] Triforce_8
			{	//[0] Triforce Absent
				{0xFF7F,0xFE7F,0xFC7F,0xF87F,0xF07F,0xE07F,0xC07F,0x807F,0x007F},	//[0]Mask
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80},	//[1]Light
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80}	//[2]Dark
			},
			{	//[1] Triforce Present
				{0xFF7F,0xFE7F,0xFC7F,0xF87F,0xF07F,0xE07F,0xC07F,0x807F,0x007F},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x0080,0x0180,0x0380,0x0780,0x0F80,0x1F80,0x3F80,0x7F80,0xFF80}	//[2]Dark
			}
		}
	};
	
	//4050
	static unsigned short Graphics16[75][3][9]=	{	//Read in EXE and DLL as Graphics16[75][27]
		{	//[0]Wooden_Sword
			{0x9FFF,0x9FFF,0x9FFF,0x9FFF,0x9FFF,0x9FFF,0x0FFF,0x9FFF,0x9FFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF000,0x0000,0x6000},	//[1]Light
			{0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x0000,0x6000,0x0000}	//[2]Dark
		},
		{	//[1]White_Sword
			{0x9FFF,0x9FFF,0x9FFF,0x9FFF,0x9FFF,0x9FFF,0x0FFF,0x9FFF,0x9FFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF000,0x0000,0x6000}	//[2]Dark
		},
		{	//[2]Magical_Sword
			{0x7FFF,0x3FFF,0x1FFF,0x9FFF,0xC7FF,0xCBFF,0xA7FF,0xD3FF,0xFBFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0800,0x0400,0x5800,0x2C00,0x0400}	//[2]Dark
		},
		{	//[3]Normal_Boomerang
			{0x9FFF,0x3FFF,0x3FFF,0x3FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x6000,0xC000,0xC000,0xC000,0x6000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[4]Magical_Boomerang
			{0x9FFF,0x3FFF,0x3FFF,0x3FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x2000,0x4000,0x4000,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x4000,0x8000,0x8000,0x8000,0x4000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[5]Bomb_1
			{0xEFFF,0xF7FF,0xEFFF,0x8FFF,0x07FF,0x07FF,0x07FF,0x8FFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x4000,0xA000,0x4000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x3000,0x1800,0xB800,0xF800,0x7000,0x0000}	//[2]Dark
		},
		{	//[6]Bomb_2
			{0xEFFF,0xF7FF,0xEFFF,0x8FFF,0x07FF,0x07FF,0x07FF,0x8FFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x7000,0xB800,0xF800,0xF800,0x7000,0x0000},	//[1]Light
			{0x1000,0x0800,0x1000,0x7000,0x9800,0xB800,0xF800,0x7000,0x0000}	//[2]Dark
		},
		{	//[7]Wooden_Arrow
			{0xBFFF,0x1FFF,0x1FFF,0xBFFF,0xBFFF,0x1FFF,0xBFFF,0x1FFF,0xBFFF},	//[0]Mask
			{0x4000,0xE000,0xA000,0x0000,0x0000,0xA000,0x0000,0xA000,0x0000},	//[1]Light
			{0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000}	//[2]Dark
		},
		{	//[8]Silver_Arrow
			{0xBFFF,0x1FFF,0x1FFF,0xBFFF,0xBFFF,0x1FFF,0xBFFF,0x1FFF,0xBFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x4000,0xE000,0xA000,0x0000,0x0000,0xA000,0x0000,0xA000,0x0000}	//[2]Dark
		},
		{	//[9]Bow
			{0x1FFF,0x4FFF,0x67FF,0x67FF,0x67FF,0x67FF,0x67FF,0x4FFF,0x1FFF},	//[0]Mask
			{0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000},	//[1]Light
			{0xE000,0x3000,0x1800,0x1800,0x1800,0x1800,0x1800,0x3000,0xE000}	//[2]Dark
		},
		{	//[10]Blue_Candle
			{0xCFFF,0x87FF,0x8FFF,0xFFFF,0x8FFF,0x87FF,0x87FF,0x07FF,0x8FFF},	//[0]Mask
			{0x0000,0x1000,0x6000,0x0000,0x0000,0x0800,0x0800,0x8800,0x7000},	//[1]Light
			{0x3000,0x6800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[11]Red_Candle
			{0xCFFF,0x87FF,0x8FFF,0xFFFF,0x8FFF,0x87FF,0x87FF,0x07FF,0x8FFF},	//[0]Mask
			{0x0000,0x1000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x3000,0x6800,0x1000,0x0000,0x7000,0x7000,0x7000,0x7000,0x0000}	//[2]Dark
		},
		{	//[12]Recorder
			{0x1FFF,0x1FFF,0x1FFF,0x1FFF,0x1FFF,0xBFFF,0x1FFF,0x1FFF,0x1FFF},	//[0]Mask
			{0x8000,0xC000,0x8000,0xC000,0x8000,0x0000,0x8000,0xC000,0x8000},	//[1]Light
			{0x6000,0x6000,0x6000,0x6000,0x6000,0x4000,0x6000,0x6000,0x6000}	//[2]Dark
		},
		{	//[13]Meat_1
			{0xA7FF,0xCFFF,0x87FF,0x03FF,0x03FF,0x03FF,0x87FF,0xCFFF,0x97FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x2800,0x4000,0x0800,0x2000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x7800,0xD400,0xBC00,0xF400,0x5800,0x0000,0x0000}	//[2]Dark
		},
		{	//[14]Meat_2
			{0xA7FF,0xCFFF,0x87FF,0x03FF,0x03FF,0x03FF,0x87FF,0xCFFF,0x97FF},	//[0]Mask
			{0x5800,0x3000,0x0000,0x2800,0x4000,0x0800,0x2000,0x3000,0x6800},	//[1]Light
			{0x5800,0x3000,0x7800,0xD400,0xBC00,0xF400,0x5800,0x3000,0x6800}	//[2]Dark
		},
		{	//[15]Letter
			{0x4BFF,0x03FF,0x03FF,0x83FF,0x03FF,0x07FF,0x8FFF,0x0FFF,0x1FFF},	//[0]Mask
			{0xB400,0xFC00,0xF800,0x7000,0xE000,0xC000,0x6000,0xE000,0xC000},	//[1]Light
			{0x0000,0x0000,0x2800,0x0000,0x2000,0x0000,0x0000,0x2000,0x0000}	//[2]Dark
		},
		{	//[16]Blue_Potion
			{0x87FF,0xCFFF,0xCFFF,0x87FF,0x03FF,0x03FF,0x03FF,0x03FF,0x87FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x3000,0x7800,0x7800,0x7800,0x3000,0x0000},	//[1]Light
			{0x7800,0x0000,0x0000,0x3000,0x7800,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[17]Red_Potion
			{0x87FF,0xCFFF,0xCFFF,0x87FF,0x03FF,0x03FF,0x03FF,0x03FF,0x87FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x3000,0x7800,0x0000,0x4800,0x2000,0x0000},	//[1]Light
			{0x7800,0x0000,0x0000,0x3000,0x7800,0x7800,0x7800,0x3000,0x0000}	//[2]Dark
		},
		{	//[18]Magic_Wand
			{0xBFFF,0x1FFF,0x1FFF,0xBFFF,0xBFFF,0xBFFF,0xBFFF,0xBFFF,0xBFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x4000,0xE000,0x4000,0x0000,0x4000,0x0000,0x4000,0x4000,0x4000}	//[2]Dark
		},
		{	//[19]Raft_1
			{0x227F,0x227F,0x007F,0x227F,0x007F,0x227F,0x227F,0x227F,0xB6FF},	//[0]Mask
			{0x0000,0x0000,0x7F00,0x8080,0x2200,0x0000,0x4900,0xDD80,0x4900},	//[1]Light
			{0xDD80,0xDD80,0x8080,0x5D00,0xDD80,0xDD80,0x9480,0x0000,0x0000}	//[2]Dark
		},
		{	//[20]Raft_2
			{0x227F,0x227F,0x007F,0x227F,0x007F,0x227F,0x227F,0x227F,0xB6FF},	//[0]Mask
			{0xDD80,0xDD80,0xFF80,0xDD80,0xFF80,0xDD80,0xDD80,0xDD80,0x4900},	//[1]Light
			{0xDD80,0xDD80,0x8080,0x5D00,0xDD80,0xDD80,0x9480,0x0000,0x0000}	//[2]Dark
		},
		{	//[21]Magical_Book
			{0x0FFF,0x07FF,0x07FF,0x07FF,0x07FF,0x07FF,0x07FF,0x07FF,0x8FFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x2000,0x7000,0x2000,0x0000,0x0000},	//[1]Light
			{0xF000,0x1800,0x0800,0x7800,0x7800,0x7800,0x7800,0xF800,0x7000}	//[2]Dark
		},
		{	//[22]Blue_Ring
			{0xFFFF,0xFFFF,0x8FFF,0x8FFF,0x77FF,0x77FF,0x8FFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x5000,0x8800,0x8800,0x7000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[23]Red_Ring
			{0xFFFF,0xFFFF,0x8FFF,0x8FFF,0x77FF,0x77FF,0x8FFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x5000,0x8800,0x8800,0x7000,0x0000,0x0000}	//[2]Dark
		},
		{	//[24]Step_Ladder_1
			{0x3E7F,0x3E7F,0x007F,0x007F,0x3E7F,0x3E7F,0x007F,0x007F,0x3E7F},	//[0]Mask
			{0xC180,0x0000,0x3E00,0x0000,0x0000,0x0000,0x3E00,0x0000,0x0000},	//[1]Light
			{0x0000,0xC180,0xC180,0xFF80,0xC180,0xC180,0xC180,0xFF80,0xC180}	//[2]Dark
		},
		{	//[25]Step_Ladder_2
			{0x3F3F,0x3F3F,0x003F,0x003F,0x3F3F,0x3F3F,0x003F,0x003F,0x3F3F},	//[0]Mask
			{0xC0C0,0xC0C0,0xFFC0,0xFFC0,0xC0C0,0xC0C0,0xFFC0,0xFFC0,0xC0C0},	//[1]Light
			{0x0000,0xC0C0,0xC0C0,0xFFC0,0xC0C0,0xC0C0,0xC0C0,0xFFC0,0xC0C0}	//[2]Dark
		},
		{	//[26]Magical_Key
			{0xC7FF,0x83FF,0x07FF,0x83FF,0xF7FF,0xF7FF,0xC7FF,0xF7FF,0xC7FF},	//[0]Mask
			{0x3800,0x7C00,0xF800,0x7C00,0x0800,0x0800,0x3800,0x0800,0x3800},	//[1]Light
			{0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[27]Power_Bracelet
			{0xC7FF,0x83FF,0x33FF,0x3BFF,0x3FFF,0x3FFF,0x3BFF,0x83FF,0xCFFF},	//[0]Mask
			{0x2000,0x1000,0x8000,0x4000,0x4000,0x8000,0x0000,0x1000,0x2000},	//[1]Light
			{0x1800,0x6C00,0x4C00,0x0400,0x0000,0x4000,0xC400,0x6C00,0x1000}	//[2]Dark
		},
		{	//[28]Menu_Weap8_Blank
			{0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x03FF},	//[0]Mask
			{0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00},	//[1]Light
			{0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00,0xFC00}	//[2]Dark
		},
		{	//[29]Menu_Weap9_Blank
			{0x007F,0x007F,0x007F,0x007F,0x007F,0x007F,0x007F,0x007F,0x007F},	//[0]Mask
			{0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80},	//[1]Light
			{0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80}	//[2]Dark
		},
		{	//[30]Black_Cursor
			{0x3F3F,0x7FBF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7FBF,0x3F3F},	//[0]Mask
			{0xC0C0,0x8040,0x0000,0x0000,0x0000,0x0000,0x0000,0x8040,0xC0C0},	//[1]Light
			{0xC0C0,0x8040,0x0000,0x0000,0x0000,0x0000,0x0000,0x8040,0xC0C0}	//[2]Dark
		},
		{	//[31]White_Cursor
			{0x3F3F,0x7FBF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7FBF,0x3F3F},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[32]Cloud_Full
			{0xC0FF,0x807F,0x003F,0x003F,0x003F,0x003F,0x003F,0x807F,0xCCFF},	//[0]Mask
			{0x0000,0x0000,0x2100,0x4080,0x4080,0x2100,0x8040,0x4C80,0x0000},	//[1]Light
			{0x3F00,0x7F80,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0xFFC0,0x7F80,0x3300}	//[2]Dark
		},
		{	//[33]Cloud_Half
			{0xC0FF,0x807F,0x003F,0x003F,0x003F,0x003F,0x003F,0x807F,0xCCFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x4080,0x4080,0x0000,0x0000,0x0C00,0x0000},	//[1]Light
			{0x3300,0x7F80,0xDEC0,0x7380,0x7380,0xDEC0,0x7F80,0x2D00,0x3300}	//[2]Dark
		},
		{	//[34]Fire_1
			{0xB6FF,0xB1FF,0xC17F,0x407F,0x00BF,0x003F,0x003F,0x807F,0xC0FF},	//[0]Mask
			{0x4900,0x4E00,0x3E80,0xB380,0xE540,0xCEC0,0xCCC0,0x6380,0x3F00},	//[1]Light
			{0x4900,0x4E00,0x3E80,0xBF80,0xFB40,0xF1C0,0xF3C0,0x7F80,0x3F00}	//[2]Dark
		},
		{	//[35]Fire_2
			{0xDB7F,0xE37F,0xA0FF,0x80BF,0x403F,0x003F,0x003F,0x807F,0xC0FF},	//[0]Mask
			{0x2480,0x1C80,0x5F00,0x7340,0xA9C0,0xDCC0,0xCCC0,0x7180,0x3F00},	//[1]Light
			{0x2480,0x1C80,0x5F00,0x7F40,0xB7C0,0xE3C0,0xF3C0,0x7F80,0x3F00}	//[2]Dark
		},
		{	//[36]Shop_Fire_1
			{0xB6FF,0xB1FF,0xC17F,0x407F,0x00BF,0x003F,0x003F,0x807F,0xC0FF},	//[0]Mask
			{0xB6C0,0xB1C0,0xC140,0x4C40,0x1A80,0x3100,0x3300,0x9C40,0xC0C0},	//[1]Light
			{0xFFC0,0xFFC0,0xFFC0,0xF3C0,0xE1C0,0xC0C0,0xC0C0,0xE3C0,0xFFC0}	//[2]Dark
		},
		{	//[37]Shop_Fire_2
			{0xDB7F,0xE37F,0xA0FF,0x80BF,0x403F,0x003F,0x003F,0x807F,0xC0FF},	//[0]Mask
			{0xDB40,0xE340,0xA0C0,0x8C80,0x5600,0x2300,0x3300,0x8E40,0xC0C0},	//[1]Light
			{0xFFC0,0xFFC0,0xFFC0,0xF3C0,0xE1C0,0xC0C0,0xC0C0,0xF1C0,0xFFC0}	//[2]Dark
		},
		{	//[38]Tornado
			{0xE3FF,0x8EFF,0x7F3F,0xB8FF,0x827F,0xEDFF,0xD2FF,0xD9FF,0xE5FF},	//[0]Mask
			{0x1C00,0x6100,0x80C0,0x4700,0x3880,0x0200,0x2D00,0x0000,0x1200},	//[1]Light
			{0x1C00,0x7100,0x80C0,0x4700,0x7D80,0x1200,0x2D00,0x2600,0x1A00}	//[2]Dark
		},
		{	//[39]Wandwave_Up
			{0xC0FF,0x807F,0x3F3F,0x61BF,0xCCFF,0x9E7F,0xB37F,0xE1FF,0xCCFF},	//[0]Mask
			{0x3F00,0x7F80,0xC0C0,0x9E40,0x3300,0x6180,0x4C80,0x1E00,0x3300},	//[1]Light
			{0x3F00,0x7F80,0xC0C0,0x9E40,0x3300,0x6180,0x4C80,0x1E00,0x3300}	//[2]Dark
		},
		{	//[40]Wandwave_Left
			{0xCCFF,0x99BF,0x937F,0x167F,0x16FF,0x167F,0x937F,0x99BF,0xCCFF},	//[0]Mask
			{0x3300,0x6640,0x6C80,0xE980,0xE900,0xE980,0x6C80,0x6640,0x3300},	//[1]Light
			{0x3300,0x6640,0x6C80,0xE980,0xE900,0xE980,0x6C80,0x6640,0x3300}	//[2]Dark
		},
		{	//[41]Wandwave_Down
			{0xCCFF,0xE1FF,0xB37F,0x9E7F,0xCCFF,0x61BF,0x3F3F,0x807F,0xC0FF},	//[0]Mask
			{0x3300,0x1E00,0x4C80,0x6180,0x3300,0x9E40,0xC0C0,0x7F80,0x3F00},	//[1]Light
			{0x3300,0x1E00,0x4C80,0x6180,0x3300,0x9E40,0xC0C0,0x7F80,0x3F00}	//[2]Dark
		},
		{	//[42]Wandwave_Right
			{0xCCFF,0x667F,0xB27F,0x9A3F,0xDA3F,0x9A3F,0xB27F,0x667F,0xCCFF},	//[0]Mask
			{0x3300,0x9980,0x4D80,0x65C0,0x25C0,0x65C0,0x4D80,0x9980,0x3300},	//[1]Light
			{0x3300,0x9980,0x4D80,0x65C0,0x25C0,0x65C0,0x4D80,0x9980,0x3300}	//[2]Dark
		},
		{	//[43]Magical_Shield
			{0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x03FF,0x87FF,0xCFFF},	//[0]Mask
			{0x0000,0x3000,0x7800,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000},	//[1]Light
			{0xFC00,0xCC00,0x8400,0xCC00,0xCC00,0xCC00,0xCC00,0x7800,0x3000}	//[2]Dark
		},
		{	//[44]Heart_Empty
			{0x27FF,0x07FF,0x07FF,0x8FFF,0xDFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[45]Heart_Light
			{0x27FF,0x07FF,0x07FF,0x8FFF,0xDFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0xD800,0xF800,0xF800,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[46]Heart_Full
			{0x27FF,0x07FF,0x07FF,0x8FFF,0xDFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0xD800,0xF800,0xF800,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[47]Heart_Half
			{0x27FF,0x07FF,0x07FF,0x8FFF,0xDFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0xC000,0xE000,0xC000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[48]Heart_None
			{0x27FF,0x07FF,0x07FF,0x8FFF,0xDFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0xD800,0xF800,0xF800,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0xD800,0xF800,0xF800,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[49]Heart_Container
			{0x9CFF,0x087F,0x007F,0x007F,0x007F,0x80FF,0xC1FF,0xE3FF,0xF7FF},	//[0]Mask
			{0x4100,0x1400,0x8080,0x0000,0x8080,0x0000,0x2200,0x0000,0x0800},	//[1]Light
			{0x0000,0x6300,0x7700,0x7F00,0x7F00,0x3E00,0x1C00,0x0800,0x0000}	//[2]Dark
		},
		{	//[50]Fairy_1
			{0x8FFF,0x07FF,0x07FF,0x07FF,0x8FFF,0xDFFF,0x07FF,0x27FF,0xBFFF},	//[0]Mask
			{0x0000,0xA800,0xF800,0xF800,0x5000,0x0000,0x8800,0x8800,0x0000},	//[1]Light
			{0x7000,0xD800,0x8800,0xD800,0x7000,0x2000,0xF800,0xD800,0x4000}	//[2]Dark	
		},
		{	//[51]Fairy_2
			{0x8FFF,0x8FFF,0x8FFF,0x07FF,0x07FF,0xDFFF,0x07FF,0xAFFF,0xBFFF},	//[0]Mask
			{0x0000,0x2000,0x7000,0xA800,0xD800,0x0000,0x8800,0x0000,0x0000},	//[1]Light
			{0x7000,0x5000,0x0000,0xD800,0xF800,0x2000,0xF800,0x5000,0x4000}	//[2]Dark
		},
		{	//[52]Clock
			{0xC7FF,0xEFFF,0xC7FF,0x83FF,0x01FF,0x01FF,0x01FF,0x83FF,0xC7FF},	//[0]Mask
			{0x3800,0x0000,0x3800,0x5400,0xAA00,0xD600,0x8200,0x5400,0x3800},	//[1]Light
			{0x3800,0x1000,0x3800,0x4400,0xAA00,0x9200,0x8200,0x4400,0x3800}	//[2]Dark
		},
		{	//[53]Rupy_Light
			{0xDFFF,0x8FFF,0x07FF,0x07FF,0x07FF,0x07FF,0x07FF,0x8FFF,0xDFFF},	//[0]Mask
			{0x0000,0x0000,0x5800,0x3800,0x3800,0x3800,0x7800,0x7000,0x2000},	//[1]Light
			{0x0000,0x0000,0x5000,0x2000,0x2000,0x2000,0x5000,0x0000,0x0000}	//[2]Dark
		},
		{	//[54]Rupy_Dark
			{0xDFFF,0x8FFF,0x07FF,0x07FF,0x07FF,0x07FF,0x07FF,0x8FFF,0xDFFF},	//[0]Mask
			{0x2000,0x7000,0xF000,0xE000,0xE000,0xE000,0xD000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x5800,0x3800,0x3800,0x3800,0x7800,0x7000,0x2000}	//[2]Dark
		},
		{	//[55]Rupy_Black
			{0xDFFF,0x8FFF,0x07FF,0x07FF,0x07FF,0x07FF,0x07FF,0x8FFF,0xDFFF},	//[0]Mask
			{0x0000,0x0000,0x5800,0x3800,0x3800,0x3800,0x7800,0x7000,0x2000},	//[1]Light
			{0x2000,0x7000,0xA800,0xD800,0xD800,0xD800,0xA800,0x7000,0x2000}	//[2]Dark
		},
		{	//[56]D_Key
			{0x87FF,0x03FF,0x33FF,0x07FF,0xCFFF,0xCFFF,0x0FFF,0x8FFF,0x0FFF},	//[0]Mask
			{0x0800,0x2400,0x4400,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000},	//[1]Light
			{0x7800,0xFC00,0xCC00,0xF800,0x3000,0x3000,0xF000,0x7000,0xF000}	//[2]Dark
		},
		{	//[57]Map
			{0x4BFF,0x03FF,0x03FF,0x83FF,0x03FF,0x07FF,0x8FFF,0x0FFF,0x1FFF},	//[0]Mask
			{0x0000,0x0000,0x2800,0x0000,0x2000,0x0000,0x0000,0x2000,0x0000},	//[1]Light
			{0xB400,0xFC00,0xF800,0x7000,0xE000,0xC000,0x6000,0xE000,0xC000}	//[2]Dark
		},
		{	//[58]Dark_Map
			{0x4BFF,0x03FF,0x03FF,0x83FF,0x03FF,0x07FF,0x8FFF,0x0FFF,0x1FFF},	//[0]Mask
			{0x0000,0x0000,0x2C00,0x0C00,0x3C00,0x3800,0x1000,0x3000,0x0000},	//[1]Light
			{0xB400,0xFC00,0xD400,0x7C00,0xDC00,0xF800,0x7000,0xD000,0xE000}	//[2]Dark
		},
		{	//[59]Compass
			{0xC7FF,0x83FF,0x01FF,0x01FF,0x01FF,0x01FF,0x83FF,0xC7FF,0xFFFF},	//[0]Mask
			{0x1000,0x2800,0x4400,0x7C00,0x3800,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x1000,0x3800,0x3800,0x9200,0xC600,0x7C00,0x3800,0x0000}	//[2]Dark
		},
		{	//[60]Dark_Compass
			{0xC7FF,0x83FF,0x01FF,0x01FF,0x01FF,0x01FF,0x83FF,0xC7FF,0xFFFF},	//[0]Mask
			{0x1000,0x3800,0x7C00,0x4400,0xAA00,0xD600,0x7C00,0x3800,0x0000},	//[1]Light
			{0x2800,0x5400,0xBA00,0xBA00,0xD600,0xEE00,0x7C00,0x3800,0x0000}	//[2]Dark
		},
		{	//[61]Triforce_Light
			{0xEFFF,0xC7FF,0xC7FF,0x83FF,0x83FF,0x01FF,0x01FF,0xFFFF,0xFFFF},	//[0]Mask
			{0x1000,0x3800,0x3800,0x7C00,0x7C00,0xFE00,0xFE00,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[62]Triforce_Dark
			{0xEFFF,0xC7FF,0xC7FF,0x83FF,0x83FF,0x01FF,0x01FF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x1000,0x3800,0x3800,0x7C00,0x7C00,0xFE00,0xFE00,0x0000,0x0000}	//[2]Dark
		},
		{	//[63]Shop_Stair
			{0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F},	//[0]Mask
			{0x0000,0x7F80,0x7F80,0x7F80,0x7F80,0x7F80,0x7F80,0x7F80,0x0000},	//[1]Light
			{0xFFC0,0x9FC0,0x93C0,0x9240,0x9240,0x9240,0x9240,0x9240,0xFFC0}	//[2]Dark
		},
		{	//[64] Wizard (Shop)
			{0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F},	//[0]Mask
			{0xFFC0,0xDEC0,0xFFC0,0xCCC0,0x8040,0x0000,0xA140,0xA140,0xD2C0},	//[1]Light
			{0xE1C0,0xD2C0,0xC0C0,0xCCC0,0xD2C0,0xF3C0,0x7F80,0xFFC0,0xEDC0}	//[2]Dark
		},
		{	//[65] Fat_Bearded_Man (Shop)
			{0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F},	//[0]Mask
			{0xC0C0,0xBF40,0xBF40,0xCCC0,0x0000,0x4080,0x8040,0x8040,0xCCC0},	//[1]Light
			{0xFFC0,0xD2C0,0xD2C0,0xB340,0x9E40,0x8040,0x7F80,0x8040,0xFFC0}	//[2]Dark
		},
		{	//[66] Old_Woman (Shop)
			{0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F},	//[0]Mask
			{0xE1C0,0xDEC0,0xDEC0,0xDEC0,0x9E40,0x8C40,0xC0C0,0xA140,0xD2C0},	//[1]Light
			{0xE1C0,0xD2C0,0xC0C0,0xD2C0,0xCCC0,0xD2C0,0xBF40,0xFFC0,0xEDC0}	//[2]Dark
		},
		{	//[67] Goriya (Shop)
			{0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F,0x003F},	//[0]Mask
			{0xEDC0,0xE1C0,0xFFC0,0xB340,0xAD40,0x9E40,0xC0C0,0xF1C0,0xAFC0},	//[1]Light
			{0x9E40,0xCCC0,0xC0C0,0x4CC0,0x5280,0xE180,0xFFC0,0xCE40,0x8FC0}	//[2]Dark
		},
		{	//[68] Enemy_Invisible
			{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
		},
		{	//[68] LeeverLight_Half
			{0xFFFF,0xFFFF,0xFFFF,0xF3FF,0xA17F,0xA17F,0x807F,0xC0FF,0xC0FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0C00,0x4080,0x4C80,0x6D80,0x2D00,0x0000},	//[1]Light
			{0x0000,0x0000,0x0000,0x0C00,0x5E80,0x5E80,0x7F80,0x3F00,0x3F00}	//[2]Dark
		},
		{	//[69] LeeverDark_Half
			{0xFFFF,0xFFFF,0xFFFF,0xF3FF,0xA17F,0xA17F,0x807F,0xC0FF,0xC0FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x1E00,0x1200,0x1200,0x1200,0x3F00},	//[1]Light
			{0x0000,0x0000,0x0000,0x0C00,0x5E80,0x5E80,0x7F80,0x3F00,0x3F00}	//[2]Dark
		},
		{	//[70] Leever_Hole_1
			{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3FF,0xE1FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0C00,0x1E00},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0C00,0x1E00}	//[2]Dark
		},
		{	//[71] Leever_Hole_1
			{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xE1FF,0xC0FF},	//[0]Mask
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x3F00},	//[1]Light
			{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x3F00}	//[2]Dark
		},
		{	//[72] OctorokRock
			{0xFFFF,0xFFFF,0xE3FF,0xC1FF,0xC1FF,0xC1FF,0xE3FF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x1C00,0x2A00,0x2E00,0x3600,0x1C00,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x1C00,0x3E00,0x3E00,0x3E00,0x1C00,0x0000,0x0000}	//[2]Dark
		},
		{	//[73] ZolaFire
			{0xFFFF,0xFFFF,0xE3FF,0xC1FF,0xC1FF,0xC1FF,0xE3FF,0xFFFF,0xFFFF},	//[0]Mask
			{0x0000,0x0000,0x1C00,0x3600,0x2A00,0x3600,0x1C00,0x0000,0x0000},	//[1]Light
			{0x0000,0x0000,0x1C00,0x3E00,0x3600,0x3E00,0x1C00,0x0000,0x0000}	//[2]Dark
		}
	};
	
	//1728
	static unsigned short Sword[4][2][4][3][9]= {	//Read in EXE as Sword[4][2][4][27]
		{	//[0]Wooden_Sword
			{	//[0]Full_Sword
				{	//[0]Up
					{0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xE1FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0000,0x0C00,0x0000},	//[1]Light
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x1E00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xFDFF,0x00FF,0x00FF,0xFDFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0xFD00,0xFD00,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0200,0xFF00,0xFF00,0x0200,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF3FF,0xE1FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0C00,0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0000},	//[1]Light
					{0x0C00,0x1E00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0xBFFF,0x00FF,0x00FF,0xBFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0xBF00,0xBF00,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x4000,0xFF00,0xFF00,0x4000,0x0000,0x0000}	//[2]Dark
				}
			},
			{	//[1]Half_Sword
				{	//[0]Up
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF0FF,0xF0FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0F00,0x0F00,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0F00,0x0F00,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x0FFF,0x0FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0xF000,0xF000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0xF000,0xF000,0x0000,0x0000,0x0000}	//[2]Dark
				}
			}
		},
		{	//[1]White_Sword
			{	//[0]Full_Sword
				{	//[0]Up
					{0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xE1FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000},	//[1]Light
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x1E00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xFDFF,0x00FF,0x00FF,0xFDFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0200,0xFF00,0xFF00,0x0200,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF3FF,0xE1FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0C00,0x1E00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0xBFFF,0x00FF,0x00FF,0xBFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x4000,0xFF00,0xFF00,0x4000,0x0000,0x0000}	//[2]Dark
				}
			},
			{	//[1]Half_Sword
				{	//[0]Up
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF0FF,0xF0FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0F00,0x0F00,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x0FFF,0x0FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0xF000,0xF000,0x0000,0x0000,0x0000}	//[2]Dark
				}
			}
		},
		{	//[2]Magical_Sword
			{	//[0]Full_Sword
				{	//[0]Up
					{0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xE1FF,0xE1FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x1200,0x0000},	//[1]Light
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x1E00,0x1E00,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xFCFF,0x00FF,0x00FF,0xFCFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0300,0x0200,0x0200,0x0300,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0300,0xFF00,0xFF00,0x0300,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xE1FF,0xE1FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x1200,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x1E00,0x1E00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0x3FFF,0x00FF,0x00FF,0x3FFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0xC000,0x4000,0x4000,0xC000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0xC000,0xFF00,0xFF00,0xC000,0x0000,0x0000}	//[2]Dark
				}
			},
			{	//[1]Half_Sword
				{	//[0]Up
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF0FF,0xF0FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0F00,0x0F00,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF3FF,0xF3FF,0xF3FF,0xF3FF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0C00,0x0C00,0x0C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x0FFF,0x0FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0xF000,0xF000,0x0000,0x0000,0x0000}	//[2]Dark
				}
			}
		},
		{	//[3]Magical_Wand
			{	//[0]Full_Sword
				{	//[0]Up
					{0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xF7FF,0xF7FF,0xF7FF,0xF7FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x1400,0x0800,0x0000,0x0800,0x0000,0x0000,0x0000},	//[1]Light
					{0x0800,0x1C00,0x1C00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0x9FFF,0x00FF,0x9FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x2000,0x1400,0x2000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x6000,0xFF00,0x6000,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF7FF,0xF7FF,0xF7FF,0xF7FF,0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0800,0x0000,0x0800,0x1400,0x0000,0x0000,0x0000},	//[1]Light
					{0x0800,0x0800,0x0800,0x0800,0x0800,0x1C00,0x1C00,0x0800,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0xF9FF,0x00FF,0xF9FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0400,0x2800,0x0400,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0600,0xFF00,0x0600,0x0000,0x0000,0x0000}	//[2]Dark
				}
			},
			{	//[1]Half_Sword
				{	//[0]Up
					{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1400,0x0800,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0000,0x0800,0x1C00,0x1C00,0x0800,0x0000}	//[2]Dark
				},
				{	//[1]Left
					{0xFFFF,0xFFFF,0xFFFF,0xF9FF,0xF0FF,0xF9FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x0200,0x0100,0x0200,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x0600,0x0F00,0x0600,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[2]Down
					{0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0800,0x1400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0800,0x1C00,0x1C00,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000}	//[2]Dark
				},
				{	//[3]Right
					{0xFFFF,0xFFFF,0xFFFF,0x9FFF,0x0FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
					{0x0000,0x0000,0x0000,0x4000,0x8000,0x4000,0x0000,0x0000,0x0000},	//[1]Light
					{0x0000,0x0000,0x0000,0x6000,0xF000,0x6000,0x0000,0x0000,0x0000}	//[2]Dark
				}
			}
		}
	};
	
	//432
	static unsigned short Sword_Shards[2][4][3][9]=	{	//Read in EXE and DLL as Sword_Shards[2][4][27]
		{	//[0]Sword_Shards_Animation_1
			{	//[0]North_West
				{0x9FFF,0x0FFF,0x07FF,0x07FF,0x9FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x6000,0xF000,0x9800,0xC800,0x4000,0x6000,0x0000,0x0000,0x0000},	//[1]Light
				{0x6000,0xF000,0xF800,0xF800,0x6000,0x6000,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[1]South_West
				{0x9FFF,0x9FFF,0x07FF,0x07FF,0x0FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x6000,0x4000,0xC800,0x9800,0xF000,0x6000,0x0000,0x0000,0x0000},	//[1]Light
				{0x6000,0x6000,0xF800,0xF800,0xF000,0x6000,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[2]South_East
				{0xCFFF,0xCFFF,0x07FF,0x07FF,0x87FF,0xCFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x3000,0x1000,0x9800,0xC800,0x7800,0x3000,0x0000,0x0000,0x0000},	//[1]Light
				{0x3000,0x3000,0xF800,0xF800,0x7800,0x3000,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[3]North_East
				{0xCFFF,0x87FF,0x07FF,0x07FF,0xCFFF,0xCFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x3000,0x7800,0xC800,0x9800,0x1000,0x3000,0x0000,0x0000,0x0000},	//[1]Light
				{0x3000,0x7800,0xF800,0xF800,0x3000,0x3000,0x0000,0x0000,0x0000}	//[2]Dark
			}
		},
		{	//[1]Sword_Shards_Animation_2
			{	//[0]North_West
				{0x9FFF,0x0FFF,0x07FF,0x07FF,0x9FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x6000,0x3000,0x2000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x6000,0xF000,0xF800,0xF800,0x6000,0x6000,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[1]South_West
				{0x9FFF,0x9FFF,0x07FF,0x07FF,0x0FFF,0x9FFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x2000,0x3000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x6000,0x6000,0xF800,0xF800,0xF000,0x6000,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[2]South_East
				{0xCFFF,0xCFFF,0x07FF,0x07FF,0x87FF,0xCFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x2000,0x6000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x3000,0x3000,0xF800,0xF800,0x7800,0x3000,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[3]North_East
				{0xCFFF,0x87FF,0x07FF,0x07FF,0xCFFF,0xCFFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x3000,0x6000,0x2000,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x3000,0x7800,0xF800,0xF800,0x3000,0x3000,0x0000,0x0000,0x0000}	//[2]Dark
			}
		}
	};
	
	//240
	static unsigned short Boomerang[8][15]=	{
		{	//[0]North
			0xC7FF,0x83FF,0xBBFF,0xFFFF,0xFFFF,	//[0]Mask
			0x3800,0x7C00,0x4400,0x0000,0x0000,	//[1]Light
			0x3800,0x7C00,0x4400,0x0000,0x0000	//[2]Dark
		},
		{	//[1]North_West
			0xC3FF,0x8FFF,0x9FFF,0xBFFF,0xBFFF,	//[0]Mask
			0x3C00,0x7000,0x6000,0x4000,0x4000,	//[1]Light
			0x3C00,0x7000,0x6000,0x4000,0x4000	//[2]Dark
		},
		{	//[2]West
			0xCFFF,0x9FFF,0x9FFF,0x9FFF,0xCFFF,	//[0]Mask
			0x3000,0x6000,0x6000,0x6000,0x3000,	//[1]Light
			0x3000,0x6000,0x6000,0x6000,0x3000	//[2]Dark
		},
		{	//[3]South_West
			0xBFFF,0xBFFF,0x9FFF,0x8FFF,0xC3FF,	//[0]Mask
			0x4000,0x4000,0x6000,0x7000,0x3C00,	//[1]Light
			0x4000,0x4000,0x6000,0x7000,0x3C00	//[2]Dark
		},
		{	//[4]South
			0xFFFF,0xFFFF,0xBBFF,0x83FF,0xC7FF,	//[0]Mask
			0x0000,0x0000,0x4400,0x7C00,0x3800,	//[1]Light
			0x0000,0x0000,0x4400,0x7C00,0x3800	//[2]Dark
		},
		{	//[5]South_East
			0xFDFF,0xFDFF,0xF9FF,0xF1FF,0xC3FF,	//[0]Mask
			0x0200,0x0200,0x0600,0x0E00,0x3C00,	//[1]Light
			0x0200,0x0200,0x0600,0x0E00,0x3C00	//[2]Dark
		},
		{	//[6]East
			0xF3FF,0xF9FF,0xF9FF,0xF9FF,0xF3FF,	//[0]Mask
			0x0C00,0x0600,0x0600,0x0600,0x0C00,	//[1]Light
			0x0C00,0x0600,0x0600,0x0600,0x0C00	//[2]Dark
		},
		{	//[7]North_East
			0xC3FF,0xF1FF,0xF9FF,0xFDFF,0xFDFF,	//[0]Mask
			0x3C00,0x0E00,0x0600,0x0200,0x0200,	//[1]Light
			0x3C00,0x0E00,0x0600,0x0200,0x0200	//[2]Dark
		}
	};
	
	//432
	static unsigned short Arrow[2][4][3][9]=	{	//Read in EXE as Arrow[2][4][27]
		{	//[0]Wooden_Arrow
			{	//[0]North
				{0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xF7FF,0xE3FF,0xF7FF,0xE3FF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000},	//[1]Light
				{0x0800,0x1C00,0x1C00,0x0800,0x0800,0x1C00,0x0800,0x1C00,0x0000}	//[2]Dark
			},
			{	//[1]West
				{0xFFFF,0xFFFF,0xFFFF,0x9AFF,0x00FF,0x9AFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0x3F00,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x0000,0x0000,0x0000,0x6500,0xFF00,0x6500,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[2]South
				{0xE3FF,0xF7FF,0xE3FF,0xF7FF,0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xFFFF},	//[0]Mask
				{0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000},	//[1]Light
				{0x1C00,0x0800,0x1C00,0x0800,0x0800,0x1C00,0x1C00,0x0800,0x0000}	//[2]Dark
			},
			{	//[3]East
				{0xFFFF,0xFFFF,0xFFFF,0x59FF,0x00FF,0x59FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0000,0x0000,0xFC00,0x0000,0x0000,0x0000,0x0000},	//[1]Light
				{0x0000,0x0000,0x0000,0xA600,0xFF00,0xA600,0x0000,0x0000,0x0000}	//[2]Dark
			}
		},
		{	//[1]Silver_Arrow
			{	//[0]North
				{0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xF7FF,0xE3FF,0xF7FF,0xE3FF,0xFFFF},	//[0]Mask
				{0x0800,0x1C00,0x1400,0x0000,0x0000,0x1400,0x0000,0x1400,0x0000},	//[1]Light
				{0x0800,0x1C00,0x1C00,0x0800,0x0800,0x1C00,0x0800,0x1C00,0x0000}	//[2]Dark
			},
			{	//[1]West
				{0xFFFF,0xFFFF,0xFFFF,0x9AFF,0x00FF,0x9AFF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0000,0x6500,0xC000,0x6500,0x0000,0x0000,0x0000},	//[1]Light
				{0x0000,0x0000,0x0000,0x6500,0xFF00,0x6500,0x0000,0x0000,0x0000}	//[2]Dark
			},
			{	//[2]South
				{0xE3FF,0xF7FF,0xE3FF,0xF7FF,0xF7FF,0xE3FF,0xE3FF,0xF7FF,0xFFFF},	//[0]Mask
				{0x1400,0x0000,0x1400,0x0000,0x0000,0x1400,0x1C00,0x0800,0x0000},	//[1]Light
				{0x1C00,0x0800,0x1C00,0x0800,0x0800,0x1C00,0x1C00,0x0800,0x0000}	//[2]Dark
			},
			{	//[3]East
				{0xFFFF,0xFFFF,0xFFFF,0x59FF,0x00FF,0x59FF,0xFFFF,0xFFFF,0xFFFF},	//[0]Mask
				{0x0000,0x0000,0x0000,0xA600,0x0300,0xA600,0x0000,0x0000,0x0000},	//[1]Light
				{0x0000,0x0000,0x0000,0xA600,0xFF00,0xA600,0x0000,0x0000,0x0000}	//[2]Dark
			}
		}
	};
	
	//1536
	static unsigned char Portals[3][128][4]= {
			//[0] unsigned char World;					 &0x03=World (Overworld, Dungeon_1, Dungeon_2)			&0x80=Link is on the right side of a dungeon underpass
			//[1] unsigned char World_Index;
			//[2] unsigned char Link_x;
			//[3] unsigned char Link_y;
		{
			{0,0,0,0},	//[0]
			{0,Shop_Room,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[1]
			{0,0,0,0},	//[2]
			{0,Shop_Room,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[3]
			{0,Shop_Room,28%Screen_w*Sprite_w,28/Screen_w*Sprite_h},	//[4]
			{2,118,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[5] Level 9
			{0,0,0,0},	//[6]
			{0,Shop_Room,74%Screen_w*Sprite_w,74/Screen_w*Sprite_h},	//[7]
			{0,0,0,0},	//[8]
			{0,0,0,0},	//[9]
			{0,Shop_Room,18%Screen_w*Sprite_w,18/Screen_w*Sprite_h},	//[10]
			{1,118,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[11] Level 5
			{0,Shop_Room,24%Screen_w*Sprite_w,24/Screen_w*Sprite_h},	//[12]
			{0,Shop_Room,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[13]
			{0,Shop_Room,69%Screen_w*Sprite_w,69/Screen_w*Sprite_h},	//[14]
			{0,Shop_Room,72%Screen_w*Sprite_w,72/Screen_w*Sprite_h},	//[15]
			{0,Shop_Room,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[16]
			{0,0,0,0},	//[17]
			{0,Shop_Room,24%Screen_w*Sprite_w,24/Screen_w*Sprite_h},	//[18]
			{0,Shop_Room,18%Screen_w*Sprite_w,18/Screen_w*Sprite_h},	//[19]
			{0,Shop_Room,28%Screen_w*Sprite_w,28/Screen_w*Sprite_h},	//[20]
			{0,0,0,0},	//[21]
			{0,Shop_Room,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[22]
			{0,0,0,0},	//[23]
			{0,0,0,0},	//[24]
			{0,0,0,0},	//[25]
			{0,Shop_Room,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h},	//[26]
			{0,0,0,0},	//[27]
			{0,Shop_Room,51%Screen_w*Sprite_w,51/Screen_w*Sprite_h},	//[28]
			{0,Shop_Room,50%Screen_w*Sprite_w,50/Screen_w*Sprite_h},	//[29]
			{0,Shop_Room,28%Screen_w*Sprite_w,28/Screen_w*Sprite_h},	//[30]
			{0,Shop_Room,70%Screen_w*Sprite_w,70/Screen_w*Sprite_h},	//[31]
			{0,0,0,0},	//[32]
			{0,Shop_Room,53%Screen_w*Sprite_w,53/Screen_w*Sprite_h},	//[33]
			{1,121,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[34] Level 6
			{0,Shop_Room,36%Screen_w*Sprite_w,36/Screen_w*Sprite_h},	//[35]
			{0,0,0,0},	//[36]
			{0,Shop_Room,26%Screen_w*Sprite_w,26/Screen_w*Sprite_h},	//[37]
			{0,Shop_Room,19%Screen_w*Sprite_w,19/Screen_w*Sprite_h},	//[38]
			{0,Shop_Room,30%Screen_w*Sprite_w,30/Screen_w*Sprite_h},	//[39]
			{0,Shop_Room,110%Screen_w*Sprite_w,110/Screen_w*Sprite_h},	//[40]
			{0,0,0,0},	//[41]
			{0,0,0,0},	//[42]
			{0,0,0,0},	//[43]
			{0,Shop_Room,105%Screen_w*Sprite_w,105/Screen_w*Sprite_h},	//[44]
			{0,Shop_Room,21%Screen_w*Sprite_w,21/Screen_w*Sprite_h},	//[45]
			{0,0,0,0},	//[46]
			{0,Shop_Room,70%Screen_w*Sprite_w,70/Screen_w*Sprite_h},	//[47]
			{0,0,0,0},	//[48]
			{0,0,0,0},	//[49]
			{0,0,0,0},	//[50]
			{0,Shop_Room,26%Screen_w*Sprite_w,26/Screen_w*Sprite_h},	//[51]
			{0,Shop_Room,52%Screen_w*Sprite_w,52/Screen_w*Sprite_h},	//[52]
			{0,0,0,0},	//[53]
			{0,0,0,0},	//[54]
			{1,115,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[55] Level_1
			{0,0,0,0},	//[56]
			{0,0,0,0},	//[57]
			{0,0,0,0},	//[58]
			{0,0,0,0},	//[59]
			{1,125,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[60] Level_2
			{0,Shop_Room,57%Screen_w*Sprite_w,57/Screen_w*Sprite_h},	//[61]
			{0,0,0,0},	//[62]
			{0,0,0,0},	//[63]
			{0,0,0,0},	//[64]
			{0,0,0,0},	//[65]
			{2,121,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[66] Level_7
			{0,0,0,0},	//[67]
			{0,Shop_Room,20%Screen_w*Sprite_w,20/Screen_w*Sprite_h},	//[68]
			{1,113,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[69] Level_4
			{0,Shop_Room,120%Screen_w*Sprite_w,120/Screen_w*Sprite_h},	//[70]
			{0,Shop_Room,108%Screen_w*Sprite_w,108/Screen_w*Sprite_h},	//[71]
			{0,Shop_Room,59%Screen_w*Sprite_w,59/Screen_w*Sprite_h},	//[72]
			{0,Shop_Room,51%Screen_w*Sprite_w,51/Screen_w*Sprite_h},	//[73]
			{0,Shop_Room,27%Screen_w*Sprite_w,27/Screen_w*Sprite_h},	//[74]
			{0,Shop_Room,44%Screen_w*Sprite_w,44/Screen_w*Sprite_h},	//[75]
			{0,0,0,0},	//[76]
			{0,Shop_Room,92%Screen_w*Sprite_w,92/Screen_w*Sprite_h},	//[77]
			{0,Shop_Room,55%Screen_w*Sprite_w,55/Screen_w*Sprite_h},	//[78]
			{0,0,0,0},	//[79]
			{0,0,0,0},	//[80]
			{0,Shop_Room,106%Screen_w*Sprite_w,106/Screen_w*Sprite_h},	//[81]
			{0,0,0,0},	//[82]
			{0,0,0,0},	//[83]
			{0,0,0,0},	//[84]
			{0,0,0,0},	//[85]
			{0,Shop_Room,123%Screen_w*Sprite_w,123/Screen_w*Sprite_h},	//[86]
			{0,0,0,0},	//[87]
			{0,0,0,0},	//[88]
			{0,0,0,0},	//[89]
			{0,0,0,0},	//[90]
			{0,Shop_Room,99%Screen_w*Sprite_w,99/Screen_w*Sprite_h},	//[91]
			{0,0,0,0},	//[92]
			{0,0,0,0},	//[93]
			{0,Shop_Room,23%Screen_w*Sprite_w,23/Screen_w*Sprite_h},	//[94]
			{0,0,0,0},	//[95]
			{0,0,0,0},	//[96]
			{0,0,0,0},	//[97]
			{0,Shop_Room,70%Screen_w*Sprite_w,70/Screen_w*Sprite_h},	//[98]
			{0,Shop_Room,103%Screen_w*Sprite_w,103/Screen_w*Sprite_h},	//[99]
			{0,Shop_Room,23%Screen_w*Sprite_w,23/Screen_w*Sprite_h},	//[100]
			{0,0,0,0},	//[101]
			{0,Shop_Room,23%Screen_w*Sprite_w,23/Screen_w*Sprite_h},	//[102]
			{0,Shop_Room,23%Screen_w*Sprite_w,23/Screen_w*Sprite_h},	//[103]
			{0,Shop_Room,99%Screen_w*Sprite_w,99/Screen_w*Sprite_h},	//[104]
			{0,0,0,0},	//[105]
			{0,Shop_Room,108%Screen_w*Sprite_w,108/Screen_w*Sprite_h},	//[106]
			{0,Shop_Room,101%Screen_w*Sprite_w,101/Screen_w*Sprite_h},	//[107]
			{0,0,0,0},	//[108]
			{2,126,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[109] Level 8
			{0,0,0,0},	//[110]
			{0,Shop_Room,19%Screen_w*Sprite_w,19/Screen_w*Sprite_h},	//[111]
			{0,Shop_Room,27%Screen_w*Sprite_w,27/Screen_w*Sprite_h},	//[112]
			{0,Shop_Room,21%Screen_w*Sprite_w,21/Screen_w*Sprite_h},	//[113]
			{0,0,0,0},	//[114]
			{0,0,0,0},	//[115]
			{1,124,151%Screen_w*Sprite_w+Sprite_w/2,151/Screen_w*Sprite_h},	//[116] Level 3
			{0,Shop_Room,18%Screen_w*Sprite_w,18/Screen_w*Sprite_h},	//[117]
			{0,Shop_Room,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[118]
			{0,Shop_Room,20%Screen_w*Sprite_w,20/Screen_w*Sprite_h},	//[119]
			{0,Shop_Room,85%Screen_w*Sprite_w,85/Screen_w*Sprite_h},	//[120]
			{0,Shop_Room,54%Screen_w*Sprite_w,54/Screen_w*Sprite_h},	//[121]
			{0,0,0,0},	//[122]
			{0,Shop_Room,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[123]
			{0,Shop_Room,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[124]
			{0,Shop_Room,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[125]
			{0,0,0,0},	//[126]
			{0,0,0,0}	//[127]
		},
		{	//[1]Dungeon_1
			{0,0,0,0},	//[0]
			{0,0,0,0},	//[1]
			{0,0,0,0},	//[2]
			{0,0,0,0},	//[3]
			{0,0,0,0},	//[4]
			{1,Treasure_Room,89%Screen_w*Sprite_w,89/Screen_w*Sprite_h},	//[5] Level 5 Recorder
			{129,100,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[6] Level 5 Warp
			{0,0,0,0},	//[7]
			{0,0,0,0},	//[8]
			{1,Treasure_Room,92%Screen_w*Sprite_w,92/Screen_w*Sprite_h},	//[9] Level 6 Wand
			{0,0,0,0},	//[10]
			{0,0,0,0},	//[11]
			{0,0,0,0},	//[12]
			{0,0,0,0},	//[13]
			{0,0,0,0},	//[14]
			{0,0,0,0},	//[15]
			{0,0,0,0},	//[16]
			{0,0,0,0},	//[17]
			{0,0,0,0},	//[18]
			{0,0,0,0},	//[19]
			{0,0,0,0},	//[20]
			{0,0,0,0},	//[21]
			{0,0,0,0},	//[22]
			{0,0,0,0},	//[23]
			{0,0,0,0},	//[24]
			{0,0,0,0},	//[25]
			{0,0,0,0},	//[26]
			{0,0,0,0},	//[27]
			{0,0,0,0},	//[28]
			{129,58,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[29] Level 6 Warp
			{0,0,0,0},	//[30]
			{0,0,0,0},	//[31]
			{0,0,0,0},	//[32]
			{0,0,0,0},	//[33]
			{1,Treasure_Room,118%Screen_w*Sprite_w,118/Screen_w*Sprite_h},	//[34] Level 1 Bow
			{0,0,0,0},	//[35]
			{0,0,0,0},	//[36]
			{0,0,0,0},	//[37]
			{0,0,0,0},	//[38]
			{0,0,0,0},	//[39]
			{0,0,0,0},	//[40]
			{0,0,0,0},	//[41]
			{0,0,0,0},	//[42]
			{0,0,0,0},	//[43]
			{0,0,0,0},	//[44]
			{0,0,0,0},	//[45]
			{0,0,0,0},	//[46]
			{0,0,0,0},	//[47]
			{0,0,0,0},	//[48]
			{0,0,0,0},	//[49]
			{1,Treasure_Room,140%Screen_w*Sprite_w,140/Screen_w*Sprite_h},	//[50] Level 4 Ladder
			{0,0,0,0},	//[51]
			{0,0,0,0},	//[52]
			{0,0,0,0},	//[53]
			{0,0,0,0},	//[54]
			{0,0,0,0},	//[55]
			{0,0,0,0},	//[56]
			{0,0,0,0},	//[57]
			{1,29,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[58] Level 6 Warp
			{0,0,0,0},	//[59]
			{0,0,0,0},	//[60]
			{0,0,0,0},	//[61]
			{0,0,0,0},	//[62]
			{0,0,0,0},	//[63]
			{0,0,0,0},	//[64]
			{0,0,0,0},	//[65]
			{0,0,0,0},	//[66]
			{0,0,0,0},	//[67]
			{0,0,0,0},	//[68]
			{0,0,0,0},	//[69]
			{0,0,0,0},	//[70]
			{0,0,0,0},	//[71]
			{0,0,0,0},	//[72]
			{0,0,0,0},	//[73]
			{0,0,0,0},	//[74]
			{0,0,0,0},	//[75]
			{0,0,0,0},	//[76]
			{0,0,0,0},	//[77]
			{0,0,0,0},	//[78]
			{0,0,0,0},	//[79]
			{0,0,0,0},	//[80]
			{0,0,0,0},	//[81]
			{0,0,0,0},	//[82]
			{0,0,0,0},	//[83]
			{0,0,0,0},	//[84]
			{0,0,0,0},	//[85]
			{0,0,0,0},	//[86]
			{0,0,0,0},	//[87]
			{0,0,0,0},	//[88]
			{0,0,0,0},	//[89]
			{0,0,0,0},	//[90]
			{0,0,0,0},	//[91]
			{0,0,0,0},	//[92]
			{0,0,0,0},	//[93]
			{0,0,0,0},	//[94]
			{0,0,0,0},	//[95]
			{0,0,0,0},	//[96]
			{0,0,0,0},	//[97]
			{0,0,0,0},	//[98]
			{0,0,0,0},	//[99]
			{1,6,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[100] Level 5 Warp
			{0,0,0,0},	//[101]
			{0,0,0,0},	//[102]
			{0,0,0,0},	//[103]
			{0,0,0,0},	//[104]
			{1,Treasure_Room,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h},	//[105]	Level 3 Raft
			{0,0,0,0},	//[106]
			{0,0,0,0},	//[107]
			{0,0,0,0},	//[108]
			{0,0,0,0},	//[109]
			{0,0,0,0},	//[110]
			{0,0,0,0},	//[111]
			{0,0,0,0},	//[112]
			{0,69,72%Screen_w*Sprite_w,72/Screen_w*Sprite_h},	//[113] Level 4 Entrance
			{0,0,0,0},	//[114]
			{0,55,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[115] Level 1 Entrance
			{0,0,0,0},	//[116]
			{0,0,0,0},	//[117]
			{0,11,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[118] Level 5 Entrance
			{0,0,0,0},	//[119]
			{0,0,0,0},	//[120]
			{0,34,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[121]Level 6 Entrance
			{0,0,0,0},	//[122]
			{0,0,0,0},	//[123]
			{0,116,72%Screen_w*Sprite_w,72/Screen_w*Sprite_h},	//[124] Level 3 Entrance
			{0,60,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[125] Level 2 Entrance
			{0,0,0,0},	//[126]
			{0,0,0,0}		//[127]
		},
		{	//[2]Dungeon_2
			{0,0,0,0},	//[0]
			{0,0,0,0},	//[1]
			{0,0,0,0},	//[2]
			{130,82,87%Screen_w*Sprite_w,87/Screen_w*Sprite_h},	//[3]	Level 9 Warp F
			{130,48,60%Screen_w*Sprite_w,60/Screen_w*Sprite_h},	//[4]	Level 9 Warp E
			{130,99,106%Screen_w*Sprite_w,106/Screen_w*Sprite_h},	//[5]	Level 9 Warp B
			{0,0,0,0},	//[6]
			{1,Treasure_Room,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[7] Level 9 Red Ring
			{0,0,0,0},	//[8]
			{0,0,0,0},	//[9]
			{0,0,0,0},	//[10]
			{0,0,0,0},	//[11]
			{0,0,0,0},	//[12]
			{2,41,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[13] Level 7 Warp
			{0,0,0,0},	//[14]
			{0,0,0,0},	//[15]
			{1,Treasure_Room,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[16] Level 9 Silver Arrow
			{0,0,0,0},	//[17]
			{0,0,0,0},	//[18]
			{0,0,0,0},	//[19]
			{2,85,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[20] Level 9 Warp A
			{0,0,0,0},	//[21]
			{0,0,0,0},	//[22]
			{0,0,0,0},	//[23]
			{0,0,0,0},	//[24]
			{0,0,0,0},	//[25]
			{1,Treasure_Room,102%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[26] Level 7 Candle
			{0,0,0,0},	//[27]
			{0,0,0,0},	//[28]
			{0,0,0,0},	//[29]
			{0,0,0,0},	//[30]
			{1,Treasure_Room,102%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[31] Level 8 Key
			{2,97,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[32] Level 9 Warp D
			{0,0,0,0},	//[33]
			{0,0,0,0},	//[34]
			{0,0,0,0},	//[35]
			{0,0,0,0},	//[36]
			{0,0,0,0},	//[37]
			{0,0,0,0},	//[38]
			{0,0,0,0},	//[39]
			{0,0,0,0},	//[40]
			{130,13,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[41] Level 7 Warp
			{0,0,0,0},	//[42]
			{0,0,0,0},	//[43]
			{0,0,0,0},	//[44]
			{0,0,0,0},	//[45]
			{0,0,0,0},	//[46]
			{0,0,0,0},	//[47]
			{2,4,60%Screen_w*Sprite_w,60/Screen_w*Sprite_h},	//[48]	Level 9 Warp E
			{0,0,0,0},	//[49]
			{0,0,0,0},	//[50]
			{0,0,0,0},	//[51]
			{0,0,0,0},	//[52]
			{0,0,0,0},	//[53]
			{0,0,0,0},	//[54]
			{0,0,0,0},	//[55]
			{0,0,0,0},	//[56]
			{0,0,0,0},	//[57]
			{0,0,0,0},	//[58]
			{0,0,0,0},	//[59]
			{0,0,0,0},	//[60]
			{0,0,0,0},	//[61]
			{0,0,0,0},	//[62]
			{2,76,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[63] Level 8 Warp 
			{0,0,0,0},	//[64]
			{0,0,0,0},	//[65]
			{0,0,0,0},	//[66]
			{0,0,0,0},	//[67]
			{0,0,0,0},	//[68]
			{0,0,0,0},	//[69]
			{0,0,0,0},	//[70]
			{0,0,0,0},	//[71]
			{0,0,0,0},	//[72]
			{0,0,0,0},	//[73]
			{0,0,0,0},	//[74]
			{0,0,0,0},	//[75]
			{130,63,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[76] Level 8 Warp
			{0,0,0,0},	//[77]
			{0,0,0,0},	//[78]
			{0,0,0,0},	//[79]
			{0,0,0,0},	//[80]
			{0,0,0,0},	//[81]
			{2,3,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[82]	Level 9 Warp F
			{0,0,0,0},	//[83]
			{0,0,0,0},	//[84]
			{130,20,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[85] Level 9 Warp A
			{0,0,0,0},	//[86]
			{0,0,0,0},	//[87]
			{0,0,0,0},	//[88]
			{0,0,0,0},	//[89]
			{0,0,0,0},	//[90]
			{0,0,0,0},	//[91]
			{0,0,0,0},	//[92]
			{0,0,0,0},	//[93]
			{0,0,0,0},	//[94]
			{0,0,0,0},	//[95]
			{0,0,0,0},	//[96]
			{130,32,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[97] Level 9 Warp D
			{0,0,0,0},	//[98]
			{2,5,106%Screen_w*Sprite_w,106/Screen_w*Sprite_h},	//[99]	Level 9 Warp B
			{0,0,0,0},	//[100]
			{0,0,0,0},	//[101]
			{0,0,0,0},	//[102]
			{0,0,0,0},	//[103]
			{0,0,0,0},	//[104]
			{0,0,0,0},	//[105]
			{0,0,0,0},	//[106]
			{0,0,0,0},	//[107]
			{0,0,0,0},	//[108]
			{0,0,0,0},	//[109]
			{0,0,0,0},	//[110]
			{0,0,0,0},	//[111]
			{0,0,0,0},	//[112]
			{2,116,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[113] Level 9 Warp C
			{0,0,0,0},	//[114]
			{0,0,0,0},	//[115]
			{130,113,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[116] Level 9 Warp C
			{0,0,0,0},	//[117]
			{0,5,101%Screen_w*Sprite_w,101/Screen_w*Sprite_h},	//[118] Level 9 Entrance
			{0,0,0,0},	//[119]
			{0,0,0,0},	//[120]
			{0,66,39%Screen_w*Sprite_w,39/Screen_w*Sprite_h},	//[121] Level 7 Entrance
			{0,0,0,0},	//[122]
			{0,0,0,0},	//[123]
			{1,Treasure_Room,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[124] Level 8 Book
			{0,0,0,0},	//[125]
			{0,109,38%Screen_w*Sprite_w,38/Screen_w*Sprite_h},	//[126] Level 8 Entrance
			{0,0,0,0}		//[127]
		}
	};
	
	//512
	static unsigned char Overworld_Pathways[128][4]= {
		{0,0,0,0},	//[0]
		{Overworld_BombWall,25,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[1]
		{0,0,0,0},	//[2]
		{Overworld_BombWall,71,71%Screen_w*Sprite_w,71/Screen_w*Sprite_h},	//[3]
		{Overworld_BombWall,28,28%Screen_w*Sprite_w,28/Screen_w*Sprite_h},	//[4]
		{Overworld_BombWall,101,101%Screen_w*Sprite_w,101/Screen_w*Sprite_h},	//[5]
		{0,0,0,0},	//[6]
		{Overworld_BombWall,74,74%Screen_w*Sprite_w,74/Screen_w*Sprite_h},	//[7]
		{0,0,0,0},	//[8]
		{0,0,0,0},	//[9]
		{0,0,0,0},	//[10]
		{0,0,0,0},	//[11]
		{0,0,0,0},	//[12]
		{Overworld_BombWall,25,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[13]
		{0,0,0,0},	//[14]
		{0,0,0,0},	//[15]
		{Overworld_BombWall,25,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[16]
		{0,0,0,0},	//[17]
		{Overworld_BombWall,24,24%Screen_w*Sprite_w,24/Screen_w*Sprite_h},	//[18]
		{Overworld_BombWall,18,18%Screen_w*Sprite_w,18/Screen_w*Sprite_h},	//[19]
		{Overworld_BombWall,28,28%Screen_w*Sprite_w,28/Screen_w*Sprite_h},	//[20]
		{0,0,0,0},	//[21]
		{Overworld_BombWall,22,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[22]
		{Overworld_Ladder,0,0,0},	//[23]
		{Overworld_Ladder,0,0,0},	//[24]
		{Overworld_Ladder,0,0,0},	//[25]
		{0,0,0,0},	//[26]
		{0,0,0,0},	//[27]
		{0,0,0,0},	//[28]
		{0,0,0,0},	//[29]
		{Overworld_BombWall,28,28%Screen_w*Sprite_w,28/Screen_w*Sprite_h},	//[30]
		{0,0,0,0},	//[31]
		{0,0,0,0},	//[32]
		{0,0,0,0},	//[33]
		{0,0,0,0},	//[34]
		{0,0,0,0},	//[35]
		{0,0,0,0},	//[36]
		{0,0,0,0},	//[37]
		{Overworld_BombWall,19,19%Screen_w*Sprite_w,19/Screen_w*Sprite_h},	//[38]
		{Overworld_BombWall|Overworld_Ladder,30,30%Screen_w*Sprite_w,30/Screen_w*Sprite_h},	//[39]
		{Overworld_BurnBush,109,109%Screen_w*Sprite_w,109/Screen_w*Sprite_h},	//[40]
		{0,0,0,0},	//[41]
		{0,0,0,0},	//[42]
		{0,0,0,0},	//[43]
		{Overworld_BombWall,105,105%Screen_w*Sprite_w,105/Screen_w*Sprite_h},	//[44]
		{Overworld_BombWall,21,21%Screen_w*Sprite_w,21/Screen_w*Sprite_h},	//[45]
		{0,0,0,0},	//[46]
		{0,0,0,0},	//[47]
		{0,0,0,0},	//[48]
		{0,0,0,0},	//[49]
		{0,0,0,0},	//[50]
		{Overworld_BombWall,26,26%Screen_w*Sprite_w,26/Screen_w*Sprite_h},	//[51]
		{0,0,0,0},	//[52]
		{0,0,0,0},	//[53]
		{0,0,0,0},	//[54]
		{0,0,0,0},	//[55]
		{0,0,0,0},	//[56]
		{0,0,0,0},	//[57]
		{0,0,0,0},	//[58]
		{0,0,0,0},	//[59]
		{0,0,0,0},	//[60]
		{0,0,0,0},	//[61]
		{0,0,0,0},	//[62]
		{0,0,0,0},	//[63]
		{0,0,0,0},	//[64]
		{0,0,0,0},	//[65]
		{0,0,0,0},	//[66]
		{0,0,0,0},	//[67]
		{0,0,0,0},	//[68]
		{0,0,0,0},	//[69]
		{Overworld_BurnBush,121,121%Screen_w*Sprite_w,121/Screen_w*Sprite_h},	//[70]
		{Overworld_BurnBush,124,124%Screen_w*Sprite_w,124/Screen_w*Sprite_h},	//[71]
		{Overworld_BurnBush,45,45%Screen_w*Sprite_w,45/Screen_w*Sprite_h},	//[72]
		{0,0,0,0},	//[73]
		{0,0,0,0},	//[74]
		{Overworld_BurnBush,43,43%Screen_w*Sprite_w,43/Screen_w*Sprite_h},	//[75]
		{0,0,0,0},	//[76]
		{Overworld_BurnBush,109,109%Screen_w*Sprite_w,109/Screen_w*Sprite_h},	//[77]
		{0,0,0,0},	//[78]
		{Overworld_Ladder,0,0,0},	//[79]
		{0,0,0,0},	//[80]
		{Overworld_BurnBush,105,105%Screen_w*Sprite_w,105/Screen_w*Sprite_h},	//[81]
		{0,0,0,0},	//[82]
		{0,0,0,0},	//[83]
		{0,0,0,0},	//[84]
		{0,0,0,0},	//[85]
		{Overworld_BurnBush,106,106%Screen_w*Sprite_w,106/Screen_w*Sprite_h},	//[86]
		{0,0,0,0},	//[87]
		{0,0,0,0},	//[88]
		{0,0,0,0},	//[89]
		{0,0,0,0},	//[90]
		{Overworld_BurnBush,98,98%Screen_w*Sprite_w,98/Screen_w*Sprite_h},	//[91]
		{0,0,0,0},	//[92]
		{0,0,0,0},	//[93]
		{0,0,0,0},	//[94]
		{Overworld_Ladder,0,0,0},	//[95]
		{0,0,0,0},	//[96]
		{0,0,0,0},	//[97]
		{Overworld_BurnBush,40,40%Screen_w*Sprite_w,40/Screen_w*Sprite_h},	//[98]
		{Overworld_BurnBush,102,102%Screen_w*Sprite_w,102/Screen_w*Sprite_h},	//[99]
		{0,0,0,0},	//[100]
		{0,0,0,0},	//[101]
		{0,0,0,0},	//[102]
		{Overworld_BombWall,23,23%Screen_w*Sprite_w,23/Screen_w*Sprite_h},	//[103]
		{Overworld_BurnBush,98,98%Screen_w*Sprite_w,98/Screen_w*Sprite_h},	//[104]
		{0,0,0,0},	//[105]
		{Overworld_BurnBush,107,107%Screen_w*Sprite_w,107/Screen_w*Sprite_h},	//[106]
		{Overworld_BurnBush,104,104%Screen_w*Sprite_w,104/Screen_w*Sprite_h},	//[107]
		{0,0,0,0},	//[108]
		{Overworld_BurnBush,42,42%Screen_w*Sprite_w,42/Screen_w*Sprite_h},	//[109]
		{0,0,0,0},	//[110]
		{0,0,0,0},	//[111]
		{0,0,0,0},	//[112]
		{Overworld_BombWall,21,21%Screen_w*Sprite_w,21/Screen_w*Sprite_h},	//[113]
		{0,0,0,0},	//[114]
		{0,0,0,0},	//[115]
		{0,0,0,0},	//[116]
		{0,0,0,0},	//[117]
		{Overworld_BombWall,22,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[118]
		{0,0,0,0},	//[119]
		{Overworld_BurnBush,100,100%Screen_w*Sprite_w,100/Screen_w*Sprite_h},	//[120]
		{0,0,0,0},	//[121]
		{0,0,0,0},	//[122]
		{Overworld_BombWall,25,25%Screen_w*Sprite_w,25/Screen_w*Sprite_h},	//[123]
		{Overworld_BombWall,22,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[124]
		{Overworld_BombWall,22,22%Screen_w*Sprite_w,22/Screen_w*Sprite_h},	//[125]
		{0,0,0,0},	//[126]
		{0,0,0,0}		//[127]
	};
	
	//3072
	static unsigned char Push_Blocks[3][128][8]= {	//{PushBlock_Index,PushBlock_x,PushBlock_y,Stair_Index,Stair_Cover,PushBlock_Floor,PushBlock_Direction}
		{	//[0]Overworld
			{0,0,0,0,0,0,0x00},	//[0]
			{0,0,0,0,0,0,0x00},	//[1]
			{0,0,0,0,0,0,0x00},	//[2]
			{0,0,0,0,0,0,0x00},	//[3]
			{0,0,0,0,0,0,0x00},	//[4]
			{0,0,0,0,0,0,0x00},	//[5]
			{0,0,0,0,0,0,0x00},	//[6]
			{0,0,0,0,0,0,0x00},	//[7]
			{0,0,0,0,0,0,0x00},	//[8]
			{0,0,0,0,0,0,0x00},	//[9]
			{0,0,0,0,0,0,0x00},	//[10]
			{0,0,0,0,0,0,0x00},	//[11]
			{0,0,0,0,0,0,0x00},	//[12]
			{0,0,0,0,0,0,0x00},	//[13]
			{0,0,0,0,0,0,0x00},	//[14]
			{0,0,0,0,0,0,0x00},	//[15]
			{0,0,0,0,0,0,0x00},	//[16]
			{0,0,0,0,0,0,0x00},	//[17]
			{0,0,0,0,0,0,0x00},	//[18]
			{0,0,0,0,0,0,0x00},	//[19]
			{0,0,0,0,0,0,0x00},	//[20]
			{0,0,0,0,0,0,0x00},	//[21]
			{0,0,0,0,0,0,0x00},	//[22]
			{0,0,0,0,0,0,0x00},	//[23]
			{0,0,0,0,0,0,0x00},	//[24]
			{0,0,0,0,0,0,0x00},	//[25]
			{0,0,0,0,0,0,0x00},	//[26]
			{0,0,0,0,0,0,0x00},	//[27]
			{0,0,0,0,0,0,0x00},	//[28]
			{83,83%Screen_w*Sprite_w,83/Screen_w*Sprite_h,53,R_0,Null,0x02},	//[29]
			{0,0,0,0,0,0,0x00},	//[30]
			{0,0,0,0,0,0,0x00},	//[31]
			{0,0,0,0,0,0,0x00},	//[32]
			{89,89%Screen_w*Sprite_w,89/Screen_w*Sprite_h,89,RIP,Stair,0x02},	//[33]
			{0,0,0,0,0,0,0x00},	//[34]
			{83,83%Screen_w*Sprite_w,83/Screen_w*Sprite_h,84,Null,Null,0x02},	//[35]
			{0,0,0,0,0,0,0x00},	//[36]
			{0,0,0,0,0,0,0x00},	//[37]
			{0,0,0,0,0,0,0x00},	//[38]
			{0,0,0,0,0,0,0x00},	//[39]
			{0,0,0,0,0,0,0x00},	//[40]
			{0,0,0,0,0,0,0x00},	//[41]
			{0,0,0,0,0,0,0x00},	//[42]
			{0,0,0,0,0,0,0x00},	//[43]
			{0,0,0,0,0,0,0x00},	//[44]
			{0,0,0,0,0,0,0x00},	//[45]
			{0,0,0,0,0,0,0x00},	//[46]
			{0,0,0,0,0,0,0x00},	//[47]
			{0,0,0,0,0,0,0x00},	//[48]
			{0,0,0,0,0,0,0x00},	//[49]
			{0,0,0,0,0,0,0x00},	//[50]
			{0,0,0,0,0,0,0x00},	//[51]
			{0,0,0,0,0,0,0x00},	//[52]
			{0,0,0,0,0,0,0x00},	//[53]
			{0,0,0,0,0,0,0x00},	//[54]
			{0,0,0,0,0,0,0x00},	//[55]
			{0,0,0,0,0,0,0x00},	//[56]
			{0,0,0,0,0,0,0x00},	//[57]
			{0,0,0,0,0,0,0x00},	//[58]
			{0,0,0,0,0,0,0x00},	//[59]
			{0,0,0,0,0,0,0x00},	//[60]
			{0,0,0,0,0,0,0x00},	//[61]
			{0,0,0,0,0,0,0x00},	//[62]
			{0,0,0,0,0,0,0x00},	//[63]
			{0,0,0,0,0,0,0x00},	//[64]
			{0,0,0,0,0,0,0x00},	//[65]
			{0,0,0,0,0,0,0x00},	//[66]
			{0,0,0,0,0,0,0x00},	//[67]
			{0,0,0,0,0,0,0x00},	//[68]
			{0,0,0,0,0,0,0x00},	//[69]
			{0,0,0,0,0,0,0x00},	//[70]
			{0,0,0,0,0,0,0x00},	//[71]
			{0,0,0,0,0,0,0x00},	//[72]
			{83,83%Screen_w*Sprite_w,83/Screen_w*Sprite_h,53,Bush,Null,0x02},	//[73]
			{0,0,0,0,0,0,0x00},	//[74]
			{0,0,0,0,0,0,0x00},	//[75]
			{0,0,0,0,0,0,0x00},	//[76]
			{0,0,0,0,0,0,0x00},	//[77]
			{0,0,0,0,0,0,0x00},	//[78]
			{0,0,0,0,0,0,0x00},	//[79]
			{0,0,0,0,0,0,0x00},	//[80]
			{0,0,0,0,0,0,0x00},	//[81]
			{0,0,0,0,0,0,0x00},	//[82]
			{0,0,0,0,0,0,0x00},	//[83]
			{0,0,0,0,0,0,0x00},	//[84]
			{0,0,0,0,0,0,0x00},	//[85]
			{0,0,0,0,0,0,0x00},	//[86]
			{0,0,0,0,0,0,0x00},	//[87]
			{0,0,0,0,0,0,0x00},	//[88]
			{0,0,0,0,0,0,0x00},	//[89]
			{0,0,0,0,0,0,0x00},	//[90]
			{0,0,0,0,0,0,0x00},	//[91]
			{0,0,0,0,0,0,0x00},	//[92]
			{0,0,0,0,0,0,0x00},	//[93]
			{0,0,0,0,0,0,0x00},	//[94]
			{0,0,0,0,0,0,0x00},	//[95]
			{0,0,0,0,0,0,0x00},	//[96]
			{0,0,0,0,0,0,0x00},	//[97]
			{0,0,0,0,0,0,0x00},	//[98]
			{0,0,0,0,0,0,0x00},	//[99]
			{0,0,0,0,0,0,0x00},	//[100]
			{0,0,0,0,0,0,0x00},	//[101]
			{0,0,0,0,0,0,0x00},	//[102]
			{0,0,0,0,0,0,0x00},	//[103]
			{0,0,0,0,0,0,0x00},	//[104]
			{0,0,0,0,0,0,0x00},	//[105]
			{0,0,0,0,0,0,0x00},	//[106]
			{0,0,0,0,0,0,0x00},	//[107]
			{0,0,0,0,0,0,0x00},	//[108]
			{0,0,0,0,0,0,0x00},	//[109]
			{0,0,0,0,0,0,0x00},	//[110]
			{0,0,0,0,0,0,0x00},	//[111]
			{0,0,0,0,0,0,0x00},	//[112]
			{0,0,0,0,0,0,0x00},	//[113]
			{0,0,0,0,0,0,0x00},	//[114]
			{0,0,0,0,0,0,0x00},	//[115]
			{0,0,0,0,0,0,0x00},	//[116]
			{0,0,0,0,0,0,0x00},	//[117]
			{0,0,0,0,0,0,0x00},	//[118]
			{0,0,0,0,0,0,0x00},	//[119]
			{0,0,0,0,0,0,0x00},	//[120]
			{88,88%Screen_w*Sprite_w,88/Screen_w*Sprite_h,89,Null,Null,0x02},	//[121]
			{0,0,0,0,0,0,0x00},	//[122]
			{0,0,0,0,0,0,0x00},	//[123]
			{0,0,0,0,0,0,0x00},	//[124]
			{0,0,0,0,0,0,0x00},	//[125]
			{0,0,0,0,0,0,0x00},	//[126]
			{0,0,0,0,0,0,0x00}	//[127]
		},
		{	//[1]Dungeons 1
			{0,0,0,0,0,0,0x00},	//[0]
			{0,0,0,0,0,0,0x00},	//[1]
			{0,0,0,0,0,0,0x00},	//[2]
			{0,0,0,0,0,0,0x00},	//[3]
			{0,0,0,0,0,0,0x00},	//[4]
			{87,87%Screen_w*Sprite_w,87/Screen_w*Sprite_h,45,0,D_Tile,0x03},	//[5] Level 5 Recorder
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[6] Level 5 Warp
			{0,0,0,0,0,0,0x00},	//[7]
			{0,0,0,0,0,0,0x00},	//[8]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,45,0,D_Tile,0x03},	//[9] Level 6 Wand
			{0,0,0,0,0,0,0x00},	//[10]
			{0,0,0,0,0,0,0x00},	//[11]
			{0,0,0,0,0,0,0x00},	//[12]
			{0,0,0,0,0,0,0x00},	//[13]
			{0,0,0,0,0,0,0x00},	//[14]
			{0,0,0,0,0,0,0x00},	//[15]
			{0,0,0,0,0,0,0x00},	//[16]
			{0,0,0,0,0,0,0x00},	//[17]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,0,0,D_Tile,0x03},	//[18] Level 4 DR_Push
			{0,0,0,0,0,0,0x00},	//[19]
			{0,0,0,0,0,0,0x00},	//[20]
			{0,0,0,0,0,0,0x00},	//[21]
			{0,0,0,0,0,0,0x00},	//[22]
			{0,0,0,0,0,0,0x00},	//[23]
			{0,0,0,0,0,0,0x00},	//[24]
			{0,0,0,0,0,0,0x00},	//[25]
			{0,0,0,0,0,0,0x00},	//[26]
			{0,0,0,0,0,0,0x00},	//[27]
			{0,0,0,0,0,0,0x00},	//[28]
			{0,0,0,0,0,0,0x00},	//[29]
			{0,0,0,0,0,0,0x00},	//[30]
			{0,0,0,0,0,0,0x00},	//[31]
			{0,0,0,0,0,0,0x00},	//[32]
			{0,0,0,0,0,0,0x00},	//[33]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[34] Level 1 Bow
			{0,0,0,0,0,0,0x00},	//[35]
			{0,0,0,0,0,0,0x00},	//[36]
			{0,0,0,0,0,0,0x00},	//[37]
			{0,0,0,0,0,0,0x00},	//[38]
			{0,0,0,0,0,0,0x00},	//[39]
			{0,0,0,0,0,0,0x00},	//[40]
			{0,0,0,0,0,0,0x00},	//[41]
			{0,0,0,0,0,0,0x00},	//[42]
			{0,0,0,0,0,0,0x00},	//[43]
			{0,0,0,0,0,0,0x00},	//[44]
			{0,0,0,0,0,0,0x00},	//[45]
			{0,0,0,0,0,0,0x00},	//[46]
			{0,0,0,0,0,0,0x00},	//[47]
			{0,0,0,0,0,0,0x00},	//[48]
			{0,0,0,0,0,0,0x00},	//[49]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,45,0,D_Tile,0x03},	//[50] Level 4 Ladder
			{0,0,0,0,0,0,0x00},	//[51]
			{0,0,0,0,0,0,0x00},	//[52]
			{0,0,0,0,0,0,0x00},	//[53]
			{0,0,0,0,0,0,0x00},	//[54]
			{0,0,0,0,0,0,0x00},	//[55]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,0,0,D_Tile,0x03},	//[56] Level 6 DR_Push
			{0,0,0,0,0,0,0x00},	//[57]
			{87,87%Screen_w*Sprite_w,87/Screen_w*Sprite_h,45,0,D_Tile,0x03},	//[58] Level 6 Warp
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,0,0,D_Tile,0x03},	//[59] Level 3 DR_Push
			{0,0,0,0,0,0,0x00},	//[60]
			{0,0,0,0,0,0,0x00},	//[61]
			{0,0,0,0,0,0,0x00},	//[62]
			{0,0,0,0,0,0,0x00},	//[63]
			{0,0,0,0,0,0,0x00},	//[64]
			{0,0,0,0,0,0,0x00},	//[65]
			{87,87%Screen_w*Sprite_w,87/Screen_w*Sprite_h,0,0,D_Tile,0x03},	//[66] Level 1 DR_Push
			{0,0,0,0,0,0,0x00},	//[67]
			{0,0,0,0,0,0,0x00},	//[68]
			{0,0,0,0,0,0,0x00},	//[69]
			{0,0,0,0,0,0,0x00},	//[70]
			{0,0,0,0,0,0,0x00},	//[71]
			{0,0,0,0,0,0,0x00},	//[72]
			{0,0,0,0,0,0,0x00},	//[73]
			{0,0,0,0,0,0,0x00},	//[74]
			{0,0,0,0,0,0,0x00},	//[75]
			{0,0,0,0,0,0,0x00},	//[76]
			{0,0,0,0,0,0,0x00},	//[77]
			{0,0,0,0,0,0,0x00},	//[78]
			{0,0,0,0,0,0,0x00},	//[79]
			{0,0,0,0,0,0,0x00},	//[80]
			{0,0,0,0,0,0,0x00},	//[81]
			{0,0,0,0,0,0,0x00},	//[82]
			{0,0,0,0,0,0,0x00},	//[83]
			{0,0,0,0,0,0,0x00},	//[84]
			{0,0,0,0,0,0,0x00},	//[85]
			{0,0,0,0,0,0,0x00},	//[86]
			{0,0,0,0,0,0,0x00},	//[87]
			{0,0,0,0,0,0,0x00},	//[88]
			{0,0,0,0,0,0,0x00},	//[89]
			{0,0,0,0,0,0,0x00},	//[90]
			{0,0,0,0,0,0,0x00},	//[91]
			{0,0,0,0,0,0,0x00},	//[92]
			{0,0,0,0,0,0,0x00},	//[93]
			{0,0,0,0,0,0,0x00},	//[94]
			{0,0,0,0,0,0,0x00},	//[95]
			{0,0,0,0,0,0,0x00},	//[96]
			{0,0,0,0,0,0,0x00},	//[97]
			{0,0,0,0,0,0,0x00},	//[98]
			{0,0,0,0,0,0,0x00},	//[99]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[100] Level 5 Warp
			{0,0,0,0,0,0,0x00},	//[101]
			{0,0,0,0,0,0,0x00},	//[102]
			{0,0,0,0,0,0,0x00},	//[103]
			{0,0,0,0,0,0,0x00},	//[104]
			{0,0,0,0,0,0,0x00},	//[105]
			{0,0,0,0,0,0,0x00},	//[106]
			{0,0,0,0,0,0,0x00},	//[107]
			{0,0,0,0,0,0,0x00},	//[108]
			{0,0,0,0,0,0,0x00},	//[109]
			{0,0,0,0,0,0,0x00},	//[110]
			{0,0,0,0,0,0,0x00},	//[111]
			{0,0,0,0,0,0,0x00},	//[112]
			{0,0,0,0,0,0,0x00},	//[113]
			{0,0,0,0,0,0,0x00},	//[114]
			{0,0,0,0,0,0,0x00},	//[115]
			{0,0,0,0,0,0,0x00},	//[116]
			{0,0,0,0,0,0,0x00},	//[117]
			{0,0,0,0,0,0,0x00},	//[118]
			{0,0,0,0,0,0,0x00},	//[119]
			{0,0,0,0,0,0,0x00},	//[120]
			{0,0,0,0,0,0,0x00},	//[121]
			{0,0,0,0,0,0,0x00},	//[122]
			{0,0,0,0,0,0,0x00},	//[123]
			{0,0,0,0,0,0,0x00},	//[124]
			{0,0,0,0,0,0,0x00},	//[125]
			{0,0,0,0,0,0,0x00},	//[126]
			{0,0,0,0,0,0,0x00}	//[127]
		},
		{	//[2]Dungeons 2
			{0,0,0,0,0,0,0x00},	//[0]
			{0,0,0,0,0,0,0x00},	//[1]
			{0,0,0,0,0,0,0x00},	//[2]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[3] Level 9 Warp F
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[4] Level 9 Warp E
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,45,0,D_Tile,0x03},	//[5] Level 8 Warp B
			{0,0,0,0,0,0,0x00},	//[6]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[7] Level 8 Red Ring
			{0,0,0,0,0,0,0x00},	//[8]
			{0,0,0,0,0,0,0x00},	//[9]
			{0,0,0,0,0,0,0x00},	//[10]
			{0,0,0,0,0,0,0x00},	//[11]
			{0,0,0,0,0,0,0x00},	//[12]
			{92,92%Screen_w*Sprite_w,92/Screen_w*Sprite_h,45,0,D_Tile,0x01},	//[13] Level 7 Warp
			{0,0,0,0,0,0,0x00},	//[14]
			{0,0,0,0,0,0,0x00},	//[15]
			{92,92%Screen_w*Sprite_w,92/Screen_w*Sprite_h,45,0,D_Tile,0x01},	//[16] Level 9 Arrow
			{0,0,0,0,0,0,0x00},	//[17]
			{0,0,0,0,0,0,0x00},	//[18]
			{0,0,0,0,0,0,0x00},	//[19]
			{0,0,0,0,0,0,0x00},	//[20]
			{0,0,0,0,0,0,0x00},	//[21]
			{0,0,0,0,0,0,0x00},	//[22]
			{0,0,0,0,0,0,0x00},	//[23]
			{0,0,0,0,0,0,0x00},	//[24]
			{0,0,0,0,0,0,0x00},	//[25]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[26] Level 7 Candle
			{0,0,0,0,0,0,0x00},	//[27]
			{0,0,0,0,0,0,0x00},	//[28]
			{0,0,0,0,0,0,0x00},	//[29]
			{0,0,0,0,0,0,0x00},	//[30]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[31] Level 8 Warp
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[32] Level 9 Warp D
			{0,0,0,0,0,0,0x00},	//[33]
			{0,0,0,0,0,0,0x00},	//[34]
			{0,0,0,0,0,0,0x00},	//[35]
			{0,0,0,0,0,0,0x00},	//[36]
			{0,0,0,0,0,0,0x00},	//[37]
			{0,0,0,0,0,0,0x00},	//[38]
			{0,0,0,0,0,0,0x00},	//[39]
			{0,0,0,0,0,0,0x00},	//[40]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[41] Level 7 Warp
			{0,0,0,0,0,0,0x00},	//[42]
			{0,0,0,0,0,0,0x00},	//[43]
			{0,0,0,0,0,0,0x00},	//[44]
			{0,0,0,0,0,0,0x00},	//[45]
			{0,0,0,0,0,0,0x00},	//[46]
			{0,0,0,0,0,0,0x00},	//[47]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,45,0,D_Tile,0x03},	//[48] Level 9 Warp E
			{0,0,0,0,0,0,0x00},	//[49]
			{0,0,0,0,0,0,0x00},	//[50]
			{0,0,0,0,0,0,0x00},	//[51]
			{0,0,0,0,0,0,0x00},	//[52]
			{0,0,0,0,0,0,0x00},	//[53]
			{0,0,0,0,0,0,0x00},	//[54]
			{0,0,0,0,0,0,0x00},	//[55]
			{0,0,0,0,0,0,0x00},	//[56]
			{0,0,0,0,0,0,0x00},	//[57]
			{0,0,0,0,0,0,0x00},	//[58]
			{0,0,0,0,0,0,0x00},	//[59]
			{0,0,0,0,0,0,0x00},	//[60]
			{0,0,0,0,0,0,0x00},	//[61]
			{0,0,0,0,0,0,0x00},	//[62]
			{0,0,0,0,0,0,0x00},	//[63]
			{0,0,0,0,0,0,0x00},	//[64]
			{0,0,0,0,0,0,0x00},	//[65]
			{0,0,0,0,0,0,0x00},	//[66]
			{0,0,0,0,0,0,0x00},	//[67]
			{0,0,0,0,0,0,0x00},	//[68]
			{0,0,0,0,0,0,0x00},	//[69]
			{0,0,0,0,0,0,0x00},	//[70]
			{0,0,0,0,0,0,0x00},	//[71]
			{0,0,0,0,0,0,0x00},	//[72]
			{0,0,0,0,0,0,0x00},	//[73]
			{0,0,0,0,0,0,0x00},	//[74]
			{0,0,0,0,0,0,0x00},	//[75]
			{0,0,0,0,0,0,0x00},	//[76]
			{0,0,0,0,0,0,0x00},	//[77]
			{0,0,0,0,0,0,0x00},	//[78]
			{0,0,0,0,0,0,0x00},	//[79]
			{0,0,0,0,0,0,0x00},	//[80]
			{0,0,0,0,0,0,0x00},	//[81]
			{0,0,0,0,0,0,0x00},	//[82]
			{0,0,0,0,0,0,0x00},	//[83]
			{0,0,0,0,0,0,0x00},	//[84]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[85] Level 9 Warp A
			{0,0,0,0,0,0,0x00},	//[86]
			{0,0,0,0,0,0,0x00},	//[87]
			{0,0,0,0,0,0,0x00},	//[88]
			{0,0,0,0,0,0,0x00},	//[89]
			{0,0,0,0,0,0,0x00},	//[90]
			{0,0,0,0,0,0,0x00},	//[91]
			{0,0,0,0,0,0,0x00},	//[92]
			{0,0,0,0,0,0,0x00},	//[93]
			{0,0,0,0,0,0,0x00},	//[94]
			{0,0,0,0,0,0,0x00},	//[95]
			{0,0,0,0,0,0,0x00},	//[96]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[97] Level 9 Warp D
			{0,0,0,0,0,0,0x00},	//[98]
			{0,0,0,0,0,0,0x00},	//[99]
			{0,0,0,0,0,0,0x00},	//[100]
			{0,0,0,0,0,0,0x00},	//[101]
			{0,0,0,0,0,0,0x00},	//[102]
			{0,0,0,0,0,0,0x00},	//[103]
			{0,0,0,0,0,0,0x00},	//[104]
			{0,0,0,0,0,0,0x00},	//[105]
			{0,0,0,0,0,0,0x00},	//[106]
			{0,0,0,0,0,0,0x00},	//[107]
			{0,0,0,0,0,0,0x00},	//[108]
			{0,0,0,0,0,0,0x00},	//[109]
			{0,0,0,0,0,0,0x00},	//[110]
			{0,0,0,0,0,0,0x00},	//[111]
			{0,0,0,0,0,0,0x00},	//[112]
			{0,0,0,0,0,0,0x00},	//[113]
			{0,0,0,0,0,0,0x00},	//[114]
			{0,0,0,0,0,0,0x00},	//[115]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[116] Level 9 Warp C
			{0,0,0,0,0,0,0x00},	//[117]
			{0,0,0,0,0,0,0x00},	//[118]
			{0,0,0,0,0,0,0x00},	//[119]
			{0,0,0,0,0,0,0x00},	//[120]
			{0,0,0,0,0,0,0x00},	//[121]
			{0,0,0,0,0,0,0x00},	//[122]
			{0,0,0,0,0,0,0x00},	//[123]
			{86,86%Screen_w*Sprite_w,86/Screen_w*Sprite_h,88,0,D_Tile,0x03},	//[124] Level 8 Book
			{0,0,0,0,0,0,0x00},	//[125]
			{0,0,0,0,0,0,0x00},	//[126]
			{0,0,0,0,0,0,0x00}	//[127]
		}
	};
	
	//200
	static unsigned char Item_Data[40][5]=	//For loading into Active_Items[16] STRUCT
	{ //[0]	Item
		//[1]	Item_w_half
		//[2] Item_h_half
		//[3] Graphics_1
		//[4] Graphics_2
		{Item_Wooden_Sword,4/2,9/2,Wooden_Sword,Wooden_Sword},	//[0]
		{Item_White_Sword,4/2,9/2,White_Sword,White_Sword},	//[1]
		{Item_Magical_Sword,6/2,9/2,Magical_Sword,Magical_Sword},	//[2]
		{Item_Boomerang,3/2,5/2,Normal_Boomerang,Normal_Boomerang},	//[3]
		{Item_Magic_Boomerang,3/2,5/2,Magical_Boomerang,Magical_Boomerang},	//[4]
		{Item_Bomb,5/2,8/2,Bomb_1,Bomb_1},	//[5] 
		{Item_Wooden_Arrow,3/2,9/2,Wooden_Arrow,Wooden_Arrow},	//[6]
		{Item_Silver_Arrow,3/2,9/2,Silver_Arrow,Silver_Arrow},	//[7]
		{Item_Bow,6/2,9/2,Bow,Bow},	//[8]
		{Item_Blue_Candle,5/2,9/2,Blue_Candle,Blue_Candle},	//[9]
		{Item_Red_Candle,5/2,9/2,Red_Candle,Red_Candle},	//[10]
		{Item_Recorder,3/2,9/2,Recorder,Recorder},	//[11]
		{Item_Meat,6/2,9/2,Meat_1,Meat_1},	//[12]
		{Item_Letter,6/2,9/2,Letter,Letter},	//[13]
		{Item_Blue_Potion,6/2,9/2,Blue_Potion,Blue_Potion},	//[14]
		{Item_Red_Potion,6/2,9/2,Red_Potion,Red_Potion},	//[15]
		{Item_Wand,3/2,9/2,Magic_Wand,Magic_Wand},	//[16]
		{Item_Raft,9/2,9/2,Raft_1,Raft_1},	//[17]
		{Item_Book,5/2,9/2,Magical_Book,Magical_Book},	//[18]
		{Item_Blue_Ring,5/2,9/2,Blue_Ring,Blue_Ring},	//[19]
		{Item_Red_Ring,5/2,5/2,Red_Ring,Red_Ring},	//[20]
		{Item_Ladder,5/2,5/2,Ladder_1,Ladder_1},	//[21]
		{Item_Magical_Key,5/2,9/2,Magical_Key,Magical_Key},	//[22]
		{Item_Bracelet,5/2,9/2,Power_Bracelet,Power_Bracelet},	//[23]
		{Item_Hrt_Cntnr_Add,9/2,9/2,Hrt_Cntnr,Hrt_Cntnr},	//[24]
		{Item_Hrt_Cntnr_Sub,9/2,9/2,Hrt_Cntnr,Hrt_Cntnr},	//[25]
		{Item_Heart,5/2,5/2,Heart_Full,Heart_Light},	//[26]
		{Item_Fairy,5/2,9/2,Fairy_1,Fairy_2},	//[27]
		{Item_Clock,5/2,9/2,Clock,Clock},	//[28]
		{Item_Rupy,5/2,9/2,Rupy_Light,Rupy_Dark},	//[29
		{Item_5xRupy,5/2,9/2,Rupy_Dark,Rupy_Dark},	//[30]
		{Item_Black_Bomb,5/2,8/2,Bomb_2,Bomb_2},	//[31] 
		{Item_Key,5/2,9/2,D_Key,D_Key},	//[32]
		{Item_Map,6/2,9/2,Dark_Map,Dark_Map},	//[33]
		{Item_Compass,7/2,9/2,Dark_Compass,Dark_Compass},	//[34]
		{Item_Triforce,7/2,7/2,Triforce_Light,Triforce_Dark},	//[35]
		{Item_More_Bombs,5/2,8/2,Bomb_1,Bomb_1},	//[36]
		{Item_Magical_Shield,10/2,9/2,Shield,Shield},	//[37]
		{Item_Not_Present,0,0,0,0},	//[38]
		{Item_Not_Present,0,0,0,0}	//[39]
	};
	
	
	//185
	static unsigned char Shop_Info[37][5]= {
		//[0]Shop_Item_1,
		//[1]Shop_Item_2
		//[2]Shop_Item_3
		//[3]Shopkeeper
		//[4]Shop_Text
		{Item_Rupy,Item_Rupy,Item_Rupy,Shopkpr_Wizard,Shop_Text_Gamble},	//[0] Shop_Gamble
		{Item_Rupy,Item_Rupy,Item_Rupy,Shopkpr_Old_Woman,Shop_Text_Pay_Talk},	//[1] Shop_Waterfall_Pay_Talk
		{Item_Rupy,Item_Rupy,Item_Rupy,Shopkpr_Old_Woman,Shop_Text_Pay_Talk},	//[2] Shop_Tree_Pay_Talk
		{Item_Magical_Shield,Item_Key,Item_Blue_Candle,Shopkpr_Fat_Man,Shop_Text_Items_1_2},	//[3] Shop_Items_1
		{Item_Magical_Shield,Item_Bomb,Item_Wooden_Arrow,Shopkpr_Fat_Man,Shop_Text_Items_1_2},	//[4] Shop_Items_2
		{Item_Magical_Shield,Item_Meat,Item_Heart,Shopkpr_Fat_Man,Shop_Text_Items_3_4},	//[5] Shop_Items_3
		{Item_Key,Item_Blue_Ring,Item_Meat,Shopkpr_Fat_Man,Shop_Text_Items_3_4},	//[6] Shop_Items_4
		{Item_Blue_Potion,Item_Not_Present,Item_Red_Potion,Shopkpr_Old_Woman,Shop_Text_Potion},	//[7] Shop_Potion
		{Item_Not_Present,Item_More_Bombs,Item_Not_Present,Shopkpr_Wizard,Shop_Text_More_Bombs},	//[8] Shop_More_Bombs
		{Item_Not_Present,Item_5xRupy,Item_Not_Present,Shopkpr_Goriya,Shop_Text_Free_10_30_100},	//[9] Shop_Free_10
		{Item_Not_Present,Item_5xRupy,Item_Not_Present,Shopkpr_Goriya,Shop_Text_Free_10_30_100},	//[10] Shop_Free_30
		{Item_Not_Present,Item_5xRupy,Item_Not_Present,Shopkpr_Goriya,Shop_Text_Free_10_30_100},	//[11] Shop_Free_100
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Door_Repair},	//[12] Shop_Door_Repair
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Goriya,Shop_Text_Hungry_Goriya},	//[13] Shop_Hungry_Goriya
		{Item_Not_Present,Item_Wooden_Sword,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Wooden_Sword},	//[14] Shop_Wooden_Sword
		{Item_Not_Present,Item_White_Sword,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Better_Sword},	//[15] Shop_White_Sword
		{Item_Not_Present,Item_Magical_Sword,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Better_Sword},	//[16] Shop_Magical_Sword
		{Item_Hrt_Cntnr_Add,Item_Not_Present,Item_Red_Potion,Shopkpr_Wizard,Shop_Text_Heart_Container},	//[17] Shop_Heart_Container
		{Item_Not_Present,Item_Letter,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Letter},	//[18] Shop_Letter
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Warp},	//[19] Shop_Warp
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_Hint_1},	//[20] Shop_Hint_1	
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Old_Woman,Shop_Text_Hint_2},	//[21] Shop_Hint_2
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L1},	//[22] Shop_L1
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L2},	//[23] Shop_L2
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L3},	//[24] Shop_L3
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L4},	//[25] Shop_L4
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L5A},	//[26] Shop_L5A
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L5B},	//[27] Shop_L5B
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L6A},	//[28] Shop_L6A
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L6B},	//[29] Shop_L6B
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L7A},	//[30] Shop_L7A
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L8A},	//[31] Shop_L8A
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L8B},	//[32] Shop_L8B
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L9A},	//[33] Shop_L9A
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L9B},	//[34] Shop_L9B
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L9C},	//[35] Shop_L9C
		{Item_Not_Present,Item_Not_Present,Item_Not_Present,Shopkpr_Wizard,Shop_Text_L9D}	//[36] Shop_L9D
	};
	
	//1715
	static unsigned char Shop_Characters[35][49]= {	//{Length, Char_1 ... Char_Return ... Char_n, Char_End}
		{	//[0] Shop_Text_Items_1_2; "BUY SOMETHIN' WILL YA!" (22)
			25,Char_B,Char_U,Char_Y,Char_Space,Char_S,Char_O,Char_M,Char_E,Char_T,Char_H,Char_I,Char_N,Char_Apostrophe,Char_Space,Char_W,Char_I,Char_L,Char_L,Char_Space,Char_Y,Char_A,Char_Exclamation,Char_End
		},
		{	//[1] Shop_Text_Items_2_3; "BOY, THIS IS || REALLY EXPENSIVE!" (12,17)
			50,Char_B,Char_O,Char_Y,Char_Comma,Char_Space,Char_T,Char_H,Char_I,Char_S,Char_Space,Char_I,Char_S,Char_Return,
			37,Char_R,Char_E,Char_A,Char_L,Char_L,Char_Y,Char_Space,Char_E,Char_X,Char_P,Char_E,Char_N,Char_S,Char_I,Char_V,Char_E,Char_Exclamation,Char_End
		},
		{	//[2] Shop_Text_Potion; "BUY MEDICINE BEFORE || YOU GO." (19,7)
			32,Char_B,Char_U,Char_Y,Char_Space,Char_M,Char_E,Char_D,Char_I,Char_C,Char_I,Char_N,Char_E,Char_Space,Char_B,Char_E,Char_F,Char_O,Char_R,Char_E,Char_Return,
			62,Char_Y,Char_O,Char_U,Char_Space,Char_G,Char_O,Char_Period,Char_End
		},
		{	//[3] Shop_Text_Gamble; "LET'S PLAY MONEY || MAKING GAME." (15,12)
			42,Char_L,Char_E,Char_T,Char_Apostrophe,Char_S,Char_Space,Char_P,Char_L,Char_A,Char_Y,Char_Space,Char_M,Char_O,Char_N,Char_E,Char_Y,Char_Return,
			50,Char_M,Char_A,Char_K,Char_I,Char_N,Char_G,Char_Space,Char_G,Char_A,Char_M,Char_E,Char_Period,Char_End
		},
		{	//[4] Shop_Text_Free_10_30_100; "IT'S A SECRET || TO EVERYBODY." (13,13)
			47,Char_I,Char_T,Char_Apostrophe,Char_S,Char_Space,Char_A,Char_Space,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_Return,
			47,Char_T,Char_O,Char_Space,Char_E,Char_V,Char_E,Char_R,Char_Y,Char_B,Char_O,Char_D,Char_Y,Char_Period,Char_End
		},
		{	//[5] Shop_Text_Door_Repair; "PAY ME FOR THE DOOR || REPAIR CHARGE." (19,14)
			32,Char_P,Char_A,Char_Y,Char_Space,Char_M,Char_E,Char_Space,Char_F,Char_O,Char_R,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_D,Char_O,Char_O,Char_R,Char_Return,
			45,Char_R,Char_E,Char_P,Char_A,Char_I,Char_R,Char_Space,Char_C,Char_H,Char_A,Char_R,Char_G,Char_E,Char_Period,Char_End
		},
		{	//[6] Shop_Text_Pay_Talk; "PAY ME AND I'LL TALK." (21)
			27,Char_P,Char_A,Char_Y,Char_Space,Char_M,Char_E,Char_Space,Char_A,Char_N,Char_D,Char_Space,Char_I,Char_Apostrophe,Char_L,Char_L,Char_Space,Char_T,Char_A,Char_L,Char_K,Char_Period,Char_End
		},
		{	//[7] Shop_Text_More_Bombs; "I BET YOU'D LIKE || TO HAVE MORE BOMBS." (16,19)
			40,Char_I,Char_Space,Char_B,Char_E,Char_T,Char_Space,Char_Y,Char_O,Char_U,Char_Apostrophe,Char_D,Char_Space,Char_L,Char_I,Char_K,Char_E,Char_Return,
			32,Char_T,Char_O,Char_Space,Char_H,Char_A,Char_V,Char_E,Char_Space,Char_M,Char_O,Char_R,Char_E,Char_Space,Char_B,Char_O,Char_M,Char_B,Char_S,Char_Period,Char_End
		},
		{	//[8] Shop_Text_Wooden_Sword; "IT'S DANGEROUS TO GO || ALONE! TAKE THIS." (20,17)
			30,Char_I,Char_T,Char_Apostrophe,Char_S,Char_Space,Char_D,Char_A,Char_N,Char_G,Char_E,Char_R,Char_O,Char_U,Char_S,Char_Space,Char_T,Char_O,Char_Space,Char_G,Char_O,Char_Return,
			37,Char_A,Char_L,Char_O,Char_N,Char_E,Char_Exclamation,Char_Space,Char_T,Char_A,Char_K,Char_E,Char_Space,Char_T,Char_H,Char_I,Char_S,Char_Period,Char_End
		},
		{	//[9] Shop_Text_Better_Sword; "MASTER USING IT AND || YOU CAN HAVE THIS." (19,18)
			32,Char_M,Char_A,Char_S,Char_T,Char_E,Char_R,Char_Space,Char_U,Char_S,Char_I,Char_N,Char_G,Char_Space,Char_I,Char_T,Char_Space,Char_A,Char_N,Char_D,Char_Return,
			35,Char_Y,Char_O,Char_U,Char_Space,Char_C,Char_A,Char_N,Char_Space,Char_H,Char_A,Char_V,Char_E,Char_Space,Char_T,Char_H,Char_I,Char_S,Char_Period,Char_End
		},
		{	//[10] Shop_Text_Heart_Container; "TAKE ANY ONE YOU WANT." (22)
			25,Char_T,Char_A,Char_K,Char_E,Char_Space,Char_A,Char_N,Char_Y,Char_Space,Char_O,Char_N,Char_E,Char_Space,Char_Y,Char_O,Char_U,Char_Space,Char_W,Char_A,Char_N,Char_T,Char_Period,Char_End
		},
		{	//[11] Shop_Text_Warp; "TAKE ANY ROAD YOU WANT." (23)
			22,Char_T,Char_A,Char_K,Char_E,Char_Space,Char_A,Char_N,Char_Y,Char_Space,Char_R,Char_O,Char_A,Char_D,Char_Space,Char_Y,Char_O,Char_U,Char_Space,Char_W,Char_A,Char_N,Char_T,Char_Period,Char_End
		},
		{	//[12] Shop_Text_Letter; "SHOW THIS TO THE || OLD WOMAN." (16,10)
			40,Char_S,Char_H,Char_O,Char_W,Char_Space,Char_T,Char_H,Char_I,Char_S,Char_Space,Char_T,Char_O,Char_Space,Char_T,Char_H,Char_E,Char_Return,
			55,Char_O,Char_L,Char_D,Char_Space,Char_W,Char_O,Char_M,Char_A,Char_N,Char_Period,Char_End
		},
		{	//[13] Shop_Text_Hint_1; "SECRET IS IN THE TREE || AT THE DEAD-END." (21,16)
			27,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_Space,Char_I,Char_S,Char_Space,Char_I,Char_N,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_T,Char_R,Char_E,Char_E,Char_Return,
			37,Char_A,Char_T,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_D,Char_E,Char_A,Char_D,Char_Hyphen,Char_E,Char_N,Char_D,Char_Period,Char_End
		},
		{	//[14] Shop_Text_Hint_2; "MEET THE OLD MAN || AT THE GRAVE." (16,13)
			40,Char_M,Char_E,Char_E,Char_T,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_O,Char_L,Char_D,Char_Space,Char_M,Char_A,Char_N,Char_Return,
			47,Char_A,Char_T,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_G,Char_R,Char_A,Char_V,Char_E,Char_Period,Char_End
		},
		{	//[15] Shop_Text_Poor; "THIS AIN'T ENOUGH || TO TALK." (16,8)
			40,Char_T,Char_H,Char_I,Char_S,Char_Space,Char_A,Char_I,Char_N,Char_Apostrophe,Char_T,Char_Space,Char_E,Char_N,Char_O,Char_U,Char_G,Char_H,Char_Return,
			60,Char_T,Char_O,Char_Space,Char_T,Char_A,Char_L,Char_K,Char_Period,Char_End
		},
		{	//[16] Shop_Text_Rich; "BOY, YOU'RE RICH!" (17)
			37,Char_B,Char_O,Char_Y,Char_Comma,Char_Space,Char_Y,Char_O,Char_U,Char_Apostrophe,Char_R,Char_E,Char_Space,Char_R,Char_I,Char_C,Char_H,Char_Exclamation,Char_End
		},
		{	//[17] Shop_Text_Forest_Maze; "GO NORTH, WEST, SOUTH || WEST IN THE FOREST MAZE." (21,24) 23+26=49
			27,Char_G,Char_O,Char_Space,Char_N,Char_O,Char_R,Char_T,Char_H,Char_Comma,Char_Space,Char_W,Char_E,Char_S,Char_T,Char_Comma,Char_Space,Char_S,Char_O,Char_U,Char_T,Char_H,Char_Return,
			22,Char_W,Char_E,Char_S,Char_T,Char_Space,Char_I,Char_N,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_F,Char_O,Char_R,Char_E,Char_S,Char_T,Char_Space,Char_M,Char_A,Char_Z,Char_E,Char_Period,Char_End
		},
		{	//[18] Shop_Text_Mountain_Maze; "GO UP, UP || THE MOUNTAIN AHEAD." (9,19)
			57,Char_G,Char_O,Char_Space,Char_U,Char_P,Char_Comma,Char_Space,Char_U,Char_P,Char_Return,
			32,Char_T,Char_H,Char_E,Char_Space,Char_M,Char_O,Char_U,Char_N,Char_T,Char_A,Char_I,Char_N,Char_Space,Char_A,Char_H,Char_E,Char_A,Char_D,Char_Period,Char_End
		},
		{	//[19] Shop_Text_Hungry_Goriya; "GRUMBLE GRUMBLE..." (18)
			35,Char_G,Char_R,Char_U,Char_M,Char_B,Char_L,Char_E,Char_Space,Char_G,Char_R,Char_U,Char_M,Char_B,Char_L,Char_E,Char_Period,Char_Period,Char_Period,Char_End
		},
		{	//[20] Shop_Text_L1; "EASTMOST PENINSULA || IS THE SECRET." (18,14)
			35,Char_E,Char_A,Char_S,Char_T,Char_M,Char_O,Char_S,Char_T,Char_Space,Char_P,Char_E,Char_N,Char_I,Char_N,Char_S,Char_U,Char_L,Char_A,Char_Return,
			45,Char_I,Char_S,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_Period,Char_End
		},
		{	//[21] Shop_Text_L2; "DODONGO DISLIKES SMOKE." (23)
			22,Char_D,Char_O,Char_D,Char_O,Char_N,Char_G,Char_O,Char_Space,Char_D,Char_I,Char_S,Char_L,Char_I,Char_K,Char_E,Char_S,Char_Space,Char_S,Char_M,Char_O,Char_K,Char_E,Char_Period,Char_End
		},
		{	//[22] Shop_Text_L3; "DID YOU GET THE SWORD || BY THE WATERFALL?"
			27,Char_D,Char_I,Char_D,Char_Space,Char_Y,Char_O,Char_U,Char_Space,Char_G,Char_E,Char_T,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_S,Char_W,Char_O,Char_R,Char_D,Char_Return,
			37,Char_B,Char_Y,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_W,Char_A,Char_T,Char_E,Char_R,Char_F,Char_A,Char_L,Char_L,Char_Q_Mark,Char_End
		},
		{	//[23] Shop_Text_L4; "WALK INTO THE || WATERFALL." (13,10)
			47,Char_W,Char_A,Char_L,Char_K,Char_Space,Char_I,Char_N,Char_T,Char_O,Char_Space,Char_T,Char_H,Char_E,Char_Return,
			55,Char_W,Char_A,Char_T,Char_E,Char_R,Char_F,Char_A,Char_L,Char_L,Char_Period,Char_End
		},
		{	//[24] Shop_Text_L5A; "SECRET POWER IS SAID || TO BE IN THE ARROW." (20,19)
			30,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_Space,Char_P,Char_O,Char_W,Char_E,Char_R,Char_Space,Char_I,Char_S,Char_Space,Char_S,Char_A,Char_I,Char_D,Char_Return,
			32,Char_T,Char_O,Char_Space,Char_B,Char_E,Char_Space,Char_I,Char_N,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_A,Char_R,Char_R,Char_O,Char_W,Char_Period,Char_End
		},
		{	//[25] Shop_Text_L5B; "DIGDOGGER HATES || CERTAIN KIND OF SOUND." (15,22)
			42,Char_D,Char_I,Char_G,Char_D,Char_O,Char_G,Char_G,Char_E,Char_R,Char_Space,Char_H,Char_A,Char_T,Char_E,Char_S,Char_Return,
			25,Char_C,Char_E,Char_R,Char_T,Char_A,Char_I,Char_N,Char_Space,Char_K,Char_I,Char_N,Char_D,Char_Space,Char_O,Char_F,Char_Space,Char_S,Char_O,Char_U,Char_N,Char_D,Char_Period,Char_End
		},
		{	//[26] Shop_Text_L6A; "AIM AT THE EYES || OF GOHMA." (15,9)
			42,Char_A,Char_I,Char_M,Char_Space,Char_A,Char_T,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_E,Char_Y,Char_E,Char_S,Char_Return,
			57,Char_O,Char_F,Char_Space,Char_G,Char_O,Char_H,Char_M,Char_A,Char_Period,Char_End
		},
		{	//[27] Shop_Text_L6B; "THERE ARE SECRETS WHERE || FAIRIES DON'T LIVE." (23,19)
			22,Char_T,Char_H,Char_E,Char_R,Char_E,Char_Space,Char_A,Char_R,Char_E,Char_Space,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_S,Char_Space,Char_W,Char_H,Char_E,Char_R,Char_E,Char_Return,
			32,Char_F,Char_A,Char_I,Char_R,Char_I,Char_E,Char_S,Char_Space,Char_D,Char_O,Char_N,Char_Apostrophe,Char_T,Char_Space,Char_L,Char_I,Char_V,Char_E,Char_Period,Char_End
		},
		{	//[28] Shop_Text_L7A; "THERE'S A SECRET IN || THE TIP OF THE NOSE." (19,20)
			32,Char_T,Char_H,Char_E,Char_R,Char_E,Char_Apostrophe,Char_S,Char_Space,Char_A,Char_Space,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_Space,Char_I,Char_N,Char_Return,
			30,Char_T,Char_H,Char_E,Char_Space,Char_T,Char_I,Char_P,Char_Space,Char_O,Char_F,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_N,Char_O,Char_S,Char_E,Char_Period,Char_End
		},
		{	//[29] Shop_Text_L8A; "10TH ENEMY HAS || THE BOMB." (14,9)
			45,Char_1,Char_0,Char_T,Char_H,Char_Space,Char_E,Char_N,Char_E,Char_M,Char_Y,Char_Space,Char_H,Char_A,Char_S,Char_Return,
			57,Char_T,Char_H,Char_E,Char_Space,Char_B,Char_O,Char_M,Char_B,Char_Period,Char_End
		},
		{	//[30] Shop_Text_L8B; "SPECTACLE ROCK IS || AN ENTRANCE TO DEATH." (17,21)
			37,Char_S,Char_P,Char_E,Char_C,Char_T,Char_A,Char_C,Char_L,Char_E,Char_Space,Char_R,Char_O,Char_C,Char_K,Char_Space,Char_I,Char_S,Char_Return,
			27,Char_A,Char_N,Char_Space,Char_E,Char_N,Char_T,Char_R,Char_A,Char_N,Char_C,Char_E,Char_Space,Char_T,Char_O,Char_Space,Char_D,Char_E,Char_A,Char_T,Char_H,Char_Period,Char_End
		},
		{	//[31] Shop_Text_L9A; "ONE'S WHO DOES NOT HAVE || TRIFORCE CAN'T GO IN." (23,21) 25+22=47 in total
			22,Char_O,Char_N,Char_E,Char_Apostrophe,Char_S,Char_Space,Char_W,Char_H,Char_O,Char_Space,Char_D,Char_O,Char_E,Char_S,Char_Space,Char_N,Char_O,Char_T,Char_Space,Char_H,Char_A,Char_V,Char_E,Char_Return,
			27,Char_T,Char_R,Char_I,Char_F,Char_O,Char_R,Char_C,Char_E,Char_Space,Char_C,Char_A,Char_N,Char_Apostrophe,Char_T,Char_Space,Char_G,Char_O,Char_Space,Char_I,Char_N,Char_Period,Char_End
		},
		{	//[32] Shop_Text_L9B; "GO TO THE NEXT ROOM." (20)
			30,Char_G,Char_O,Char_Space,Char_T,Char_O,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_N,Char_E,Char_X,Char_T,Char_Space,Char_R,Char_O,Char_O,Char_M,Char_Period,Char_End
		},
		{	//[33] Shop_Text_L9C; "EYES OF SKULL || HAS A SECRET." (13,13)
			47,Char_E,Char_Y,Char_E,Char_S,Char_Space,Char_O,Char_F,Char_Space,Char_S,Char_K,Char_U,Char_L,Char_L,Char_Return,
			47,Char_H,Char_A,Char_S,Char_Space,Char_A,Char_Space,Char_S,Char_E,Char_C,Char_R,Char_E,Char_T,Char_Period,Char_End
		},
		{	//[34] Shop_Text_L9D; "PATRA HAS THE MAP." (18)
			35,Char_P,Char_A,Char_T,Char_R,Char_A,Char_Space,Char_H,Char_A,Char_S,Char_Space,Char_T,Char_H,Char_E,Char_Space,Char_M,Char_A,Char_P,Char_Period,Char_End
		}
	};

	//480
	static signed short Shop_Prices[12][4][5]= {
		//[0]Price_Number
		//[1]Price_Char_1
		//[2]Price_Char_2
		//[3]Price_Char_3
		//[4]Price_Char_4
		{	//[0] Shop_Gamble
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{10,Char_Hyphen,Char_1,Char_0,Char_Space},				//[1] Item 1
			{10,Char_Hyphen,Char_1,Char_0,Char_Space},				//[2] Item 2
			{10,Char_Hyphen,Char_1,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[1] Shop_Waterfall_Pay_Talk
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{5,Char_Space,Char_Hyphen,Char_5,Char_Space},			//[1] Item 1
			{10,Char_Hyphen,Char_1,Char_0,Char_Space},				//[2] Item 2
			{20,Char_Hyphen,Char_2,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[2] Shop_Tree_Pay_Talk
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{10,Char_Hyphen,Char_1,Char_0,Char_Space},				//[1] Item 1
			{30,Char_Hyphen,Char_3,Char_0,Char_Space},				//[2] Item 2
			{50,Char_Hyphen,Char_5,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[3] Shop_Items_1
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{160,Char_1,Char_6,Char_0,Char_Space},						//[1] Item 1
			{100,Char_1,Char_0,Char_0,Char_Space},						//[2] Item 2
			{60,Char_Space,Char_6,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[4] Shop_Items_2
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{130,Char_1,Char_3,Char_0,Char_Space},						//[1] Item 1
			{20,Char_Space,Char_2,Char_0,Char_Space},					//[2] Item 2
			{80,Char_Space,Char_8,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[5] Shop_Items_3
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{90,Char_Space,Char_9,Char_0,Char_Space},					//[1] Item 1
			{100,Char_1,Char_0,Char_0,Char_Space},						//[2] Item 2
			{10,Char_Space,Char_1,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[6] Shop_Items_4
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{80,Char_Space,Char_8,Char_0,Char_Space},					//[1] Item 1
			{250,Char_2,Char_5,Char_0,Char_Space},						//[2] Item 2
			{60,Char_Space,Char_6,Char_0,Char_Space}					//[3] Item 3
		},
		{	//[7] Shop_Potion
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{40,Char_Space,Char_4,Char_0,Char_Space},					//[1] Item 1
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[2] Item 2
			{68,Char_Space,Char_6,Char_8,Char_Space}					//[3] Item 3
		},
		{	//[8] Shop_More_Bombs	
			{0,Char_Space,Char_Space,Char_X,Char_Space},			//[0] "0x"
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[1] Item 1
			{100,Char_Hyphen,Char_1,Char_0,Char_0},						//[2] Item 2
			{0,Char_Space,Char_Space,Char_Space,Char_Space}		//[3] Item 3
		},
		{	//[9] Shop_Free_10
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[0] "0x"
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[1] Item 1
			{-10,Char_Space,Char_1,Char_0,Char_Space},				//[2] Item 2
			{0,Char_Space,Char_Space,Char_Space,Char_Space}		//[3] Item 3
		},
		{	//[10] Shop_Free_30
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[0] "0x"
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[1] Item 1
			{-30,Char_Space,Char_3,Char_0,Char_Space},				//[2] Item 2
			{0,Char_Space,Char_Space,Char_Space,Char_Space}		//[3] Item 3
		},
		{	//[11] Shop_Free_100
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[0] "0x"
			{0,Char_Space,Char_Space,Char_Space,Char_Space},	//[1] Item 1
			{-100,Char_1,Char_0,Char_0,Char_Space},						//[2] Item 2
			{0,Char_Space,Char_Space,Char_Space,Char_Space}		//[3] Item 3
		},
	};
	
	//384
	static unsigned char Shop_From_World_Index[3][128]= {
		{	//[0] Overworld
			0,	//[0]
			Shop_Door_Repair,	//[1]
			0,	//[2]
			Shop_Door_Repair,	//[3]
			Shop_Potion,	//[4]
			0,	//[5]
			0,	//[6]
			Shop_Door_Repair,	//[7]
			0,	//[8]
			0,	//[9]
			Shop_White_Sword,	//[10]
			0,	//[11]
			Shop_Items_1,	//[12]
			Shop_Potion,	//[13]
			Shop_Letter,	//[14]
			Shop_Free_100,	//[15]
			Shop_Gamble,	//[16]
			0,	//[17]
			Shop_Items_2,	//[18]
			Shop_Free_30,	//[19]
			Shop_Door_Repair,	//[20]
			0,	//[21]
			Shop_Gamble,	//[22]
			0,	//[23]
			0,	//[24]
			0,	//[25]
			Shop_Waterfall_Pay_Talk,	//[26]
			0,	//[27]
			Shop_Hint_1,	//[28]
			Shop_Warp,	//[29]
			Shop_Door_Repair,	//[30]
			Shop_Gamble,	//[31]
			0,	//[32]
			Shop_Magical_Sword,	//[33]
			0,	//[34]
			Shop_Warp,	//[35]
			0,	//[36]
			Shop_Items_3,	//[37]
			Shop_Items_2,	//[38]
			Shop_Potion,	//[39]
			Shop_Free_30,	//[40]
			0,	//[41]
			0,	//[42]
			0,	//[43]
			Shop_Heart_Container,	//[44]
			Shop_Free_30,	//[45]
			0,	//[46]
			Shop_Heart_Container,	//[47]
			0,	//[48]
			0,	//[49]
			0,	//[50]
			Shop_Potion,	//[51]
			Shop_Items_4,	//[52]
			0,	//[53]
			0,	//[54]
			0,	//[55]
			0,	//[56]
			0,	//[57]
			0,	//[58]
			0,	//[59]
			0,	//[60]
			Shop_Free_30,	//[61]
			0,	//[62]
			0,	//[63]
			0,	//[64]
			0,	//[65]
			0,	//[66]
			0,	//[67]
			Shop_Items_3,	//[68]
			0,	//[69]
			Shop_Items_2,	//[70]
			Shop_Heart_Container,	//[71]
			Shop_Free_30,	//[72]
			Shop_Warp,	//[73]
			Shop_Items_3,	//[74]
			Shop_Potion,	//[75]
			0,	//[76]
			Shop_Items_2,	//[77]
			Shop_Free_10,	//[78]
			0,	//[79]
			0,	//[80]
			Shop_Free_10,	//[81]
			0,	//[82]
			0,	//[83]
			0,	//[84]
			0,	//[85]
			Shop_Free_10,	//[86]
			0,	//[87]
			0,	//[88]
			0,	//[89]
			0,	//[90]
			Shop_Free_10,	//[91]
			0,	//[92]
			0,	//[93]
			Shop_Items_1,	//[94]
			0,	//[95]
			0,	//[96]
			0,	//[97]
			Shop_Free_100,	//[98]
			Shop_Door_Repair,	//[99]
			Shop_Potion,	//[100]
			0,	//[101]
			Shop_Items_1,	//[102]
			Shop_Free_30,	//[103]
			Shop_Door_Repair,	//[104]
			0,	//[105]
			Shop_Door_Repair,	//[106]
			Shop_Free_100,	//[107]
			0,	//[108]
			0,	//[109]
			0,	//[110]
			Shop_Items_3,	//[111]
			Shop_Tree_Pay_Talk,	//[112]
			Shop_Free_30,	//[113]
			0,	//[114]
			0,	//[115]
			0,	//[116]
			Shop_Hint_2,	//[117]
			Shop_Gamble,	//[118]
			Shop_Wooden_Sword,	//[119]
			Shop_Potion,	//[120]
			Shop_Warp,	//[121]
			0,	//[122]
			Shop_Heart_Container,	//[123]
			Shop_Gamble,	//[124]
			Shop_Door_Repair,	//[125]
			0,	//[126]
			0		//[127]
		},
		{	//[1] Dungeon 1
			Shop_L4,	//[0]
			0,	//[1]
			0,	//[2]
			0,	//[3]
			0,	//[4]
			0,	//[5]
			0,	//[6]
			0,	//[7]
			0,	//[8]
			0,	//[9]
			0,	//[10]
			Shop_L6B,	//[11]
			0,	//[12]
			0,	//[13]
			0,	//[14]
			0,	//[15]
			0,	//[16]
			0,	//[17]
			0,	//[18]
			0,	//[19]
			0,	//[20]
			Shop_L5A,	//[21]
			0,	//[22]
			Shop_More_Bombs,	//[23]
			0,	//[24]
			0,	//[25]
			0,	//[26]
			0,	//[27]
			0,	//[28]
			0,	//[29]
			0,	//[30]
			Shop_L2,	//[31]
			0,	//[32]
			0,	//[33]
			0,	//[34]
			0,	//[35]
			0,	//[36]
			0,	//[37]
			0,	//[38]
			0,	//[39]
			0,	//[40]
			0,	//[41]
			0,	//[42]
			Shop_L3,	//[43]
			0,	//[44]
			0,	//[45]
			0,	//[46]
			0,	//[47]
			0,	//[48]
			0,	//[49]
			0,	//[50]
			0,	//[51]
			0,	//[52]
			0,	//[53]
			0,	//[54]
			0,	//[55]
			0,	//[56]
			0,	//[57]
			0,	//[58]
			0,	//[59]
			0,	//[60]
			0,	//[61]
			0,	//[62]
			0,	//[63]
			0,	//[64]
			Shop_L1,	//[65]
			0,	//[66]
			0,	//[67]
			0,	//[68]
			0,	//[69]
			0,	//[70]
			0,	//[71]
			0,	//[72]
			0,	//[73]
			0,	//[74]
			0,	//[75]
			0,	//[76]
			0,	//[77]
			0,	//[78]
			0,	//[79]
			0,	//[80]
			0,	//[81]
			0,	//[82]
			0,	//[83]
			0,	//[84]
			0,	//[85]
			0,	//[86]
			0,	//[87]
			0,	//[88]
			0,	//[89]
			0,	//[90]
			0,	//[91]
			0,	//[92]
			0,	//[93]
			0,	//[94]
			0,	//[95]
			0,	//[96]
			0,	//[97]
			0,	//[98]
			0,	//[99]
			0,	//[100]
			0,	//[101]
			0,	//[102]
			Shop_L5B,	//[103]
			0,	//[104]
			0,	//[105]
			Shop_L6A,	//[106]
			0,	//[107]
			0,	//[108]
			0,	//[109]
			0,	//[110]
			0,	//[111]
			0,	//[112]
			0,	//[113]
			0,	//[114]
			0,	//[115]
			0,	//[116]
			0,	//[117]
			0,	//[118]
			0,	//[119]
			0,	//[120]
			0,	//[121]
			0,	//[122]
			0,	//[123]
			0,	//[124]
			0,	//[125]
			0,	//[126]
			0		//[127]
		},
		{	//[2] Dungeon 2
			0,	//[0]
			0,	//[1]
			Shop_L9C,	//[2]
			0,	//[3]
			0,	//[4]
			0,	//[5]
			Shop_L9B,	//[6]
			0,	//[7]
			0,	//[8]
			0,	//[9]
			0,	//[10]
			0,	//[11]
			0,	//[12]
			0,	//[13]
			0,	//[14]
			0,	//[15]
			0,	//[16]
			0,	//[17]
			0,	//[18]
			0,	//[19]
			0,	//[20]
			0,	//[21]
			0,	//[22]
			0,	//[23]
			0,	//[24]
			0,	//[25]
			0,	//[26]
			0,	//[27]
			0,	//[28]
			0,	//[29]
			0,	//[30]
			0,	//[31]
			0,	//[32]
			0,	//[33]
			0,	//[34]
			0,	//[35]
			0,	//[36]
			0,	//[37]
			0,	//[38]
			0,	//[39]
			Shop_Hungry_Goriya,	//[40]
			0,	//[41]
			0,	//[42]
			0,	//[43]
			0,	//[44]
			0,	//[45]
			0,	//[46]
			0,	//[47]
			0,	//[48]
			0,	//[49]
			0,	//[50]
			0,	//[51]
			0,	//[52]
			0,	//[53]
			0,	//[54]
			0,	//[55]
			0,	//[56]
			0,	//[57]
			0,	//[58]
			Shop_L8A,	//[59]
			0,	//[60]
			Shop_L8B,	//[61]
			0,	//[62]
			0,	//[63]
			0,	//[64]
			0,	//[65]
			0,	//[66]
			Shop_L9D,	//[67]
			0,	//[68]
			0,	//[69]
			0,	//[70]
			0,	//[71]
			Shop_More_Bombs,	//[72]
			0,	//[73]
			0,	//[74]
			0,	//[75]
			0,	//[76]
			0,	//[77]
			0,	//[78]
			0,	//[79]
			0,	//[80]
			0,	//[81]
			0,	//[82]
			0,	//[83]
			0,	//[84]
			0,	//[85]
			0,	//[86]
			0,	//[87]
			0,	//[88]
			0,	//[89]
			0,	//[90]
			Shop_L7A,	//[91]
			0,	//[92]
			0,	//[93]
			0,	//[94]
			0,	//[95]
			0,	//[96]
			0,	//[97]
			0,	//[98]
			0,	//[99]
			0,	//[100]
			0,	//[101]
			Shop_L9A,	//[102]
			0,	//[103]
			0,	//[104]
			0,	//[105]
			0,	//[106]
			0,	//[107]
			0,	//[108]
			0,	//[109]
			0,	//[110]
			0,	//[111]
			0,	//[112]
			0,	//[113]
			0,	//[114]
			0,	//[115]
			0,	//[116]
			0,	//[117]
			0,	//[118]
			0,	//[119]
			0,	//[120]
			0,	//[121]
			0,	//[122]
			0,	//[123]
			0,	//[124]
			0,	//[125]
			0,	//[126]
			0		//[127]
		}
	};
	
	asm("\n.ascii \"UNPACK_1\""); 
}
