// C Header File
// Created 6/29/2003; 7:29:15 PM

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// DEFINITIONS

//Decompression constants
#define Save_Size				2+330+7
#define Data1_Size			4963+2
#define Data2_Size			58939+2 
#define Data3_Size			36089+2
#define DLL_preSize			15000
#define DLL_Size				DLL_preSize-70
#define Decomp_Screen_BW	0
#define Decomp_Screen_GS	1
#define Decomp_Screen_h		93
#define Decompress_None		0
#define Decompress_Data1	1
#define Decompress_Data2	2
#define Decompress_Data3	4
#define Decompress_DLL		8
#define Decompress_All		15
#define Retain_None				15
#define Retain_All				0

//Memory allocation constants
//#define Size_of_Default_Save								120
//#define Size_of_Save												120+2048
//#define Size_of_Save_File										3*Size_of_Save
#define Size_of_Save												120
#define Size_of_Save_File										3*Size_of_Save
#define Size_of_Oversized_Buffer						7020	//[240*(99+2*9)*2]/8	Must use 240 pixel width to synchronize with Gray_Planes
#define Size_of_Menu_Buffer									5940	//(240*99*2)/8	Must use 240 pixel width to synchronize with Gray_Planes
#define Size_of_Background_Buffer						5940	//(240*99*2)/8	Must use 240 pixel width to synchronize with Gray_Planes
#define Size_of_Screen_Buffer								3960	//(160*99*2)/8
#define Size_of_Submenu											750		//(240*25)/8
#define Size_of_D_Room_Properties						2048	//2*128*8
#define Size_of_Screen_Tiles_Buffer					176		//(Screen_w*Screen_h)
#define Size_of_Collision_Detection_Buffer	176		//(Screen_w*Screen_h)
#define Size_of_Item_Struct									5			//5b

//Plane constants
#define LG_Plane_BIN				(1<<0)	//LightGray
#define DG_Plane_BIN				(1<<1)	//DarkGray
#define LO_Plane_BIN				(1<<2)	//LightOversized
#define DO_Plane_BIN				(1<<3)	//DarkOversized
#define LM_Plane_BIN				(1<<4)	//LightMenu
#define DM_Plane_BIN				(1<<5)	//DarkMenu
#define LB_Plane_BIN				(1<<6)	//LightBackground
#define DB_Plane_BIN				(1<<7)	//DarkBackground
#define Gray_Planes_BIN			(1<<0)
#define OS_Planes_BIN				(1<<1)	//OverSized
#define Menu_Planes_BIN			(1<<2)	
#define BG_Planes_BIN				(1<<3)	//BackGround
#define Max_Plane_Freq			-28
#define Default_Plane_Freq	0

//Indexing constants for Character[46][27], which is used for printing
#define Char_A											0
#define Char_B											1
#define Char_C											2
#define Char_D											3
#define Char_E											4
#define Char_F											5
#define Char_G											6
#define Char_H											7
#define Char_I											8
#define Char_J											9
#define Char_K											10
#define Char_L											11
#define Char_M											12
#define Char_N											13
#define Char_O											14
#define Char_P											15
#define Char_Q											16
#define Char_R											17
#define Char_S											18
#define Char_T											19
#define Char_U											20
#define Char_V											21
#define Char_W											22
#define Char_X											23
#define Char_Y											24
#define Char_Z											25
#define Char_Hyphen									26
#define Char_Plus										27
#define Char_Comma									28
#define Char_Exclamation						29
#define Char_Apostrophe							30
#define Char_And										31
#define Char_Period									32
#define Char_0											33
#define Char_1											34
#define Char_2											35
#define Char_3											36
#define Char_4											37
#define Char_5											38
#define Char_6											39
#define Char_7											40
#define Char_8											41
#define Char_9											42
#define Char__											43
#define Char_Space									44
#define Char_Q_Mark									45
#define Char_Return									126
#define Char_End										127

//Time constants
#define APD_TimeLength									7680	//Wait 7680/256= 30 seconds before automatic power down
#define Default_Sprite_Interval					5			//Wait 5/256 seconds
#define Default_Projectile_Interval			2			//Wait 2/256 seconds
#define Default_Scroll_Interval					2			//Wait 2/256 seconds
#define Default_Adjust_Interval					25		//Wait 25/256 seconds

//Splash screen constants
#define LofZ_Triforce_x										55
#define LofZ_Triforce_y										12
#define LofZ_Triforce_h										45
#define LofZ_Waterfall_x									49
#define LofZ_Waterfall_y									75
#define LofZ_Waterfall_h									25								
#define LofZ_Froth_x											49
#define LofZ_Froth_y											75
#define LofZ_Froth_h											5

//Direction constants
#define UP																0
#define LEFT															1
#define DOWN															2
#define RIGHT															3
#define UP_DOWN														0
#define LEFT_RIGHT												1
#define NOWHERE														99

//Fixed distance contants
#define LCD_w															160
#define LCD_h															100
#define World_w														16		//Width in screens
#define World_h														8			//Height in screens
#define Screen_w													16		//Width in tiles
#define Screen_h													11		//Height in tiles
#define Sprite_w													10		//Width in pixels
#define Sprite_h													9			//Height in pixels
#define Screen_Index_Offset								World_Index_Offset

//Binary constants used with "_rowread(ROW)&KEY"
#define ARROWS_ROW	~(1<<0)
#define UP_KEY			1<<0
#define LEFT_KEY		1<<1
#define DOWN_KEY		1<<2
#define RIGHT_KEY		1<<3
#define SECOND_KEY	1<<4
#define SHIFT_KEY		1<<5
#define DIAMOND_KEY	1<<6
#define ALPHA_KEY		1<<7
#define F5_ROW			~(1<<1)
#define ENTER_KEY		1<<0
#define PLUS_KEY		1<<1
#define MINUS_KEY		1<<2
#define MULT_KEY		1<<3
#define DIV_KEY			1<<4
#define CARET_KEY		1<<5
#define CLEAR_KEY		1<<6
#define F5_KEY			1<<7
#define F4_ROW			~(1<<2)
#define NEG_KEY			1<<0
#define THREE_KEY		1<<1
#define SIX_KEY			1<<2
#define NINE_KEY		1<<3
#define COMMA_KEY		1<<4
#define T_KEY				1<<5
#define BKSPC_KEY		1<<6
#define F4_KEY			1<<7
#define F3_ROW			~(1<<3)
#define DECIMAL_KEY	1<<0
#define TWO_KEY			1<<1
#define FIVE_KEY		1<<2
#define EIGHT_KEY		1<<3
#define RB_KEY			1<<4
#define Z_KEY				1<<5
#define CTLG_KEY		1<<6
#define F3_KEY			1<<7
#define F2_ROW			~(1<<4)
#define ZERO_KEY		1<<0
#define ONE_KEY			1<<1
#define FOUR_KEY		1<<2
#define SEVEN_KEY		1<<3
#define LB_KEY			1<<4
#define Y_KEY				1<<5
#define MODE_KEY		1<<6
#define F2_KEY			1<<7
#define F1_ROW			~(1<<5)
#define APPS_KEY		1<<0
#define STO_KEY			1<<1
#define EE_KEY			1<<2
#define OR_KEY			1<<3
#define EQ_KEY			1<<4
#define X_KEY				1<<5
#define HOME_KEY		1<<6
#define F1_KEY			1<<7
#define ESC_ROW			~(1<<6)
#define ESC_KEY			1<<0

//Miscellaneous game constants
#define Static														0
#define Walking														1
#define Overworld													0
#define Dungeon_1													1
#define Dungeon_2													2
#define MenuScreen												0
#define GameScreen												1
#define Frames_Per_Animation							Sprite_w
#define LCD_CharWidth											30	//(240/8)
#define Screen_CharWidth									20	//(160/8)	
#define Overworld_BombWall								R_0		// =29
#define Overworld_BurnBush								Bush	// =33
#define Overworld_Ladder									0x80
#define PushBlock_Detectable							1
#define PushBlock_Pushed									2
#define Link_Slide												0
#define Link_Appear												1
#define Link_Hide													2
#define Lift_Item													4
#define Lift_Triforce											5

//Constants used for handling the in-game menu and submenu
#define Main_Menu																	0
#define Sub_Menu																	1
#define Action_Scroll_MainMenu										0
#define Action_Scroll_Submenu											1
#define Action_Scroll_From_MainMenu								2
#define Action_Scroll_From_SubMenu								3
#define Menu_w																		5		//Width In Tiles
#define Menu_Tile_h																99
#define SubMenu_h																	25
#define Triforce_Template_x												44
#define Triforce_Template_y												38
#define Triforce_Template_h												36
#define Menu_Map_x																11
#define Menu_Map_y																80
#define Menu_Map_h																17
#define Map_Compass_x															12
#define Map_Compass_y															48
#define Map_Icon_x																17
#define Map_Icon_y																56
#define Compass_Icon_x														52
#define Compass_Icon_y														56
#define Dungeon_Rough_Map_x												85
#define Dungeon_Rough_Map_y												40
#define Dungeon_Rough_Map_h												34
#define Level_String_x														9	
#define Level_String_y														76
#define Menu_Dungeon_Map_x												38
#define Menu_Dungeon_Map_y												82
#define Menu_Dungeon_Map_h												8		//Height in dungeon screens
#define Menu_Dungeon_Map_w												8		//Width in dungeon screens
#define Hearts_x																	109
#define Hearts_y																	91
#define First_Col																	92
#define Second_Col																105
#define Third_Col																	118
#define Fourth_Col																131
#define First_Row																	15
#define Second_Row																25
#define Row_Above_Box															2
#define Raft_x_MENU																88
#define Book_x																		101
#define Ring_x																		108
#define Ladder_x_MENU															115
#define Magic_Key_x																126
#define Bracelet_x																134
#define Triforce_1_x															64
#define Triforce_2_x															73
#define Triforce_3_x															55
#define Triforce_4_x															82
#define Triforce_5_x															64
#define Triforce_6_x															64
#define Triforce_7_x															73
#define Triforce_8_x															73
#define Triforce_1_y															44
#define Triforce_2_y															44
#define Triforce_3_y															53
#define Triforce_4_y															53
#define Triforce_5_y															53
#define Triforce_6_y															53
#define Triforce_7_y															53
#define Triforce_8_y															53
#define B_MainBox_x																33
#define B_MainBox_y																13
#define B_SubBox_x																79
#define B_SubBox_y																10
#define A_SubBox_x																94
#define A_SubBox_y																10
#define First_Cursor_Col													90
#define Second_Cursor_Col													103
#define Third_Cursor_Col													116
#define Fourth_Cursor_Col													129
#define First_Cursor_Row													15
#define Second_Cursor_Row													25
#define First_Cursor_Position											0
#define Second_Cursor_Position										1
#define Third_Cursor_Position											2
#define Fourth_Cursor_Position										3
#define Fifth_Cursor_Position											4
#define Sixth_Cursor_Position											5
#define Seventh_Cursor_Position										6
#define Eighth_Cursor_Position										7
#define First_Cursor_Slot													0x1		//1<<0
#define Second_Cursor_Slot												0x2		//1<<1
#define Third_Cursor_Slot													0x4		//1<<2
#define Fourth_Cursor_Slot												0x8		//1<<3
#define Fifth_Cursor_Slot													0x10	//1<<4
#define Sixth_Cursor_Slot													0x20	//1<<5
#define Seventh_Cursor_Slot												0x40	//1<<6
#define Eighth_Cursor_Slot												0x80	//1<<7
#define First_Weapon_Slot													0
#define Second_Weapon_Slot												1
#define Third_Weapon_Slot													2
#define Fourth_Weapon_Slot												3
#define Fifth_Weapon_Slot													4
#define Sixth_Weapon_Slot													5
#define Seventh_Weapon_Slot												6
#define Eighth_Weapon_Slot												7
#define Nineth_Weapon_Slot												8
#define Tenth_Weapon_Slot													9
#define Eleventh_Weapon_Slot											10
#define Twelveth_Weapon_Slot											11
#define Thirteenth_Weapon_Slot										12
#define Fourteenth_Weapon_Slot										13
#define Fifteenth_Weapon_Slot											14
#define Find_For_Weapon_Slot											0
#define Find_For_Cursor_Position									1

//Miscellaneous constants for Link's weapons
#define Small_Shield										0
#define Magical_Shield									1
#define Sword_w													8
#define Sword_h													8
#define Shard_w													5
#define Shard_h													6
#define Zeroth_Sword_Stage							0
#define First_Sword_Stage								1
#define Second_Sword_Stage							2
#define Third_Sword_Stage								3
#define Zeroth_Weapon_Release_Stage			0
#define First_Weapon_Release_Stage			1
#define Second_Weapon_Release_Stage			2
#define Boomerang_Type_Normal						0
#define Boomerang_Type_Magical					1
#define Boomerang_Released							1
#define Boomerang_Returning							2
#define Frames_Per_Boomerang_Animation	6
#define Boomerang_Factor								2
#define North														0
#define North_West											1
#define West														2
#define South_West											3
#define South														4
#define South_East											5
#define East														6
#define North_East											7
#define North_BIN												0x01	//0b0001
#define North_West_BIN									0x03	//0b0011
#define West_BIN												0x02	//0b0010
#define South_West_BIN									0x06	//0b0110
#define South_BIN												0x04	//0b0100
#define South_East_BIN									0x0C	//0b1100
#define East_BIN												0x08	//0b1000
#define North_East_BIN									0x09	//0b1001
#define First_Scaled_Tan_Ratio					53	//=TAN(22.5)<<7
#define Second_Scaled_Tan_Ratio					309	//=TAN(67.5)<<7
#define Boomerang_w											6
#define Boomerang_h											5
#define Zeroth_Bomb_Stage								0
#define First_Bomb_Stage								1
#define Second_Bomb_Stage								2
#define Third_Bomb_Stage								3
#define Fourth_Bomb_Stage								4
#define Fifth_Bomb_Stage								5
#define First_Bomb											0
#define Second_Bomb											1
#define First_Bomb_BIN									0x1
#define Second_Bomb_BIN									0x2
#define Both_Bombs_BIN									0x3
#define Arrow_Type_Wooden								0
#define Arrow_Type_Silver								1
#define Arrow_w													8
#define Arrow_h													8
#define First_Candle										0x1
#define Second_Candle										0x2
#define Both_Candles										0x3
#define First_Flame											0
#define Second_Flame										1
#define Default_Candle_Factor						8
#define Tornado_Factor									2
#define Zeroth_Tornado_Stage						0
#define First_Tornado_Stage							1
#define Second_Tornado_Stage						2
#define Level_1_Warp_Position						0
#define Level_8_Warp_Position						7
#define Not_Using_Potion								0
#define Using_Potion										1
#define Wand_w													8
#define Wand_h													8
#define WandWave_w											10
#define WandWave_h											9

//Indexing constants for Sword[4][2][4][3][9], Graphics16[62][27] and Triforces[8][2][27]
#define Full_Sword					0
#define Half_Sword					1
#define Wooden_Sword				0		//Weapon #0
#define White_Sword					1		//Weapon #1
#define Magical_Sword				2		//Weapon #2
#define Sword_Wand					3		//(for unsigned short Swords[Sword_Wand][2][4][3][9])
#define Normal_Boomerang		3		//Weapon #3
#define Magical_Boomerang		4		//Weapon #4
#define Bomb_1							5		//Weapon #5
#define Bomb_2							6
#define Wooden_Arrow				7		//Weapon #6
#define Silver_Arrow				8		//Weapon #7
#define Bow									9		//Weapon #8
#define Blue_Candle					10	//Weapon #9
#define Red_Candle					11	//Weapon #10
#define Recorder						12	//Weapon #11
#define Meat_1							13	//Weapon #12
#define Meat_2							14
#define Letter							15	//Weapon #13
#define Blue_Potion					16	//Weapon #14
#define Red_Potion					17	//Weapon #15
#define Magic_Wand					18	//Weapon #16	(for unsigned short Graphics16[Magic_Wand])
#define Raft_1							19	//Weapon #17
#define Raft_2							20
#define Magical_Book				21	//Weapon #18
#define Blue_Ring						22	//Weapon #19
#define Red_Ring						23	//Weapon #20
#define Ladder_1						24	//Weapon #21
#define Ladder_2						25
#define Magical_Key					26	//Weapon #22
#define Power_Bracelet			27	//Weapon #23
#define Menu_Weap8_Blank		28
#define Menu_Weap9_Blank		29
#define Black_Cursor				30
#define White_Cursor				31
#define Cloud_Full					32
#define Cloud_Half					33
#define Fire								34
#define Shop_Fire						36
#define Tornado							38
#define WandWave						39
#define Shield							43
#define Heart_Empty					44
#define Heart_Light					45
#define Heart_Full					46
#define Heart_Half					47
#define Heart_None					48
#define Hrt_Cntnr						49
#define Fairy_1							50
#define Fairy_2							51
#define Clock								52
#define Rupy_Light					53
#define Rupy_Dark						54
#define Rupy_Black					55
#define D_Key								56
#define Map									57
#define Dark_Map						58
#define Compass							59
#define Dark_Compass				60
#define Triforce_Light			61
#define Triforce_Dark				62
#define Shop_Stair					63
#define Shopkpr_Wizard			64
#define Shopkpr_Fat_Man			65
#define Shopkpr_Old_Woman		66
#define Shopkpr_Goriya			67
#define Enemy_Invisible			68
#define LeeverLight_Half		69
#define LeeverDark_Half			70
#define Leever_Hole_1				71
#define Leever_Hole_2				72
#define OctorokRock_GFX			73
#define ZolaFire_GFX				74
#define No_Shop_Item				255
#define Triforce_One				0		//Weapon #24
#define Triforce_Two				1		//Weapon #25
#define Triforce_Three			2		//Weapon #26
#define Triforce_Four				3		//Weapon #27
#define Triforce_Five				4		//Weapon #28
#define Triforce_Six				5		//Weapon #29
#define Triforce_Seven			6		//Weapon #30
#define Triforce_Eight			7		//Weapon #31

//Binary constants used to flag the possession of a weapon on or off within "unsigned long Weapons_Possessed"
#define Wooden_Sword_BIN				0x1					//1<<0
#define White_Sword_BIN					0x2					//1<<1
#define Magical_Sword_BIN				0x4					//1<<2
#define Boomerang_BIN						0x8					//1<<3
#define Magical_Boomerang_BIN		0x10				//1<<4
#define Boomerangs_BIN					0x18				//(1<<3) | (1<<4)
#define Bomb_BIN								0x20				//1<<5
#define Arrow_BIN								0x40				//1<<6
#define Silver_Arrow_BIN				0x80				//1<<7
#define Arrows_BIN							0xC0				//(1<<6) | (1<<7)
#define Bow_BIN									0x100				//1<<8
#define Blue_Candle_BIN					0x200				//1<<9
#define Red_Candle_BIN					0x400				//1<<10
#define Candles_BIN							0x600				//(1<<9) | (1<<10)
#define Recorder_BIN						0x800				//1<<11
#define Meat_BIN								0x1000			//1<<12
#define Letter_BIN							0x2000			//1<<13
#define Blue_Potion_BIN					0x4000			//1<<14
#define Red_Potion_BIN					0x8000			//1<<15
#define Potions_BIN							0xE000			//(1<<13) | (1<<14) | (1<<15)
#define Magical_Wand_BIN				0x10000			//1<<16
#define Raft_BIN								0x20000			//1<<17
#define Magical_Book_BIN				0x40000			//1<<18
#define Blue_Ring_BIN						0x80000			//1<<19
#define Red_Ring_BIN						0x100000		//1<<20
#define Ladder_BIN							0x200000		//1<<21
#define Magical_Key_BIN					0x400000		//1<<22
#define Power_Bracelet_BIN			0x800000		//1<<23
#define Triforce_1_BIN					0x1000000		//1<<24
#define Triforce_2_BIN					0x2000000		//1<<25
#define Triforce_3_BIN					0x4000000		//1<<26
#define Triforce_4_BIN					0x8000000		//1<<27
#define Triforce_5_BIN					0x10000000	//1<<28
#define Triforce_6_BIN					0x20000000	//1<<29
#define Triforce_7_BIN					0x40000000	//1<<30
#define Triforce_8_BIN					0x80000000	//1<<31
#define Triforces_BIN						0xFF000000

//Dungeon constants
#define L_0											0				//Level 0
#define L_1											1				//Level 1
#define L_2											2				//Level 2
#define L_3											3				//Level 3
#define L_4											4				//Level 4
#define L_5											5				//Level 5
#define L_6											6				//Level 6
#define L_7											7				//Level 7
#define L_8											8				//Level 8
#define L_9											9				//Level 9
#define DD_Kill									0				//Kill Enemies To Open (DD=Dungeon Door)
#define DD_Push									1				//Push Block To Open (DD=Dungeon Door)
#define DD_LOut									2				//Always Locks Link Out (DD=Dungeon Door)
#define DD_Lock									3				//Door Requires Key (DD=Dungeon Door)
#define DD_Open									4				//Normal Door (DD=Dungeon Door)
#define DD_Bomb									5				//Break Wall With Bomb (DD=Dungeon Door)
#define DD_Wall									6				//Unbreakable Wall (DD=Dungeon Door)
#define DD_Walk									7				//Walkthrough (DD=Dungeon Door)
#define DI_Rupies								254			//A Group Of Rupies Is Located Here (DI=Dungeon Item)
#define DI_Power								255			//The Triforce Of Power Is Located Here (DI=Dungeon Item)
#define Auto_Appear							0x80		//The Item Appears Before Killing All Enemies
#define D_Dark_Room							0x40		//Room Needs To Be Lit With Candle
#define Lights_On								0
#define Lights_Off							1
#define Turning_Lights_On				2
#define Screen_Luminosity				0x01
#define Battle_Area_Luminosity	0x02
#define Synchronize_OpenDoors		0x04
#define Finished_Unlock					0
#define Unlock_North_Door				1
#define Unlock_West_Door				2
#define Unlock_South_Door				3
#define Unlock_East_Door				4
#define L7_Lake									66
#define Dungeon_Underpass				254	//Screen_Map_Special[1]
#define Treasure_Room						253	//Screen_Map_Special[2]

//Item Constants
#define Item_Wooden_Sword			0
#define Item_White_Sword 			1
#define Item_Magical_Sword		2
#define Item_Boomerang				3
#define Item_Magic_Boomerang	4
#define Item_Bomb							5
#define Item_Wooden_Arrow			6
#define Item_Silver_Arrow			7
#define Item_Bow							8
#define Item_Blue_Candle			9
#define Item_Red_Candle				10
#define Item_Recorder					11
#define Item_Meat							12
#define Item_Letter						13
#define Item_Blue_Potion			14
#define Item_Red_Potion				15
#define Item_Wand							16
#define Item_Raft							17
#define Item_Book							18
#define Item_Blue_Ring				19
#define Item_Red_Ring					20
#define Item_Ladder						21
#define Item_Magical_Key			22
#define Item_Bracelet					23
#define Item_Hrt_Cntnr_Add		24
#define Item_Hrt_Cntnr_Sub		25
#define Item_Heart 						26	//Can pick up with sword
#define Item_Fairy						27	//Can pick up with sword
#define Item_Clock						28	//Can pick up with sword
#define Item_Rupy							29	//Can pick up with sword
#define Item_5xRupy						30	//Can pick up with sword
#define Item_Black_Bomb				31	//Can pick up with sword
#define Item_Key							32
#define Item_Map							33
#define Item_Compass					34
#define Item_Triforce					35
#define Item_More_Bombs				36
#define Item_Magical_Shield		37
#define Item_Warp							38
#define Item_Not_Present			39

//Shop Constants
#define Shop_Room											255	//Screen_Map_Special[0]
#define Just_Entered_Shop							1
#define Shop_Active										2
#define Shop_Inactive									3
#define Terminate_Flash_Submenu				0
#define Initialize_Flash_Submenu			1
#define Pause_Flash_Submenu						2
#define Flash_Submenu_Active					3
#define Lose_10												0
#define Lose_40												1
#define Win__20												2
#define Win__50												3
#define Shopkeeper										3
#define Shop_Text											4
#define Beach_Warp_World_Index				121
#define Fairy_Warp_World_Index				73
#define L5_Warp_World_Index						29
#define L6_Warp_World_Index						35
#define Shop_Gamble										0		//Flash submenu.
#define Shop_Waterfall_Pay_Talk				1		//Flash submenu.
#define Shop_Tree_Pay_Talk						2		//Flash submenu.
#define Shop_Items_1									3		//Flash submenu. Flicker Shopkeeper. Lift item.
#define Shop_Items_2									4		//Flash submenu. Flicker Shopkeeper. Lift item.
#define Shop_Items_3									5		//Flash submenu. Flicker Shopkeeper. Lift item.
#define Shop_Items_4									6		//Flash submenu. Flicker Shopkeeper. Lift item.
#define Shop_Potion										7		//Flash submenu. Flicker Shopkeeper. Lift item.
#define Shop_More_Bombs								8		//Flash submenu. Flicker Shopkeeper. One-time shop. Last shop with "0x" flashing rupy icon.
#define Shop_Free_10									9		//Flash submenu. One-time shop.
#define Shop_Free_30									10	//Flash submenu. One-time shop.
#define Shop_Free_100									11	//Flash submenu. One-time shop. Last shop with printed prices. 
#define Shop_Door_Repair							12	//Manual flash submenu. One-time shop.
#define Shop_Hungry_Goriya						13	//One-time shop. Flicker Shopkeeper. 
#define Shop_Wooden_Sword							14	//One-time shop. Flicker Shopkeeper. Lift item. 
#define Shop_White_Sword							15	//One-time shop. Flicker Shopkeeper. Lift item.
#define Shop_Magical_Sword						16	//One-time shop. Flicker Shopkeeper. Lift item. 
#define Shop_Heart_Container					17	//One-time shop. Flicker Shopkeeper. Lift item. 
#define Shop_Letter										18	//One-time shop. Flicker Shopkeeper. Lift item. 
#define Shop_Warp											19
#define Shop_Hint_1										20
#define Shop_Hint_2										21
#define Shop_L1												22
#define Shop_L2												23
#define Shop_L3												24
#define Shop_L4												25
#define Shop_L5A											26
#define Shop_L5B											27
#define Shop_L6A											28
#define Shop_L6B											29
#define Shop_L7A											30
#define Shop_L8A											31
#define Shop_L8B											32
#define Shop_L9A											33
#define Shop_L9B											34
#define Shop_L9C											35
#define Shop_L9D											36
#define Shop_Text_Items_1_2						0
#define Shop_Text_Items_3_4						1
#define Shop_Text_Potion							2
#define Shop_Text_Gamble							3
#define Shop_Text_Free_10_30_100			4
#define Shop_Text_Door_Repair					5
#define Shop_Text_Pay_Talk						6
#define Shop_Text_More_Bombs					7
#define Shop_Text_Wooden_Sword				8
#define Shop_Text_Better_Sword				9
#define Shop_Text_Heart_Container			10
#define Shop_Text_Warp								11
#define Shop_Text_Letter							12
#define Shop_Text_Hint_1							13
#define Shop_Text_Hint_2							14
#define Shop_Text_Poor								15
#define Shop_Text_Rich								16
#define Shop_Text_Forest_Maze					17
#define Shop_Text_Mountain_Maze				18
#define Shop_Text_Hungry_Goriya				19
#define Shop_Text_L1									20
#define Shop_Text_L2									21
#define Shop_Text_L3									22
#define Shop_Text_L4									23
#define Shop_Text_L5A									24
#define Shop_Text_L5B									25
#define Shop_Text_L6A									26
#define Shop_Text_L6B									27
#define Shop_Text_L7A									28
#define Shop_Text_L8A									29
#define Shop_Text_L8B									30
#define Shop_Text_L9A									31
#define Shop_Text_L9B									32
#define Shop_Text_L9C									33
#define Shop_Text_L9D									34

//Enemy constants
#define OctorokLight				0	//Beginning of 4D enemies
#define OctorokDark					1
#define MolblinLight				2
#define MolblinDark					3
#define LynelLight					4
#define LynelDark						5
#define GoriyaLight					6
#define GoriyaDark					7
#define DarknutLight				8
#define DarknutDark					9
#define Hand								10
#define WizzrobeLight				11
#define WizzrobeDark				12
#define Ghost								13
#define Armos								14
#define SnakeLight					15
#define SnakeDark						16	//End of 4D enemies
#define SpiderLight					17	//Beginning of 1D enemies
#define SpiderDark					18
#define LeeverLight					19
#define LeeverDark					20
#define Peahat							21
#define Zola								22
#define Rock								23
#define Stalfos							24
#define Zol									25
#define Gel									26
#define Vire								27
#define Bat									28
#define Bunny								29
#define Likelike						30
#define Mummy								31
#define BigPatra						32
#define Patra								33
#define SunFlash						34
#define SunLight						35
#define SunDark							36
#define Gate								37
#define GleeokHead					38
#define Digdog							39	//End of 1D enemies
#define Enemy_Dead					255
#define Boomerang_Kill			0x1
#define Arrow_Kill					0x2
#define Bat_Split						0x4
#define Spider_Jump					0
#define PeahatFly						1		//Stops periodically
#define Fly									2
#define VireBunny_Hop				3
#define Wizzrobe_Glide			4
#define On_Land							5
#define Zola_Water					6		//Unique birth location
#define LeeverLight_Dive		7		//Unique birth location
#define LeeverDark_Dive			8		//Unique birth location
#define Rock_Fall						9		//Unique birth location
#define Hand_Creep					10	//Unique birth location
#define Wizzrobe_Teleport		11	//Unique birth location
#define Patra_Revolve				12	//Unique birth location
#define Gate_Glide					13	//Possibly exclude from normal enemy algorithm
#define Statue_Frozen				14	//Possibly exclude from normal enemy algorithm
#define Enemy_Rock					1
#define Enemy_Fire					2
#define Enemy_Arrow					3
#define Enemy_Boomerang			4
#define Enemy_Sword					5
#define Enemy_Wave					6
#define Enemy_Appearing			0	//Full Bomb_Cloud
#define Enemy_Breaking			1	//Half Bomb_Cloud
#define Enemy_Stop					2
#define Enemy_Move					3
#define Enemy_ShootProj			4
#define Enemy_SpeedUp				5
#define Enemy_SlowDown			6
#define Enemy_Jump					7
#define Enemy_Emerging			8
#define Enemy_Submerging		9
#define Enemy_Submerged			10
#define Enemy_Hop						11
#define Enemy_Fly						12
#define Enemy_Meander				0
#define Enemy_Attack				1
#define Enemy_Evade					2
#define No_Projectile				0
#define OctorokRock					1
#define MolblinArrow				2
#define LynelSword					3
#define ZolaFire						4


//Indexing constants for Map_Tiles[191][18], which have been made useful for Collisiion_Detection() as well
#define Null				0		//Fully Walkable
#define Cave				1		//Fully Walkable
#define Sand				2		//Fully Walkable
#define Dock				3		//Fully Walkable
#define Ladder			4		//Fully Walkable
#define Ladder_RIP	5		//Fully Walkable
#define Dark				6		//Fully Walkable
#define Stair				7		//Fully Walkable
#define W_0_D				8		//Fully Walkable
#define W_N_D				9		//Fully Walkable
#define W_W_D				10	//Fully Walkable
#define W_S_D				11	//Fully Walkable
#define W_E_D				12	//Fully Walkable
#define W_NW_D			13	//Fully Walkable
#define W_SW_D			14	//Fully Walkable
#define W_SE_D			15	//Fully Walkable
#define W_NE_D			16	//Fully Walkable
#define W_NE_I			17	//Fully Walkable
#define W_NW_I			18	//Fully Walkable
#define W_SE_I			19	//Fully Walkable
#define W_SW_I			20	//Fully Walkable
#define L_D					21	//Fully Walkable
#define D_Sand			22	//Fully Walkable
#define D_Tile			23	//Fully Walkable
#define E_4_D				24	//Fully Walkable
#define EE_5_D			25	//Fully Walkable
#define W_4_D				26	//Fully Walkable
#define WW_5_D			27	//Fully Walkable
#define D_W					28	//Fully Non-Walkable
#define R_0					29	//Fully Non-Walkable
#define R_N					30	//Fully Non-Walkable
#define R_N_C				31	//Fully Non-Walkable
#define Snail				32	//Fully Non-Walkable
#define Bush				33	//Fully Non-Walkable
#define W_0					34	//Fully Non-Walkable
#define W_N					35	//Fully Non-Walkable
#define W_W					36	//Fully Non-Walkable
#define W_S					37	//Fully Non-Walkable
#define W_E					38	//Fully Non-Walkable
#define W_SW				39	//Fully Non-Walkable
#define W_SE				40	//Fully Non-Walkable
#define W_F					41	//Fully Non-Walkable
#define T_N					42	//Fully Non-Walkable
#define T_NW				43	//Fully Non-Walkable
#define T_SE				44	//Fully Non-Walkable
#define Guard				45	//Fully Non-Walkable
#define D_N					46	//Fully Non-Walkable
#define D_SW				47	//Fully Non-Walkable
#define D_SE				48	//Fully Non-Walkable
#define R_0_RIP			49	//Fully Non-Walkable
#define R_N_RIP			50	//Fully Non-Walkable
#define Bush_RIP		51	//Fully Non-Walkable
#define RIP					52	//Fully Non-Walkable
#define Guard_RIP		53	//Fully Non-Walkable
#define D_N_RIP			54	//Fully Non-Walkable
#define D_SW_RIP		55	//Fully Non-Walkable
#define D_SE_RIP		56	//Fully Non-Walkable
#define Block				57	//Fully Non-Walkable
#define BW_SE				58	//Fully Non-Walkable
#define BW_W				59	//Fully Non-Walkable
#define BW_SW				60	//Fully Non-Walkable
#define BW_E				61	//Fully Non-Walkable
#define BR_1				62	//Fully Non-Walkable
#define BR_2				63	//Fully Non-Walkable
#define E_1					64	//Fully Non-Walkable
#define E_2					65	//Fully Non-Walkable
#define E_4					66	//Fully Non-Walkable
#define E_4_DC			67	//Fully Non-Walkable
#define E_4_DL			68	//Fully Non-Walkable
#define E_5					69	//Fully Non-Walkable
#define E_5_D				70	//Fully Non-Walkable
#define E_5_DCL			71	//Fully Non-Walkable
#define E_6					72	//Fully Non-Walkable
#define E_7					73	//Fully Non-Walkable
#define EE_1				74	//Fully Non-Walkable
#define EE_2				75	//Fully Non-Walkable
#define EE_3				76	//Fully Non-Walkable
#define EE_4				77	//Fully Non-Walkable
#define EE_6				78	//Fully Non-Walkable
#define EE_6_D			79	//Fully Non-Walkable
#define EE_7				80	//Fully Non-Walkable
#define H_C					81	//Fully Non-Walkable
#define H_O					82	//Fully Non-Walkable
#define NE_C				83	//Fully Non-Walkable
#define NENE_C			84	//Fully Non-Walkable
#define NN_1				85	//Fully Non-Walkable
#define NN_2				86	//Fully Non-Walkable
#define NN_3				87	//Fully Non-Walkable
#define NN_5				88	//Fully Non-Walkable
#define NN_6				89	//Fully Non-Walkable
#define NN_9				90	//Fully Non-Walkable
#define NN_10				91	//Fully Non-Walkable
#define NN_13				92	//Fully Non-Walkable
#define NN_14				93	//Fully Non-Walkable
#define NW_C				94	//Fully Non-Walkable
#define NWNW_C			95	//Fully Non-Walkable
#define S_1					96	//Fully Non-Walkable
#define S_2					97	//Fully Non-Walkable
#define S_3					98	//Fully Non-Walkable
#define S_4					99	//Fully Non-Walkable
#define S_5					100	//Fully Non-Walkable
#define S_6					101	//Fully Non-Walkable
#define S_6_DC			102	//Fully Non-Walkable
#define S_6_DL			103	//Fully Non-Walkable
#define S_7_DC			104	//Fully Non-Walkable
#define S_7_DL			105	//Fully Non-Walkable
#define S_8					106	//Fully Non-Walkable
#define S_9					107	//Fully Non-Walkable
#define S_10				108	//Fully Non-Walkable
#define S_11				109	//Fully Non-Walkable
#define S_12				110	//Fully Non-Walkable
#define SE_C				111	//Fully Non-Walkable
#define SESE_C			112	//Fully Non-Walkable
#define SS_1				113	//Fully Non-Walkable
#define SS_2				114	//Fully Non-Walkable
#define SS_3				115	//Fully Non-Walkable
#define SS_5				116	//Fully Non-Walkable
#define SS_6				117	//Fully Non-Walkable
#define SS_9				118	//Fully Non-Walkable
#define SS_10				119	//Fully Non-Walkable
#define SS_13				120	//Fully Non-Walkable
#define SS_14				121	//Fully Non-Walkable
#define SW_C				122	//Fully Non-Walkable
#define SWSW_C			123	//Fully Non-Walkable
#define W_1					124	//Fully Non-Walkable
#define W_2					125	//Fully Non-Walkable
#define W_4					126	//Fully Non-Walkable
#define W_4_DC			127	//Fully Non-Walkable
#define W_4_DL			128	//Fully Non-Walkable
#define W_5					129	//Fully Non-Walkable
#define W_5_D				130	//Fully Non-Walkable
#define W_5_DCL			131	//Fully Non-Walkable
#define W_6					132	//Fully Non-Walkable
#define W_7					133	//Fully Non-Walkable
#define WW_1				134	//Fully Non-Walkable
#define WW_2				135	//Fully Non-Walkable
#define WW_3				136	//Fully Non-Walkable
#define WW_4				137	//Fully Non-Walkable
#define WW_6				138	//Fully Non-Walkable
#define WW_6_D			139	//Fully Non-Walkable
#define WW_7				140	//Fully Non-Walkable
#define R_NW				141	//Special- Type I
#define R_NW_RIP		142	//Special- Type I
#define W_NW				143	//Special- Type I
#define D_NW				144	//Special- Type I
#define D_NW_RIP		145	//Special- Type I
#define R_SW				146	//Special- Type II
#define R_SW_RIP		147	//Special- Type II
#define R_SE				148	//Special- Type III
#define R_SE_RIP		149	//Special- Type III
#define R_NE				150	//Special- Type IV
#define R_NE_RIP		151	//Special- Type IV
#define W_NE				152	//Special- Type IV
#define D_NE				153	//Special- Type IV
#define D_NE_RIP		154	//Special- Type IV
#define BW_NW				155	//Special- Type V
#define BW_NE				156	//Special- Type V
#define E_3					157	//Special- Type V
#define E_3_D				158	//Special- Type V
#define E_3_DCL			159	//Special- Type V
#define EE_4_D			160	//Special- Type V
#define N_1					161	//Special- Type V
#define N_2					162	//Special- Type V
#define N_3					163	//Special- Type V
#define N_4					164	//Special- Type V
#define N_5					165	//Special- Type V
#define N_6					166	//Special- Type V
#define N_6_DC			167	//Special- Type V
#define N_6_DL			168	//Special- Type V
#define N_7_DC			169	//Special- Type V
#define N_7_DL			170	//Special- Type V
#define N_8					171	//Special- Type V
#define N_9					172	//Special- Type V
#define N_10				173	//Special- Type V
#define N_11				174	//Special- Type V
#define N_12				175	//Special- Type V
#define W_3					176	//Special- Type V
#define W_3_D				177	//Special- Type V
#define W_3_DCL			178	//Special- Type V
#define WW_4_D			179	//Special- Type V
#define N_6_D				180	//Special- Type VI
#define NN_7_D			181	//Special- Type VI
#define S_6_D				182	//Special- Type VI
#define SS_7_D			183	//Special- Type VI
#define N_7_D				184	//Special- Type VII
#define NN_8_D			185	//Special- Type VII
#define S_7_D				186	//Special- Type VII
#define SS_8_D			187	//Special- Type VII
#define T_SW				188	//Unique I
#define T_NE				189	//Unique II
#define HALF_S			190	//Unique III (Only for Collision_Detection)
#define Stair_G			190	//Fully Walkable

//DLL indexing constants for a more automated DLL environment
#define FXN_FastCopyScreen_M									0
#define FXN_Install_Planes										FXN_FastCopyScreen_M+1
#define FXN_Update_Vars												FXN_Install_Planes+1
#define FXN_Draw_Screen												FXN_Update_Vars+1
#define FXN_Scroll_Screen											FXN_Draw_Screen+1
#define FXN_Collision_Detected								FXN_Scroll_Screen+1
#define FXN_Open_Curtains											FXN_Collision_Detected+1
#define FXN_Cover_Undiscovered_Pathways				FXN_Open_Curtains+1

#define FXN_Arrow_Key_CleanUp									FXN_Cover_Undiscovered_Pathways+1
#define FXN_Slide_Link												FXN_Arrow_Key_CleanUp+1

#define FXN_Update_Menu_SubTemplates					FXN_Slide_Link+1
#define FXN_Store_Current_Screen							FXN_Update_Menu_SubTemplates+1
#define FXN_Scroll_Menu												FXN_Store_Current_Screen+1
#define FXN_Find_Best_Weapon									FXN_Scroll_Menu+1
#define FXN_Update_Menu_Weapons								FXN_Find_Best_Weapon+1
#define FXN_Blink_Cursor											FXN_Update_Menu_Weapons+1
#define FXN_Move_Cursor_Position							FXN_Blink_Cursor+1
#define FXN_Find_Best_Sword										FXN_Move_Cursor_Position+1
#define FXN_Update_B_Box											FXN_Find_Best_Sword+1
#define FXN_Update_Triforces									FXN_Update_B_Box+1
#define FXN_Update_Hearts											FXN_Update_Triforces+1
#define FXN_Update_Countable_Items						FXN_Update_Hearts+1

#define FXN_Within_Boundaries									FXN_Update_Countable_Items+1
#define FXN_Replenish_Sword_Shards_Background	FXN_Within_Boundaries+1
#define FXN_Draw_Sword_Shards									FXN_Replenish_Sword_Shards_Background+1
#define FXN_Find_Relative_Direction						FXN_Draw_Sword_Shards+1
#define FXN_Replenish_Bomb_Cloud_Background		FXN_Find_Relative_Direction+1
#define FXN_Replenish_Bomb_Cloud_Background		FXN_Find_Relative_Direction+1
#define FXN_Draw_Bomb_Cloud										FXN_Replenish_Bomb_Cloud_Background+1

#define FXN_Define_D_Door_Tiles								FXN_Draw_Bomb_Cloud+1
#define FXN_Update_Doors											FXN_Define_D_Door_Tiles+1
#define FXN_Darken_Room												FXN_Update_Doors+1

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// FUNCTION DEFINITIONS

#define OSContrastValue *({unsigned char* __addr; asm volatile ("moveq #4,%%d0; trap #9; move.l %%a0,%0": "=a"(__addr):: "d0","a0"); __addr; })
#define Replenish_Curtain_BG							Replenish_BG_16	//Only in DLL
#define Replenish_Link_BG									Replenish_BG_16
#define Replenish_Sword_BG								Replenish_BG_16
#define Replenish_Shooting_Sword_BG				Replenish_BG_16
#define Replenish_A_Sword_Shard_BG				Replenish_BG_16
#define Replenish_Boomerang_BG						Replenish_BG_16
#define Replenish_Bomb_BG									Replenish_BG_16
#define Replenish_Cloud_BG								Replenish_BG_16
#define Replenish_Arrow_BG								Replenish_BG_16
#define Replenish_Candle_BG								Replenish_BG_16
#define Replenish_Tornado_BG							Replenish_BG_16
#define Replenish_Meat_BG									Replenish_BG_16
#define Replenish_Wand_BG									Replenish_BG_16
#define Replenish_WandWave_BG							Replenish_BG_16
#define Replenish_Raft_BG									Replenish_BG_16
#define Replenish_Ladder_BG								Replenish_BG_16
#define Replenish_PushBlock_BG						Replenish_BG_16
#define Replenish_Tile_BG									Replenish_BG_16
#define Replenish_Item_BG									Replenish_BG_16
#define Replenish_Shopkeeper_BG						Replenish_BG_16
#define Replenish_Enemy_BG								Replenish_BG_16
#define Replenish_EnemyProj_BG						Replenish_BG_16

#define Clear_Tile_On_StartMenu						Sprite16_AND_Mh
#define Draw_Part_Of_Menu_Map							Sprite16_AND_Mh	//Only in DLL
#define Draw_Part_Of_The_BombShock				Sprite16_AND_Mh
#define Draw_Part_Of_Dungeon_Map					Sprite16_AND_Mh	//Only in DLL
#define Clear_Cursor											Sprite16_OR_Mh
#define Draw_Curtain											Sprite16_OR_Mh
#define Reset_Menu_Center_Area						Sprite16_OR_Mh
#define Reset_Menu_Map_Area								Sprite16_OR_Mh
#define Draw_Part_Of_Dungeon_Rough_Map		Sprite16_OR_Mh
#define Darken_Doorway										Sprite16_OR_Mh
#define Modify_Part_Of_Room_Luminosity		Sprite16_OR_Mh
#define Clear_Shop_Text										Sprite16_OR_Mh
#define Clear_Shopkeeper									Sprite16_OR_Mh
#define Clear_Shop_Prices									Sprite16_OR_Mh
#define Clear_Shop												Sprite16_OR_Mh

#define Print_Character										GraySprite16_MASK_M
#define Draw_Link													GraySprite16_MASK_M
#define Draw_Sword												GraySprite16_MASK_M
#define Draw_Shooting_Sword								GraySprite16_MASK_M
#define Draw_A_Sword_Shard								GraySprite16_MASK_M	//Only in DLL
#define Draw_Menu_Weapon									GraySprite16_MASK_M
#define Clear_Menu_Weapon									GraySprite16_MASK_M
#define Draw_Triforce											GraySprite16_MASK_M //Only in DLL
#define Update_A_Box											GraySprite16_MASK_M
#define Draw_Menu_Cursor									GraySprite16_MASK_M
#define Draw_B_Box_Weapon									GraySprite16_MASK_M
#define Draw_A_Heart											GraySprite16_MASK_M
#define Draw_Bomb													GraySprite16_MASK_M
#define Draw_Single_Cloud									GraySprite16_MASK_M
#define Draw_Arrow												GraySprite16_MASK_M
#define Draw_Candle												GraySprite16_MASK_M
#define Draw_Tornado											GraySprite16_MASK_M
#define Draw_Meat													GraySprite16_MASK_M
#define Draw_Magical_Wand									GraySprite16_MASK_M
#define Draw_WandWave											GraySprite16_MASK_M
#define Draw_Raft													GraySprite16_MASK_M
#define Draw_Step_Ladder									GraySprite16_MASK_M
#define Draw_Shop_Rupy										GraySprite16_MASK_M
#define Draw_Map_Compass_String						GraySprite16_MASK_M	//Only in DLL
#define Draw_Map_Icon											GraySprite16_MASK_M	//Only in DLL
#define Draw_Compass_Icon									GraySprite16_MASK_M	//Only in DLL
#define Print_Level_String								GraySprite16_MASK_M	//Only in DLL
#define Print_Level												GraySprite16_MASK_M	//Only in DLL
#define Draw_Item													GraySprite16_MASK_M
#define Draw_Shop_Prices									GraySprite16_MASK_M
#define Draw_Shopkeeper										GraySprite16_MASK_M
#define Draw_Enemy												GraySprite16_MASK_M
#define Draw_Enemy_Proj										GraySprite16_MASK_M
#define Draw_Paused												GraySprite16_MASK_Mh
#define Draw_Boomerang										GraySprite16_MASK_Mh

#define Draw_Tile													GraySprite16_BLIT_M
#define Draw_PushBlock										GraySprite16_BLIT_M

#define Draw_Decompression_Screen					GraySprite32_BLIT_Mh
#define Draw_Part_Of_LofZ_Triforce  			GraySprite32_BLIT_Mh
#define Draw_LofZ_Waterfall								GraySprite32_BLIT_Mh
#define Draw_Part_Of_Triforce_Template		GraySprite32_BLIT_Mh	//Only in DLL
#define Draw_Part_Of_Title_Screen					GraySprite32_BLIT_Mh
#define Draw_A_Menu_Tile									GraySprite32_BLIT_Mh
#define Draw_Dungeon_Rough_Map_Template		GraySprite32_BLIT_Mh

#define Increment_Shooting_Sword_x				Increment_x
#define Increment_Shooting_Sword_y				Increment_y
#define Increment_Arrow_x									Increment_x
#define Increment_Arrow_y									Increment_y
#define Increment_Candle_x								Increment_x
#define Increment_Candle_y								Increment_y
#define Increment_WandWave_x							Increment_x
#define Increment_WandWave_y							Increment_y
#define Link_Boomerang_Collision					Object_Collision
#define Link_Object_Collision							Object_Collision
#define Sword_Object_Collision						Object_Collision
#define Scroll_MainMenu										Scroll_Menu	//Appears only once
#define Scroll_From_MainMenu							Scroll_Menu	//Appears only once
#define Scroll_SubMenu										Scroll_Menu	//Called twice (SHIFT & Potion)
#define Scroll_From_SubMenu								Scroll_Menu	//Called twice (SHIFT & Potion)

//Rom Calls
#define Update_Screen_Tiles_Buffer 				memcpy
#define Update_Collision_Detection_Buffer	memcpy
#define Copy_D_Room_Properties 						memcpy
#define Load_Item							 						memcpy
#define Update_Shop_Info									memcpy
#define Update_Shop_Prices								memcpy
#define Load_Enemies											memcpy
#define Load_Enemy_Data										memcpy
#define Clear_File_Status									memset
#define Clear_100th_Row										memset
#define Blacken_Buffer										memset
#define Set_Shop_Boundaries								memset
#define Release_Shop_Boundaries						memset
#define Reset_Enemy_Projectiles						memset


//Macros
#define EXT_SETPIX_AN(a,offset,n) ({if(__builtin_constant_p(offset)) \
{	\
	if(__builtin_constant_p(a))	\
		asm(" bset.b %0,%c1" : : "g" (n), "dai" ((offset)+(a)));	\
	else	\
		if (offset !=0) \
			asm(" bset.b %0,%c1(%2)" : : "g" (n), "dai" (offset), "a" (a));	\
		else \
			asm(" bset.b %0,(%1)" : : "g" (n), "a" (a));	\
}	\
else	\
	asm(" bset.b %0,0(%2,%1.w)" : : "g" (n), "da" (offset), "a" (a));	\
})

#define EXT_XORPIX_AN(a,offset,n) ({if(__builtin_constant_p(offset)) \
	{	\
		if(__builtin_constant_p(a))	\
			asm(" bchg.b %0,%c1" : : "g" (n), "dai" ((offset)+(a)));	\
		else	\
			if (offset !=0) \
				asm(" bchg.b %0,%c1(%2)" : : "g" (n), "dai" (offset), "a" (a));	\
			else \
				asm(" bchg.b %0,(%1)" : : "g" (n), "a" (a));	\
	}	\
	else	\
		asm(" bchg.b %0,0(%2,%1.w)" : : "g" (n), "da" (offset), "a" (a));	\
	})
	
#define EXT_PIXOFFSET(x,y) ((((y)<<4)-(y))*2+((x)>>3))
#define EXT_SETPIX(p,x,y) EXT_SETPIX_AN(p,EXT_PIXOFFSET(x,y),~(x))
#define EXT_XORPIX(p,x,y) EXT_XORPIX_AN(p,EXT_PIXOFFSET(x,y),~(x))

#define OR_Menu_Dungeon_Map								EXT_SETPIX
#define OR_Dungeon_Rough_Map							EXT_SETPIX
#define XOR_Menu_Map											EXT_XORPIX
#define XOR_Menu_Dungeon_Map							EXT_XORPIX
#define XOR_Menu_Compass_On_Map						EXT_XORPIX
#define XOR_Dungeon_Rough_Map							EXT_XORPIX


//TTARCHIVE AND TTUNPACK
#ifndef __TTUNPACK_H__
#define __TTUNPACK_H__

typedef struct {
    unsigned char  osize_lo;   // original size lowbyte
    unsigned char  osize_hi;   // original size highbyte
    unsigned char  magic1;     // must be equal to TTUNPACK_MAGIC1
    unsigned char  magic2;     // must be equal to TTUNPACK_MAGIC2
    unsigned char  csize_lo;   // compressed size lowbyte
    unsigned char  csize_hi;   // compressed size highbyte
    unsigned char  esc1;       // escape >> (8-escBits)
    unsigned char  notused3;
    unsigned char  notused4;
    unsigned char  esc2;       // escBits
    unsigned char  gamma1;     // maxGamma + 1
    unsigned char  gamma2;     // (1<<maxGamma)
    unsigned char  extralz;    // extraLZPosBits
    unsigned char  notused1;
    unsigned char  notused2;
    unsigned char  rleentries; // rleUsed
} TTUNPACK_HEADER;

#define TTUNPACK_MAGIC1 0x54
#define TTUNPACK_MAGIC2 0x50

#define ttunpack_size(_p_)  ((unsigned short)(((TTUNPACK_HEADER*)(_p_))->osize_lo | (((TTUNPACK_HEADER*)(_p_))->osize_hi << 8)))
#define ttunpack_valid(_p_) (((TTUNPACK_HEADER*)(_p_))->magic1 == TTUNPACK_MAGIC1 && ((TTUNPACK_HEADER*)(_p_))->magic2 == TTUNPACK_MAGIC2)

#define TTUNPACK_OKAY             0
#define TTUNPACK_NOESCFOUND     248
#define TTUNPACK_ESCBITS        249
#define TTUNPACK_MAXGAMMA       250
#define TTUNPACK_EXTRALZP       251
#define TTUNPACK_NOMAGIC        252
#define TTUNPACK_OUTBUFOVERRUN  253
#define TTUNPACK_LZPOSUNDERRUN  254

//short UnpackBuffer(unsigned char *src, unsigned char *dest) __attribute__((__stkparm__));
//#define ttunpack_decompress UnpackBuffer

//From Extgraph 2.0 b5 (does not interfere with INT_1)
#define Unpack ((__attribute__((__stkparm__)) unsigned short(*)(unsigned char*,unsigned char*))(unsigned short[]){\
0x48e7,0x1f3e,0x2c6f,0x002c,0x2a6f,0x0030,0x47ee,0x000f,0x7a00,0x1a2e,\
0x0006,0x3e3c,0x0080,0x7004,0x0c2e,0x0054,0x0002,0x666c,0x0c2e,0x0050,\
0x0003,0x6664,0x7808,0x7006,0xb82e,0x000a,0x665a,0x0c2e,0x0080,0x000b,\
0x6652,0x7007,0x7200,0x122e,0x0009,0x2841,0x5141,0x6444,0x7005,0x7200,\
0x122e,0x000c,0x2241,0x5b41,0x6e36,0x984c,0xc98c,0x7000,0x1013,0x4df6,\
0x0010,0x4fef,0xfefc,0x244f,0x421a,0x7000,0x7207,0x7400,0x01c2,0x5342,\
0x14c0,0x51ca,0xfffc,0x5240,0x51c9,0xfff0,0x244f,0x1c1e,0x601c,0x7000,\
0x4fef,0x0104,0x4400,0x4cdf,0x7cf8,0x4e75,0x320c,0xe838,0x1600,0x6100,\
0x0158,0x8600,0x1ac3,0x3204,0x6708,0x6100,0x014c,0xb005,0x66e6,0x6100,\
0x00fc,0x3600,0x5340,0x6740,0x6100,0x00f2,0x5200,0x67c6,0x5500,0x3209,\
0x670a,0xe368,0x2040,0x6100,0x0128,0xd048,0x7400,0x1f00,0x341f,0x1f06,\
0x301f,0x1c1e,0x1006,0x1232,0x7000,0x5201,0xe268,0x1400,0x4602,0x4682,\
0x41f5,0x2800,0x1ad8,0x51cb,0xfffc,0x60aa,0x1007,0xc006,0x671e,0xe21f,\
0x6402,0x1c1e,0x1007,0xc006,0x6638,0xe21f,0x6402,0x1c1e,0x3204,0x6100,\
0x00e0,0xc145,0x6000,0xff7a,0xe21f,0x6402,0x1c1e,0x1f06,0x321f,0x1c1e,\
0x1206,0x1032,0x7000,0x5240,0xe069,0x74ff,0x1401,0x41f5,0x2800,0x1ad8,\
0x1ad8,0x6000,0xff62,0xe21f,0x6402,0x1c1e,0x6162,0x1600,0x6a1a,0xd603,\
0x1007,0xc006,0x56c0,0x9600,0xe21f,0x6402,0x1c1e,0x614c,0x5300,0x3f03,\
0x1e80,0x361f,0x6142,0x0c00,0x0020,0x6406,0x1033,0x0000,0x602c,0xe708,\
0x1206,0x1432,0x7000,0xe61f,0x5502,0x6412,0x1c16,0xdc06,0xd301,0x5202,\
0x6704,0xdc06,0xd301,0x1c1e,0x6006,0x6602,0x1c1e,0xe429,0x0201,0x0007,\
0x8001,0x1ac0,0x51cb,0xfffc,0x6000,0xfef8,0x3407,0x1006,0xc400,0x6738,\
0xd402,0x5302,0x1232,0x7000,0xc002,0xb102,0x6606,0x1416,0x4602,0x5001,\
0x9232,0x2000,0x1401,0x5202,0x0c01,0x0007,0x6504,0x7207,0x7407,0x3007,\
0xe43f,0xbe00,0x6502,0x1c1e,0x610e,0x5201,0x03c0,0x4e75,0x7001,0xe21f,\
0x652a,0x4e75,0x7000,0x5301,0x6524,0x6736,0x3007,0xe23f,0xbe00,0x651c,\
0xd040,0x5340,0xc006,0x1f00,0x301f,0x1c1e,0x1006,0x1432,0x7000,0xe468,\
0xe21f,0x6402,0x1c1e,0x4e75,0xd040,0x5340,0xc006,0x1432,0x7000,0xe428,\
0xe21f,0x65ec,0x4e75,0x1006,0xc007,0x56c0,0x4400,0xe21f,0x65de,0x4e75\
})


#else
#error EXTGRAPH.H already contains TTUNPACK.H defines (remove ttunpack.h include!)
#endif


#ifndef __TTARCHIVE_H__
#define __TTARCHIVE_H__

typedef struct {
   unsigned short offset;     // offset to the entry data from end of entry list
   unsigned short length;     // length of entry
   char           name[8];    // entry name
   unsigned char  misc1[2];   // info from cfg file (may be queried by a program)
   unsigned char  misc2[2];   // info from cfg file (may be queried by a program)
} TTARCHIVE_ENTRY;

typedef struct {
   unsigned long   magic;    // must be equal to TTARCHIVE_MAGIC
   unsigned short  nr;       // number of entries
   TTARCHIVE_ENTRY entry[0]; // here comes the list of TTARCHIVE_ENTRY structures
} TTARCHIVE_HEADER;

#define TTARCHIVE_MAGIC 0x74746100L

#define ttarchive_valid(_p_)     (((TTARCHIVE_HEADER*)(_p_))->magic == TTARCHIVE_MAGIC)
#define ttarchive_entries(_p_)   (((TTARCHIVE_HEADER*)(_p_))->nr)
#define ttarchive_desc(_p_,_i_)  (&(((TTARCHIVE_HEADER*)(_p_))->entry[_i_]))
#define ttarchive_data(_p_,_i_)  (((unsigned char*)&(((TTARCHIVE_HEADER*)(_p_))->entry[((TTARCHIVE_HEADER*)(_p_))->nr]))+\
                                 ((TTARCHIVE_HEADER*)(_p_))->entry[_i_].offset)
#define ttarchive_size(_p_)      ({TTARCHIVE_ENTRY* e=&(((TTARCHIVE_HEADER*)(_p_))->entry[((TTARCHIVE_HEADER*)(_p_))->nr-1]);\
                                  ((unsigned char*)e)+sizeof(TTARCHIVE_ENTRY)+e->offset+e->length-(unsigned char*)(_p_);})
#define ttarchive_info(_p_)      ({char* p=((char*)(_p_))+ttarchive_size(_p_)+21;\
                                  ((!(*p) && (*(p+1) ==((char)0xad)))?(p-20):NULL);})

#define TTARCHIVE_INFOLENGTH 20

#else
#error EXTGRAPH.H already contains TTARCHIVE.H defines (remove ttarchive.h include!)
#endif
