// Header File
// Created 8/24/2004; 2:29:32 PM

	//120
	static unsigned char Tiles_From_Door_Property[4][5][6]= {
		{	//[0] UP
		//	INNER TILES							OUTER TILES	
			{N_6_DC,N_7_DC,N_8,				NN_7_D,NN_8_D,NN_9},		//[0] DD_Kill, DD_Push, DD_LOut
			{N_6_DL,N_7_DL,N_8,				NN_7_D,NN_8_D,NN_9},		//[1] DD_Lock
			{N_6_D,N_7_D,N_8,					NN_7_D,NN_8_D,NN_9},		//[2] DD_Open
			{BW_NW,BW_NE,N_8,					NN_3,NN_3,NN_9},				//[3] DD_Bomb
			{N_6,N_6,N_8,							NN_3,NN_3,NN_9},				//[4] DD_Wall, DD_Walk
		},
		{	//[1] LEFT
			{W_3_DCL,W_4_DC,W_5_DCL,	WW_4_D,WW_5_D,WW_6_D},	//[0] DD_Kill, DD_Push, DD_LOut
			{W_3_DCL,W_4_DL,W_5_DCL,	WW_4_D,WW_5_D,WW_6_D},	//[1] DD_Lock
			{W_3_D,W_4_D,W_5_D,				WW_4_D,WW_5_D,WW_6_D},	//[2] DD_Open
			{W_3,BW_W,W_5,						WW_4,WW_1,WW_6},				//[3] DD_Bomb
			{W_3,W_4,W_5,							WW_4,WW_1,WW_6},				//[4] DD_Wall, DD_Walk
		},
		{	//[2] DOWN
			{S_6_DC,S_7_DC,S_8,				SS_7_D,SS_8_D,SS_9},		//[0] DD_Kill, DD_Push, DD_LOut
			{S_6_DL,S_7_DL,S_8,				SS_7_D,SS_8_D,SS_9},		//[1] DD_Lock
			{S_6_D,S_7_D,S_8,					SS_7_D,SS_8_D,SS_9},		//[2] DD_Open
			{BW_SW,BW_SE,S_8,					SS_3,SS_3,SS_9},				//[3] DD_Bomb
			{S_6,S_6,S_8,							SS_3,SS_3,SS_9}					//[4] DD_Wall, DD_Walk
		},
		{	//[3] RIGHT
			{E_3_DCL,E_4_DC,E_5_DCL,	EE_4_D,EE_5_D,EE_6_D},	//[0] DD_Kill, DD_Push, DD_LOut
			{E_3_DCL,E_4_DL,E_5_DCL,	EE_4_D,EE_5_D,EE_6_D},	//[1] DD_Lock
			{E_3_D,E_4_D,E_5_D,				EE_4_D,EE_5_D,EE_6_D},	//[2] DD_Open
			{E_3,BW_E,E_5,						EE_4,EE_1,EE_6},				//[3] DD_Bomb
			{E_3,E_4,E_5,							EE_4,EE_1,EE_6},				//[4] DD_Wall, DD_Walk
		}
	};
	
//Used to define the door tiles of Screen_Tiles_Buffer with the dynamic variable D_Room_Properties
void Define_D_Door_Tiles(unsigned char Link_Direction,unsigned char *D_Room_Properties,unsigned char *Screen_Tiles_Buffer)
{
	unsigned char Current_Property;
	unsigned char Direction_Index;
	unsigned char Offset_Index;
	unsigned char i;
	
	unsigned char Invert_Direction[4]= {DOWN,RIGHT,UP,LEFT};
	
	unsigned char Screen_Indexes[4][6]=
	{	//INNER				OUTER
		{23,24,25,		7,8,9},				//[0] Up
		{65,81,97,		64,80,96},		//[1] Left
		{151,152,153,	167,168,169},	//[2] Down
		{78,94,110,		79,95,111}		//[3] Right
	};
	
	for(Direction_Index=0;Direction_Index<4;++Direction_Index)
	{
		Current_Property=D_Room_Properties[Direction_Index];
		if(Link_Direction!=NOWHERE && Invert_Direction[Direction_Index]==Link_Direction && Current_Property<=DD_Lock)
			i=2;
		else if(Current_Property<=DD_LOut)
			i=0;
		else if(Current_Property>=DD_Wall)
			i=4;
		else
			i=Current_Property-2;
		for(Offset_Index=0;Offset_Index<6;++Offset_Index)
			Screen_Tiles_Buffer[Screen_Indexes[Direction_Index][Offset_Index]]= Tiles_From_Door_Property[Direction_Index][i][Offset_Index];
	}
};

void Update_Doors(unsigned char Dark_Room,unsigned char *D_Room_Properties,unsigned short (*Map_Tiles)[18])
{
	unsigned char Direction;
	unsigned char Current_Property;
	unsigned char Offset_Index;
	unsigned char Current_x;
	unsigned char Current_y;
	unsigned char i;
	
	unsigned char x[4][3]=
	{	
		{70,80,90},			//[0] Up
		{10,10,10},			//[1] Left
		{70,80,90},			//[2] Down
		{140,140,140}		//[3] Right
	};
	
	unsigned char y[4][3]=
	{	
		{9,9,9},			//[0] Up
		{36,45,54},		//[1] Left
		{81,81,81},		//[2] Down
		{36,45,54}		//[3] Right
	};
	
	unsigned char Doorway_x[4]= {75,10,75,140};
	unsigned char Doorway_y[4]= {9,45,81,45};
	
	for(Direction=0;Direction<4;++Direction)
	{
		Current_Property=D_Room_Properties[Direction];
		if(Current_Property<=DD_LOut)
			i=0;
		else if(Current_Property>=DD_Wall)
			i=4;
		else
			i=Current_Property-2;
			
		for(Offset_Index=0;Offset_Index<3;++Offset_Index)
		{
			Current_x=x[Direction][Offset_Index];
			Current_y=y[Direction][Offset_Index];
			Draw_Tile(Current_x,Current_y,Map_Tiles[Tiles_From_Door_Property[Direction][i][Offset_Index]],OS_Planes_BIN|BG_Planes_BIN);
			if(Dark_Room==Lights_Off)
				Darken_Doorway(Current_x,Current_y,Sprite_h,0xFFC0,LO_Plane_BIN|LB_Plane_BIN);
		}
		if(Dark_Room==Lights_Off && Current_Property==DD_Open)	
			Darken_Doorway(Doorway_x[Direction],Doorway_y[Direction],Sprite_h,0xFFC0,DO_Plane_BIN|DB_Plane_BIN);
	}
}

void Darken_Room(unsigned char Luminosity_Action,unsigned char *Screen_Tiles_Buffer,unsigned short Plane_Bitflag)
{
	unsigned char Index=0;
	if(Luminosity_Action&Battle_Area_Luminosity)
	{
		for(Index=0;Index<8;++Index)
			Modify_Part_Of_Room_Luminosity(20+(Index<<4)-((Index/7)<<3),18,63,0xFFFF,Plane_Bitflag);
		if(Luminosity_Action&Synchronize_OpenDoors)
		{
			if(Screen_Tiles_Buffer[23]==N_6_D)
				Modify_Part_Of_Room_Luminosity(75,9,Sprite_h,0xFFC0,Plane_Bitflag);
			if(Screen_Tiles_Buffer[81]==W_4_D)
				Modify_Part_Of_Room_Luminosity(10,45,Sprite_h,0xFFC0,Plane_Bitflag);
			if(Screen_Tiles_Buffer[151]==S_6_D)
				Modify_Part_Of_Room_Luminosity(75,81,Sprite_h,0xFFC0,Plane_Bitflag);
			if(Screen_Tiles_Buffer[94]==E_4_D)
				Modify_Part_Of_Room_Luminosity(140,45,Sprite_h,0xFFC0,Plane_Bitflag);
		}
	}
	else
	{
		for(Index=0;Index<10;++Index)
			Modify_Part_Of_Room_Luminosity(Index<<4,0,99,0xFFFF,Plane_Bitflag);
	}
	return;
}
