// C Header File
// Created 6/8/2003; 9:52:42 AM

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// FUNCTIONS

///Appears only once in EXE
unsigned short Arrow_Key_CleanUp(unsigned short Rowread_Input,unsigned short Effective_Direction)
{
	switch(Rowread_Input)
	{
		case UP_KEY :
			return UP;
		case LEFT_KEY :
			return LEFT;
		case DOWN_KEY :
			return DOWN;
		case RIGHT_KEY :
			return RIGHT;
	}
	switch(Effective_Direction)
	{
		case UP :
		{
			if(Rowread_Input==North_West_BIN||Rowread_Input==North_East_BIN)
				return UP;
			break;
		}
		case LEFT :
		{
			if(Rowread_Input==North_West_BIN||Rowread_Input==South_West_BIN)
				return LEFT;
			break;
		}
		case DOWN :
		{
			if(Rowread_Input==South_West_BIN||Rowread_Input==South_East_BIN)
				return DOWN;
			break;
		}
		case RIGHT :
		{
			if(Rowread_Input==North_East_BIN||Rowread_Input==South_East_BIN)
				return RIGHT;
			break;
		}
	}
	return NOWHERE;
}

void Slide_Link(unsigned char Slide_Type,unsigned char Slide_Direction,unsigned char Link_x,unsigned char Link_y,
	unsigned char Sprite_Interval,volatile unsigned long *Game_Clock_Ptr,unsigned short *Current_Link)
{
	unsigned char i=0;
	signed char x_Increment[4]= {0,-1,0,1};
	signed char y_Increment[4]= {-1,0,1,0};
	signed char Current_Tile_x_Offset[4]= {0,-10,0,10};	//Only for Slide_Type=Hide
	signed char Current_Tile_y_Offset[4]= {-9,0,9,0};		//Only for Slide_Type=Hide
	unsigned char Current_Tile_x=Link_x;
	unsigned char Current_Tile_y=Link_y;
	unsigned long Link_Clock_Reference=*Game_Clock_Ptr;
	
	if(Slide_Type==Link_Hide)
	{
		Current_Tile_x+=Current_Tile_x_Offset[Slide_Direction];
		Current_Tile_y+=Current_Tile_y_Offset[Slide_Direction];
	}
	for(;i<9+(Slide_Direction&0x01);++i)
	{
		Replenish_Link_BG(Link_x,Link_y,Current_Link);
		Link_x+=x_Increment[Slide_Direction];
		Link_y+=y_Increment[Slide_Direction];
		Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
		if(Slide_Type)
			Replenish_Tile_BG(Current_Tile_x,Current_Tile_y,Graphics16[Shop_Stair]);
		FastCopyScreen_M(Planes[2],Planes[0]);
		FastCopyScreen_M(Planes[3],Planes[1]);
		while(*Game_Clock_Ptr-Link_Clock_Reference<Sprite_Interval) {}
		Link_Clock_Reference=*Game_Clock_Ptr;
	}
}