// C Header File
// Created 6/26/2003; 5:58:38 PM

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// FUNCTIONS

///This function is not written for speed but speed is not required here anyways. MainMenu functions appear only once in EXE.
void Scroll_Menu(unsigned char Action,unsigned char Scroll_Index,unsigned char* Buffer_Light,unsigned char* Buffer_Dark,
	unsigned char (*Oversized_Buffer)[3510])
{
	switch(Action)
	{
		case Action_Scroll_MainMenu :
		{
			memcpy(Oversized_Buffer[0]-30,Buffer_Light+(LCD_h-2-Scroll_Index)*LCD_CharWidth,Screen_CharWidth);	//Copy source line (variable) to roof of dest (const)
			memcpy(Oversized_Buffer[1]-30,Buffer_Dark+(LCD_h-2-Scroll_Index)*LCD_CharWidth,Screen_CharWidth);
			ScrollDown160_M((unsigned short*)(Oversized_Buffer[0]-30),LCD_h);																		//scroll down with roof
			ScrollDown160_M((unsigned short*)(Oversized_Buffer[1]-30),LCD_h);
			break;
		}
		case Action_Scroll_From_MainMenu :
		{
			memcpy(Oversized_Buffer[0]+(LCD_h-1)*LCD_CharWidth,Buffer_Light+Scroll_Index*Screen_CharWidth,Screen_CharWidth);
			memcpy(Oversized_Buffer[1]+(LCD_h-1)*LCD_CharWidth,Buffer_Dark+Scroll_Index*Screen_CharWidth,Screen_CharWidth);
			ScrollUp160_M((unsigned short*)Oversized_Buffer[0],LCD_h);
			ScrollUp160_M((unsigned short*)Oversized_Buffer[1],LCD_h);
			break;
		}
		case Action_Scroll_Submenu :
		{
			memcpy(Oversized_Buffer[0]-30,Buffer_Light+(LCD_h-2-Scroll_Index)*LCD_CharWidth,Screen_CharWidth);
			memcpy(Oversized_Buffer[1]-30,Buffer_Dark+(LCD_h-2-Scroll_Index)*LCD_CharWidth,Screen_CharWidth);
			ScrollDown160_M((unsigned short*)(Oversized_Buffer[0]-30),Scroll_Index+2);
			ScrollDown160_M((unsigned short*)(Oversized_Buffer[1]-30),Scroll_Index+2);
			break;
		}
		case Action_Scroll_From_SubMenu :
		{
			ScrollUp160_M((unsigned short*)(Oversized_Buffer[0]-30),SubMenu_h-Scroll_Index+1);
			ScrollUp160_M((unsigned short*)(Oversized_Buffer[1]-30),SubMenu_h-Scroll_Index+1);
			memcpy(Oversized_Buffer[0]+(SubMenu_h-1-Scroll_Index)*LCD_CharWidth,Buffer_Light+(SubMenu_h-1-Scroll_Index)*Screen_CharWidth,Screen_CharWidth);
			memcpy(Oversized_Buffer[1]+(SubMenu_h-1-Scroll_Index)*LCD_CharWidth,Buffer_Dark+(SubMenu_h-1-Scroll_Index)*Screen_CharWidth,Screen_CharWidth);
			break;
		}
	}
}

///Clean this function up if possible. Too many arguments. 
void Update_Menu_SubTemplates(unsigned char World, unsigned char World_Index, unsigned short *Dungeon_Maps_Compasses,
	unsigned short (*Dungeon_Tracker)[8],	unsigned char (*D_Room_Properties)[128][8], unsigned char (*Dungeon_Levels)[128],
	unsigned short (*Character)[27], unsigned long (*Triforce_Template)[72], unsigned long (*Dungeon_Rough_Map_Template)[68])
{
	/*
	Functions for overworld:
	1) Clear triforce area and overworld map area 
	2) Draw triforce template and overworld map
	
	Functions for underworld
	1) Draw underworld map templates (neat + rough), map/compass strings, level string
	2) Maintain log for underworld rough map
	3) Draw map/compass and boss location on neat map
	4) Draw rough map details
	*/
	unsigned char Current_Dungeon=Dungeon_Levels[World-1][World_Index];
	unsigned char Dungeon_Screen_Index=0;
	unsigned char D_Map_Row=0;
	unsigned char D_Map_Col=0;
	signed char Shifted_D_Map_Col=0;
	unsigned char i=0;
	unsigned char j=0;

	unsigned char Compass_x_Offset[9]= {6*(4),3*(4),5*(4),5*(4),2*(4),5*(4),4*(4),2*(4),2*(4)};
	unsigned char Compass_y_Offset[9]= {3*(2),0*(2),3*(2),0*(2),1*(2),0*(2),2*(2),2*(2),3*(2)};
	unsigned char Map_Compass_String[12]= {Char_M,Char_A,Char_P,Char_Space,Char_Space,Char_C,Char_O,Char_M,Char_P,Char_A,Char_S,Char_S};
	unsigned char Level_String[6]= {Char_L,Char_E,Char_V,Char_E,Char_L,Char_Hyphen};


	signed char Rough_Map_Screen_Offset[9]= {8,-2,0,10,6,1,1,-2,8};
	signed char Rough_Map_Door_Offset[9]= {7,17,15,5,9,14,14,17,7};
	
	unsigned char Binary_Dungeon_Maps[9][8]= {
		{0x00,0x00,0x30,0x16,0x7C,0x38,0x10,0x38},	//[0] Level 1
		{0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x18},	//[1] Level 2
		{0x00,0x00,0x30,0x14,0x7C,0x7C,0x50,0x18},	//[2] Level 3
		{0x3C,0x2C,0x30,0x38,0x20,0x30,0x18,0x30},	//[3] Level 4
		{0x18,0x2C,0x3C,0x24,0x0C,0x1C,0x3C,0x0C},	//[4] Level 5
		{0x3C,0x7E,0x66,0x74,0x40,0x40,0x50,0x70},	//[5] Level 6
		{0x7E,0x6C,0x78,0x70,0x60,0x78,0x7E,0x70},	//[6] Level 7
		{0x08,0x1C,0x28,0x7C,0x78,0x3C,0x08,0x3C},	//[7] Level 8
		{0x7E,0xFF,0xFF,0xDB,0xFF,0xFF,0x7E,0x5A}		//[8] Level 9
	};
	unsigned char Rough_Map_x[4]= {131,129,131,133};	//Starting positions for open doorway labelling as f(door)
	unsigned char Rough_Map_y[4]= {41,43,44,43};			//Starting positions for open doorway labelling as f(door)
	
	for(;i<10;++i)
		Reset_Menu_Center_Area(i<<4,37,37,0xFFFF,LM_Plane_BIN|DM_Plane_BIN);
	for(i=0;i<3;++i)
		Reset_Menu_Map_Area(9+(i<<4)-(i>>1)*14,76,21,0xFFFF,LM_Plane_BIN|DM_Plane_BIN);
	if(!World || (World==Dungeon_2 && World_Index==Shop_Room))
	{
		for(i=0;i<2;++i)
			Draw_Part_Of_Triforce_Template(Triforce_Template_x+(i<<5),Triforce_Template_y,Triforce_Template_h,Triforce_Template[i],Menu_Planes_BIN);
		for(i=0;i<3;++i)
			Draw_Part_Of_Menu_Map(Menu_Map_x-1+(i<<4)-(i>>1)*15,Menu_Map_y-1,Menu_Map_h,0x0000,LM_Plane_BIN);
	}
	else
	{
		for(i=0;i<12;++i)
			Draw_Map_Compass_String(Map_Compass_x+i*5,Map_Compass_y,Character[Map_Compass_String[i]],Menu_Planes_BIN);
		for(i=0;i<2;++i)
			Draw_Dungeon_Rough_Map_Template(Dungeon_Rough_Map_x+(i<<5),Dungeon_Rough_Map_y,Dungeon_Rough_Map_h,Dungeon_Rough_Map_Template[i],Menu_Planes_BIN);	
		for(i=0;i<6;++i)
			Print_Level_String(Level_String_x+i*5,Level_String_y,Character[Level_String[i]],Menu_Planes_BIN);
		Print_Level(Level_String_x+6*5,Level_String_y,Character[Char_0+Current_Dungeon],Menu_Planes_BIN);
		if(Current_Dungeon)
		{
			Dungeon_Tracker[World-1][World_Index>>4]|=(1<<(15-(World_Index&0x0F)));
			if(Dungeon_Maps_Compasses[0]&(1<<(Current_Dungeon-1)))
				Draw_Map_Icon(Map_Icon_x,Map_Icon_y,Graphics16[Map],Menu_Planes_BIN);
			if(Dungeon_Maps_Compasses[1]&(1<<(Current_Dungeon-1)))
			{
				Draw_Compass_Icon(Compass_Icon_x,Compass_Icon_y,Graphics16[Compass],Menu_Planes_BIN);
				XOR_Menu_Compass_On_Map(Planes[5],11+Compass_x_Offset[Current_Dungeon-1],82+Compass_y_Offset[Current_Dungeon-1]);
			}
			for(D_Map_Row=0;D_Map_Row<Menu_Dungeon_Map_h;++D_Map_Row)
			{
				for(D_Map_Col=0;D_Map_Col<Menu_Dungeon_Map_w;++D_Map_Col)
				{
					if(Binary_Dungeon_Maps[Current_Dungeon-1][D_Map_Row]&(1<<D_Map_Col))
					{
						if(Dungeon_Maps_Compasses[0]&(1<<(Current_Dungeon-1)))
							Draw_Part_Of_Dungeon_Map(Menu_Dungeon_Map_x-(D_Map_Col<<2),Menu_Dungeon_Map_y+(D_Map_Row<<1),1,0x1FFF,LM_Plane_BIN);
						Shifted_D_Map_Col=D_Map_Col+Rough_Map_Screen_Offset[Current_Dungeon-1];
						if(Shifted_D_Map_Col>=0 && Shifted_D_Map_Col<16 && Dungeon_Tracker[World-1][D_Map_Row]&(1<<(Shifted_D_Map_Col)))
						{
							Draw_Part_Of_Dungeon_Rough_Map(130-D_Map_Col*5,42+(D_Map_Row<<2),2,0xE000,LM_Plane_BIN);
							Dungeon_Screen_Index=D_Map_Row*World_w-D_Map_Col+Rough_Map_Door_Offset[Current_Dungeon-1];
							for(i=0;i<4;++i)
							{	//Draws connections between rooms on Dungeon_Rough_Map when connecting doors are open.
								j=D_Room_Properties[World-1][Dungeon_Screen_Index][i];
								if(j==DD_Open || j==DD_Bomb)
									XOR_Dungeon_Rough_Map(Planes[4],Rough_Map_x[i]-D_Map_Col*5,Rough_Map_y[i]+(D_Map_Row<<2));
							}
						}
					}
				}
			}
		}
	}
}

///rewrite w/asm or use 240 pixel wide buffer with FastCopyScreen_R.
//Note, this is not a time constraining fxn. Appears only three times in EXE (ALPHA, SHIFT, Potion)
void Store_Current_Screen(unsigned char (*Current_Screen_Buffer)[1980])
{
	unsigned char Copy_Index;
	for(Copy_Index=0;Copy_Index<LCD_h-1;++Copy_Index)
	{
		memcpy(Current_Screen_Buffer[0]+Copy_Index*Screen_CharWidth,Planes[2]+Copy_Index*LCD_CharWidth,Screen_CharWidth);
		memcpy(Current_Screen_Buffer[1]+Copy_Index*Screen_CharWidth,Planes[3]+Copy_Index*LCD_CharWidth,Screen_CharWidth);
	}
}

unsigned char Find_Best_Weapon(BOOL Weapon_Slot_Or_Cursor_Position,unsigned char Index,unsigned long Weapons_Possessed)
{
	if(Weapon_Slot_Or_Cursor_Position==Find_For_Cursor_Position&&Index>Third_Cursor_Position)
		++Index;
	switch(Index)
	{
		case First_Weapon_Slot :
		{
			if(Weapons_Possessed&Magical_Boomerang_BIN)
				return Magical_Boomerang;
			if(Weapons_Possessed&Boomerang_BIN)
				return Normal_Boomerang;
			break;
		}
		case Second_Weapon_Slot	:
		{
			if(Weapons_Possessed&Bomb_BIN)
				return Bomb_1;
			break;
		}
		case Third_Weapon_Slot :
		{
			if(Weapons_Possessed&Silver_Arrow_BIN)
				return Silver_Arrow;
			if(Weapons_Possessed&Arrow_BIN)
				return Wooden_Arrow;
			break;
		}
		case Fourth_Weapon_Slot :
		{
			if(Weapons_Possessed&Bow_BIN)
				return Bow;
			break;
		}
		case Fifth_Weapon_Slot :
		{
			if(Weapons_Possessed&Red_Candle_BIN)
				return Red_Candle;
			if(Weapons_Possessed&Blue_Candle_BIN)
				return Blue_Candle;
			break;
		}
		case Sixth_Weapon_Slot :
		{
			if(Weapons_Possessed&Recorder_BIN)
				return Recorder;
			break;
		}
		case Seventh_Weapon_Slot	:	{
			if(Weapons_Possessed&Meat_BIN)
				return Meat_1;
			break;
			}
		case Eighth_Weapon_Slot :
		{
			if(Weapons_Possessed&Red_Potion_BIN)
				return Red_Potion;
			if(Weapons_Possessed&Blue_Potion_BIN)
				return Blue_Potion;
			if(Weapons_Possessed&Letter_BIN)
				return Letter;
			break;
		}
		case Nineth_Weapon_Slot :
		{
			if(Weapons_Possessed&Magical_Wand_BIN)
				return Magic_Wand;
			break;
		}
		case Tenth_Weapon_Slot :
		{
			if(Weapons_Possessed&Raft_BIN)
				return Raft_1;
			break;
		}
		case Eleventh_Weapon_Slot :
		{
			if(Weapons_Possessed&Magical_Book_BIN)
				return Magical_Book;
			break;
		}
		case Twelveth_Weapon_Slot :
		{
			if(Weapons_Possessed&Red_Ring_BIN)
				return Red_Ring;
			if(Weapons_Possessed&Blue_Ring_BIN)
				return Blue_Ring;
			break;
		}
		case Thirteenth_Weapon_Slot	:	{
			if(Weapons_Possessed&Ladder_BIN)
				return Ladder_1;
			break;
		}
		case Fourteenth_Weapon_Slot :
		{
			if(Weapons_Possessed&Magical_Key_BIN)
				return Magical_Key;
			break;
		}
		case Fifteenth_Weapon_Slot :
		{
			if(Weapons_Possessed&Power_Bracelet_BIN)
				return Power_Bracelet;
		}
	}
	return Menu_Weap8_Blank;
}

//Only Appears Twice in Program
void Update_Menu_Weapons(unsigned long Weapons_Possessed)
{
	if(_rowread(F5_ROW)&CARET_KEY)
	{
		MoveTo(0,39);
		printf("%08lX ",Weapons_Possessed);
	}
	
	unsigned char Weapon_Slot;
	unsigned char Current_Weapon;
	unsigned char Menu_Weapon_x_Coordinates[15]= {
		First_Col+1,Second_Col,Third_Col-1,Third_Col+3,Fourth_Col,First_Col+1,Second_Col,
		Third_Col,Fourth_Col+1,Raft_x_MENU,Book_x,Ring_x,Ladder_x_MENU,Magic_Key_x,Bracelet_x};
	unsigned char Menu_Weapon_y_Coordinates[15]= {
		First_Row+2,First_Row,First_Row,First_Row,First_Row,Second_Row,Second_Row,
		Second_Row,Second_Row,Row_Above_Box,Row_Above_Box,Row_Above_Box,Row_Above_Box,Row_Above_Box,Row_Above_Box};
		
	for(Weapon_Slot=0;Weapon_Slot<15;++Weapon_Slot)
	{
		Current_Weapon=Find_Best_Weapon(Find_For_Weapon_Slot,Weapon_Slot,Weapons_Possessed);
		if(Current_Weapon==Menu_Weap8_Blank&&(Weapon_Slot==Tenth_Weapon_Slot||Weapon_Slot==Thirteenth_Weapon_Slot))
			Current_Weapon=Menu_Weap9_Blank;
		Clear_Menu_Weapon(Menu_Weapon_x_Coordinates[Weapon_Slot],Menu_Weapon_y_Coordinates[Weapon_Slot],Graphics16[Menu_Weap8_Blank],OS_Planes_BIN);
		Draw_Menu_Weapon(Menu_Weapon_x_Coordinates[Weapon_Slot],Menu_Weapon_y_Coordinates[Weapon_Slot],Graphics16[Current_Weapon],OS_Planes_BIN);
	}
}

///Consider not importing
void Blink_Cursor(unsigned char Cursor_Type,unsigned char Cursor_Position)
{
	unsigned char Cursor_x_Positions[4]= {First_Cursor_Col,Second_Cursor_Col,Third_Cursor_Col,Fourth_Cursor_Col};
	unsigned char Cursor_y_Positions[2]= {First_Cursor_Row,Second_Cursor_Row};
	Draw_Menu_Cursor(Cursor_x_Positions[Cursor_Position&0x03],Cursor_y_Positions[Cursor_Position>>2],Graphics16[Cursor_Type],OS_Planes_BIN);
}

unsigned char Move_Cursor_Position(unsigned char Direction,unsigned char Cursor_Position,unsigned long Weapons_Possessed)
{
	short Active_Cursor_Positions=0;
	if(Weapons_Possessed&Boomerangs_BIN)
		Active_Cursor_Positions|=First_Cursor_Slot;
	if(Weapons_Possessed&Bomb_BIN)
		Active_Cursor_Positions|=Second_Cursor_Slot;
	if(Weapons_Possessed&Bow_BIN&&Weapons_Possessed&Arrows_BIN)
		Active_Cursor_Positions|=Third_Cursor_Slot;
	if(Weapons_Possessed&Candles_BIN)
		Active_Cursor_Positions|=Fourth_Cursor_Slot;
	if(Weapons_Possessed&Recorder_BIN)
		Active_Cursor_Positions|=Fifth_Cursor_Slot;
	if(Weapons_Possessed&Meat_BIN)
		Active_Cursor_Positions|=Sixth_Cursor_Slot;
	if(Weapons_Possessed&Potions_BIN)
		Active_Cursor_Positions|=Seventh_Cursor_Slot;
	if(Weapons_Possessed&Magical_Wand_BIN)
		Active_Cursor_Positions|=Eighth_Cursor_Slot;
	if(!Active_Cursor_Positions)
		Active_Cursor_Positions=First_Cursor_Slot;
	do
	{
		if(Direction==LEFT)
		{
			if(Cursor_Position==First_Cursor_Position)
				Cursor_Position=Eighth_Cursor_Position;
			else
				--Cursor_Position;
		}
		else if(Direction==RIGHT)
		{
			if(Cursor_Position==Eighth_Cursor_Position)
				Cursor_Position=First_Cursor_Position;
			else
				++Cursor_Position;
		}
		else
			Direction=LEFT;
	}	while(!(Active_Cursor_Positions&(1<<(Cursor_Position))));
	return Cursor_Position;
}

unsigned char Find_Best_Sword(unsigned long Weapons_Possessed)
{
	if(Weapons_Possessed&Magical_Sword_BIN)
		return Magical_Sword;
	else if(Weapons_Possessed&White_Sword_BIN)
		return White_Sword;
	else if(Weapons_Possessed&Wooden_Sword_BIN)
		return Wooden_Sword;
	else
		return Menu_Weap8_Blank;
}

void Update_B_Box(BOOL Current_Menu,unsigned char Cursor_Position,unsigned long Weapons_Possessed)
{
	unsigned char B_Box_x[2]= {B_MainBox_x,B_SubBox_x};
	unsigned char B_Box_y[2]= {B_MainBox_y,B_SubBox_y};
	signed char Weapon_Offset_x[8]= {1,0,1,0,1,0,0,1};
	signed char Weapon_Offset_y[8]= {2,0,0,0,0,0,0,0};
	unsigned char Current_Weapon=Find_Best_Weapon(Find_For_Cursor_Position,Cursor_Position,Weapons_Possessed);
	if(Current_Weapon==Menu_Weap8_Blank)
		++Cursor_Position;	//Otherwise offset for boomerang creates drawing error.
	Clear_Menu_Weapon(B_Box_x[Current_Menu],B_Box_y[Current_Menu],Graphics16[Menu_Weap8_Blank],Gray_Planes_BIN|OS_Planes_BIN);
	Draw_B_Box_Weapon(B_Box_x[Current_Menu]+Weapon_Offset_x[Cursor_Position],B_Box_y[Current_Menu]+Weapon_Offset_y[Cursor_Position],
		Graphics16[Current_Weapon],Gray_Planes_BIN|OS_Planes_BIN);
}

void Update_Triforces(unsigned long Weapons_Possessed,unsigned short (*Triforces)[2][27],unsigned short Plane_Bitflag)
{
	BOOL Triforce_Present=FALSE;
	unsigned char Triforce_Index;
	unsigned char Triforce_x[8]= {Triforce_1_x,Triforce_2_x,Triforce_3_x,Triforce_4_x,Triforce_5_x,Triforce_6_x,Triforce_7_x,Triforce_8_x};
	unsigned char Triforce_y[8]= {Triforce_1_y,Triforce_2_y,Triforce_3_y,Triforce_4_y,Triforce_5_y,Triforce_6_y,Triforce_7_y,Triforce_8_y};
	unsigned long Triforce_BIN[8]= {Triforce_1_BIN,Triforce_2_BIN,Triforce_3_BIN,Triforce_4_BIN,Triforce_5_BIN,Triforce_6_BIN,Triforce_7_BIN,Triforce_8_BIN};
	for(Triforce_Index=0;Triforce_Index<8;++Triforce_Index)
	{
		if(Weapons_Possessed&Triforce_BIN[Triforce_Index])
			Triforce_Present=TRUE;
		else
			Triforce_Present=FALSE;
		Draw_Triforce(Triforce_x[Triforce_Index],Triforce_y[Triforce_Index],Triforces[Triforce_Index][Triforce_Present],Plane_Bitflag);
	}
}

void Update_Hearts(BOOL Currently_Using_Potion,unsigned char Hearts,unsigned char Heart_Containers,unsigned short Plane_Bitflag)
{
	unsigned char Heart_Index;
	unsigned char Current_Heart;
	//Heart Containers: [1-16]
	//Hearts: [0-32] (Each a half heart)
	
	for(Heart_Index=0;Heart_Index<16;++Heart_Index)
	{
		if(Heart_Containers<=Heart_Index)
			Current_Heart=Heart_None;
		else if(Hearts<=Heart_Index<<1)
			Current_Heart=Heart_Empty;
		else if(Hearts>>1>Heart_Index)
			Current_Heart=Heart_Full;
		else
			Current_Heart=Heart_Half;
		Draw_A_Heart(Hearts_x+(Heart_Index&0x07)*6,Hearts_y-(Heart_Index>>3)*5-Currently_Using_Potion*74,Graphics16[Current_Heart],Plane_Bitflag);
	}
}

void Update_Countable_Items(unsigned char Rupies_Possessed,unsigned char Keys_Possessed,unsigned char Bombs_Possessed,
	BOOL Possess_Magical_Key,unsigned short (*Character)[27],unsigned short Current_Planes)
{
	unsigned char Possession_Vector[3]= {Rupies_Possessed,Keys_Possessed,Bombs_Possessed};
	unsigned char Item_Index;
	unsigned char Position_Index;
	unsigned char Split_Number[3]= {0,0,0};
	unsigned char Current_Char=0;
	for(Item_Index=0;Item_Index<3;++Item_Index)
	{
		Split_Number[0]=Possession_Vector[Item_Index]/100;
		Split_Number[1]=(Possession_Vector[Item_Index]%100)/10;
		Split_Number[2]=Possession_Vector[Item_Index]%10;
		for(Position_Index=0;Position_Index<3;++Position_Index)
		{
			if(!Position_Index&&!Split_Number[0])
				Current_Char=Char_X;
			else if(Possess_Magical_Key&&Item_Index==1)
			{
				if(Position_Index==1)
					Current_Char=Char_A;
				else
					Current_Char=Char_Space;
			}
			else if(!Split_Number[0] && !Split_Number[1])
			{
				if(Position_Index==1)
					Current_Char=Char_0+Split_Number[2];
				else
					Current_Char=Char_Space;
			}
			else
				Current_Char=Char_0+Split_Number[Position_Index];
			Print_Character(57+5*Position_Index,79+6*Item_Index,Character[Current_Char],Current_Planes);
		}
	}
}
