// C Header File
// Created 7/18/2003; 12:52:22 PM

signed char Cloud_Offset_x[7]= {-Sprite_w/2-1,-Sprite_w-1,-Sprite_w/2-1,Sprite_w/2-1,Sprite_w-1,Sprite_w/2-1,-1};
signed char Cloud_Offset_y[7]= {-Sprite_h,0,Sprite_h,Sprite_h,0,-Sprite_h,0};

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// FUNCTIONS

BOOL Link_Within_Boundaries(unsigned char Object_Direction,unsigned char Object_x,unsigned char Object_y,
	unsigned char North_Limit,unsigned char West_Limit,unsigned char South_Limit,unsigned char East_Limit)
{
	switch(Object_Direction)
	{
		case UP :
		{
			if(Object_y>(LCD_h-1-Sprite_h*3/2)||Object_y<North_Limit)
				return FALSE;
			break;
		}
		case LEFT :
		{
			if(Object_x>(LCD_w-Sprite_w*3/2)||Object_x<West_Limit)
				return FALSE;
			break;
		}
		case DOWN :
		{
			if(Object_y<Sprite_h/2||Object_y>South_Limit)
				return FALSE;
			break;
		}
		case RIGHT :
		{
			if(Object_x<Sprite_w/2||Object_x>East_Limit)
				return FALSE;
			break;
		}
	}
	return TRUE;
}

unsigned char Find_Shard_x(unsigned char Shards_Index,signed short Current_Shard_x,unsigned char Current_Sword_Shards_Stage)	//Not Exported
{
	signed short Shard_x_Offset[4]= {
		-(Shard_w+Current_Sword_Shards_Stage-1),-(Shard_w+Current_Sword_Shards_Stage-1),Current_Sword_Shards_Stage-1,Current_Sword_Shards_Stage-1
	};
	Current_Shard_x+=Shard_x_Offset[Shards_Index];
	return Current_Shard_x;
}

unsigned char Find_Shard_y(unsigned char Shards_Index,signed short Current_Shard_y,unsigned char Current_Sword_Shards_Stage)	//Not Exported
{
	signed short Shard_y_Offset[4]= {
		-(Shard_h+Current_Sword_Shards_Stage-1),Current_Sword_Shards_Stage-1,Current_Sword_Shards_Stage-1,-(Shard_h+Current_Sword_Shards_Stage-1)
	};
	Current_Shard_y+=Shard_y_Offset[Shards_Index];
	return Current_Shard_y;
}

BOOL Current_Shard_Within_Boundaries(signed short Current_Shard_x,signed short Current_Shard_y)	//Not Exported
{
	if(Current_Shard_x<0||Current_Shard_x>(LCD_w-Shard_w)||Current_Shard_y<0||Current_Shard_y>(LCD_h-1-Shard_h))
		return FALSE;
	return TRUE;
}

void Replenish_Sword_Shards_BG(signed short Shard_Reference_x,signed short Shard_Reference_y,unsigned char Current_Sword_Shards_Stage,
	unsigned short (*Sword_Shards)[4][27])
{
	unsigned char Shards_Index;
	signed short Current_Shard_x;
	signed short Current_Shard_y;
	for(Shards_Index=0;Shards_Index<4;Shards_Index++)
	{
		Current_Shard_x=Find_Shard_x(Shards_Index,Shard_Reference_x,Current_Sword_Shards_Stage);
		Current_Shard_y=Find_Shard_y(Shards_Index,Shard_Reference_y,Current_Sword_Shards_Stage);
		if(Current_Shard_Within_Boundaries(Current_Shard_x,Current_Shard_y))
			Replenish_A_Sword_Shard_BG(Current_Shard_x,Current_Shard_y,Sword_Shards[0][Shards_Index]);
	}
}

void Draw_Sword_Shards(signed short Shard_Reference_x,signed short Shard_Reference_y,unsigned char Current_Sword_Shards_Stage,
	BOOL Sword_Shards_Animation,unsigned short (*Sword_Shards)[4][27])
{
	unsigned char Shards_Index;
	signed short Current_Shard_x;
	signed short Current_Shard_y;
	for(Shards_Index=0;Shards_Index<4;Shards_Index++)
	{
		Current_Shard_x=Find_Shard_x(Shards_Index,Shard_Reference_x,Current_Sword_Shards_Stage);
		Current_Shard_y=Find_Shard_y(Shards_Index,Shard_Reference_y,Current_Sword_Shards_Stage);
		if(Current_Shard_Within_Boundaries(Current_Shard_x,Current_Shard_y))
			Draw_A_Sword_Shard(Current_Shard_x,Current_Shard_y,Sword_Shards[Sword_Shards_Animation][Shards_Index],OS_Planes_BIN);
	}
}

///Maybe integrate ZolaFire algorithm here (each quadraunt has 10 angles, not only 2)
//Remember CAST!
//#define First_Scaled_Tan_Ratio		53	//=TAN(22.5)<<7
//#define Second_Scaled_Tan_Ratio		309	//=TAN(67.5)<<7
unsigned char Find_Relative_Direction(unsigned char Boomerang_Center_x,unsigned char Boomerang_Center_y,
	unsigned char Link_Center_x,unsigned char Link_Center_y)
{	//The "Relative_Direction" returned is the direction of the ray from the boomerang to link [0-7]
	signed short Relative_Distance_x=Link_Center_x-Boomerang_Center_x;
	signed short Relative_Distance_y=Boomerang_Center_y-Link_Center_y;
	if(!Relative_Distance_x)
		Relative_Distance_x=1;
	signed short Scaled_Tan_Ratio=(Relative_Distance_y<<7)/Relative_Distance_x;
	
	if(Scaled_Tan_Ratio>=Second_Scaled_Tan_Ratio)
	{
		if(Relative_Distance_x>=0)
			return North;
		return South;
	}
	if(Scaled_Tan_Ratio<Second_Scaled_Tan_Ratio && Scaled_Tan_Ratio>=First_Scaled_Tan_Ratio)
	{
		if(Relative_Distance_x>=0)
			return North_East;
		return South_West;
	}
	if(Scaled_Tan_Ratio<First_Scaled_Tan_Ratio && Scaled_Tan_Ratio>=-First_Scaled_Tan_Ratio)
	{
		if(Relative_Distance_x>=0)
			return East;
		return West;
	}
	if(Scaled_Tan_Ratio<-First_Scaled_Tan_Ratio && Scaled_Tan_Ratio>=-Second_Scaled_Tan_Ratio)
	{
		if(Relative_Distance_x>=0)
			return South_East;
		return North_West;
	}
	if(Scaled_Tan_Ratio<-First_Scaled_Tan_Ratio && Scaled_Tan_Ratio>=-Second_Scaled_Tan_Ratio)
	{
		if(Relative_Distance_x>=0)
			return South_East;
		return North_West;
	}
	if(Relative_Distance_x>=0)
		return South;
	return North;
}

BOOL Current_Cloud_Within_Boundaries(signed short Current_Cloud_x,signed short Current_Cloud_y)	//Not Exported
{
	if(Current_Cloud_x<0||Current_Cloud_x>(LCD_w-Sprite_w)||Current_Cloud_y<0||Current_Cloud_y>(LCD_h-1-Sprite_h))
		return FALSE;
	return TRUE;
}

void Replenish_Bomb_Cloud_BG(signed short Bomb_x,signed short Bomb_y,unsigned short *Bomb_Cloud_Mask)
{
	unsigned char Cloud_Index;
	signed short Current_Cloud_x;
	signed short Current_Cloud_y;
	for (Cloud_Index=0;Cloud_Index<7;++Cloud_Index)
	{
		Current_Cloud_x=Bomb_x+Cloud_Offset_x[Cloud_Index];
		Current_Cloud_y=Bomb_y+Cloud_Offset_y[Cloud_Index];
		if(Current_Cloud_Within_Boundaries(Current_Cloud_x,Current_Cloud_y))
			Replenish_Cloud_BG(Current_Cloud_x,Current_Cloud_y,Bomb_Cloud_Mask);
	}
}

void Draw_Bomb_Cloud(unsigned char Cloud_Type,signed short Bomb_x,signed short Bomb_y)
{
	unsigned char Cloud_Index;
	signed short Current_Cloud_x;
	signed short Current_Cloud_y;
	for (Cloud_Index=0;Cloud_Index<7;++Cloud_Index)
	{
		Current_Cloud_x=Bomb_x+Cloud_Offset_x[Cloud_Index];
		Current_Cloud_y=Bomb_y+Cloud_Offset_y[Cloud_Index];
		if(Current_Cloud_Within_Boundaries(Current_Cloud_x,Current_Cloud_y))
		{
			Draw_Single_Cloud(Current_Cloud_x,Current_Cloud_y,Graphics16[Cloud_Type],OS_Planes_BIN);
		}
	}
}
