// C Header File
// Created 5/26/03; 9:15:08 PM

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
//FUNCTIONS

void Draw_Screen(unsigned short (*Map_Tiles)[18],unsigned char *Screen_Tiles_Buffer,unsigned short Current_Planes)
{
	unsigned char i;
	for (i=0;i<(Screen_w*Screen_h);++i)
		Draw_Tile(i%Screen_w*Sprite_w,i/Screen_w*Sprite_h,Map_Tiles[Screen_Tiles_Buffer[i]],Current_Planes);
}

void Update_Vars(unsigned char *Sprite_Interval,unsigned char *Projectile_Interval,unsigned char *Scroll_Interval,
	unsigned char *Adjust_Interval,signed char *Gray_Index,unsigned char *Current_Shield,unsigned long *Weapons_Possessed,unsigned char *Heart_Containers, unsigned char *Hearts,
	unsigned char *Rupies_Possessed,unsigned char *Keys_Possessed,unsigned char *Bombs_Possessed,unsigned char *Max_Bombs,unsigned short *Dungeon_Maps_Compasses)
{
	MoveTo(0,0);
	unsigned short Row_BitValue=_rowread(F5_ROW);
	unsigned short ENTER_KEY_Pressed=		Row_BitValue&ENTER_KEY;
	unsigned short PLUS_KEY_Pressed=		Row_BitValue&PLUS_KEY;
	unsigned short MINUS_KEY_Pressed=		Row_BitValue&MINUS_KEY;
	unsigned short MULT_KEY_Pressed=		Row_BitValue&MULT_KEY;
	unsigned short DIV_KEY_Pressed=			Row_BitValue&DIV_KEY;
	unsigned short CARET_KEY_Pressed=		Row_BitValue&CARET_KEY;
	
	Row_BitValue=_rowread(F4_ROW);
	unsigned short NEG_KEY_Pressed=			Row_BitValue&NEG_KEY;
	unsigned short THREE_KEY_Pressed=		Row_BitValue&THREE_KEY;
	unsigned short SIX_KEY_Pressed=			Row_BitValue&SIX_KEY;
	unsigned short NINE_KEY_Pressed=		Row_BitValue&NINE_KEY;
	unsigned short T_KEY_Pressed=				Row_BitValue&T_KEY;
	
	Row_BitValue=_rowread(F3_ROW);
	unsigned short DECIMAL_KEY_Pressed=	Row_BitValue&DECIMAL_KEY;
	unsigned short TWO_KEY_Pressed=			Row_BitValue&TWO_KEY;
	unsigned short FIVE_KEY_Pressed=		Row_BitValue&FIVE_KEY;
	unsigned short EIGHT_KEY_Pressed=		Row_BitValue&EIGHT_KEY;
	unsigned short RB_KEY_Pressed=			Row_BitValue&RB_KEY;
	unsigned short Z_KEY_Pressed=				Row_BitValue&Z_KEY;
	
	Row_BitValue=_rowread(F2_ROW);
	unsigned short ZERO_KEY_Pressed=		Row_BitValue&ZERO_KEY;
	unsigned short ONE_KEY_Pressed=			Row_BitValue&ONE_KEY;
	unsigned short FOUR_KEY_Pressed=		Row_BitValue&FOUR_KEY;
	unsigned short SEVEN_KEY_Pressed=		Row_BitValue&SEVEN_KEY;
	unsigned short LB_KEY_Pressed=			Row_BitValue&LB_KEY;
	unsigned short Y_KEY_Pressed=				Row_BitValue&Y_KEY;
	
	Row_BitValue=_rowread(F1_ROW);
	unsigned short STO_KEY_Pressed=			Row_BitValue&STO_KEY;
	unsigned short EE_KEY_Pressed=			Row_BitValue&EE_KEY;
	unsigned short EQ_KEY_Pressed=			Row_BitValue&EQ_KEY;
	unsigned short X_KEY_Pressed=				Row_BitValue&X_KEY;
	
	//Sprite_Interval
	if(X_KEY_Pressed)
	{
		if(RB_KEY_Pressed&&*Sprite_Interval<255)
		{
			++*Sprite_Interval;
			printf("%u ",*Sprite_Interval);
		}
		if(LB_KEY_Pressed&&*Sprite_Interval>0)
		{
			--*Sprite_Interval;
			printf("%u ",*Sprite_Interval);
		}
		if(EQ_KEY_Pressed)
		{
			*Sprite_Interval=Default_Sprite_Interval;
			printf("%u ",*Sprite_Interval);
		}
	}
	
	//Projectile_Interval
	if(Y_KEY_Pressed)
	{
		if(*Projectile_Interval<255&&RB_KEY_Pressed)
		{
			++*Projectile_Interval;
			printf("%u ",*Projectile_Interval);
		}
		if(*Projectile_Interval>0&&LB_KEY_Pressed)
		{
			--*Projectile_Interval;
			printf("%u ",*Projectile_Interval);
		}
		if(EQ_KEY_Pressed)
		{
			*Projectile_Interval=Default_Projectile_Interval;
			printf("%u ",*Projectile_Interval);
		}
	}
	
	//Scroll_Interval
	if(Z_KEY_Pressed)
	{
		if(*Scroll_Interval<255&&RB_KEY_Pressed)
		{
			++*Scroll_Interval;
			printf("%u ",*Scroll_Interval);
		}
		if(*Scroll_Interval>0&&LB_KEY_Pressed)
		{
			--*Scroll_Interval;
			printf("%u ",*Scroll_Interval);
		}
		if(EQ_KEY_Pressed)
		{
			*Scroll_Interval=Default_Scroll_Interval;
			printf("%u ",*Scroll_Interval);
		}
	}
	
	//Adjust_Interval
	if(T_KEY_Pressed)
	{
		if(RB_KEY_Pressed&&*Adjust_Interval<255)
		{
			++*Adjust_Interval;
			printf("%u ",*Adjust_Interval);
		}
		if(*Adjust_Interval>0&&LB_KEY_Pressed)
		{
			--*Adjust_Interval;
			printf("%u ",*Adjust_Interval);
		}
		if(T_KEY_Pressed&&EQ_KEY_Pressed)
		{
			*Adjust_Interval=Default_Adjust_Interval;
			printf("%u ",*Adjust_Interval);
		}
	}
	
	//Gray_Index
	if(PLUS_KEY_Pressed)
		OSContrastUp();
	if(MINUS_KEY_Pressed)
		OSContrastDn();	
	if(MULT_KEY_Pressed)
	{
		if(*Gray_Index<127)
		{
			++*Gray_Index;
			GrayAdjust(*Gray_Index);
		}
		printf("%d ",*Gray_Index);
	}
	if(DIV_KEY_Pressed)
	{
		if(*Gray_Index>-28)
		{
			--*Gray_Index;
			GrayAdjust(*Gray_Index);
		}
		printf("%d ",*Gray_Index);
	}
	
	//Current_Shield
	if(EQ_KEY_Pressed&&LB_KEY_Pressed)
		*Current_Shield=Small_Shield;
	if(EQ_KEY_Pressed&&RB_KEY_Pressed)
		*Current_Shield=Magical_Shield;
	
	
	//Weapons_Possessed
	if(!Y_KEY_Pressed&&!Z_KEY_Pressed&&!T_KEY_Pressed)
	{
		if(STO_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed|=Wooden_Sword_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed|=White_Sword_BIN;
			if(TWO_KEY_Pressed)		*Weapons_Possessed|=Magical_Sword_BIN;
			if(THREE_KEY_Pressed)	*Weapons_Possessed|=Boomerang_BIN;
			if(FOUR_KEY_Pressed)	*Weapons_Possessed|=Magical_Boomerang_BIN;
			if(FIVE_KEY_Pressed)
			{
				*Weapons_Possessed|=Bomb_BIN;
				*Bombs_Possessed=*Max_Bombs;
			}
			if(SIX_KEY_Pressed)		*Weapons_Possessed|=Arrow_BIN;
			if(SEVEN_KEY_Pressed)	*Weapons_Possessed|=Silver_Arrow_BIN;
			if(EIGHT_KEY_Pressed)	*Weapons_Possessed|=Bow_BIN;
			if(NINE_KEY_Pressed)	*Weapons_Possessed|=Blue_Candle_BIN;
		}
		else if(EE_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed&=~Wooden_Sword_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed&=~White_Sword_BIN;
			if(TWO_KEY_Pressed)		*Weapons_Possessed&=~Magical_Sword_BIN;
			if(THREE_KEY_Pressed)	*Weapons_Possessed&=~Boomerang_BIN;
			if(FOUR_KEY_Pressed)	*Weapons_Possessed&=~Magical_Boomerang_BIN;
			if(FIVE_KEY_Pressed)	
			{
				*Weapons_Possessed&=~Bomb_BIN;
				*Bombs_Possessed=0;	
			}
			if(SIX_KEY_Pressed)		*Weapons_Possessed&=~Arrow_BIN;
			if(SEVEN_KEY_Pressed)	*Weapons_Possessed&=~Silver_Arrow_BIN;
			if(EIGHT_KEY_Pressed)	*Weapons_Possessed&=~Bow_BIN;
			if(NINE_KEY_Pressed)	*Weapons_Possessed&=~Blue_Candle_BIN;
		}
	}
	if(Y_KEY_Pressed)
	{
		if(STO_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed|=Red_Candle_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed|=Recorder_BIN;
			if(TWO_KEY_Pressed)		*Weapons_Possessed|=Meat_BIN;
			if(THREE_KEY_Pressed)	*Weapons_Possessed|=Letter_BIN;
			if(FOUR_KEY_Pressed)	*Weapons_Possessed|=Blue_Potion_BIN;
			if(FIVE_KEY_Pressed)	*Weapons_Possessed|=Red_Potion_BIN;
			if(SIX_KEY_Pressed)		*Weapons_Possessed|=Magical_Wand_BIN;
			if(SEVEN_KEY_Pressed)	*Weapons_Possessed|=Raft_BIN;
			if(EIGHT_KEY_Pressed)	*Weapons_Possessed|=Magical_Book_BIN;
			if(NINE_KEY_Pressed)	*Weapons_Possessed|=Blue_Ring_BIN;
		}
		else if(EE_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed&=~Red_Candle_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed&=~Recorder_BIN;
			if(TWO_KEY_Pressed)		*Weapons_Possessed&=~Meat_BIN;
			if(THREE_KEY_Pressed)	*Weapons_Possessed&=~Letter_BIN;
			if(FOUR_KEY_Pressed)	*Weapons_Possessed&=~Blue_Potion_BIN;
			if(FIVE_KEY_Pressed)	*Weapons_Possessed&=~(unsigned long)Red_Potion_BIN; //Bugfix
			if(SIX_KEY_Pressed)		*Weapons_Possessed&=~Magical_Wand_BIN;
			if(SEVEN_KEY_Pressed)	*Weapons_Possessed&=~Raft_BIN;
			if(EIGHT_KEY_Pressed)	*Weapons_Possessed&=~Magical_Book_BIN;
			if(NINE_KEY_Pressed)	*Weapons_Possessed&=~Blue_Ring_BIN;
		}
	}
	if(Z_KEY_Pressed)
	{
		if(STO_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed|=Red_Ring_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed|=Ladder_BIN;
			if(TWO_KEY_Pressed)		*Weapons_Possessed|=Magical_Key_BIN;
			if(THREE_KEY_Pressed)	*Weapons_Possessed|=Power_Bracelet_BIN;
			if(FOUR_KEY_Pressed)	*Weapons_Possessed|=Triforce_1_BIN;
			if(FIVE_KEY_Pressed)	*Weapons_Possessed|=Triforce_2_BIN;
			if(SIX_KEY_Pressed)		*Weapons_Possessed|=Triforce_3_BIN;
			if(SEVEN_KEY_Pressed)	*Weapons_Possessed|=Triforce_4_BIN;
			if(EIGHT_KEY_Pressed)	*Weapons_Possessed|=Triforce_5_BIN;
			if(NINE_KEY_Pressed)	*Weapons_Possessed|=Triforce_6_BIN;
		}
		else if(EE_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed&=~Red_Ring_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed&=~Ladder_BIN;
			if(TWO_KEY_Pressed)		*Weapons_Possessed&=~Magical_Key_BIN;
			if(THREE_KEY_Pressed)	*Weapons_Possessed&=~Power_Bracelet_BIN;
			if(FOUR_KEY_Pressed)	*Weapons_Possessed&=~Triforce_1_BIN;
			if(FIVE_KEY_Pressed)	*Weapons_Possessed&=~Triforce_2_BIN;
			if(SIX_KEY_Pressed)		*Weapons_Possessed&=~Triforce_3_BIN;
			if(SEVEN_KEY_Pressed)	*Weapons_Possessed&=~Triforce_4_BIN;
			if(EIGHT_KEY_Pressed)	*Weapons_Possessed&=~Triforce_5_BIN;
			if(NINE_KEY_Pressed)	*Weapons_Possessed&=~Triforce_6_BIN;
		}
	}
	if(T_KEY_Pressed)
	{
		if(STO_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed|=Triforce_7_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed|=Triforce_8_BIN;
		}
		else if(EE_KEY_Pressed)
		{
			if(ZERO_KEY_Pressed)	*Weapons_Possessed&=~Triforce_7_BIN;
			if(ONE_KEY_Pressed)		*Weapons_Possessed&=~Triforce_8_BIN;
		}
	}
	
	if(EQ_KEY_Pressed)
	{
		if(STO_KEY_Pressed)
		{
			*Weapons_Possessed=0xFFFFFFFF;
			*Bombs_Possessed=*Max_Bombs;
			Dungeon_Maps_Compasses[0]=0x01FF;
			Dungeon_Maps_Compasses[1]=0x01FF;
		}
		if(EE_KEY_Pressed)
		{
			*Weapons_Possessed=0x00000000;
			*Bombs_Possessed=0;
			Dungeon_Maps_Compasses[0]=0;
			Dungeon_Maps_Compasses[1]=0;
		}
	}
	
	//Heart_Containers
	if(STO_KEY_Pressed)
	{
		if(LB_KEY_Pressed&&*Heart_Containers>1)
		{
			--*Heart_Containers;
			if(CARET_KEY_Pressed)
				printf("%u ",*Heart_Containers);
		}
		if(RB_KEY_Pressed&&*Heart_Containers<16)
		{
			++*Heart_Containers;
			if(CARET_KEY_Pressed)
				printf("%u ",*Heart_Containers);
		}
	}
	
	//Hearts
	if(EE_KEY_Pressed)
	{
		if(LB_KEY_Pressed&&*Hearts>0)
		{
			--*Hearts;
			if(CARET_KEY_Pressed)
				printf("%u ",*Hearts);
		}
		if(RB_KEY_Pressed)
		{
			++*Hearts;
			if(CARET_KEY_Pressed)
				printf("%u ",*Hearts);
		}
	}
	if(*Hearts>*Heart_Containers*2)
		*Hearts=*Heart_Containers*2;
	
	//Rupies_Possessed
	if(DECIMAL_KEY_Pressed)
	{
		if(LB_KEY_Pressed&&*Rupies_Possessed>0)
			--*Rupies_Possessed;
		if(RB_KEY_Pressed&&*Rupies_Possessed<255)
			++*Rupies_Possessed;
		if(EE_KEY_Pressed)
			*Rupies_Possessed=0;
		if(STO_KEY_Pressed)
			*Rupies_Possessed=255;
	}
	
	//Keys_Possessed
	if(NEG_KEY_Pressed)
	{
		if(LB_KEY_Pressed&&*Keys_Possessed>0)
			--*Keys_Possessed;
		if(RB_KEY_Pressed&&*Keys_Possessed<99)
			++*Keys_Possessed;
		if(EE_KEY_Pressed)
			*Keys_Possessed=0;
		if(STO_KEY_Pressed)
			*Keys_Possessed=99;
	}
	
	//Bombs_Possessed
	if(ENTER_KEY_Pressed)
	{
		if(LB_KEY_Pressed&&*Bombs_Possessed)
			--*Bombs_Possessed;
		if(RB_KEY_Pressed&&*Bombs_Possessed<*Max_Bombs)
			++*Bombs_Possessed;
		if(EE_KEY_Pressed)
			*Bombs_Possessed=0;
		if(STO_KEY_Pressed)
			*Bombs_Possessed=*Max_Bombs;
		if(*Bombs_Possessed)
			*Weapons_Possessed|=Bomb_BIN;
		else
			*Weapons_Possessed&=~Bomb_BIN;
	}
}

//(Only Appears Once)
void Scroll_Screen(unsigned char Scroll_Direction,unsigned char Scroll_Index)
{	//Scroll_Index is used to know which tiles/lines to load into non-visible memory
	unsigned char i=0;
	unsigned long offset;
	unsigned long *src_1=NULL;
	unsigned long *src_2,*dest_1,*dest_2;
	
	switch (Scroll_Direction)
	{
		case UP :
		{
			dest_1=(unsigned long*)((unsigned long)Planes[2]-30);
			dest_2=(unsigned long*)((unsigned long)Planes[3]-30);
			offset=2940-(Scroll_Index<<5)+(Scroll_Index<<1);
			src_1=(unsigned long*)((unsigned long)Planes[6]+offset);
			src_2=(unsigned long*)((unsigned long)Planes[7]+offset);
			for(i=5;i;i--)
			{
				*dest_1++=*src_1++;		//Copy source line to roof of dest
				*dest_2++=*src_2++;
			}
			ScrollDown160_M((unsigned short*)((unsigned long)Planes[2]-30),LCD_h);
			ScrollDown160_M((unsigned short*)((unsigned long)Planes[3]-30),LCD_h);
			break;
		}
		case LEFT :
		{
			if((Scroll_Index&0x0F)==0)
			{
				dest_1=(unsigned long*)((unsigned long)Planes[2]-2);
				dest_2=(unsigned long*)((unsigned long)Planes[3]-2);
				offset=(9-(Scroll_Index>>4))<<1;
				src_1=(unsigned long*)((unsigned long)Planes[6]+offset);
				src_2=(unsigned long*)((unsigned long)Planes[7]+offset);
				for(i=99;i;i--)
				{
					*(unsigned short*)dest_1=*(unsigned short*)src_1;
					*(unsigned short*)dest_2=*(unsigned short*)src_2;
					(unsigned long)dest_1+=30;
					(unsigned long)dest_2+=30;
					(unsigned long)src_1+=30;
					(unsigned long)src_2+=30;
				}
			}
			ScrollRight176x99_M((unsigned short*)((unsigned long)Planes[2]));
			ScrollRight176x99_M((unsigned short*)((unsigned long)Planes[3]));
			break;
		}
		case DOWN :
		{
			dest_1=(unsigned long*)((unsigned long)Planes[2]+2970);
			dest_2=(unsigned long*)((unsigned long)Planes[3]+2970);
			offset=(Scroll_Index<<5)-(Scroll_Index<<1);
			src_1=(unsigned long*)((unsigned long)Planes[6]+offset);
			src_2=(unsigned long*)((unsigned long)Planes[7]+offset);
			for(i=5;i;i--)
			{
				*dest_1++=*src_1++;
				*dest_2++=*src_2++;
			}
			ScrollUp160_M((unsigned short*)Planes[2],LCD_h);
			ScrollUp160_M((unsigned short*)Planes[3],LCD_h);
			break;
		}
		case RIGHT :
		{
			if((Scroll_Index&0x0F)==0)
			{
				dest_1=(unsigned long*)((unsigned long)Planes[2]+20);
				dest_2=(unsigned long*)((unsigned long)Planes[3]+20);
				offset=(Scroll_Index>>4)<<1;
				src_1=(unsigned long*)((unsigned long)Planes[6]+offset);
				src_2=(unsigned long*)((unsigned long)Planes[7]+offset);
				for(i=99;i;i--)
				{
					*(unsigned short*)dest_1=*(unsigned short*)src_1;
					*(unsigned short*)dest_2=*(unsigned short*)src_2;
					(unsigned long)dest_1+=30;
					(unsigned long)dest_2+=30;
					(unsigned long)src_1+=30;
					(unsigned long)src_2+=30;
				}
			}
			ScrollLeft176x99_M((unsigned short*)Planes[2]);
			ScrollLeft176x99_M((unsigned short*)Planes[3]);
			break;
		}
	}
}

///Appears only once in EXE
BOOL Collision_Detected(unsigned char Link_Direction,unsigned char Link_Screen_Index,BOOL x_half,BOOL y_half,unsigned char *Collision_Detection_Buffer)
{
	unsigned char North_Tile=Collision_Detection_Buffer[Link_Screen_Index-Screen_w];
	unsigned char NorthEast_Tile=Collision_Detection_Buffer[Link_Screen_Index-Screen_w+1];
	unsigned char West_Tile=Collision_Detection_Buffer[Link_Screen_Index-1];
	unsigned char Center_Tile=Collision_Detection_Buffer[Link_Screen_Index];
	unsigned char East_Tile=Collision_Detection_Buffer[Link_Screen_Index+1];
	unsigned char SouthWest_Tile=Collision_Detection_Buffer[Link_Screen_Index+Screen_w-1];
	unsigned char South_Tile=Collision_Detection_Buffer[Link_Screen_Index+Screen_w];
	unsigned char SouthEast_Tile=Collision_Detection_Buffer[Link_Screen_Index+Screen_w+1];
	switch (Link_Direction)
	{
		case UP :
		{
			switch (y_half)
			{
				case FALSE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Aligned, Horizontally Aligned
						{
							if((Center_Tile==R_SE||Center_Tile==D_SE_RIP)||	//Special- Type III
								(North_Tile>=BW_NW&&North_Tile<=WW_4_D)||			//Special- Type VI
								(North_Tile>=N_6_D&&North_Tile<=SS_7_D)||			//Special- Type V
								(North_Tile>=N_7_D&&North_Tile<=SS_8_D))			//Special- Type VII
								return TRUE;
							break;
						}
						case TRUE :	//Vertically Aligned, Horizontally Non-Aligned
						{
							if((East_Tile==R_SW||East_Tile==D_SW_RIP)||					//Special- Type I
								(Center_Tile==R_SE||Center_Tile==R_SE_RIP)||			//Special- Type III
								(North_Tile>=BW_NW&&North_Tile<=WW_4_D)||					//Special- Type V
								(NorthEast_Tile>=BW_NW&&NorthEast_Tile<=WW_4_D))	//Special- Type V
								return TRUE;
							break;
						}
					}
					break;
				}
				case TRUE :	//Vertically Non-Aligned, Horizontally Aligned
				{
					switch (x_half)
					{
						case FALSE :
						{
							if((Center_Tile>=D_W&&Center_Tile<=WW_7)||			//Fully Non-Walkable
								(Center_Tile==R_SW||Center_Tile==R_SW_RIP)||	//Special- Type II
								(Center_Tile==T_SW))													//Unique I
								return TRUE;
							break;
						}
						case TRUE :	//Vertically Non-Aligned, Horizontally Non-Aligned
						{
							if((Center_Tile>=D_W&&Center_Tile<=WW_7)||			//Fully Non-Walkable
								(East_Tile>=D_W&&East_Tile<=WW_7)||						//Fully Non-Walkable
								(Center_Tile==R_SW||Center_Tile==R_SW_RIP)||	//Special- Type II
								(East_Tile==R_SE||East_Tile==R_SE_RIP)||			//Special- Type III
								(Center_Tile==T_SW))													//Unique I
								return TRUE;
							break;
						}
					}
					break;
				}
			}
			break;
		}
		case LEFT :
		{
			switch (y_half)
			{
				case FALSE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Aligned, Horizontally Aligned
						{
							if((West_Tile>=D_W&&West_Tile<=WW_7)||			//Fully Non-Walkable
								(West_Tile==R_SW||West_Tile==R_SW_RIP)||	//Special- Type II
								(West_Tile>=R_NE&&West_Tile<=D_NE_RIP)||	//Special- Type IV
								(West_Tile>=BW_NW&&West_Tile<=WW_4_D)||		//Special- Type V
								(West_Tile==T_SW))												//Unique I
								return TRUE;
							break;
						}
						case TRUE :	//Vertically Aligned, Horizontally Non-Aligned
						{
							if((Center_Tile==R_SE||Center_Tile==R_SE_RIP)||	//Special- Type III
								(Center_Tile>=N_6_D&&Center_Tile<=SS_7_D)||		//Special- Type VI
								(Center_Tile==T_NE))													//Unique II
								return TRUE;
							break;
						}
					}
					break;
				}
				case TRUE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Non-Aligned, Horizontally Aligned
						{
							if((SouthWest_Tile>=D_W&&SouthWest_Tile<=WW_7)||			//Fully Non-Walkable
								(SouthWest_Tile==R_NW||SouthWest_Tile==D_NW_RIP)||	//Special- Type I
								(SouthWest_Tile==R_SW||SouthWest_Tile==R_SW_RIP)||	//Special- Type II
								(SouthWest_Tile==R_SE||SouthWest_Tile==R_SE_RIP)||	//Special- Type III
								(West_Tile>=BW_NW&&West_Tile<=WW_4_D)||							//Special- Type V
								(SouthWest_Tile>=BW_NW&&SouthWest_Tile<=WW_4_D)||		//Special- Type V
								(SouthWest_Tile==T_SW))															//Unique I
								return TRUE;
							break;
						}
						case TRUE :	//Vertically Non-Aligned, Horizontally Non-Aligned
						{
							if((South_Tile>=R_NE&&South_Tile<=D_NE_RIP)||	//Special- Type IV
								(Center_Tile>=N_6_D&&Center_Tile<=SS_7_D)||	//Special- Type VI
								(South_Tile>=N_6_D&&South_Tile<=SS_7_D)||		//Special- Type VI
								(South_Tile==T_NE))													//Unique II
								return TRUE;
							break;
						}
					}
					break;
				}
			}
			break;
		}
		case DOWN :
		{
			switch (y_half)
			{
				case FALSE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Aligned, Horizontally Aligned
						{
							if((South_Tile>=D_W&&South_Tile<=WW_7)||			//Fully Non-Walkable
								(South_Tile>=R_NW&&South_Tile<=D_NW_RIP)||	//Special- Type I
								(South_Tile>=N_6_D&&South_Tile<=SS_7_D)||		//Special- Type VI
								(South_Tile>=N_7_D&&South_Tile<=SS_8_D))		//Special- Type VII
								return TRUE;
							break;
						}
						case TRUE	 :	//Vertically Aligned, Horizontally Non-Aligned
						{
							if((South_Tile>=D_W&&South_Tile<=WW_7)||						//Fully Non-Walkable
								(SouthEast_Tile>=D_W&&SouthEast_Tile<=WW_7)||			//Fully Non-Walkable
								(South_Tile>=R_NW&&South_Tile<=D_NW_RIP)||				//Special- Type I
								(SouthEast_Tile>=R_NE&&SouthEast_Tile<=D_NE_RIP))	//Special- Type IV
								return TRUE;
							break;
						}
					}
					break;
				}
				case TRUE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Non-Aligned, Horizontally Aligned
						{
							if((South_Tile>=R_NE&&South_Tile<=D_NE_RIP)||	//Special- Type IV
								(South_Tile==HALF_S))												//Unique III
								return TRUE;
							break;
						}
						case TRUE :	//Vertically Non-Aligned, Horizontally Non-Aligned
							{
							if((SouthEast_Tile>=R_NW&&SouthEast_Tile<=D_NW_RIP)||	//Special- Type I
								(South_Tile>=R_NE&&South_Tile<=D_NE_RIP)||					//Special- Type IV
								(South_Tile==HALF_S||SouthEast_Tile==HALF_S))				//Unique III
								return TRUE;
							break;
						}
					}
					break;
				}
			}
			break;
		}
		case RIGHT :
		{
			switch (y_half)
			{
				case FALSE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Aligned, Horizontally Aligned
						{
							if((East_Tile>=D_W&&East_Tile<=WW_7)||			//Fully Non-Walkable
								(East_Tile>=R_NW&&East_Tile<=D_NW_RIP)||	//Special- Type I
								(East_Tile==R_SE||East_Tile==R_SE_RIP)||	//Special- Type III
								(East_Tile>=R_NE&&East_Tile<=D_NE_RIP)||	//Special- Type IV
								(East_Tile>=BW_NW&&East_Tile<=WW_4_D))		//Special- Type V
								return TRUE;
							break;
							}
						case TRUE :	//Vertically Aligned, Horizontally Non-Aligned
						{
							if((East_Tile==R_SW||East_Tile==R_SW_RIP)||	//Special- Type II
								(East_Tile>=N_7_D&&East_Tile<=SS_8_D)||		//Special- Type VII
								(East_Tile==T_SW))												//Unique I
								return TRUE;
							break;
						}
					}
					break;
				}
				case TRUE :
				{
					switch (x_half)
					{
						case FALSE :	//Vertically Non-Aligned, Horizontally Aligned
						{
							if((SouthEast_Tile>=D_W&&SouthEast_Tile<=WW_7)||			//Fully Non-Walkable
								(SouthEast_Tile==R_SW||SouthEast_Tile==R_SW_RIP)||	//Special- Type II
								(SouthEast_Tile==R_SE||SouthEast_Tile==R_SE_RIP)||	//Special- Type III
								(SouthEast_Tile>=R_NE&&SouthEast_Tile<=D_NE_RIP)||	//Special- Type IV
								(East_Tile>=BW_NW&&East_Tile<=WW_4_D)||							//Special- Type V
								(SouthEast_Tile>=BW_NW&&SouthEast_Tile<=WW_4_D))		//Special- Type V
								return TRUE;
							break;
						}
						case TRUE :	//Vertically Non-Aligned, Horizontally Non-Aligned
						{
							if((SouthEast_Tile>=R_NW&&SouthEast_Tile<=D_NW_RIP)||	//Special- Type I
								(East_Tile>=N_7_D&&East_Tile<=SS_8_D)||							//Special- Type VII
								(SouthEast_Tile>=N_7_D&&SouthEast_Tile<=SS_8_D)||		//Special- Type VII
								(SouthEast_Tile==T_SW))															//Unique I
								return TRUE;
							break;
						}
					}
					break;
				}
			}
			break;
		}
	}
	return FALSE;
}

void Open_Curtains(volatile unsigned long *Global_Clock_Ptr)
{
	unsigned char i=0;
	unsigned char Curtain_Index=0;
	unsigned long Curtain_Clock_Reference=*Global_Clock_Ptr;
	unsigned short Curtain_Mask[9]={0x7FFF,0x7FFF,0x7FFF,0x7FFF,0x7FFF,0x7FFF,0x7FFF,0x7FFF,0x7FFF};
	
	memset(Planes[2],0xFF,2970);
	memset(Planes[3],0xFF,2970);
	FastCopyScreen_M(Planes[2],Planes[0]);
	FastCopyScreen_M(Planes[3],Planes[1]);
	while(*Global_Clock_Ptr-Curtain_Clock_Reference<100) {}
	
	for(Curtain_Index=0;Curtain_Index<LCD_w/2;++Curtain_Index)
	{
		while(*Global_Clock_Ptr-Curtain_Clock_Reference<4) {}
		Curtain_Clock_Reference=*Global_Clock_Ptr;
		for(i=0;i<99;i+=9)
		{
			Replenish_Curtain_BG(LCD_w/2-1-Curtain_Index,i,Curtain_Mask);
			Replenish_Curtain_BG(LCD_w/2+Curtain_Index,i,Curtain_Mask);
		}
		FastCopyScreen_M(Planes[2],Planes[0]);
		FastCopyScreen_M(Planes[3],Planes[1]);
	}
}

//Covers up BurnBushes, Bombwalls, Pushblock entrances and implements Overworld Ladder_Usage
void Cover_Undiscovered_Pathways(unsigned char World_Index,unsigned short *Discovered_Pathways,unsigned char (*Overworld_Pathways)[4],
	unsigned char (*Push_Blocks)[128][8],unsigned char *Collision_Detection_Buffer,unsigned char *Screen_Tiles_Buffer)
{
	BOOL Pathway_Discovered=(Discovered_Pathways[World_Index/World_w]>>(World_Index%World_w))&0x01;
	BOOL Ladder_Usage=Overworld_Pathways[World_Index][0]&0x80;
	unsigned char Secret_Type=Overworld_Pathways[World_Index][0]&0x7F;
	unsigned char Index=Overworld_Pathways[World_Index][1];
	unsigned char i=0;
	
	if(Ladder_Usage)
	{
		for(i=0;i<Screen_w*Screen_h;++i)
		{
			if(Collision_Detection_Buffer[i]>=W_0 && Collision_Detection_Buffer[i]<=W_S)
				Collision_Detection_Buffer[i]=D_W;
		}
	}
	if(Secret_Type&&!Pathway_Discovered)
	{
		Screen_Tiles_Buffer[Index]=Secret_Type;
		Collision_Detection_Buffer[Index]=Secret_Type;
	}
	Index=Push_Blocks[0][World_Index][3];
	if(!Pathway_Discovered&&Index)
		Screen_Tiles_Buffer[Index]=Push_Blocks[0][World_Index][4];
	return;
}