// C Source File
// Created 8/22/2003; 11:19:39 AM

#define NO_EXIT_SUPPORT		///Include?
#define EXECUTE_IN_GHOST_SPACE	///Include?

#include <tigcclib.h>		// Include All Header Files

#include "definitions.h"
#include "DLL_definitions.h"

///PROBLEMS
//Risk of Garbage Collection after "Save & Quit" selected from ExitMenu. Graphics become mangled and program restart required.

///NEXT STEPS
///Implement fairy ponds
///Implement DI_Power (Triforce of Power)
///Max enemies will need to be 16 (patra, "come to life" statues)
///Implement start screen story (now items are available)

///NOTES
///While tornado is present, multiple recorder blows will shift the level again
///Enemies drop different items depending on what you use to kill them. (ex. bombs give bombs)
///Dungeon shopkeeper as enemy? (needs to be able to be attacked, which activates the flames to attack)
///Once dungeon enemies are implemented, revisit "Key in Enemy" tags in Dat3

///IMPROVEMENTS
///Item_Data does not need to include "item" information since this is already known. maybe define an item[] array for this. Also, reduce max items to 8.
///small enemy graphics could be centered to ease collision detection
///Rewrite core functions (speed + size optimization). Think about the use of macros. Lionel Debroux's optimizations: ptr++ vs. foo[i] in for loops.
///Think about how the planes should be implemented/accessed. Also how drawing functions should behave (Plane_Bitflag?)
///DLL does not unpack from TTArchive properly. Therefore, two handles are used and two memory allocations are necessary. Fix?
///Link Scroll flashes link (related to replenish_BG)

///IDEAS
///White/red ring could give Link an ora. (or come up with another idea)
///Method of warning player of low life remaining?
///Save states?

	unsigned char* Planes[9];
	
	
	//288
	unsigned short Paused_GFX[3][48]=
	{
		{ //[0] "PA"
			0xC000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0xC000,	//[0] Mask
			0x0000,0x0000,0x1FFF,0x2000,0x4F04,0x488A,0x4891,0x4891,0x4F1F,0x4811,0x4811,0x4811,0x4000,0x2000,0x1FFF,0x0000,	//[1] Light
			0x0000,0x1FFF,0x3FFF,0x6000,0x4F86,0x4CCF,0x4CD9,0x4CD9,0x4F9F,0x4C19,0x4C19,0x4C19,0x6000,0x3FFF,0x1FFF,0x0000		//[2] Dark
		},
		{ //[1] "US"
			0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,	//[0] Mask
			0x0000,0x0000,0xFFFF,0x0000,0x2238,0x2244,0x2240,0x2230,0x2208,0x2204,0x2244,0x1C38,0x0000,0x0000,0xFFFF,0x0000,	//[1] Light
			0x0000,0xFFFF,0xFFFF,0x0000,0x333C,0x3366,0xB360,0xB338,0xB30C,0xB306,0xB366,0x9E3C,0x0000,0xFFFF,0xFFFF,0x0000		//[2] Dark
		},
		{ //[2] "ED"
			0x0003,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0x0003,	//[0] Mask
			0x0000,0x0000,0xFFF8,0x0004,0xF382,0x8242,0x8222,0xF222,0x8222,0x8222,0x8242,0xF382,0x0002,0x0004,0xFFF8,0x0000,	//[1] Light
			0x0000,0xFFF8,0xFFFC,0x0006,0xFBC2,0xC362,0xC332,0xFB32,0xC332,0xC332,0xC362,0xFBC2,0x0006,0xFFFC,0xFFF8,0x0000		//[2] Dark
		}
	};
	
void Sprite16_OR_Mh(unsigned short x,unsigned short y,unsigned short h,unsigned short OR_Value,unsigned short Plane_Bitflag)
{
    register long           addr;
    register long           offset   = (y<<5)-(y<<1)+((x>>3)&0x1e);
    register unsigned short cnt      = 16-(x&15);
	unsigned char i,j;
	
	for(i=0;i<=7;++i)
	{
		if(Plane_Bitflag&(1<<i))
		{
			addr=(unsigned long)(Planes[i]+offset);
			for(j=0;j<h;++j,addr+=30)
        *(long*)addr|=(long)(OR_Value)<<cnt;
		}
	}
}

void Sprite16_AND_Mh(unsigned short x,unsigned short y,unsigned short h,unsigned short AND_Value,unsigned short Plane_Bitflag)
{
    register long           addr;
    register long           offset   = (y<<5)-(y<<1)+((x>>3)&0x1e);
    register unsigned short cnt      = 16-(x&15);
	unsigned char i,j;
	
	for(i=0;i<=7;++i)
	{
		if(Plane_Bitflag&(1<<i))
		{
			addr=(unsigned long)(Planes[i]+offset);
			for(j=0;j<h;++j,addr+=30)
        *(long*)addr&=~((long)~AND_Value<<cnt);
		}
	}
}
	
void Replenish_BG_16(unsigned char x,unsigned char y,unsigned short* mask)
{
	unsigned char i;
	unsigned long maskval;
	unsigned long temp_1;
	unsigned long temp_2;
	unsigned char cnt=16-(x&15);
	unsigned long offset=(y<<5)-(y<<1)+((x>>3)&0x1E);
	unsigned long BG_addr_1;
	unsigned long BG_addr_2;
	unsigned long Current_addr_1;
	unsigned long Current_addr_2;
	
	BG_addr_1=(unsigned long)Planes[6]+offset;
	BG_addr_2=(unsigned long)Planes[7]+offset;
	Current_addr_1=(unsigned long)Planes[2]+offset;
	Current_addr_2=(unsigned long)Planes[3]+offset;
	for(i=0;i<9;++i)
	{
		maskval=((unsigned long)(~mask[i]))<<cnt;
		temp_1=*(long*)BG_addr_1;
		temp_2=*(long*)BG_addr_2;
		temp_1&=maskval;
		temp_2&=maskval;
		maskval=~maskval;
		*(long*)Current_addr_1&=maskval;
		*(long*)Current_addr_2&=maskval;
		*(long*)Current_addr_1|=temp_1;
		*(long*)Current_addr_2|=temp_2;
		BG_addr_1+=30;
		BG_addr_2+=30;
		Current_addr_1+=30;
		Current_addr_2+=30;
	}
	return;
}

//Shift a bitflag by one each loop instead of calculating it three times per loop
void GraySprite16_BLIT_M(unsigned short x,unsigned short y,unsigned short* Sprite,unsigned short Plane_Bitflag)
{
  register unsigned long offset = (y<<5)-(y<<1)+((x>>3)&0x1e);
  register unsigned long addr1;
  register unsigned long addr2;
  register unsigned short cnt = 16-(x&15);
  register unsigned long maskval = ~((unsigned long)0x0000FFC0<<cnt);
	unsigned short* Sprite_Backup=Sprite;
	unsigned char i,j;
	
	for(i=0;i<=3;++i)
	{
		if(Plane_Bitflag&(1<<i))
		{
			addr1=(unsigned long)(Planes[i<<1]+offset);
			addr2=(unsigned long)(Planes[(i<<1)+1]+offset);
			Sprite=Sprite_Backup;
			for(j=0;j<9;++j,addr1+=30,addr2+=30)
			{
        *(long*)addr1&=maskval;
        *(long*)addr2&=maskval;
        *(long*)addr1|=(long)(*Sprite)<<cnt;
        *(long*)addr2|=(long)(*(Sprite+9))<<cnt;	//Should not add 9 each loop. Do it only once!
        ++Sprite;
			}
		}
	}
}

void GraySprite32_BLIT_Mh(unsigned short x,unsigned short y,short h,unsigned long* Sprite,unsigned short Plane_Bitflag)
{
  register unsigned long offset = (y<<5)-(y<<1)+((x>>3)&0x1e);
  register unsigned long addr1;
  register unsigned long addr2;
  register unsigned short cnt  = x&15;
  register unsigned short ccnt = 32-cnt;
	unsigned long* Sprite_Backup=Sprite;
	register unsigned long  data;
	register unsigned long  maskval1 = ~(0xFFFFFFFF>>cnt);
	register unsigned long  maskval2 = ~(0xFFFFFFFF<<ccnt);
	unsigned char i,j;
	
	for(i=0;i<=3;++i)
	{
		if(Plane_Bitflag&(1<<i))
		{
			addr1=(unsigned long)(Planes[i<<1]+offset);
			addr2=(unsigned long)(Planes[(i<<1)+1]+offset);
			Sprite=Sprite_Backup;
			
	    for (j=0;j<h;++j,addr1+=30,addr2+=30)
	    {
	        *(long*)addr1&=maskval1;
	        *(long*)(addr1+4)&=maskval2;
	        data=*Sprite;
	        *(long*)addr1|=(data>>cnt);
	        *(long*)(addr1+4)|=(data<<ccnt);
	
	        *(long*)addr2&=maskval1;
	        *(long*)(addr2+4)&=maskval2;
	        data=*(Sprite+h);
	        *(long*)addr2|=(data>>cnt);
	        *(long*)(addr2+4)|=(data<<ccnt);
	        ++Sprite;
	    }
		}
	}
}

void GraySprite16_MASK_M(unsigned char x,unsigned char y,unsigned short* Sprite,unsigned short Plane_Bitflag)
{
    register long           offset = (y<<5)-(y<<1)+((x>>3)&0x1e);
    register long           addr1;
    register long           addr2;
    register unsigned short cnt    = 16-(x&15);
	unsigned short* Sprite_0;
	unsigned short* Sprite_1;
	unsigned char i,j;
	
	for(i=0;i<=3;++i)
	{
		if(Plane_Bitflag&(1<<i))
		{
			addr1=(unsigned long)(Planes[i<<1]+offset);
			addr2=(unsigned long)(Planes[(i<<1)+1]+offset);
			Sprite_0=Sprite;
			Sprite_1=Sprite;
			for(j=0;j<9;++j,addr1+=30,addr2+=30)
			{
        *(long*)addr1&=~((long)~(*Sprite_0)<<cnt);
        *(long*)addr2&=~((long)~(*Sprite_1)<<cnt);
        *(long*)addr1|=(long)(*(Sprite_0+9))<<cnt;
        *(long*)addr2|=(long)(*(Sprite_1+18))<<cnt;
        ++Sprite_0;
        ++Sprite_1;
			}
		}
	}
}

void GraySprite16_MASK_Mh(unsigned char x,unsigned char y,unsigned char h,unsigned short* Sprite,unsigned short Plane_Bitflag)
{
    register long           offset = (y<<5)-(y<<1)+((x>>3)&0x1e);
    register long           addr1;
    register long           addr2;
	unsigned short* Sprite_0;
	unsigned short* Sprite_1;
    register unsigned short cnt    = 16-(x&15);
	unsigned char i,j;
	
	for(i=0;i<=3;++i)
	{
		if(Plane_Bitflag&(1<<i))
		{
			addr1=(unsigned long)(Planes[i<<1]+offset);
			addr2=(unsigned long)(Planes[(i<<1)+1]+offset);
			Sprite_0=Sprite;
			Sprite_1=Sprite;
			for(j=0;j<h;++j,addr1+=30,addr2+=30)
			{
        *(long*)addr1&=~((long)~(*Sprite_0)<<cnt);
        *(long*)addr2&=~((long)~(*Sprite_1)<<cnt);
        *(long*)addr1|=(long)(*(Sprite_0+h))<<cnt;
        *(long*)addr2|=(long)(*(Sprite_1+(h<<1)))<<cnt;
        ++Sprite_0;
        ++Sprite_1;
			}
		}
	}
}
	
	///Crucial Function for speed when enemies implemented. Think through carefully.
	//Currently requires pre-processing. Objects coordinates are center of object. (shifts and additions only)
	BOOL Object_Collision(unsigned char Object_x,unsigned char Object_y,unsigned char Link_x,unsigned char Link_y)
	{
		if(Link_x+Sprite_w>Object_x && Link_x<Object_x && Link_y+Sprite_h>Object_y && Link_y<Object_y)
			return TRUE;
		else
			return FALSE;
	}


	BOOL Object_Within_Boundaries(unsigned char Object_Direction,unsigned char Object_x,unsigned char Object_y,
		unsigned char North_Limit,unsigned char West_Limit,unsigned char South_Limit,unsigned char East_Limit)
	{
		switch(Object_Direction)
		{
			case UP :
			{
				if(Object_y<North_Limit)
					return FALSE;
				break;
			}
			case LEFT :
			{
				if(Object_x<West_Limit)
					return FALSE;
				break;
			}
			case DOWN :
			{
				if(Object_y>South_Limit)
					return FALSE;
				break;
			}
			case RIGHT :
			{
				if(Object_x>East_Limit)
					return FALSE;
				break;
			}
		}
		return TRUE;
	}


/*
void File_Abort(unsigned char File_Stage,HANDLE h)	//Static to EXE
{
	if(File_Stage>7)
		EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
	if(File_Stage>0)
		SymDel(SYMSTR("LoZ_Dat1"));
	if(File_Stage>8)
		EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
	if(File_Stage>2)
		SymDel(SYMSTR("LoZ_Dat2"));
	if(File_Stage>9)
		EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
	if(File_Stage>4)
		SymDel(SYMSTR("LoZ_Dat3"));
	if(File_Stage>10)
		EM_moveSymFromExtMem(SYMSTR("LofZ_DLL"),HS_NULL);
	if(File_Stage>6)
		SymDel(SYMSTR("LofZ_DLL"));
	if(File_Stage==0||File_Stage==2||File_Stage==4||File_Stage==6)
		HeapFree(h);
	return;
}*/


void Print_File_Status(unsigned char String,unsigned short (*Character)[27],unsigned char (*File_Strings)[32])
{
	unsigned char i;
	Clear_File_Status((unsigned char*)(Planes[0]+2790),0xFF,210);
	Clear_File_Status((unsigned char*)(Planes[1]+2790),0xFF,210);
	for(i=0;i<32;++i)
		Print_Character(2+5*i,94,Character[File_Strings[String][i]],Gray_Planes_BIN);
	return;
}

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// GLOBAL VARIABLES

volatile BOOL Game_In_Progress=FALSE;
volatile unsigned long Game_Clock=0;
volatile unsigned long Global_Clock=0;


//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// INTERRUPT FOR CLOCKS

DEFINE_INT_HANDLER(CLOCK_HANDLER)
{
  if(Game_In_Progress)
  	++Game_Clock;
  ++Global_Clock;
}

//,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`,`
// MAIN FUNCTION

void _main(void)
{
	unsigned char File_Stage=0;
	SYM_ENTRY *sym;
	HANDLE h=H_NULL;
	HANDLE h_DLL=H_NULL;
	unsigned char *Unpacked;
	unsigned char *Packed;
	unsigned char Decompress=Decompress_All;
	unsigned long Flash_Required=Data1_Size+Data2_Size+Data3_Size+DLL_Size+SaveFile_Size;
	unsigned long Flash_Before_GC=0;
	unsigned long Flash_After_GC=0;
	BOOL Decompression_Key_Released=TRUE;
	BOOL SaveFile_Active=FALSE;
	unsigned char i=0;
	unsigned char j=0;
	unsigned char k=0;
	unsigned char x=0;
	unsigned char y=0;
	signed char offset=0;
	signed short dx=0;
	signed short dy=0;
	unsigned char *ptr=NULL;
	unsigned char *ptr2=NULL;
//	unsigned char *ptr3=NULL;
	unsigned char *ptr_array[5];
	
	unsigned char *Light_Plane;
	unsigned char *Dark_Plane;
	unsigned long (*Decompression_Screen)[186];
	unsigned short (*Character)[27];
	unsigned char (*File_Strings)[32];
	
	unsigned char *Save_File;
	const unsigned char LofZ_Tag[7]={0,'L','o','f','Z',0,OTH_TAG};
	
	//3x(120+2048)=6504B
	struct SAVE
	{
		unsigned char Player_Name[8];								//8
		unsigned long Weapons_Possessed;						//4
		unsigned short Discovered_Pathways[8];			//16
		unsigned short Shop_Activity_Record[3][8];	//48
		unsigned short Dungeon_Tracker[2][8];				//32
		unsigned short Dungeon_Maps_Compasses[2];		//4
		unsigned char Heart_Containers;							//1
		unsigned char Bombs_Possessed;							//1
		unsigned char Max_Bombs;										//1
		unsigned char Rupies_Possessed;							//1
		unsigned char Keys_Possessed;								//1
		unsigned char Current_Shield;								//1
		unsigned char Letter_Shown;									//1
		unsigned char Beach_HrtCntnr_Taken;					//1
																								//TOTAL= 120 B
	} Saves[3];
	
	//360B
	unsigned long Default_Saves[3][30]=
	{
		{	//[0]
			0x0A200A0E,0x050B0411,												//K.KOFLER Player Name
			0x00000000,																		//Weapons_Possessed;
			0x00000000,0x00000000,0x00000000,0x00000000,	//Discovered Pathways
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0x00000000,0x00000000,0x00000000,0x00000000,	//Dungeon_Tracker
			0x00000000,0x00000000,0x00000000,0x00000000,	//Dungeon_Tracker
			0x00000000,																		//Dungeon_Maps_Compasses
			0x03000800,																		//Heart_Containers,Bombs_Possessed,Max_Bombs,Rupies_Possessed
			0x00000000																		//Keys_Possessed,Current_Shield,Letter_Shown,Beach_HrtCntnr_Taken
		},
		{	//[1]
			0x0B030401,0x110E1417,												//LDEBROUX Player Name
			0x0FA23B6B,																		//Weapons_Possessed;
			0x00000000,0x00000000,0x00000000,0x00000000,	//Discovered Pathways
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Dungeon_Tracker
			0x00000000,0x00000000,0x00000000,0x00000000,	//Dungeon_Tracker
			0x000F000F,																		//Dungeon_Maps_Compasses
			0x080C0C32,																		//Heart_Containers,Bombs_Possessed,Max_Bombs,Rupies_Possessed
			0x03010000																		//Keys_Possessed,Current_Shield,Letter_Shown,Beach_HrtCntnr_Taken
		},
		{	//[2]
			0x0C000418,0x07040C2C,												//MAEYHEM Player Name
			0xFFFFFFFF,																		//Weapons_Possessed;
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Discovered Pathways
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Shop_Activity_Record
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Dungeon_Tracker
			0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,	//Dungeon_Tracker
			0xFFFFFFFF,																		//Dungeon_Maps_Compasses
			0x101010FF,																		//Heart_Containers,Bombs_Possessed,Max_Bombs,Rupies_Possessed
			0x10010100																		//Keys_Possessed,Current_Shield,Letter_Shown,Beach_HrtCntnr_Taken
		}
	};
		
	
	//Save Screen
	LCD_BUFFER LCD;
	LCD_save(LCD);
	
	//Determine which data files are present and which need to be extracted and decompressed from the archive
	if(SymFindPtr(SYMSTR("LoZ_Dat1"),4))
	{
		Decompress&=~Decompress_Data1;
		Flash_Required-=Data1_Size;
	}
	if(SymFindPtr(SYMSTR("LoZ_Dat2"),4))
	{
		Decompress&=~Decompress_Data2;
		Flash_Required-=Data2_Size;
	}
	if(SymFindPtr(SYMSTR("LoZ_Dat3"),4))
	{
		Decompress&=~Decompress_Data3;
		Flash_Required-=Data3_Size;
	}
	if(SymFindPtr(SYMSTR("LofZ_DLL"),4))
	{
		Decompress&=~Decompress_DLL;
		Flash_Required-=DLL_preSize;
	}
	
	EM_survey(0,&Flash_After_GC,&Flash_Before_GC,0,0,0);
	Flash_After_GC+=Flash_Before_GC;
		
	if(Decompress)
	{
		//684b from here to end of ttunpack_valid routine
		if(!(sym=SymFindPtr(SYMSTR("LoZ_Arch"),4)))
		{
		 	LCD_restore(LCD);
			ST_helpMsg("LoZ_Arch.LofZ not found...");
			return;
		}
		if(!ttarchive_valid(Packed=(unsigned char*)HeapDeref(sym->handle)+2))
		{
		 	LCD_restore(LCD);
			ST_helpMsg("LoZ_Arch.LofZ not valid archive...");
			return;
		}
		if(!ttunpack_valid((unsigned char*)ttarchive_data(Packed,0)))
		{
		 	LCD_restore(LCD);
			ST_helpMsg("LoZ_Dat1.LofZ not valid PPG...");
			return;
		}
		if(!ttunpack_valid((unsigned char*)ttarchive_data(Packed,1)))
		{
		 	LCD_restore(LCD);
			ST_helpMsg("LoZ_Dat2.LofZ not valid PPG...");
			return;
		}
		if(!ttunpack_valid((unsigned char*)ttarchive_data(Packed,2)))
		{
		 	LCD_restore(LCD);
			ST_helpMsg("LoZ_Dat3.LofZ not valid PPG...");
			return;
		}
		if(!ttunpack_valid((unsigned char*)ttarchive_data(Packed,3)))
		{
		 	LCD_restore(LCD);
			ST_helpMsg("LofZ_DLL.LofZ not valid PPG...");
			return;
		}
		//end of ttunpack_valid
		
		//Extract and decompress LoZ_Dat1
		if(Decompress&Decompress_Data1)
		{
			if(!(h=HeapAlloc(Data1_Size)))
			{
		 		LCD_restore(LCD);
				ST_helpMsg("Not enough RAM...");
				return;
			}
			Unpacked=(unsigned char*)HeapDeref(h);	//Get address of h1's memory  
			*(unsigned short*)Unpacked=Data1_Size-4;	//Set size of file (it's incorrect to start)
			Unpacked+=2;	//This is where the data entry begins
			Packed=(unsigned char*)ttarchive_data((unsigned char*)(HeapDeref(SymFindPtr(SYMSTR("LoZ_Arch"),4)->handle))+2,0);	//Get address of 1st archive entry
			if(Unpack(Packed,Unpacked)!=TTUNPACK_OKAY)	//Decompress Data1
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				
		 		LCD_restore(LCD);
				ST_helpMsg("Error Decompressing LoZ_Dat1.LofZ...");
				return;
			}
			if(!(sym=DerefSym(SymAddMain(SYMSTR("LoZ_Dat1")))))	//Add the file "LoZ_Dat1"
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				
		 		LCD_restore(LCD);
				ST_helpMsg("Error Creating LoZ_Dat1.LofZ...");
				return;
			}
			sym->handle=h;	//Point the file to the decompressed data. File complete.
			++File_Stage;	//Advance to 1st Stage
			
			if(!EM_findEmptySlot(Data1_Size))	//Check if there is enough ROM for Data1
			{
				//File_Abort(File_Stage,h);
				SymDel(SYMSTR("LoZ_Dat1"));
				
	 			LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory...");
				return;
			}
			++File_Stage;//Advance to 3rd Stage
			if(!EM_moveSymToExtMem(SYMSTR("LoZ_Dat1"),HS_NULL))	//Move Data1 from RAM to ROM
			{
				//File_Abort(File_Stage,h);
				SymDel(SYMSTR("LoZ_Dat1"));
				
		 		LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory (UX-1)...");
				return;
			}
		}
	}
	
	Unpacked=(unsigned char*)HeapDeref(SymFindPtr(SYMSTR("LoZ_Dat1"),4)->handle)+90;	//Get address of LoZ_Dat1
	Decompression_Screen=(unsigned long (*)[186])(Unpacked);	//Reference the variables inside of  LoZ_Dat1
	File_Strings=(unsigned char (*)[32])((unsigned long)Decompression_Screen+2232);
	Character=(unsigned short (*)[27])((unsigned long)File_Strings+128);
	
	
	if(Decompress)
	{	
		if(!GrayOn())
		{
			//File_Abort(File_Stage,h);
			SymDel(SYMSTR("LoZ_Dat1"));
			
		  LCD_restore(LCD);
			ST_helpMsg("Failed To Initialize Grayscale...");
			return;
		}
		++File_Stage;//Advance to 2nd Stage
		
		Planes[0]=GetPlane(0);
		Planes[1]=GetPlane(1);
		memset(Planes[0],0xFFFF,3000);
		memset(Planes[1],0xFFFF,3000);
		for(i=0;i<3;++i)
			Draw_Decompression_Screen(32+(i<<5),0,Decomp_Screen_h,Decompression_Screen[i],Gray_Planes_BIN);
		
		//Check availability of Flash Memory
		if(Flash_Before_GC<2*Flash_Required)
		{	//Perform garbage collection
			Print_File_Status(3,Character,File_Strings);
			GrayWaitNSwitches(2);	//Fixes incomplete print of defrag message
			if(Flash_After_GC<Flash_Required)
			{
				//File_Abort(File_Stage,h);
				SymDel(SYMSTR("LoZ_Dat1"));
				
		 		LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory...");
				return;
			}
			EM_GC(FALSE);
			
			//Required to ensure all pointers are valid after EM_GC()
			Unpacked=(unsigned char*)HeapDeref(SymFindPtr(SYMSTR("LoZ_Dat1"),4)->handle)+90;	//Get address of LoZ_Dat1
			Decompression_Screen=(unsigned long (*)[186])(Unpacked);	//Reference the variables inside of  LoZ_Dat1
			File_Strings=(unsigned char (*)[32])((unsigned long)Decompression_Screen+2232);
			Character=(unsigned short (*)[27])((unsigned long)File_Strings+128);
		}	
			
		if(Decompress&Decompress_Data2)
		{
			Print_File_Status(0,Character,File_Strings);
			if(!(h=HeapAlloc(Data2_Size)))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				GrayOff();				
				
	 			LCD_restore(LCD);
				ST_helpMsg("No RAM to Decompress LoZ_Dat2.LofZ...");
				return;
			}
			++File_Stage;//Advance to 4th Stage
			Unpacked=(unsigned char*)HeapDeref(h);
			*(unsigned short*)Unpacked=Data2_Size-4;
			Unpacked+=2;
			Packed=(unsigned char*)ttarchive_data((unsigned char*)(HeapDeref(SymFindPtr(SYMSTR("LoZ_Arch"),4)->handle))+2,1);
			if(Unpack(Packed,Unpacked)!=TTUNPACK_OKAY)
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Error Decompressing LoZ_Dat2.LofZ...");
				return;
			}
			if(!(sym=DerefSym(SymAddMain(SYMSTR("LoZ_Dat2")))))
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Error Creating LoZ_Dat2.LofZ...");
				return;
			}
			sym->handle=h;
			++File_Stage;//Advance to 5th Stage
			
			
			if(!EM_findEmptySlot(Data2_Size))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				SymDel(SYMSTR("LoZ_Dat2"));
				GrayOff();
				
 				LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory ...");
				return;
			}
			++File_Stage;//Advance to 6th Stage
			if(!EM_moveSymToExtMem(SYMSTR("LoZ_Dat2"),HS_NULL))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				GrayOff();

	 			LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory  (UX-2)...");
				return;
			}
		}
	
		if(Decompress&Decompress_Data3)
		{
			Print_File_Status(1,Character,File_Strings);
			if(!(h=HeapAlloc(Data3_Size)))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("No RAM to Decompress LoZ_Dat3.LofZ...");
				return;
			}
			++File_Stage;//Advance to 7th Stage
			Unpacked=(unsigned char*)HeapDeref(h);
			*(unsigned short*)Unpacked=Data3_Size-4;
			Unpacked+=2;
			
			Packed=(unsigned char*)ttarchive_data((unsigned char*)(HeapDeref(SymFindPtr(SYMSTR("LoZ_Arch"),4)->handle))+2,2);
			if(Unpack(Packed,Unpacked)!=TTUNPACK_OKAY)
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Error Decompressing LoZ_Dat3.LofZ...");
				return;
			}
			if(!(sym=DerefSym(SymAddMain(SYMSTR("LoZ_Dat3")))))
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Error Creating LoZ_Dat3.LofZ...");
				return;
			}
			sym->handle=h;
			++File_Stage;//Advance to 8th Stage
			
			if(!EM_findEmptySlot(Data3_Size))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				SymDel(SYMSTR("LoZ_Dat3"));
				GrayOff();
				
 				LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory...");
				return;
			}
			++File_Stage;//Advance to 9th Stage
			if(!EM_moveSymToExtMem(SYMSTR("LoZ_Dat3"),HS_NULL))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory (UX-3)...");
				return;
			}
		}
		
		if(Decompress&Decompress_DLL)
		{
			Print_File_Status(2,Character,File_Strings);
			if(!(h=HeapAlloc(DLL_Size)))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("No RAM to Decompress LofZ_DLL.dll...");
				return;
			}
			++File_Stage;//Advance to 10th Stage
			
			if(!(h_DLL=HeapAlloc(DLL_preSize)))
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("No RAM to Decompress LoZ_Dat4.dll...");
				return;
			}
			
			Unpacked=(unsigned char *)HeapDeref(h_DLL);
			Unpacked=(unsigned char *)HeapDeref(h);
			Packed=(unsigned char *)ttarchive_data((unsigned char *)HeapDeref(SymFindPtr(SYMSTR("LoZ_Arch"),4)->handle)+2,3);
			if(Unpack(Packed,Unpacked)!=TTUNPACK_OKAY)
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				GrayOff();
				
				HeapFree(h_DLL);
	 			LCD_restore(LCD);
				ST_helpMsg("Error Decompressing LofZ_DLL.dll...");
				return;
			}
			Packed=(unsigned char*)HeapDeref(h);	//Packed used as dummy
			memcpy(Packed,Unpacked+86,DLL_Size);	//Packed used as dummy
			HeapFree(h_DLL);
			
			if(!(sym=DerefSym(SymAddMain(SYMSTR("LofZ_DLL")))))
			{
				//File_Abort(File_Stage,h);
				HeapFree(h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Error Creating LofZ_DLL.dll...");
				return;
			}
			sym->handle=h;
			++File_Stage;//Advance to 11th Stage
			
			if(!EM_findEmptySlot(DLL_Size))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				SymDel(SYMSTR("LofZ_DLL"));
				GrayOff();
				
				ST_helpMsg("Not Enough Flash Memory...");
				return;
			}
			++File_Stage;//Advance to 12th Stage
			if(!EM_moveSymToExtMem(SYMSTR("LofZ_DLL"),HS_NULL))
			{
				//File_Abort(File_Stage,h);
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat1"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat2"));
				EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
				SymDel(SYMSTR("LoZ_Dat3"));
				EM_moveSymFromExtMem(SYMSTR("LofZ_DLL"),HS_NULL);
				SymDel(SYMSTR("LofZ_DLL"));
				GrayOff();
				
	 			LCD_restore(LCD);
				ST_helpMsg("Not Enough Flash Memory (UX-4)...");
				return;
			}
		}
		GrayOff();
	}
		
	//Load DLL
	unsigned char DLL_Status=LoadDLL("lofz_dll",01234567,1,0);
	if (DLL_Status)
	{
 		LCD_restore(LCD);
		switch(DLL_Status)	//210b in switch case
		{
			case DLL_NOTINGHOSTSPACE:
			{
				ST_helpMsg("Not in Ghost Space...");
				break;
			}
			case DLL_NOTFOUND:
			{
				ST_helpMsg("DLL Not Found...");
				break;
			}
			case DLL_OUTOFMEM:
			{
				ST_helpMsg("Not Enough RAM to Load DLL...");
				break;
			}
			case DLL_WRONGVERSION:
			{
				ST_helpMsg("Wrong DLL Version...");
				break;
			}
		}
		return;
	}

	//Declare Buffer Pointers, Allocate Memory etc...
	unsigned char (*Oversized_Buffer)[3510]					=(unsigned char (*)[3510])((unsigned char*)malloc(Size_of_Oversized_Buffer)+272);	//Offset: +16x / +9y pixels
	unsigned char (*Current_Background_Buffer)[2970]=(unsigned char (*)[2970])malloc(Size_of_Background_Buffer);
	unsigned char (*Menu_Buffer)[2970]							=(unsigned char (*)[2970])malloc(Size_of_Menu_Buffer);
	unsigned char (*Current_Screen_Buffer)[1980]		=(unsigned char (*)[1980])malloc(Size_of_Screen_Buffer);
	unsigned char *Screen_Tiles_Buffer							=(unsigned char*)malloc(Size_of_Screen_Tiles_Buffer);
	unsigned char *Collision_Detection_Buffer				=(unsigned char*)malloc(Size_of_Collision_Detection_Buffer);
	unsigned char (*D_Room_Properties)[2][128][8]		=(unsigned char (*)[2][128][8])malloc(3*Size_of_D_Room_Properties);
	if(!Oversized_Buffer||!Current_Background_Buffer||!Menu_Buffer||!Current_Screen_Buffer||!Screen_Tiles_Buffer||!Collision_Detection_Buffer||!D_Room_Properties)
	{
	  LCD_restore(LCD);
		ST_helpMsg("Not Enough RAM...");
		goto Not_Enough_Memory;
	}

	//Custom access to external data variables LoZ_Dat2 and LoZ_Dat3 (required here for SaveFile initialization)
	Unpacked=(unsigned char*)HeapDeref(SymFindPtr(SYMSTR("LoZ_Dat2"),4)->handle)+90;
	unsigned long (*LofZ_Title_Screen)[200]=(unsigned long (*)[200])(Unpacked);
	unsigned long (*LofZ_Triforce)[2][90]=(unsigned long (*)[2][90])((unsigned long)LofZ_Title_Screen+4000);
	unsigned long (*LofZ_Waterfall)[50]=(unsigned long (*)[50])((unsigned long)LofZ_Triforce+2880);
	unsigned short (*Map_Tiles)[18]=(unsigned short (*)[18])((unsigned long)LofZ_Waterfall+1000);
	unsigned char (*Screen_Map_Over)[176]=(unsigned char (*)[176])((unsigned long)Map_Tiles+6876);
	unsigned short (*Link)[4][2][27]=(unsigned short (*)[4][2][27])((unsigned long)Screen_Map_Over+22528);
	unsigned short (*Link_Strike)[27]=(unsigned short (*)[27])((unsigned long)Link+864);
	unsigned long (*Menu_Tiles)[198]=(unsigned long (*)[198])((unsigned long)Link_Strike+324);
	unsigned long (*Triforce_Template)[72]=(unsigned long (*)[72])((unsigned long)Menu_Tiles+3960);
	unsigned short (*Triforces)[2][27]=(unsigned short (*)[2][27])((unsigned long)Triforce_Template+576);
	unsigned short (*Graphics16)[27]=(unsigned short (*)[27])((unsigned long)Triforces+864);
	unsigned short (*Sword)[2][4][27]=(unsigned short (*)[2][4][27])((unsigned long)Graphics16+4050);
	unsigned short (*Sword_Shards)[4][27]=(unsigned short (*)[4][27])((unsigned long)Sword+1728);
	unsigned short (*Boomerang)[15]=(unsigned short (*)[15])((unsigned long)Sword_Shards+432);
	unsigned short (*Arrow)[4][27]=(unsigned short (*)[4][27])((unsigned long)Boomerang+240);
	unsigned char (*Portals)[128][4]=(unsigned char (*)[128][4])((unsigned long)Arrow+432);
	unsigned char (*Overworld_Pathways)[4]=(unsigned char (*)[4])((unsigned long)Portals+1536);
	unsigned char (*Push_Blocks)[128][8]=(unsigned char (*)[128][8])((unsigned long)Overworld_Pathways+512);
	unsigned char (*Item_Data)[5]=(unsigned char (*)[5])((unsigned long)Push_Blocks+3072);
	unsigned char (*Shop_Info)[5]=(unsigned char (*)[5])((unsigned long)Item_Data+200);
	unsigned char (*Shop_Characters)[49]=(unsigned char (*)[49])((unsigned long)Shop_Info+185);
	signed short (*Shop_Prices)[4][5]=(signed short (*)[4][5])((unsigned long)Shop_Characters+1715);
	unsigned char (*Shop_From_World_Index)[128]=(unsigned char (*)[128])((unsigned long)Shop_Prices+480);
	Unpacked=(unsigned char*)HeapDeref(SymFindPtr(SYMSTR("LoZ_Dat3"),4)->handle)+90;
	unsigned char (*Screen_Map_Special)[176]=(unsigned char (*)[176])(Unpacked);
	unsigned char (*Screen_Map_D)[128][84]=(unsigned char (*)[128][84])((unsigned long)Screen_Map_Special+704);
	unsigned char (*Dungeon_Levels)[128]=(unsigned char (*)[128])((unsigned long)Screen_Map_D+21504);
	unsigned long (*Dungeon_Rough_Map_Template)[68]=(unsigned long (*)[68])((unsigned long)Dungeon_Levels+256);
	unsigned char (*D_Room_Properties_ROM)[128][8]=(unsigned char (*)[128][8])((unsigned long)Dungeon_Rough_Map_Template+544);
	unsigned short (*Enemies4D)[4][2][27]=(unsigned short (*)[4][2][27])((unsigned long)D_Room_Properties_ROM+2048);
	unsigned short (*Enemies1D)[2][27]=(unsigned short (*)[2][27])((unsigned long)Enemies4D+7344);
	unsigned char (*Overworld_Enemies_ROM)[8]=(unsigned char (*)[8])((unsigned long)Enemies1D+2484);

	//Check if save file already exists, else create it and fill it with default save data.
	if(SymFindPtr(SYMSTR("loz_save"),4))
		SaveFile_Active=TRUE;	
	else
	{
		if(!(h=HeapAlloc(2+SaveFile_Size+7)))	//Allocate memory for save file and store the handle
		{
	 		LCD_restore(LCD);
			ST_helpMsg("Not enough flash memory...");
			return;
		}
		Save_File=(unsigned char*)HeapDeref(h);	//Dereference the handle and obtain the pointer to the save file
		*(unsigned short*)Save_File=SaveFile_Size+7;
		Save_File+=2;
		ptr=Save_File;
		ptr+=SaveFile_Size;
		memcpy(ptr,LofZ_Tag,7);
		if(!(sym=DerefSym(SymAddMain(SYMSTR("loz_save")))))	//Add the save file
		{
			HeapFree(h);
	 		LCD_restore(LCD);
			ST_helpMsg("Error Creating LoZ_Save.LofZ...");
			return;
		}
		sym->handle=h;	//Point the file to the allocated memory. File complete.
		
		//Copy the default save data to the Save_File
		//First load 3 blocks of DefaultSave data at beginning of Save_File (3 x 120 B)
		memcpy(Save_File,Default_Saves[0],3*DefaultSave_Size);
		
		//Go to slot for D_Room_Properties
		Save_File+=3*DefaultSave_Size;
		
		//Second load 3 blocks of D_Room_Properties after the 3 blocks of DefaultSave data (3 x 2048 B)
		//Also, modify the copies of D_Room_Properties in the Save_File so all dungeon bomb walls are not bombed
		ptr=Save_File;
		for(k=0;k<3;++k)
		{
			memcpy(Save_File,D_Room_Properties_ROM,Size_of_D_Room_Properties);
			ptr=Save_File;
			Save_File+=Size_of_D_Room_Properties;
			for(i=0;i!=255;++i)
			{
				for(j=0;j<4;++j)
				{
					if(*ptr==DD_Bomb)
						*ptr=DD_Wall;
					++ptr;
				}
				ptr+=4;
			}
		}
		
		//Move Save_File from RAM to ROM
		if(!EM_moveSymToExtMem(SYMSTR("loz_save"),HS_NULL))
		{
			//File_Abort(File_Stage,h);
			SymDel(SYMSTR("loz_save"));
			
	 		LCD_restore(LCD);
			ST_helpMsg("Not Enough Flash ROM (UX-0)...");
			return;
		}
	}
	
	
	//Clock references
	unsigned long AutoOff_ClockRef=0;
	unsigned char Adjust_Interval=Default_Adjust_Interval;
	unsigned long Adjust_ClockRef=0;
	unsigned char Scroll_Interval=Default_Scroll_Interval;
	unsigned long Scroll_ClockRef=0;
	unsigned char Sprite_Interval=Default_Sprite_Interval;
	unsigned long Link_ClockRef=0;
	unsigned char Projectile_Interval=Default_Projectile_Interval;
	unsigned long Sword_ClockRef=0;
	unsigned long Shooting_Sword_ClockRef=0;
	unsigned long Weapon_Release_ClockRef=0;
	unsigned long Boomerang_ClockRef=0;
	unsigned long Bomb_ClockRef[2]={0,0};
	unsigned long Arrow_ClockRef=0;
	unsigned long Candle_ClockRef[2]={0,0};
	unsigned long Tornado_ClockRef=0;
	unsigned long Meat_ClockRef=0;
	unsigned long Potion_ClockRef=0;
	unsigned long WandWave_ClockRef=0;
	unsigned long Cursor_ClockRef=0;
	unsigned long Dungeon_Map_ClockRef=0;
	unsigned long D_Door_ClockRef=0;
	unsigned long Shop_Candle_ClockRef=0;

	//Map navigation varibles
	unsigned char Scroll_Index=0;
	unsigned char World_Index=119;	//Homescreen (7*World_w+8)-1
	unsigned char Previous_World_Index=World_Index;
	unsigned char World=Overworld;
	unsigned char Previous_World=Overworld;
	signed char Gray_Index=0;
	
	//Link variables
//	unsigned long Link_Buffer[2][9];
	unsigned char Link_Direction=UP;
	unsigned char Link_x=75;	//(7*Sprite_w)+(Sprite_w/2)
	unsigned char Link_y=45;	//(5*Sprite_h)
	unsigned char Link_x_RMNDR=0;
	unsigned char Link_y_RMNDR=0;
	unsigned char Link_Screen_Index=0;
	unsigned char Previous_Link_x=75;
	unsigned char Previous_Link_y=45;	//(5*Sprite_h)
	unsigned char Relative_Direction=0;
	unsigned char Current_Shield=Small_Shield;
	BOOL Link_Animation=Static;
	unsigned char Lifting_Item=0;
	BOOL Portal_Open=TRUE;
	BOOL Inside_Portal=FALSE;
	unsigned char Animation_Counter=0;
//	unsigned long Weapons_Possessed=0xFFA73FE9;
	unsigned long Weapons_Possessed=0x00000000;
	unsigned char Hearts=6;
	unsigned char Heart_Containers=3;
	unsigned char Cursor_Color=Black_Cursor;
	unsigned short Keys_Pressed=0;
	unsigned short Effective_Direction=0;
	unsigned char Refresh_Counter=0;
	BOOL Walkthrough_Key_Released=TRUE;
	BOOL Walkthrough=FALSE;
	BOOL TimeBypass_Key_Released=TRUE;
	BOOL TimeBypass=FALSE;
	BOOL APPS_KEY_Pressed=FALSE; //Game pause key
	
	//Constants dependent on direction
  signed short Scroll_Index_Offset[4]= {LCD_h-1,LCD_w,LCD_h-1,LCD_w};
  signed char Unit_x_Offset[4]= {0,-1,0,1};
  signed char Unit_y_Offset[4]= {-1,0,1,0};
  signed char Scroll_x_Offset[4]= {0,1,0,-1};
  signed char Scroll_y_Offset[4]= {1,0,-1,0};
  signed char Sprite_x_Offset[4]= {0,-Sprite_w,0,Sprite_w};
  signed char Sprite_y_Offset[4]= {-Sprite_h,0,Sprite_h,0};
  signed char World_Index_Offset[4]= {-World_w,-1,World_w,1};	//Is used as Screen_Index_Offset too
  unsigned char Link_x_Dungeon_Door[4]= {75,20,75,130};
  unsigned char Link_y_Dungeon_Door[4]= {18,45,72,45};
  
  //Weapon variables
	unsigned char Cursor_Position=First_Cursor_Position;
	BOOL Cursor_Key_Released=TRUE;
	BOOL Sword_Key_Released=TRUE;
	BOOL Weapon_Key_Released=TRUE;
	BOOL Menu_Key_Released=TRUE;
	BOOL Currently_Using_Sword=FALSE;
	unsigned char Current_Sword=0;
	unsigned char Sword_x=0;
	unsigned char Sword_y=0;
	BOOL Already_Switched_Sword_Direction=FALSE;
	BOOL Shooting_Sword_Present=FALSE;
	BOOL Shooting_Sword_Animation=FALSE;
	unsigned char Shooting_Sword_Direction=UP;
	unsigned char Shooting_Sword_x=0;
	unsigned char Shooting_Sword_y=0;
	unsigned char Current_Sword_Stage=Zeroth_Sword_Stage;
	unsigned char Current_Sword_Shards_Stage=0;
	BOOL Sword_Shards_Present=FALSE;
	BOOL Releasing_Or_Recieving_Weapon=FALSE;
	unsigned char Current_Weapon=0;
	unsigned char Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
	unsigned char Boomerang_Present=0;
	BOOL Boomerang_Type=0;
	unsigned char Boomerang_x=0;
	unsigned char Boomerang_y=0;
	unsigned char Boomerang_Reference_x=0;
	unsigned char Boomerang_Reference_y=0;
	unsigned char Boomerang_Direction=North;
	unsigned char Boomerang_Animation=North;
	unsigned char Boomerang_Animation_Counter=0;
	unsigned char Bomb_Present=0;
	unsigned char Current_Bomb=0;
	unsigned char Bombs_Possessed=8;
	unsigned char Max_Bombs=8;
	unsigned char Bomb_x[2]={0,0};
	unsigned char Bomb_y[2]={0,0};
	unsigned char Current_Bomb_Stage[2]={Second_Bomb_Stage,Second_Bomb_Stage};
	BOOL BombShock_Present=FALSE; 
	BOOL Arrow_Present=FALSE;
	BOOL Arrow_Type=0;
	unsigned char Arrow_Direction=0;
	unsigned char Arrow_x=0;
	unsigned char Arrow_y=0;
	unsigned char Candle_Present=0;
	BOOL Candle_Exhausted=FALSE;
	unsigned char Current_Flame=0;
	unsigned char Candle_x[2]={0,0};
	unsigned char Candle_y[2]={0,0};
	unsigned char Candle_Direction[2]={North,North};
	BOOL Candle_Animation[2]={0,0};
	unsigned char Candle_Counter[2]={0,0};
	unsigned char Candle_Factor[2]={Default_Candle_Factor,Default_Candle_Factor};
	BOOL Tornado_Present=FALSE;
	unsigned long Recorder_ClockRef=0;
	BOOL Recorder_Exhausted=FALSE;
	BOOL Warped_By_Recorder=0;
	unsigned char Warp_Direction=0;
	unsigned char Recorder_Warping[2][9]= {
		{54,59,115,68,10,33,65,108,5},		//[0] Screen_Index
		{88,120,88,88,120,88,120,40,101}	//[1] Link_Index
	};
	unsigned char Current_Warp_Stage=0;
	unsigned char Current_Warp_Position=Level_1_Warp_Position;
	unsigned char Tornado_x=0;
	unsigned char Tornado_y=0;
	BOOL Meat_Present=FALSE;
	unsigned char Meat_x=0;
	unsigned char Meat_y=0;
	BOOL Potion_Present=FALSE;
	BOOL Currently_Using_Wand=FALSE;
	BOOL WandWave_Present=FALSE;
	unsigned char WandWave_Direction=0;
	unsigned char WandWave_x=0;
	unsigned char WandWave_y=0;
	unsigned char Current_Pathway_x=0;
	unsigned char Current_Pathway_y=0;
	unsigned char Rupies_Possessed=128;
	unsigned char Keys_Possessed=3;
	
	//Weapon constants
	const signed char Sword_x_Offset[4]= {0,-Sword_w,0,Sprite_w};
	const signed char Sword_y_Offset[4]= {-Sword_h,0,Sprite_h,0};
	const signed char Shooting_Sword_x_Offset[4]= {0,-13,0,15};
	const signed char Shooting_Sword_y_Offset[4]= {-13,0,14,0};
	unsigned char Boomerang_Direction_From_Keypress[13]= {8,North,West,North_West,8,8,South_West,8,East,North_East,8,8,South_East};
	signed char Boomerang_x_Offset[8]= {2,-Boomerang_w,-Boomerang_w,-Boomerang_w,2,Sprite_w,Sprite_w,Sprite_w};
	signed char Boomerang_y_Offset[8]= {-Boomerang_h,-Boomerang_h,2,Sprite_h,Sprite_h,Sprite_h,2,-Boomerang_h};
	signed char Boomerang_x_Increment[8]= {0,-1,-1,-1,0,1,1,1};
	signed char Boomerang_y_Increment[8]= {-1,-1,0,1,1,1,0,-1};
	const signed char Bomb_x_Offset[4]= {2,-Sprite_w+3,2,Sprite_w+2};
	const signed char Bomb_y_Offset[4]= {-Sprite_h-1,0,Sprite_h+1,0};
	const signed char Arrow_x_Offset[4]= {0,-Arrow_w,0,Sprite_w};
	const signed char Arrow_y_Offset[4]= {-Arrow_h,0,Sprite_h,0};
	const signed char Candle_x_Offset[4]= {0,-Sprite_w-1,0,Sprite_w+1};
	const signed char Candle_y_Offset[4]= {-Sprite_h,0,Sprite_h,0};
	const signed char Meat_x_Offset[4]= {2,-Sprite_w+2,2,Sprite_w+2};
	const signed char Meat_y_Offset[4]= {-Sprite_h-1,0,Sprite_h+1,0};
	const signed char WandWave_x_Offset[4]= {0,-Sprite_w-Wand_w/2,0,Sprite_w+Wand_w/2};
	const signed char WandWave_y_Offset[4]= {-Sprite_h-Wand_h/2,0,Sprite_h+Wand_h/2,0};

	//Underworld variables
	unsigned char Current_Dungeon_Level=0;
	unsigned char Dungeon_Entrance_Locations[8]= {115,125,124,113,118,121,121,126};
	unsigned short Dungeon_Maps_Compasses[2]= {0x0000,0x0000};
//	unsigned short Dungeon_Maps_Compasses[2]= {0x01FF,0x01FF};
	unsigned char DI_Rupies_x[10]= {75,70,80,60,70,80,90,70,80,75};
	unsigned char DI_Rupies_y[10]= {27,36,36,45,45,45,45,54,54,63};
	unsigned short Dungeon_Tracker[2][8];
	memset(Dungeon_Tracker[0],0x0000,32);
	//memset(Dungeon_Tracker[0],0xFFFF,32);
	signed char Level_Offset[9]= {0,-10,-8,2,-2,-7,-7,-10,0};
	unsigned char Unlock_Door=0;
	unsigned char Dark_Room=0;
	BOOL Triforce_Curtains=FALSE;
	
	//Ladder variables/constants
	BOOL Using_Ladder=FALSE;
	unsigned char Ladder_Direction=0;
	unsigned char Ladder_x=0;
	signed char Ladder_x_Offset[4]=	{0,-Sprite_w,0,Sprite_w};
	unsigned char Ladder_y=0;
	signed char Ladder_y_Offset[4]=	{-5,0,Sprite_h,0};
	unsigned char Ladder_Index=0;
	signed char Ladder_Index_Offset[2][4]= {	//Only Depends On y-Alignment
		{0,Screen_w-1,Screen_w,Screen_w+1},	//[0] y Non-Aligned
		{0,-1,Screen_w,1}										//[1] y Aligned
	};
	unsigned char Current_Ladder_Alignment=0;
	unsigned char Ladder_x_Aligned=0;
	unsigned char Ladder_y_Aligned=0;
	unsigned char Ladder_Tiles_Backup[3];
	unsigned char Ladder_Tiles[2][2][3]= {	//Placed on Collision_Detection_Buffer to restrict movement during ladder usage
		{	//[0]	UP_DOWN
			{D_Tile,N_6_D,N_7_D},	//[0] x Non-Aligned	(D_Tile Not Needed)
			{N_1,D_Tile,N_1}			//[1] x Aligned
		},
		{	//[0]	LEFT_RIGHT
			{Block,HALF_S,D_Tile},	//[0] y Non-Aligned	(D_Tile Not Needed)
			{N_1,D_Tile,Block}			//[1] y Aligned
		}
	};
	signed char Ladder_Tile_Offset[2][3]= {
		{-1,0,1},								//[0] UP_DOWN (-1 Not Needed For Non-Aligned Use)
		{-Screen_w,0,Screen_w}	//[1] LEFT_RIGHT (-Screen_w Not Needed For Non-Aligned Use)
	};
	
	//Miscellaneous variables
	unsigned char PushBlock_Present=0;
	unsigned char PushBlock_Type=0;
	unsigned char PushBlock_Index=0;
	unsigned char PushBlock_x=0;
	unsigned char PushBlock_y=0;
	unsigned char Stair_Index=0;
	unsigned char PushBlock_Floor=0;
	unsigned char PushBlock_Direction=0;
	unsigned char Push_Distance=0;
  unsigned char Lifted_Item_x=0;
  unsigned char Lifted_Item_y=0;
  unsigned long Lifted_Item_ClockRef=0;
	unsigned char Mountain_Maze_Index=0;
	unsigned char Forest_Maze_Index=0;
	unsigned char Forest_Maze[4]= {UP,LEFT,DOWN,LEFT};
	unsigned short Discovered_Pathways[8]= {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};
	unsigned char Letter_Shown=FALSE;
	unsigned char Beach_HrtCntnr_Taken=FALSE;
	
	//Item_Data[Current_Item] gets loaded into STRUCT Active_Items[16]
	struct ITEM
	{
		unsigned char Item;
		unsigned char Item_w_half;
		unsigned char Item_h_half;
		unsigned char Item_Graphics[2];
	} Active_Items[16];
	
  //Not in STRUCT
  unsigned char Total_Items=0;
  unsigned char Current_Item=0;
  signed short Current_Item_Price=0;
  unsigned char Current_Item_Graphics=0;
  unsigned char Item_x[16];
  unsigned char Item_y[16];
  signed short Item_Price[16];
  BOOL Item_Animation_Flag[16];
  unsigned char Item_Animation_Time[16];
  unsigned short Item_Expire_Time[16];
  unsigned long Item_Animation_ClockRef[16];
  unsigned long Item_Expire_ClockRef[16];
  
  BOOL Rupy_Animation_Flag=FALSE;
  unsigned long Rupy_Animation_ClockRef=0;
  
  //Shop variables
	unsigned char Inside_Shop=0;
	unsigned char Shop_World=0;
	unsigned char Shop_World_Index=0;
	unsigned char Current_Shop=0;
	signed short Current_Shop_Prices[4][5];
	unsigned long Shop_Text_ClockRef=0;
	unsigned char Shop_Text_x=0;
	unsigned char Shop_Text_y=0;
	unsigned char *Current_Shop_Characters=NULL;
	BOOL Printing_Shop_Text=FALSE;
	BOOL Shop_Candle_Animation=0;
	BOOL Shopkeeper_Flickering=FALSE;
	unsigned char Shopkeeper_Flicker_Counter=0;
	BOOL Shopkeeper_Animation=0;
	unsigned long Shopkeeper_ClockRef=0;
	unsigned long Shopkeeper_Flicker_ClockRef=0;
	BOOL Browsing_Shops=FALSE;
	BOOL Flash_Submenu=FALSE;
	unsigned char Split_Number[3];
	unsigned long Flash_Submenu_ClockRef=0;
	signed short Rupies_Spent=0;
	unsigned short Shop_Activity_Record[3][8];	//Bitflag: 3x(8*16)
	memset(Shop_Activity_Record,0xFF,48);
	unsigned char Shop_Gamble_SEED=0;
	signed short Gamble_Prices[4][5]=
	{
		{10,Char_Hyphen,Char_1,Char_0,Char_Space},	//[0] Lose_10
		{40,Char_Hyphen,Char_4,Char_0,Char_Space},	//[1] Lose_40
		{-20,Char_Plus,Char_2,Char_0,Char_Space},		//[2] Win__20
		{-50,Char_Plus,Char_5,Char_0,Char_Space}		//[3] Win__50
	};
	signed char Gamble_Permutations[24][3]=
	{
		//[0] Permutations of +50,-40,-10
		{Win__50,Lose_40,Lose_10},
		{Win__50,Lose_10,Lose_40},
		{Lose_40,Win__50,Lose_10},
		{Lose_40,Lose_10,Win__50},
		{Lose_10,Win__50,Lose_40},
		{Lose_10,Lose_40,Win__50},
		//[1] Permutations of +50,-10,-10
		{Win__50,Lose_10,Lose_10},
		{Win__50,Lose_10,Lose_10},
		{Lose_10,Win__50,Lose_10},
		{Lose_10,Lose_10,Win__50},
		{Lose_10,Win__50,Lose_10},
		{Lose_10,Lose_10,Win__50},
		//[2] Permutations of +20,-10,-10
		{Win__20,Lose_10,Lose_10},
		{Win__20,Lose_10,Lose_10},
		{Lose_10,Win__20,Lose_10},
		{Lose_10,Lose_10,Win__20},
		{Lose_10,Win__20,Lose_10},
		{Lose_10,Lose_10,Win__20},
		//[3] Permutations of +20,-10,-10 (repeated to increase probability)
		{Win__20,Lose_10,Lose_10},
		{Win__20,Lose_10,Lose_10},
		{Lose_10,Win__20,Lose_10},
		{Lose_10,Lose_10,Win__20},
		{Lose_10,Win__20,Lose_10},
		{Lose_10,Lose_10,Win__20},
	};
	unsigned char Beach_Warp[3]=	{29,35,73};		//121 60,27
	unsigned char Fairy_Warp[3]=	{121,29,35};	//73  30,27
	unsigned char L5_Warp[3]= 		{35,73,121};	//29  20,27
	unsigned char L6_Warp[3]=			{73,121,29};	//35	40,18
	
	//Enemy variables $$
	unsigned char Enemies[8]= {Enemy_Dead,Enemy_Dead,Enemy_Dead,Enemy_Dead,Enemy_Dead,Enemy_Dead,Enemy_Dead,Enemy_Dead};	//Works as sprite def'n as well
	unsigned char Enemy_Direction[8];
	unsigned char Enemy_x[8];
	unsigned char Enemy_y[8];
	unsigned short* Enemy_Sprite[8];
	BOOL Enemy_Animation[8];
	BOOL Enemy_Animate[8];
	unsigned char Enemy_Anim_Counter[8];
	unsigned long Enemy_Move_ClockRef[8];
	unsigned char Enemy_Event[8];
	unsigned short Enemy_Event_Interval[8];
	unsigned long Enemy_Event_ClockRef[8];
	unsigned long Enemy_ProjRelease_ClockRef[8];
	unsigned short Enemy_ProjRelease_Interval[8];
	unsigned char Enemy_Projectile[12]= {0,0,0,0,0,0,0,0,0,0,0,0};
	unsigned char Enemy_Projectile_x[12];
	unsigned char Enemy_Projectile_y[12];
	unsigned char Enemy_Proj_Direction[12];
  unsigned long Enemy_ProjMove_ClockRef[12];
  unsigned char Enemy_ProjMove_Interval[12];
  unsigned char Enemy_ProjMove_Intervals[3]= {3,3,2};	//{OctorokRock, MolblinArrow, LynelSword}
  unsigned short* Enemy_Proj_Sprite[12];
	unsigned char Enemy_State[8];
	unsigned char Enemy_Attitude[8];
	unsigned char Enemy_Counter[8];
	unsigned char Enemy_LogicLevel[8];
	unsigned char Current_Enemy=0;
	unsigned char Current_Movement=0;
	unsigned char Total_Land_Tiles=0;
	unsigned char Total_Water_Tiles=0;
	unsigned char Directions[4];
	unsigned char Total_Directions=0;
	unsigned char Enemy_Screen_Index=0;
	unsigned char Enemy_x_RMNDR=0;
	unsigned char Enemy_y_RMNDR=0;
	
	BOOL Gates_Present=FALSE;
	unsigned char Gate_x[4];
	unsigned char Gate_y[4];
	unsigned char Statues_Present=0;
	unsigned char Statue_x[4];
	unsigned char Statue_y[4];
	
	//Enemy_Data[Current_Item] gets loaded into STRUCT Active_Enemies[16]
	struct ENEMY
	{
		unsigned char Life;
		unsigned char Movement;
		unsigned char Movement_Interval;
		unsigned char Animate_Interval;
		unsigned char Enemy_Damage_to_Link;
		unsigned char Projectile_Type;	//Works as sprite def'n as well
		unsigned char ProjRelease_Interval;	//is shifted left by 8 after being loaded
		unsigned char ProjDamage_to_Link;
		unsigned char Special;	//Defines weaknesses, immunities
		unsigned char Dropable_Items;
	} Active_Enemies[8];
	
	//400B
	unsigned char Enemy_Data[40][10]=
	{	//Data order corresponds to struct ENEMY above
		{1,On_Land,10,4,1,OctorokRock,3,1,0,0},	//[0] OctorokLight
		{2,On_Land,10,4,1,OctorokRock,3,1,0,0},	//[1] OctorokDark	
		{2,On_Land,15,3,1,MolblinArrow,3,1,0,0},	//[2] MolblinLight
		{3,On_Land,15,3,1,MolblinArrow,3,1,0,0},	//[3] MolblinDark
		{4,On_Land,15,4,1,LynelSword,3,1,0,0},	//[4] LynelLight
		{6,On_Land,15,4,1,LynelSword,3,1,0,0},	//[5] LynelDark
		{3,On_Land,10,4,},	//[6] GoriyaLight
		{5,On_Land,10,4,},	//[7] GoriyaDark
		{4,On_Land,10,4,},	//[8] DarknutLight
		{7,On_Land,10,4,},	//[9] DarknutDark
		{2,Hand_Creep,10,4,},	//[10] Hand
		{4,Wizzrobe_Teleport,10,4,},	//[11] WizzrobeLight
		{9,Wizzrobe_Glide,10,4,},	//[12] WizzrobeDark
		{9,On_Land,10,4,},	//[13] Ghost
		{2,On_Land,10,4,},	//[14] Armos
		{2,On_Land,10,4,},	//[15] SnakeLight
		{2,On_Land,10,4,},	//[16] SnakeDark
		{1,Spider_Jump,10,6,},	//[17] SpiderLight
		{1,Spider_Jump,10,6,},	//[18] SpiderDark
		{2,LeeverLight_Dive,10,4,},	//[19] LeeverLight
		{4,LeeverDark_Dive,10,4,},	//[20] LeeverDark
		{2,PeahatFly,20,4,},	//[21] Peahat
		{2,Zola_Water,10,4,},	//[22] Zola
		{1,Rock_Fall,8,10,},	//[23] Rock
		{2,On_Land,10,4,},	//[24] Stalfos
		{2,On_Land,10,4,},	//[25] Zol	
		{1,On_Land,10,4,},	//[26] Gel
		{4,VireBunny_Hop,10,4,},	//[27] Vire
		{1,Fly,10,4,},	//[28] Bat
		{9,VireBunny_Hop,10,4,},	//[29] Bunny
		{9,On_Land,10,4,},	//[30] Likelike
		{7,On_Land,10,4,},	//[31] Mummy
		{9,Fly,10,4,},	//[32] BigPatra
		{7,Patra_Revolve,10,4,},	//[33] Patra
		{1,On_Land,10,4,},	//[34] SunFlash
		{1,On_Land,10,4,},	//[35] SunLight
		{1,On_Land,10,4,},	//[36] SunDark
		{1,Gate_Glide,10,4,},	//[37] Gate
		{1,Fly,10,4,},	//[38] GleeokHead
		{7,Fly,10,4,}	//[39] Digdog
	};
	
	//140B
	signed char SpiderPath_Offset[7][20]=
	{	//Offsets are used in reverse order (right -> left)
		{0,-1,-1,-1,-1,-2,-2,-2,-2,-2},	//[0]	Up 1.5
		{-1,-2,-2,-2,-2},	//[1] Up 1
		{0,-1,-1,-1,-2},	//[2] Up 0.5
		{2,2,2,2,1,-1,-2,-2,-2,-2},	//[3] Sideways
		{2,2,2,2,2,2,1,1,0,-1,-1,-1,-2,-2,-2},	//[4] Down 0.5
		{2,2,2,2,2,2,1,1,1,1,1,0,1,0,-1,-1,-1,-2,-2,-2}, //[5] Down 1
		{2,2,2,2,2,2,2,2,2,2,1,1,1,0,-1,-1,-1,-2,-2,-2}	//[6] Down 1.5
	};
	unsigned char SpiderPath_Length[7]={10,5,5,10,15,20,20};
	unsigned char SpiderJumps_Remaining[8];
	unsigned char Current_SpiderPath[8];
	
	unsigned char Flying_Directions[8][5]=
	{
		{North_East,North_East,North,North_West,North_West},	//[0] North
		{North,North,North_West,West,West},										//[1] North_West
		{North_West,North_West,West,South_West,South_West},		//[2] West
		{West,West,South_West,South,South},										//[3] South_West
		{South_West,South_West,South,South_East,South_East},	//[4] South
		{South,South,South_East,East,East},										//[5] South_East
		{South_East,South_East,East,North_East,North_East},		//[6] East
		{East,East,North_East,North,North}										//[7] North_East
	};
	
	unsigned char LeeverLight_Count=0;
	
	unsigned char ZolaFire_Index=0;
	signed char Zola_Quadrant=0;
	signed short Tan_Ratio=0;
	unsigned char ZolaFire_CycleLength=0;
	unsigned char ZolaFire_CycleLengths[10]= {8,6,8,7,6,6,7,8,6,8};
	unsigned char ZolaFire_x_Offset[10][8]=	//Offsets "out of cycle" are padded with '9' (corresponds to ZolaFire_CycleLengths[10])
	{
		{1,1,1,1,1,1,1,1},	//[0] 0
		{1,1,1,1,1,1,9,9},	//[1] 10
		{1,1,1,1,1,1,1,1},	//[2] 20
		{1,1,1,1,1,1,1,9},	//[3] 30
		{1,1,1,1,1,1,9,9},	//[4] 40
		{1,1,1,0,1,1,9,9},	//[5] 50
		{0,1,0,1,1,1,0,9},	//[6] 60
		{0,1,0,0,1,0,1,0},	//[7] 70
		{0,0,1,0,0,0,9,9},	//[8] 80
		{0,0,0,0,0,0,0,0}		//[9] 90
	};
	unsigned char ZolaFire_y_Offset[10][8]=
	{
		{0,0,0,0,0,0,0,0},	//[0] 0
		{0,0,1,0,0,0,9,9},	//[1] 10
		{0,1,0,0,1,0,1,0},	//[2] 20
		{0,1,0,1,1,1,0,9},	//[3] 30
		{1,1,1,0,1,1,9,9},	//[4] 40
		{1,1,1,1,1,1,9,9},	//[5] 50
		{1,1,1,1,1,1,1,9},	//[6] 60
		{1,1,1,1,1,1,1,1},	//[7] 70
		{1,1,1,1,1,1,9,9},	//[8] 80
		{1,1,1,1,1,1,1,1}		//[9] 90
	};
	
	
	unsigned short *Current_Link=Link[Current_Shield][Link_Animation][Link_Direction];
	
	
	//Redirect HANDLERS
	INT_HANDLER save_int_1=GetIntVec(AUTO_INT_1);
	SetIntVec(AUTO_INT_1,CLOCK_HANDLER);
	INT_HANDLER save_int_5=GetIntVec(AUTO_INT_5);
	SetIntVec(AUTO_INT_5,DUMMY_HANDLER);
	
	//Initiate Grayscale
	unsigned char Calc_ID[17];
	if(!GrayOn())
	{
		SetIntVec(AUTO_INT_1,save_int_1);
		SetIntVec(AUTO_INT_5,save_int_5);
	  LCD_restore(LCD);
		ST_helpMsg("Failed To Initialize Grayscale...");
		goto Not_Enough_Memory;
	}
	Light_Plane=GetPlane(0);
	Dark_Plane=GetPlane(1);
	AB_serno(Calc_ID);
	if(Calc_ID[1]==51) //TI-89 hardware present
	{
		Gray_Index=Max_Plane_Freq;
		GrayAdjust(Gray_Index);
		OSContrastDn();
		OSContrastDn();
		OSContrastDn();
		OSContrastDn();
	}
	
	//Array Planes[9] serves only to be exported to the DLL by Install_Planes()
	Planes[0]=Light_Plane;
	Planes[1]=Dark_Plane;
	Planes[2]=Oversized_Buffer[0];
	Planes[3]=Oversized_Buffer[1];
	Planes[4]=Menu_Buffer[0];
	Planes[5]=Menu_Buffer[1];
	Planes[6]=Current_Background_Buffer[0];
	Planes[7]=Current_Background_Buffer[1];
	Planes[8]=(unsigned char*)Graphics16;
	Install_Planes((unsigned char*)Planes);
	
	//Show Title Screen
	Global_Clock=0;
	for(i=0;i<5;++i)
		Draw_Part_Of_Title_Screen(i<<5,0,LCD_h,LofZ_Title_Screen[i],Gray_Planes_BIN);
	i=1;
	Tornado_x=0;
	WandWave_Direction=DOWN;
	
	while((~_rowread(ARROWS_ROW)&SECOND_KEY)&&(~_rowread(F5_ROW)&ENTER_KEY))
	{
		if(_rowread(ESC_ROW)&ESC_KEY)
			goto Cleanup;
		if(_rowread(ALL_ROWS))
			AutoOff_ClockRef=Global_Clock;
		if(Calc_ID[1]==51 && (_rowread(F1_ROW)&OR_KEY || Global_Clock-AutoOff_ClockRef>=APD_TimeLength))
		{
			asm("trap #4");
			AutoOff_ClockRef=Global_Clock;
			GrayAdjust(Gray_Index);
		}
		if(Global_Clock-Adjust_ClockRef>Adjust_Interval)	//Adjust Contrast
		{
			Adjust_ClockRef=Global_Clock;
			if(_rowread(F5_ROW)&PLUS_KEY)
				OSContrastUp();
			if(_rowread(F5_ROW)&MINUS_KEY)
				OSContrastDn();
		}
		if(Global_Clock-Link_ClockRef>50)	//Flicker triforce
		{
			Link_ClockRef=Global_Clock;
			if(WandWave_Direction)
			{
				if(i)
					--i;
				else
				{
					WandWave_Direction=UP;
					++i;
				}
			}
			else
			{
				if(i<3)
					++i;
				else
				{
					WandWave_Direction=DOWN;
					--i;
				}
			}
			
			for(j=0;j<2;++j)
				Draw_Part_Of_LofZ_Triforce(LofZ_Triforce_x+(j<<5),LofZ_Triforce_y,LofZ_Triforce_h,LofZ_Triforce[i][j],Gray_Planes_BIN);
		}
		if(Global_Clock-Sword_ClockRef>15)	//Animate waterfall
		{
			Sword_ClockRef=Global_Clock;
			if(Tornado_x<4)	//Used as dummy since j is in use.
				++Tornado_x;
			else
				Tornado_x=0;
			Draw_LofZ_Waterfall(LofZ_Waterfall_x,LofZ_Waterfall_y,LofZ_Waterfall_h,LofZ_Waterfall[Tornado_x],Gray_Planes_BIN);
		}
	}
	
	//Initialize StartMenu
//	Decompress=Retain_All;	//Keep all decompressed/archived data/dll files by default
	unsigned char Current_Save=0;
	unsigned char Save_Game=FALSE;
	unsigned char Return_to_StartMenu=FALSE;
	unsigned char StartMenu_Text_x[5]= {42,54,101,32,32};	//Select,Name,Life,Register,Delete
	unsigned char StartMenu_Text_y[5]= {8,20,20,67,79};	//Select,Name,Life,Register,Delete
	unsigned char Select_Text[16]=
		{Char_Hyphen,Char_Space,Char_S,Char_Space,Char_E,Char_Space,Char_L,Char_Space,Char_E,Char_Space,Char_C,Char_Space,Char_T,Char_Space,Char_Hyphen,Char_End};
	unsigned char Name_Text[5]= {Char_N,Char_A,Char_M,Char_E,Char_End};
	unsigned char Life_Text[5]= {Char_L,Char_I,Char_F,Char_E,Char_End};
	unsigned char RegPlayer_Text[16]=
		{Char_R,Char_E,Char_G,Char_I,Char_S,Char_T,Char_E,Char_R,Char_Space,Char_P,Char_L,Char_A,Char_Y,Char_E,Char_R,Char_End};
	unsigned char DelPlayer_Text[14]= {Char_D,Char_E,Char_L,Char_E,Char_T,Char_E,Char_Space,Char_P,Char_L,Char_A,Char_Y,Char_E,Char_R,Char_End};
	unsigned char Resume_Text[14]= {Char_R,Char_E,Char_S,Char_U,Char_M,Char_E,Char_End};
	unsigned char SaveQuit_Text[14]= {Char_S,Char_A,Char_V,Char_E,Char_Space,Char_And,Char_Space,Char_Q,Char_U,Char_I,Char_T,Char_End};
	unsigned char Quit_Text[14]= {Char_Q,Char_U,Char_I,Char_T,Char_End};
	
	StartMenu:
	OSContrastDn();
	
	//Draw blank screen
	memset(Light_Plane,0xFFFF,3000);
	memset(Dark_Plane,0xFFFF,3000);
	
	if(Save_Game)
	{
		//Save game data into Save_File
		//Prepare SAVE struct with DefaultSave data
		Saves[Current_Save].Weapons_Possessed=Weapons_Possessed;
		memcpy(Saves[Current_Save].Discovered_Pathways,Discovered_Pathways,16);
		memcpy(Saves[Current_Save].Shop_Activity_Record,Shop_Activity_Record,48);
		memcpy(Saves[Current_Save].Dungeon_Tracker,Dungeon_Tracker,32);
		memcpy(Saves[Current_Save].Dungeon_Tracker,Dungeon_Tracker,32);
		*(unsigned long*)Saves[Current_Save].Dungeon_Maps_Compasses=*(unsigned long*)Dungeon_Maps_Compasses;
		Saves[Current_Save].Heart_Containers=Heart_Containers;
		Saves[Current_Save].Bombs_Possessed=Bombs_Possessed;
		Saves[Current_Save].Max_Bombs=Max_Bombs;
		Saves[Current_Save].Rupies_Possessed=Rupies_Possessed;
		Saves[Current_Save].Keys_Possessed=Keys_Possessed;
		Saves[Current_Save].Current_Shield=Current_Shield;
		Saves[Current_Save].Letter_Shown=Letter_Shown;
		Saves[Current_Save].Beach_HrtCntnr_Taken=Beach_HrtCntnr_Taken;
		
		//Unarchive Save_File
		EM_moveSymFromExtMem(SYMSTR("loz_save"),HS_NULL);
		
		//Get Save_File Pointer
		Save_File=(unsigned char*)HeapDeref(SymFindPtr(SYMSTR("loz_save"),4)->handle)+2;
		ptr=Save_File;
		
		//Access Current DefaultSave in Save_File
		ptr+=Current_Save*DefaultSave_Size;
		
		//Copy Current DefaultSave data to Save_File
		memcpy(ptr,&Saves[Current_Save].Player_Name,DefaultSave_Size);
		
		//Access Current D_Room_Properties in Save_File
		Save_File+=3*DefaultSave_Size+Current_Save*Size_of_D_Room_Properties;
		
		//Copy Current D_Room_Properties to Save_File
		memcpy(Save_File,D_Room_Properties[Current_Save],Size_of_D_Room_Properties);
		
		//Archive Save_File
		EM_moveSymToExtMem(SYMSTR("loz_save"),HS_NULL);
		Save_Game=FALSE;
	}
	
	//Get address of archived Save_File and load Saves
	Save_File=(unsigned char*)HeapDeref(SymFindPtr(SYMSTR("loz_save"),4)->handle)+2;
	
	//Copy Current DefaultSave data from Save_File
	memcpy(&Saves[0].Player_Name,Save_File,3*DefaultSave_Size);
	
	
	//Access Current D_Room_Properties in Save_File
	Save_File+=3*DefaultSave_Size;
	
	//Load all D_Room_Properties from Save_File
	memcpy(D_Room_Properties[0],Save_File,3*Size_of_D_Room_Properties);
	
	//Draw StartMenu Box
	ptr=Light_Plane+30*21+2;
	*(unsigned long*)ptr&=0xC0000000;	//Top left line segment
	ptr+=6;
	*(unsigned long*)ptr&=0xFFFC0001;	//Top middle line segment
	ptr+=6;
	*(unsigned long*)ptr&=0xFFF80001;	//Top right line segment
	ptr=Light_Plane+30*90+2;
	*(unsigned long*)ptr&=0xC0000000;	//Bottom left line segment
	ptr+=4;
	*(unsigned long*)ptr&=0x00000000;	//Bottom middle line segment
	ptr+=4;
	*(unsigned long*)ptr&=0x00000000;	//Bottom middle line segment
	ptr+=4;
	*(unsigned long*)ptr&=0x00000001;	//Bottom right line segment
	
	ptr=Light_Plane+30*21+2;
	for(i=0;i<70;++i)
	{	//Left line
		*ptr&=0xDF;
		ptr+=30;
	}
	ptr=Light_Plane+30*21+17;
	for(i=0;i<70;++i)
	{	//Right line
		*ptr&=0xFD;
		ptr+=30;
	}
	
	//Prepare StartMenu text array
	ptr_array[0]=Select_Text;
	ptr_array[1]=Name_Text;
	ptr_array[2]=Life_Text;
	ptr_array[3]=RegPlayer_Text;
	ptr_array[4]=DelPlayer_Text;
	for(i=0;i<5;++i)
	{	//Print all texts except for player names
		x=StartMenu_Text_x[i];
		y=StartMenu_Text_y[i];
		ptr=ptr_array[i];
		while(*ptr!=Char_End)
		{
			Print_Character(x,y,Character[*ptr],Gray_Planes_BIN);
			x+=5;
			++ptr;
		}
	}
	
	//Draw StartMenu Link Sprites, Player Names and Heart Containers
	for(i=0;i<3;++i)
	{
		Draw_Link(31,29+12*i,Link[Magical_Shield][DOWN][Static],Gray_Planes_BIN);
		ptr=Saves[i].Player_Name;
		for(j=0;j<8;++j)
			Print_Character(43+5*j,31+12*i,Character[ptr[j]],Gray_Planes_BIN);
		x=Saves[i].Heart_Containers;
		for(j=0;j<x;++j)
			Draw_A_Heart(92+(j&0x07)*6,33+12*i-(j>>3)*5,Graphics16[Heart_Full],Gray_Planes_BIN);
	}
	//End of StartMenu initialization
	
	//Begin StartMenu Loop
	Menu_Key_Released=FALSE;
	Draw_A_Heart(25,31+12*Current_Save,Graphics16[Heart_Full],Gray_Planes_BIN);
	while(!Menu_Key_Released || (~_rowread(ARROWS_ROW)&SECOND_KEY && ~_rowread(F5_ROW)&ENTER_KEY))
	{
		if(~_rowread(ARROWS_ROW)&SECOND_KEY && ~_rowread(F5_ROW)&ENTER_KEY)
			Menu_Key_Released=TRUE;
		if(_rowread(ESC_ROW)&ESC_KEY)
		{
			OSContrastUp();
			goto Cleanup;
		}
		if(_rowread(ALL_ROWS))
			AutoOff_ClockRef=Global_Clock;
		if(Calc_ID[1]==51 && (_rowread(F1_ROW)&OR_KEY || Global_Clock-AutoOff_ClockRef>=APD_TimeLength))
		{
			asm("trap #4");
			AutoOff_ClockRef=Global_Clock;
			GrayAdjust(Gray_Index);
		}
		if(Global_Clock-Adjust_ClockRef>Adjust_Interval)	//Adjust Contrast
		{
			Adjust_ClockRef=Global_Clock;
			if(_rowread(F5_ROW)&PLUS_KEY)
				OSContrastUp();
			if(_rowread(F5_ROW)&MINUS_KEY)
				OSContrastDn();
		}
		
		j=_rowread(ARROWS_ROW);
		if(~j&UP_KEY && ~j&DOWN_KEY)
			Cursor_Key_Released=TRUE;
		if(Cursor_Key_Released==TRUE && ((j&UP_KEY && Current_Save>0) || (j&DOWN_KEY && Current_Save<2)))
		{
			Cursor_Key_Released=FALSE;
			Clear_Cursor(25,31+12*Current_Save,5,0xF800,LG_Plane_BIN);
			if(j&UP_KEY)
				--Current_Save;
			else
				++Current_Save;
			Draw_A_Heart(25,31+12*Current_Save,Graphics16[Heart_Full],Gray_Planes_BIN);
		}
	}
	OSContrastUp();
				
	//Load selected save data
	Weapons_Possessed=Saves[Current_Save].Weapons_Possessed;
	memcpy(Discovered_Pathways,Saves[Current_Save].Discovered_Pathways,16);
	memcpy(Shop_Activity_Record,Saves[Current_Save].Shop_Activity_Record,48);
	memcpy(Dungeon_Tracker,Saves[Current_Save].Dungeon_Tracker,32);
	memcpy(Dungeon_Tracker,Saves[Current_Save].Dungeon_Tracker,32);
	*(unsigned long*)Dungeon_Maps_Compasses=*(unsigned long*)Saves[Current_Save].Dungeon_Maps_Compasses;
	Heart_Containers=Saves[Current_Save].Heart_Containers;
	Bombs_Possessed=Saves[Current_Save].Bombs_Possessed;
	Max_Bombs=Saves[Current_Save].Max_Bombs;
	Rupies_Possessed=Saves[Current_Save].Rupies_Possessed;
	Keys_Possessed=Saves[Current_Save].Keys_Possessed;
	Current_Shield=Saves[Current_Save].Current_Shield;
	Letter_Shown=Saves[Current_Save].Letter_Shown;
	Beach_HrtCntnr_Taken=Saves[Current_Save].Beach_HrtCntnr_Taken;
	
	SaveFile_Active=TRUE;
	
		/*
	//For testing if TI-89 hardware present or just VTI
	unsigned char print[6]={Calc_ID[0],Calc_ID[1],Calc_ID[2],Calc_ID[3],Calc_ID[4],0};
	MoveTo(0,0);
	printf("%u ",Calc_ID[0]);
	MoveTo(0,8);
	printf("%u ",Calc_ID[1]);
	MoveTo(0,16);
	printf("%u ",Calc_ID[2]);
	MoveTo(0,24);
	printf("%u ",Calc_ID[3]);
	MoveTo(0,32);
	printf("%u ",Calc_ID[4]);
	//printf("%s",print); //Doesn't work. don't know why
	*/
						
	//Initiate Home Screen, Link, And Menu
	Link_x=75;	//(7*Sprite_w)+(Sprite_w/2)
	Link_y=45;	//(5*Sprite_h)
	Hearts=6;
	Cursor_Position=First_Cursor_Position;
	World=Overworld;
	World_Index=119;	//Homescreen (7*World_w+8)-1
//World_Index=55;	//Level 1
//World_Index=60;	//Level 2
//World_Index=116;	//Level 3
//World_Index=69;	//Level 4
//World_Index=11;	//Level 5
//World_Index=34;	//Level 6
//World_Index=109;	//Level 8
//World_Index=5;	//Level 9
	Inside_Portal=FALSE;
	Flash_Submenu=Flash_Submenu_Inactive;
	Clear_100th_Row(Light_Plane+2970,0,20);
	Clear_100th_Row(Dark_Plane+2970,0,20);
	Clear_100th_Row(Oversized_Buffer[0]+2970,0,20);
	Clear_100th_Row(Oversized_Buffer[1]+2970,0,20);
	Update_Screen_Tiles_Buffer(Screen_Tiles_Buffer,Screen_Map_Over[World_Index],Size_of_Screen_Tiles_Buffer);
	Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
	Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN|BG_Planes_BIN);
	Open_Curtains(&Global_Clock);
	for(i=0;i<Menu_w;++i)
		Draw_A_Menu_Tile(i<<5,0,Menu_Tile_h,Menu_Tiles[i],Menu_Planes_BIN);
	Update_Menu_SubTemplates(World,World_Index,Dungeon_Maps_Compasses,Dungeon_Tracker,D_Room_Properties[Current_Save],Dungeon_Levels,
		Character,Triforce_Template,Dungeon_Rough_Map_Template);
	Update_Triforces(Weapons_Possessed,Triforces,Menu_Planes_BIN);
	Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
	XOR_Menu_Map(Menu_Buffer[1],Menu_Map_x+((World_Index&0x0F)<<1),Menu_Map_y+((World_Index>>3)&0xFE));
	Update_Hearts(Not_Using_Potion,Hearts,Heart_Containers,Menu_Planes_BIN);
	Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
	Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
	PortSet(Oversized_Buffer[1],239,127);
	
	Game_Clock=0;
	Game_In_Progress=TRUE;
	
	
		
	//Temp variables for enemy_test routine in loop below
	BOOL SpriteKey=FALSE;
	BOOL Link_as_EnemySprite=FALSE;
	unsigned char Link_EnemySprite=OctorokLight;
		
	//Loop Game. Major loop.
	while(1)
	{		
		
		///Test enemy sprites (17 4D + 23 1D = 40)
		if(SpriteKey && ~_rowread(F3_ROW)&CTLG_KEY && ~_rowread(F1_ROW)&F1_KEY && ~_rowread(F2_ROW)&F2_KEY)
			SpriteKey=FALSE;
		if(!SpriteKey && _rowread(F3_ROW)&CTLG_KEY)
		{
			SpriteKey=TRUE;
			Link_as_EnemySprite=!Link_as_EnemySprite;
			Replenish_Link_BG(Link_x,Link_y,Current_Link);
			if(Link_as_EnemySprite)
			{
				if(Link_EnemySprite<17)
					Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
				else
					Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
			}
			else
				Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
		}
		if(!SpriteKey && Link_as_EnemySprite && (_rowread(F1_ROW)&F1_KEY || _rowread(F2_ROW)&F2_KEY))
		{
			SpriteKey=TRUE;
			if(_rowread(F1_ROW)&F1_KEY)
			{
				if(Link_EnemySprite>0)
					--Link_EnemySprite;
				else
					Link_EnemySprite=39;
			}
			if(_rowread(F2_ROW)&F2_KEY)
			{
				if(Link_EnemySprite<39)
					++Link_EnemySprite;
				else
					Link_EnemySprite=0;
			}
			MoveTo(0,0);
			printf("%u ",Link_EnemySprite);
			Replenish_Link_BG(Link_x,Link_y,Current_Link);
			if(Link_EnemySprite<17)
				Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
			else
				Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
	  }
	  
	  
		
		Game:
		//Algorithm for ExitMenu
		if(_rowread(ESC_ROW)&ESC_KEY)
		{
			Game_In_Progress=FALSE;
			memset(Light_Plane,0xFFFF,2970);
			memset(Dark_Plane,0xFFFF,2970);
			OSContrastDn();
			ptr_array[0]=Resume_Text;
			ptr_array[1]=SaveQuit_Text;
			ptr_array[2]=Quit_Text;
			for(i=0;i<3;++i)
			{	//Print ExitMenu Texts
				x=40;
				ptr=ptr_array[i];
				while(*ptr!=Char_End)
				{
					Print_Character(x,31+9*i,Character[*ptr],Gray_Planes_BIN);
					x+=5;
					++ptr;
				}
			}
			
			j=0;
			Menu_Key_Released=FALSE;
			Draw_A_Heart(32,31,Graphics16[Heart_Full],Gray_Planes_BIN);
			while(~_rowread(ARROWS_ROW)&SECOND_KEY && ~_rowread(F5_ROW)&ENTER_KEY)
			{
				if(~_rowread(ESC_ROW)&ESC_KEY)
					Menu_Key_Released=TRUE;
				if(Menu_Key_Released && _rowread(ESC_ROW)&ESC_KEY)
				{
					OSContrastUp();
					goto Cleanup;
				}
				if(_rowread(ALL_ROWS))
					AutoOff_ClockRef=Global_Clock;
				if(Calc_ID[1]==51 && (_rowread(F1_ROW)&OR_KEY || Global_Clock-AutoOff_ClockRef>=APD_TimeLength))
				{
					asm("trap #4");
					AutoOff_ClockRef=Global_Clock;
					GrayAdjust(Gray_Index);
				}
				
				i=_rowread(ARROWS_ROW);
				if(~i&UP_KEY && ~i&DOWN_KEY)
					Cursor_Key_Released=TRUE;
				if(Cursor_Key_Released==TRUE && ((i&UP_KEY && j>0) || (i&DOWN_KEY && j<2)))
				{
					Cursor_Key_Released=FALSE;
					Clear_Cursor(32,31+9*j,5,0xF800,LG_Plane_BIN);
					if(i&UP_KEY)
						--j;
					else
						++j;
					Draw_A_Heart(32,31+9*j,Graphics16[Heart_Full],Gray_Planes_BIN);
				}
			}
			OSContrastUp();
			if(j==0)
			{
				Game_In_Progress=TRUE;
				Sword_Key_Released=FALSE; //Prevents Link from shooting sword immediately after resuming game with 2nd key
				goto Game;
			}
			else if(j==1)
			{
				while(_rowread(ARROWS_ROW)&SECOND_KEY) {} //Prevents "2nd" from appearing on status bar 
				Save_Game=TRUE;
				Return_to_StartMenu=TRUE;
				goto Scroll_Prep;
			}
			else
			{
				Return_to_StartMenu=TRUE;
				goto Scroll_Prep;
			}
		}
		
		
	
	
		//Pause game function
		if(~_rowread(F1_ROW)&APPS_KEY)
			APPS_KEY_Pressed=FALSE;
		if(!APPS_KEY_Pressed && _rowread(F1_ROW)&APPS_KEY)
		{
			APPS_KEY_Pressed=TRUE;
			Game_In_Progress=FALSE;
			for(i=0;i<3;++i)
				Draw_Paused(56+(i<<4),18,16,Paused_GFX[i],Gray_Planes_BIN);
			while(APPS_KEY_Pressed==TRUE || ~_rowread(F1_ROW)&APPS_KEY)
			{
				if(~_rowread(F1_ROW)&APPS_KEY)
					APPS_KEY_Pressed=FALSE;
				if(Global_Clock-Adjust_ClockRef>Adjust_Interval)	//Adjust Contrast
				{
					Adjust_ClockRef=Global_Clock;
					if(_rowread(F5_ROW)&PLUS_KEY)
						OSContrastUp();
					if(_rowread(F5_ROW)&MINUS_KEY)
						OSContrastDn();
				}
				if(_rowread(ALL_ROWS))
					AutoOff_ClockRef=Global_Clock;
				if(Calc_ID[1]==51 && (_rowread(F1_ROW)&OR_KEY || Global_Clock-AutoOff_ClockRef>=APD_TimeLength))
				{
					asm("trap #4");
					AutoOff_ClockRef=Global_Clock;
					GrayAdjust(Gray_Index);
				}
			}
			APPS_KEY_Pressed=TRUE;
			Game_In_Progress=TRUE;
		}
				
		//Algorithm to adjust all variables
		if(Global_Clock-Adjust_ClockRef>Adjust_Interval)
		{
			Adjust_ClockRef=Global_Clock;
			if(_rowread(ALL_ROWS))
				AutoOff_ClockRef=Global_Clock;
			if(Calc_ID[1]==51 && (_rowread(F1_ROW)&OR_KEY || Global_Clock-AutoOff_ClockRef>=APD_TimeLength))
			{
				asm("trap #4");
				AutoOff_ClockRef=Global_Clock;
				GrayAdjust(Gray_Index);
			}
			if(~_rowread(F2_ROW)&MODE_KEY)
				Decompression_Key_Released=TRUE;
			if(_rowread(F2_ROW)&MODE_KEY&&Decompression_Key_Released)
			{
				Decompression_Key_Released=FALSE;
				if(Decompress==Retain_All)
				{
					Decompress=Retain_None;
					MoveTo(0,0);
					printf("Retain None");
				}
				else
				{
					Decompress=Retain_All;
					MoveTo(0,0);
					printf("Retain All ");
				}
			}
			if(_rowread(F4_ROW)&COMMA_KEY)
			{
				MoveTo(93,0);
				printf("%010lu",Global_Clock);
			}
			if(~_rowread(F4_ROW)&BKSPC_KEY)
				TimeBypass_Key_Released=TRUE;
			if(TimeBypass_Key_Released&&_rowread(F4_ROW)&BKSPC_KEY)
			{
				TimeBypass_Key_Released=FALSE;
				TimeBypass=!TimeBypass;
			}
			if(~_rowread(F5_ROW)&CLEAR_KEY)
				Walkthrough_Key_Released=TRUE;
			if(Walkthrough_Key_Released&&_rowread(F5_ROW)&CLEAR_KEY)
			{
				Walkthrough_Key_Released=FALSE;
				Walkthrough=!Walkthrough;
			}
			Update_Vars(&Sprite_Interval,&Projectile_Interval,&Scroll_Interval,&Adjust_Interval,&Gray_Index,
				&Current_Shield,&Weapons_Possessed,&Heart_Containers,&Hearts,&Rupies_Possessed,&Keys_Possessed,&Bombs_Possessed,&Max_Bombs,&Dungeon_Maps_Compasses[0]);
			if(_rowread(F1_ROW)&STO_KEY||_rowread(F1_ROW)&EE_KEY||_rowread(F2_ROW)&LB_KEY||_rowread(F3_ROW)&RB_KEY)
			{
				Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
				if(!World)
					Update_Triforces(Weapons_Possessed,Triforces,Menu_Planes_BIN);
				Update_Hearts(Not_Using_Potion,Hearts,Heart_Containers,Menu_Planes_BIN);
				Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
				Replenish_Link_BG(Link_x,Link_y,Current_Link);
				if(!Link_as_EnemySprite)
					Current_Link=Link[Current_Shield][Link_Direction][Link_Animation]; 
			}
		}	//End of Adjust Variables algorithm
		
			
	  
		
				/*			///Refresh list once finalized		
				//Enemy variables
				unsigned char Enemies[8];	//Works as sprite def'n as well
				unsigned char Enemy_Direction[8];
				unsigned char Enemy_x[8];
				unsigned char Enemy_y[8];
				BOOL Enemy_Animation[8];
				unsigned long Enemy_Move_ClockRef[8];
				unsigned long Enemy_Event[8];
				unsigned long Enemy_Event_ClockRef[8];
				unsigned long Enemy_ProjRelease_ClockRef[8];
				//unsigned char Enemy_LogicLevel[8];
				//unsigned char Enemy_Attitude[8];
		*/
		
				/* REPEATED HERE FOR REFERENCE
				//Enemy_Data[Current_Item] gets loaded into STRUCT Active_Enemies[8]	
				struct ENEMY	///Refresh list once finalized	
				{
					unsigned char Life;
					unsigned char Movement;
					unsigned char Movement_Interval;
					unsigned char Enemy_Damage_to_Link;
					unsigned char Projectile_Type;	//Works as sprite def'n as well
					unsigned char Projectile_Release_Time;	//is shifted left by 8 after being loaded
					unsigned char Projectile_Damage_to_Link;
					unsigned char Special;	//Defines weaknesses, immunities
					unsigned char Dropable_Items;
				} Active_Enemies[8];
				*/	
		
		
		//Active_Enemies algorithm
		for(i=0;i<8;++i)
		{	//Scan through all 8 possibly existing enemies
			Current_Enemy=Enemies[i];
			if(Current_Enemy!=Enemy_Dead && !World && !World_Index!=Shop_Room)
			{
				x=Enemy_x[i];
				y=Enemy_y[i];
				j=Enemy_State[i];
				Replenish_Enemy_BG(x,y,Enemy_Sprite[i]);	//Erase the enemy before possible direction and location modifications
				if(Game_Clock-Enemy_Move_ClockRef[i]>Active_Enemies[i].Movement_Interval)	//If enough time has passed, allow movement
				{
					Enemy_Move_ClockRef[i]=Game_Clock;
					if(Enemy_State[i]<=Enemy_Breaking)
					{	//For new enemies
						if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
						{	//Enemies are now born
							Enemy_Event_ClockRef[i]=Game_Clock;
							Enemy_State[i]=Enemy_Move;
							switch(Current_Enemy)
							{	//Enemy-specific initialization instructions after birth
								case SpiderLight:
								{
									Enemy_State[i]=Enemy_Stop;
									Enemy_Counter[i]=8;	//Forces jump almost immediately after birth
									break;
								}
								case SpiderDark:
								{
									Enemy_State[i]=Enemy_Stop;
									Enemy_Counter[i]=8;	//Forces jump almost immediately after birth
									break;
								}
								case Peahat:
								{
									Enemy_State[i]=Enemy_SpeedUp;
									Enemy_Direction[i]=i&7;	//Creates randomness in initial flight direction
									Enemy_Counter[i]=10;
									break;
								}
							}
						}
						else if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i]-64)
						{
							Enemy_State[i]=Enemy_Breaking;
							Enemy_Sprite[i]=Graphics16[Cloud_Half];
						}
						
						k=Enemy_State[i];
						if(k==Enemy_Appearing)
							Enemy_Sprite[i]=Graphics16[Cloud_Full];
						else if(k==Enemy_Breaking)
							Enemy_Sprite[i]=Graphics16[Cloud_Half];
						else if(Current_Enemy<SpiderLight)	//4D enemies
							Enemy_Sprite[i]=Enemies4D[Current_Enemy][Enemy_Direction[i]][Enemy_Animation[i]];
						else	//1D enemies
							Enemy_Sprite[i]=Enemies1D[Current_Enemy-SpiderLight][Enemy_Animation[i]];
					}	//End of enemy appearing/breaking routine
					else
					{	//Beginning of enemy movement routine
						Enemy_Screen_Index=y/Sprite_h*Screen_w+x/Sprite_w;	//Compute Screen_Index to allow use of Screen_Tiles_Buffer
						Enemy_x_RMNDR=x%Sprite_w;
						Enemy_y_RMNDR=y%Sprite_h;
						if(Enemy_Animate[i])
							++Enemy_Anim_Counter[i];
						if(Enemy_Anim_Counter[i]==Active_Enemies[i].Animate_Interval)	//Animate the enemy after enough movements have passed
						{
							Enemy_Anim_Counter[i]=0;
							Enemy_Animation[i]= !Enemy_Animation[i];
						}
						switch(Active_Enemies[i].Movement)
						{
							case Spider_Jump:
							{
								switch(Enemy_State[i])
								{
									case Enemy_Stop:
									{
										--Enemy_Counter[i];
										if(Enemy_Counter[i]==15)
										{	//Stop animating just prior to jumping
											Enemy_Animate[i]=FALSE;
											Enemy_Animation[i]=0;
										}
										if(Enemy_Counter[i]==0)
										{
											Enemy_State[i]=Enemy_Jump;
											Enemy_Animate[i]=FALSE;	//Required for first jump, not for the rest
											Enemy_Animation[i]=1;
											if(Global_Clock&1)
												Enemy_Direction[i]=LEFT;
											else
												Enemy_Direction[i]=RIGHT;
											SpiderJumps_Remaining[i]=1+Game_Clock%3;	//Randomly define 1-3 successive jumps
										}
										break;
									}
									case Enemy_Jump:
									{
										if(Enemy_Counter[i])
										{	//Continue the current jump
											Enemy_x[i]+=Unit_x_Offset[Enemy_Direction[i]];
											Enemy_y[i]+=SpiderPath_Offset[Current_SpiderPath[i]][Enemy_Counter[i]];
											j=Enemy_x[i];
											if(j<=Sprite_w)
												Enemy_Direction[i]=RIGHT;
											if(j>=LCD_w-2*Sprite_w)
												Enemy_Direction[i]=LEFT;
											--Enemy_Counter[i];
										}
										else if(SpiderJumps_Remaining[i])
										{	//Initiate another jump
											--SpiderJumps_Remaining[i];
											if(y<14)	//Limit upward jumping options
												j=3;
											else if(y<18)
												j=2;
											else if(y<23)
												j=1;
											else
												j=0;
											if(y>76)	//Limit downward jumping options
												k=4;
											else if(y>72)
												k=5;
											else if(y>67)
												k=6;
											else
												k=7;
											Current_SpiderPath[i]=j+Game_Clock%(k-j);	//Randomly define a jumping path based on limits
											Enemy_Counter[i]=SpiderPath_Length[Current_SpiderPath[i]];	//Initialize the counter as the length of the defined path
										}
										else
										{	//Last jump is complete, stop movement
											Enemy_State[i]=Enemy_Stop;
											Enemy_Animate[i]=TRUE;
											Enemy_Event_ClockRef[i]=Game_Clock;
											if(i&1)
												j=Game_Clock&1;
											else
												j=Global_Clock&1;
											Enemy_Counter[i]=(1+j)<<5;	//Randomize # of movement cycles of stop time
											//Enemy_Counter[i]=1;
										}
										break;
									}
								}
								Enemy_Sprite[i]=Enemies1D[Current_Enemy-SpiderLight][Enemy_Animation[i]];
								break;
							}	//End of SpiderJump
							case PeahatFly:
							{	//During flight, move cycles are used for redirecting and clock is used for stopping. Movement_Interval is used as SpeedUp/SlowDown index.
								if(Enemy_State[i]!=Enemy_Stop)
								{	//Execute movements
									if(Enemy_State[i]==Enemy_SpeedUp && Game_Clock-Enemy_Event_ClockRef[i]>40)
									{	//Progressively speed up enemy to full speed
										Enemy_Event_ClockRef[i]=Game_Clock;
										--Active_Enemies[i].Movement_Interval;
										if(Active_Enemies[i].Movement_Interval==10)
										{
											Enemy_State[i]=Enemy_Fly;
											Enemy_Event_Interval[i]=(7+Game_Clock%7)<<8;	//Randomly define # of seconds of full speed flight time
										}
									}
									if(Enemy_State[i]==Enemy_Fly && Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
										Enemy_State[i]=Enemy_SlowDown;
									if(Enemy_State[i]==Enemy_SlowDown && Game_Clock-Enemy_Event_ClockRef[i]>40)
									{	//Progressively slow down enemy to a stop
										Enemy_Event_ClockRef[i]=Game_Clock;
										++Active_Enemies[i].Movement_Interval;
										if(Active_Enemies[i].Movement_Interval==20)
										{
											Enemy_State[i]=Enemy_Stop;
											Enemy_Animate[i]=FALSE;
											Enemy_Animation[i]=1;
											Enemy_Event_Interval[i]=512;
											Enemy_Event_ClockRef[i]=Game_Clock;
										}
									}
									j=Enemy_State[i];
									if(Enemy_Counter[i])
									{
										j=Enemy_x[i];
										if(j<=Sprite_w)
											Enemy_Direction[i]=East;
										if(j>=LCD_w-2*Sprite_w)
											Enemy_Direction[i]=West;
										j=Enemy_y[i];
										if(j<=Sprite_h)
											Enemy_Direction[i]=South;
										if(j>=LCD_h-1-2*Sprite_h)
											Enemy_Direction[i]=North;
										j=Enemy_Direction[i];
										Enemy_x[i]+=Boomerang_x_Increment[j];
										Enemy_y[i]+=Boomerang_y_Increment[j];
										--Enemy_Counter[i];
									}
									else
									{
										if(Enemy_State[i]==Enemy_Fly)	//Change fly direction only when not speeding up or slowing down
												Enemy_Direction[i]=Flying_Directions[Enemy_Direction[i]][(Game_Clock)%5];
										Enemy_Counter[i]=10;
									}
								}
								else
								{	//Do not move peahat
									if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
									{
										Enemy_State[i]=Enemy_SpeedUp;
										Enemy_Animate[i]=TRUE;
										Enemy_Counter[i]=10;
										Enemy_Event_ClockRef[i]=Game_Clock;
									}
								}
								Enemy_Sprite[i]=Enemies1D[Peahat-SpiderLight][Enemy_Animation[i]];
								break;
							}	//End of PeahatFly
							case VireBunny_Hop:
							{
								Enemy_Sprite[i]=Enemies1D[Current_Enemy-SpiderLight][Enemy_Animation[i]];
								break;
							}	//End of VireBunny_Hop
							case Wizzrobe_Glide:
							{
								
								Enemy_Sprite[i]=Enemies4D[Current_Enemy][Enemy_Direction[i]][Enemy_Animation[i]];
								break;
							}	//End of Wizzrobe_Glide
							case On_Land:
							{
								if(Enemy_State[i]==Enemy_Move)
								{
									//If enemy is aligned horizontally and vertically, make a direction decision
									if(!Enemy_x_RMNDR && !Enemy_y_RMNDR)
									{
										Total_Directions=0;	//Total number of directions the enemy can turn to.
										for(j=0;j<4;++j)	//Check all 4 directions around the enemy
										{
											k=Screen_Tiles_Buffer[Enemy_Screen_Index+Screen_Index_Offset[j]];	//Grab an adjacent tile
											if((k==D_Tile || k==Null || k==Dark || k==Cave || k==Sand) && //Check if the tile is "walkable"
												Object_Within_Boundaries(j,x,y,Sprite_h+1,Sprite_w+1,LCD_h-1-2*Sprite_h-1,LCD_w-2*Sprite_w-1))
											{
												Directions[Total_Directions]=j;	//Add current direction to the list if walkable
												++Total_Directions;
												if((j^0x02)!=Enemy_Direction[i])	//Increase the probability of the enemy avoiding 180 turns ( ^0x02 inverts the direction) 
												{
													Directions[Total_Directions]=j;
													++Total_Directions;
												}
												if(j==Enemy_Direction[i])	//Further increase the probability of the enemy going straight
												{
													Directions[Total_Directions]=j;
													++Total_Directions;
													Directions[Total_Directions]=j;
													++Total_Directions;
												}
											}
										}
										if(i&1)
											j=(unsigned char)(Game_Clock%Total_Directions);	//Generate random seed for i=1,3,5,7
										else
											j=(unsigned char)(Global_Clock%Total_Directions);	//Generate random seed for i=0,2,4,6
										Enemy_Direction[i]=Directions[j];
									}
									Enemy_x[i]+=Unit_x_Offset[Enemy_Direction[i]];
									Enemy_y[i]+=Unit_y_Offset[Enemy_Direction[i]];
									
									//Projectile release testing/initialization
									if(Game_Clock-Enemy_ProjRelease_ClockRef[i]>Enemy_ProjRelease_Interval[i])
									{
										//Measure the length of the "line of sight" of the enemy (to avoid shooting directly into a wall)
										Enemy_Screen_Index=y/Sprite_h*Screen_w+x/Sprite_w;
										offset=Screen_Index_Offset[Enemy_Direction[i]];
										j=Screen_Tiles_Buffer[Enemy_Screen_Index+offset];
										offset+=offset;
										k=Screen_Tiles_Buffer[Enemy_Screen_Index+offset];
										if(j>WW_5_D || k>WW_5_D)
											Enemy_ProjRelease_Interval[i]+=256;	//Postpone the projectile shot by one second due to short "line of sight"
										else if(Game_Clock&1 &&	//Randomize the possibility of firing a projectile (otherwise delay further)
										 Object_Within_Boundaries(Enemy_Direction[i],Enemy_x[i],Enemy_y[i],2*Sprite_h,2*Sprite_w,LCD_h-3*Sprite_h,LCD_w-3*Sprite_w))
										{	//Initialize a projectile
											Enemy_State[i]=Enemy_ShootProj;	//Temporarily immobilizes enemy
											Enemy_Event_ClockRef[i]=Game_Clock;
										}
										else	///Can remove brackets?
										{	//Increase Enemy_ProjRelease_Interval[i] by 1-4 seconds
											Enemy_ProjRelease_Interval[i]+=(1+(Global_Clock&3))<<7;
										}
									}
								}
								else if(Enemy_State[i]==Enemy_ShootProj && Game_Clock-Enemy_Event_ClockRef[i]>128)	//Shoot a projectile
								{
									Enemy_State[i]=Enemy_Stop;
									Enemy_Projectile[i]=Active_Enemies[i].Projectile_Type;
									Enemy_Projectile_x[i]=Enemy_x[i];
									Enemy_Projectile_y[i]=Enemy_y[i];
									Enemy_Proj_Direction[i]=Enemy_Direction[i];
									switch(Enemy_Projectile[i])
									{
										case OctorokRock:
										{
											Enemy_Proj_Sprite[i]=Graphics16[OctorokRock_GFX];
											break;
										}
										case MolblinArrow:
										{
											Enemy_Proj_Sprite[i]=Arrow[0][Enemy_Proj_Direction[i]];
											break;
										}
										case LynelSword:
										{
											Enemy_Proj_Sprite[i]=Sword[Wooden_Sword][Full_Sword][Enemy_Proj_Direction[i]];
											break;
										}
									}
  								Enemy_ProjMove_Interval[i]=Enemy_ProjMove_Intervals[Enemy_Projectile[i]-1];
									Enemy_ProjRelease_Interval[i]=(Active_Enemies[i].ProjRelease_Interval)<<8;
									Enemy_ProjRelease_ClockRef[i]=Game_Clock;
								}
								else if(Enemy_State[i]==Enemy_Stop && Game_Clock-Enemy_Event_ClockRef[i]>256)	//Resume movement after shooting a projectile
									Enemy_State[i]=Enemy_Move;
									
								if(Current_Enemy<SpiderLight)	//4D enemies
									Enemy_Sprite[i]=Enemies4D[Current_Enemy][Enemy_Direction[i]][Enemy_Animation[i]];
								else	//1D enemies
									Enemy_Sprite[i]=Enemies1D[Current_Enemy-SpiderLight][Enemy_Animation[i]];
								break;
							}	//End of On_Land
							case Zola_Water:
							{
								switch(Enemy_State[i])
								{
									case Enemy_Submerged:
									{
										if(Game_Clock-Enemy_Event_ClockRef[i]>512)
										{
											Total_Water_Tiles=0;
											ptr=Screen_Tiles_Buffer+17;	//read-only ptr
											ptr2=Current_Screen_Buffer[0];	//Used to store the locations of water tiles (write ptr)
											for(Scroll_Index=17;Scroll_Index<=158;++Scroll_Index)	//Scans only the middle 9 rows, while ignoring leftmost and rightmost columns
											{
												j=*ptr++;	//Grab current tile and increment ptr
												k=Scroll_Index&0x0F;	//k= Scroll_Index%16
												if(j>=W_0 && j<=W_SE && k>=1 && k<=14)
												{
													*ptr2++=Scroll_Index;	//record the number of the tile that has been identified
													++Total_Water_Tiles;	//increment the water squares counter
												}
											}
											ptr2=Current_Screen_Buffer[0];	//Reset water pointer
						
											j=Game_Clock%Total_Water_Tiles;	//Generate random seed
											k=ptr2[j];	//Grab a random On_Land tile
											Enemy_x[i]=(k&0x0F)*Sprite_w;
											Enemy_y[i]=(k>>4)*Sprite_h;
											
											Enemy_State[i]=Enemy_Emerging;
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Sprite[i]=Graphics16[Leever_Hole_1];
										}
										break;
									}
									case Enemy_Emerging:
									{
										Flash_Required=Game_Clock-Enemy_Event_ClockRef[i];	//Used as dummy (unsigned long required)
										if(Flash_Required>128)
										{
											Enemy_State[i]=Enemy_Move;
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Sprite[i]=Enemies1D[Zola-SpiderLight][0];
										}
										else if(Flash_Required>64)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_2];
										break;
									}
									case Enemy_Move:
									{
										if(Game_Clock-Enemy_Event_ClockRef[i]>192)
										{	//Aim and fire a projectile
											Enemy_State[i]=Enemy_Stop;	//Ensures only one shot is fired
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Projectile[i]=ZolaFire;
											Enemy_Proj_Sprite[i]=Graphics16[ZolaFire_GFX];
											Enemy_Projectile_x[i]=Enemy_x[i];
											Enemy_Projectile_y[i]=Enemy_y[i];
  								
											dx=Link_x-Enemy_x[i];	//Uses polarity convention of standard cartesian coordinates
											dy=Enemy_y[i]-Link_y;	//Uses polarity convention of standard cartesian coordinates
											if(dy>=0)
											{
												if(dx>=0)
													Zola_Quadrant=1;
												else
													Zola_Quadrant=2;
											}
											else
											{
												if(dx>=0)
													Zola_Quadrant=4;
												else
													Zola_Quadrant=3;
											}
											
											Tan_Ratio=(dy<<8)/(dx+1);
											Tan_Ratio=abs(Tan_Ratio);
											if(Tan_Ratio<22)	//5
												Enemy_Proj_Direction[i]=0;
											else if(Tan_Ratio<69)	//15
												Enemy_Proj_Direction[i]=1;
											else if(Tan_Ratio<119)	//25
												Enemy_Proj_Direction[i]=2;
											else if(Tan_Ratio<179)	//35
												Enemy_Proj_Direction[i]=3;
											else if(Tan_Ratio<256)	//45
												Enemy_Proj_Direction[i]=4;
											else if(Tan_Ratio<366)	//55
												Enemy_Proj_Direction[i]=5;
											else if(Tan_Ratio<549)	//65
												Enemy_Proj_Direction[i]=6;
											else if(Tan_Ratio<955)	//75
												Enemy_Proj_Direction[i]=7;
											else if(Tan_Ratio<2926)	//85
												Enemy_Proj_Direction[i]=8;
											else	//>85
												Enemy_Proj_Direction[i]=9;
											ZolaFire_CycleLength=ZolaFire_CycleLengths[Enemy_Proj_Direction[i]];
											
											
		  								if(Enemy_Proj_Direction[i]>=3 && Enemy_Proj_Direction[i]<=6)
		  									Enemy_ProjMove_Interval[i]=5;	//Slow down projectiles fired at angles close to 45
		  								else
		  									Enemy_ProjMove_Interval[i]=4;
										}
									}
									case Enemy_Stop:
									{
										if(Game_Clock-Enemy_Event_ClockRef[i]>192)
										{
											Enemy_State[i]=Enemy_Submerging;
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Sprite[i]=Graphics16[Leever_Hole_2];
										}
										break;
									}
									case Enemy_Submerging:
									{
										Flash_Required=Game_Clock-Enemy_Event_ClockRef[i];	//Used as dummy (unsigned long required)
										if(Flash_Required>128)
										{
											Enemy_Sprite[i]=Graphics16[Enemy_Invisible];
											Enemy_State[i]=Enemy_Submerged;
											Enemy_Event_ClockRef[i]=Game_Clock;
										}
										else if(Flash_Required>64)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_1];
										break;
									}
								}
								break;
							}	//End of Zola_Water
							case LeeverLight_Dive:
							{
								switch(Enemy_State[i])
								{
									case Enemy_Submerged:
									{
										if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
										{
											for(j=0;j<2;++j)
											{
												if(Enemy_State[i]==Enemy_Submerged)
												{
													Scroll_Index=0;	//Used as dummy to test if boundary constraints were met during tests
													switch(Link_Direction)
													{
														case UP:
														{
															if(Link_y>3*Sprite_h)
															{
																Scroll_Index=1;
																Enemy_x[i]=Link_x;
																Enemy_y[i]=Link_y-2*Sprite_h-Link_y_RMNDR;
																Enemy_Direction[i]=DOWN;
															}
															break;
														}
														case LEFT:
														{
															if(Link_x>3*Sprite_w)
															{
																Scroll_Index=1;
																Enemy_y[i]=Link_y;
																Enemy_x[i]=Link_x-2*Sprite_w-Link_x_RMNDR;
																Enemy_Direction[i]=RIGHT;
															}
															break;
														}
														case DOWN:
														{
															if(Link_y<LCD_h-1-4*Sprite_h)
															{
																Scroll_Index=1;
																Enemy_x[i]=Link_x;
																Enemy_y[i]=Link_y+3*Sprite_w-Link_y_RMNDR;
																Enemy_Direction[i]=UP;
															}
															break;
														}
														case RIGHT:
														{
															if(Link_x<LCD_w-3*Sprite_w)
															{
																Scroll_Index=1;
																Enemy_y[i]=Link_y;
																Enemy_x[i]=Link_x+3*Sprite_w-Link_x_RMNDR;
																Enemy_Direction[i]=LEFT;
															}
															break;
														}
													}
													k=Enemy_y[i]/Sprite_h*World_w+Enemy_x[i]/Sprite_w;
													if(Link_Direction==DOWN)
														k+=Screen_w;	//Fixes problem where part of Leever emerges through rock/tree
													x=Screen_Tiles_Buffer[k];	//used as dummy
													if(Link_Direction&1)	//LEFT or RIGHT
														y=Screen_Tiles_Buffer[k+Screen_w];	//used as dummy
													else	//UP or DOWN
														y=Screen_Tiles_Buffer[k+1];	//used as dummy
													if(Scroll_Index && (x==Null || x==Sand) && (y==Null || y==Sand))
													{
														Enemy_State[i]=Enemy_Emerging;
														Enemy_Event_ClockRef[i]=Game_Clock;
													}
												}
												Link_Direction^=0x2;	//Effectively inverts direction (always executed twice by for loop)
											}	//End of for loop
										}	//End of Event_ClockRef test
										break;
									}	//End of Enemy_Submerged
									case Enemy_Emerging:
									{
										Flash_Required=Game_Clock-Enemy_Event_ClockRef[i];	//Used as dummy (unsigned long required)
										if(Flash_Required>256)
										{
											Enemy_State[i]=Enemy_Move;
											Enemy_Sprite[i]=Enemies1D[LeeverLight-SpiderLight][Enemy_Animation[i]];
										}
										else if(Flash_Required>192)
											Enemy_Sprite[i]=Graphics16[LeeverLight_Half];
										else if(Flash_Required>128)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_2];
										else if(Flash_Required>64)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_1];
										break;
									}
									case Enemy_Move:
									{
										j=Enemy_Direction[i];
										if((j&1 && !Enemy_x_RMNDR) || (!(j&1) && !Enemy_y_RMNDR))
										{
											k=Screen_Tiles_Buffer[Enemy_Screen_Index + Screen_Index_Offset[j]];
											if(Enemy_y_RMNDR)	//Left/Right but non-aligned
												Scroll_Index=Screen_Tiles_Buffer[Enemy_Screen_Index + Screen_Index_Offset[j]+World_w];
											else if(Enemy_x_RMNDR)	//Up/Down but non-aligned
												Scroll_Index=Screen_Tiles_Buffer[Enemy_Screen_Index + Screen_Index_Offset[j]+1];
											else
												Scroll_Index=k;
											if((k!=Null && k!=Sand) || (Scroll_Index!=Null && Scroll_Index!=Sand) ||
												!Object_Within_Boundaries(j,x,y,Sprite_h+1,Sprite_w+1,LCD_h-1-2*Sprite_h-1,LCD_w-2*Sprite_w-1))
											{
												Enemy_State[i]=Enemy_Submerging;
												Enemy_Event_ClockRef[i]=Game_Clock;
											}
										}
										if(Enemy_State[i]!=Enemy_Submerging)
										{
											Enemy_x[i]+=Unit_x_Offset[j];
											Enemy_y[i]+=Unit_y_Offset[j];
											Enemy_Sprite[i]=Enemies1D[LeeverLight-SpiderLight][Enemy_Animation[i]];	//Required for animations
										}
										break;
									}
									case Enemy_Submerging:
									{
										Flash_Required=Game_Clock-Enemy_Event_ClockRef[i];	//Used as dummy (unsigned long required)
										if(Flash_Required>256)
										{
											Enemy_State[i]=Enemy_Submerged;
											Enemy_Sprite[i]=Graphics16[Enemy_Invisible];
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Event_Interval[i]=512;
										}
										else if(Flash_Required>192)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_1];
										else if(Flash_Required>128)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_2];
										else if(Flash_Required>64)
											Enemy_Sprite[i]=Graphics16[LeeverLight_Half];
										break;
									}
								}
								break;
							}	//End of LeeverLight_Dive
							case LeeverDark_Dive:
							{
								switch(Enemy_State[i])
								{
									case Enemy_Submerged:
									{
										if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
										{
											Enemy_State[i]=Enemy_Emerging;
											Enemy_Event_ClockRef[i]=Game_Clock;
											
											//Identify valid "birth squares" for LeeverDark.
											Total_Land_Tiles=0;
											ptr=Screen_Tiles_Buffer+34;
											ptr2=Current_Screen_Buffer[0];	//Used to store the locations of land tiles
											for(Scroll_Index=34;Scroll_Index<=141;++Scroll_Index)	//Scans only the middle 7 rows, while ignoring 2 left columns at top row and 2 right columns at bottome row
											{
												j=*ptr++;	//Grab current tile and increment ptr
												k= Scroll_Index&0x0F;	//dummy variable
												if(k>=2 && k<=13)
												{
													if(j==Null || j==Sand)
													{
														*ptr2++=Scroll_Index;	//record the number of the tile that has been identified
														++Total_Land_Tiles;	//increment the land squares counter
													}
												}
											}
											ptr2=Current_Screen_Buffer[0];	//Reset land pointer
											
											j=Game_Clock%Total_Land_Tiles;	//Randomly select one of the identified available birth squares 
											k=ptr2[j];	//Grab a random On_Land tile
											Enemy_x[i]=(k&0x0F)*Sprite_w;
											Enemy_y[i]=(k>>4)*Sprite_h;
										}
										break;
									}	//End of Enemy_Submerged
									case Enemy_Emerging:
									{
										Flash_Required=Game_Clock-Enemy_Event_ClockRef[i];	//Used as dummy (unsigned long required)
										if(Flash_Required>256)
										{
											Enemy_State[i]=Enemy_Move;
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Event_Interval[i]=(5+Game_Clock%4)<<8;	//Randomly define 5-8 seconds of move time
											//Enemy_Sprite[i]=Enemies1D[LeeverDark-SpiderLight][Enemy_Animation[i]];	///Required?
										}
										else if(Flash_Required>192)
											Enemy_Sprite[i]=Graphics16[LeeverLight_Half];
										else if(Flash_Required>128)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_2];
										else if(Flash_Required>64)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_1];
										break;
									}
									case Enemy_Move:
									{
										if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
										{
											Enemy_State[i]=Enemy_Submerging;
											Enemy_Event_ClockRef[i]=Game_Clock;
										}
										else
										{
											if(!Enemy_x_RMNDR && !Enemy_y_RMNDR)	//If enemy is aligned horizontally and vertically, make a direction decision
											{
												Total_Directions=0;	//Total number of directions the enemy can turn to.
												for(j=0;j<4;++j)	//Check all 4 directions around the enemy
												{
													k=Screen_Tiles_Buffer[Enemy_Screen_Index+Screen_Index_Offset[j]];	//Grab an adjacent tile
													if((k==Null || k==Sand) && //Check if the tile is "walkable"
														Object_Within_Boundaries(j,x,y,Sprite_h+1,Sprite_w+1,LCD_h-1-2*Sprite_h-1,LCD_w-2*Sprite_w-1))
													{
														Directions[Total_Directions]=j;	//Add current direction to the list if walkable
														++Total_Directions;
														if((j^0x02)!=Enemy_Direction[i])	//Increase the probability of the enemy avoiding 180 turns ( ^0x02 inverts the direction) 
														{
															Directions[Total_Directions]=j;
															++Total_Directions;
														}
														if(j==Enemy_Direction[i])	//Further increase the probability of the enemy going straight
														{
															Directions[Total_Directions]=j;
															++Total_Directions;
															Directions[Total_Directions]=j;
															++Total_Directions;
															Directions[Total_Directions]=j;
															++Total_Directions;
														}
													}
												}
												if(i&1)
													j=(unsigned char)(Game_Clock%Total_Directions);	//Generate random seed for 0<=i<4
												else
													j=(unsigned char)(Global_Clock%Total_Directions);	//Generate random seed for 4<=i<8
												Enemy_Direction[i]=Directions[j];
											}
											j=Enemy_Direction[i];
											Enemy_x[i]+=Unit_x_Offset[j];
											Enemy_y[i]+=Unit_y_Offset[j];
											Enemy_Sprite[i]=Enemies1D[LeeverDark-SpiderLight][Enemy_Animation[i]];	//Required for animations
										}
										break;
									}	//End of Enemy_Move
									case Enemy_Submerging:
									{
										Flash_Required=Game_Clock-Enemy_Event_ClockRef[i];	//Used as dummy (unsigned long required)
										if(Flash_Required>256)
										{
											Enemy_State[i]=Enemy_Submerged;
											Enemy_Sprite[i]=Graphics16[Enemy_Invisible];
											Enemy_Event_ClockRef[i]=Game_Clock;
											Enemy_Event_Interval[i]=512;
										}
										else if(Flash_Required>192)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_1];
										else if(Flash_Required>128)
											Enemy_Sprite[i]=Graphics16[Leever_Hole_2];
										else if(Flash_Required>64)
											Enemy_Sprite[i]=Graphics16[LeeverDark_Half];
										break;
									}
								}
								break;
							}
							case Rock_Fall:
							{
								if(Enemy_State[i]==Enemy_Stop)
								{
									if(Game_Clock-Enemy_Event_ClockRef[i]>Enemy_Event_Interval[i])
									{
										Enemy_State[i]=Enemy_Jump;
										Enemy_Counter[i]=0;
									}
								}
								else if(Enemy_Counter[i])
								{	//Continue the current jump
									Enemy_x[i]+=Unit_x_Offset[Enemy_Direction[i]];
									Enemy_y[i]+=SpiderPath_Offset[6][Enemy_Counter[i]];
									j=Enemy_x[i];
									if(j<=Sprite_w)
										Enemy_Direction[i]=RIGHT;
									if(j>=LCD_w-2*Sprite_w)
										Enemy_Direction[i]=LEFT;
									//++Enemy_Anim_Counter;
									//if(Enemy_Anim_Counter[i]&7)==0)
									//	Enemy_Animation[i]=!Enemy_Animation[i];
									Enemy_Sprite[i]=Enemies1D[Rock-SpiderLight][Enemy_Animation[i]];
									--Enemy_Counter[i];
									if(Enemy_y[i]>=LCD_h-1-Sprite_h)
									{
										Enemy_State[i]=Enemy_Stop;
										Enemy_Event_Interval[i]=(1+(Game_Clock>>i)%2)<<7;	//Randomly define 0.5-1 seconds of stop time
										Enemy_Sprite[i]=Graphics16[Enemy_Invisible];
									}
								}
								else
								{	//Initiate another jump
									if(Enemy_y[i]>=LCD_h-1-Sprite_h)
									{
										Enemy_y[i]=Sprite_h;
										Enemy_x[i]=(3+Game_Clock%11)*Sprite_w;
									}
									if(Global_Clock&1)
										Enemy_Direction[i]=LEFT;
									else
										Enemy_Direction[i]=RIGHT;
									Enemy_Counter[i]=20;
								}
								break;
							}
							case Hand_Creep:
							{
								
								break;
							}
							case Wizzrobe_Teleport:
							{
								
								break;
							}
						}
					}
				}	//End of enemy movement routine
				Draw_Enemy(Enemy_x[i],Enemy_y[i],Enemy_Sprite[i],OS_Planes_BIN);	//Draw the enemy
			}
		}	//End of Active_Enemies
		
		
	  	///$$
	  //Active Enemy_Projectiles algorithm
	  for(i=0;i<12;++i)
	  {
	  	if(Enemy_Projectile[i])
	  	{
	  		Replenish_EnemyProj_BG(Enemy_Projectile_x[i],Enemy_Projectile_y[i],Enemy_Proj_Sprite[i]);
	  		if(Game_Clock-Enemy_ProjMove_ClockRef[i]>Enemy_ProjMove_Interval[i])
	  		{
	  			Enemy_ProjMove_ClockRef[i]=Game_Clock;
	  			if(Enemy_Projectile[i]==ZolaFire)
	  			{
	  				if(Enemy_Projectile_x[i]>0 && Enemy_Projectile_x[i]<LCD_w-Sprite_w && Enemy_Projectile_y[i]>0 && Enemy_Projectile_y[i]<LCD_h-1-Sprite_h)
	  				{	//Advance projectile
	  					if(ZolaFire_Index<ZolaFire_CycleLength-1)
	  						++ZolaFire_Index;
	  					else
	  						ZolaFire_Index=0;
	  					switch(Zola_Quadrant)
	  					{
	  						case 1:
	  						{
	  							Enemy_Projectile_x[i]+=ZolaFire_x_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							Enemy_Projectile_y[i]-=ZolaFire_y_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							break;
	  						}
	  						case 2:
	  						{
	  							Enemy_Projectile_x[i]-=ZolaFire_x_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							Enemy_Projectile_y[i]-=ZolaFire_y_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							break;
	  						}
	  						case 3:
	  						{
	  							Enemy_Projectile_x[i]-=ZolaFire_x_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							Enemy_Projectile_y[i]+=ZolaFire_y_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							break;
	  						}
	  						case 4:
	  						{
	  							Enemy_Projectile_x[i]+=ZolaFire_x_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							Enemy_Projectile_y[i]+=ZolaFire_y_Offset[Enemy_Proj_Direction[i]][ZolaFire_Index];
	  							break;
	  						}
	  					}
	  				}
	  				else
	  				{	//Delete projectile
							Enemy_Projectile[i]=No_Projectile;
							Enemy_Proj_Sprite[i]=Graphics16[Enemy_Invisible];
	  				}
	  			}
	  			else
	  			{	//For common 4-direction projectiles
						x=Enemy_Projectile_x[i]%Sprite_w;
						y=Enemy_Projectile_y[i]%Sprite_h;
						if(!x && !y)
						{
							j=Enemy_Projectile_y[i]/Sprite_h*World_w + Enemy_Projectile_x[i]/Sprite_w + Screen_Index_Offset[Enemy_Proj_Direction[i]];
							if(Screen_Tiles_Buffer[j]>WW_5_D ||
								!Object_Within_Boundaries(Enemy_Proj_Direction[i],Enemy_Projectile_x[i],Enemy_Projectile_y[i],1,1,LCD_h-2-Sprite_h,LCD_w-Sprite_w-1))
							{
								Enemy_Projectile[i]=No_Projectile;
								Enemy_Proj_Sprite[i]=Graphics16[Enemy_Invisible];
							}
						}
		  			Enemy_Projectile_x[i]+=Unit_x_Offset[Enemy_Proj_Direction[i]];
		  			Enemy_Projectile_y[i]+=Unit_y_Offset[Enemy_Proj_Direction[i]];
	  			}
	  		}
	  		Draw_Enemy_Proj(Enemy_Projectile_x[i],Enemy_Projectile_y[i],Enemy_Proj_Sprite[i],OS_Planes_BIN);
	  	}
	  }
		
	/*
						
	MoveTo(0,0);
	printf("%u ",Tornado_x);
	MoveTo(0,8);
	printf("%u ",Tornado_y);
	MoveTo(136,0);
	printf("%u ",ptr2[0]);
	MoveTo(136,8);
	printf("%u",ptr2[1]);
	MoveTo(136,16);
	printf("%u",ptr2[2]);
	MoveTo(136,24);
	printf("%u",ptr2[3]);
	MoveTo(136,32);
	printf("%u",ptr3[0]);
	MoveTo(136,40);
	printf("%u",ptr3[1]);
	MoveTo(136,48);
	printf("%u",ptr3[2]);
	MoveTo(136,56);
	printf("%u",ptr3[3]);
	*/
	
		if(!Flash_Submenu && _rowread(ARROWS_ROW)&SHIFT_KEY)
		{
			Game_In_Progress=FALSE;
			Store_Current_Screen(Current_Screen_Buffer);
			for(Scroll_Index=0;Scroll_Index<SubMenu_h;++Scroll_Index)
			{
				while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>(unsigned char)(Scroll_Interval+1))) {}
				Scroll_ClockRef=Global_Clock;
				Scroll_SubMenu(Action_Scroll_Submenu,Scroll_Index,Menu_Buffer[0],Menu_Buffer[1],Oversized_Buffer);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			i=A_SubBox_x;
			j=Find_Best_Sword(Weapons_Possessed);
			if(j<2)
				++i;
			Update_A_Box(i,A_SubBox_y,Graphics16[j],Gray_Planes_BIN|OS_Planes_BIN);
			Update_B_Box(Sub_Menu,Cursor_Position,Weapons_Possessed);
			while(_rowread(ARROWS_ROW)&SHIFT_KEY)
			{
				AutoOff_ClockRef=Global_Clock;
				Keys_Pressed=_rowread(ARROWS_ROW)&0x0F;	//Accept Only Arrow Keys
				if(!Keys_Pressed)
					Cursor_Key_Released=TRUE;
				if(Cursor_Key_Released&&(Keys_Pressed==LEFT_KEY||Keys_Pressed==RIGHT_KEY))
				{
					Cursor_Key_Released=FALSE;
					if(Keys_Pressed==LEFT_KEY)
						i=LEFT;
					else
						i=RIGHT;
					Cursor_Position=Move_Cursor_Position(i,Cursor_Position,Weapons_Possessed);
					Update_B_Box(Sub_Menu,Cursor_Position,Weapons_Possessed);
				}
				if(Global_Clock-Adjust_ClockRef>Adjust_Interval)
				{
					Adjust_ClockRef=Global_Clock;
					if(_rowread(F5_ROW)&PLUS_KEY)
						OSContrastUp();
					if(_rowread(F5_ROW)&DOWN_KEY)
						OSContrastDn();
				}
				if(Global_Clock-Dungeon_Map_ClockRef>175 && World && Current_Dungeon_Level)
				{
					Dungeon_Map_ClockRef=Global_Clock;
					if(Inside_Portal)
						i=Previous_World_Index;
					else
						i=World_Index;
					XOR_Menu_Dungeon_Map(Oversized_Buffer[1],11+(((i&0x0F)+Level_Offset[Current_Dungeon_Level-1])<<2),8+((i>>3)&0xFE));
				}
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Update_B_Box(Sub_Menu,Cursor_Position,0x00000000);
			Update_A_Box(A_SubBox_x,A_SubBox_y,Graphics16[Menu_Weap8_Blank],OS_Planes_BIN);
			for(Scroll_Index=0;Scroll_Index<SubMenu_h;++Scroll_Index)
			{
				while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>(unsigned char)(Scroll_Interval+1))) {}
				Scroll_ClockRef=Global_Clock;
				Scroll_From_SubMenu(Action_Scroll_From_SubMenu,Scroll_Index,Current_Screen_Buffer[0],Current_Screen_Buffer[1],Oversized_Buffer);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Game_In_Progress=TRUE;
		}
		
		if(~_rowread(ARROWS_ROW)&ALPHA_KEY)
			Menu_Key_Released=TRUE;
		if(Menu_Key_Released&&_rowread(ARROWS_ROW)&ALPHA_KEY)
		{
			Menu_Key_Released=FALSE;
			Game_In_Progress=FALSE;
			Store_Current_Screen(Current_Screen_Buffer);
			for(Scroll_Index=0;Scroll_Index<LCD_h-1;++Scroll_Index)
			{
				while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>Scroll_Interval)) {}
				Scroll_ClockRef=Global_Clock;
				Scroll_MainMenu(Action_Scroll_MainMenu,Scroll_Index,Menu_Buffer[0],Menu_Buffer[1],Oversized_Buffer);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			OSContrastDn();
			Update_Menu_Weapons(Weapons_Possessed);
			Update_B_Box(Main_Menu,Cursor_Position,Weapons_Possessed);
			while(!Menu_Key_Released||~_rowread(ARROWS_ROW)&ALPHA_KEY)
			{
				Menu:
				if(~_rowread(ARROWS_ROW)&ALPHA_KEY)
					Menu_Key_Released=TRUE;
				if(_rowread(F4_ROW)&COMMA_KEY) 
				{
					MoveTo(93,39);
					printf("%010lu",Global_Clock);
				}
				
				//ExitMenu Algorithm
				if(_rowread(ESC_ROW)&ESC_KEY)
				{
					memset(Light_Plane,0xFFFF,2970);
					memset(Dark_Plane,0xFFFF,2970);
					ptr_array[0]=Resume_Text;
					ptr_array[1]=SaveQuit_Text;
					ptr_array[2]=Quit_Text;
					for(i=0;i<3;++i)
					{	//Print ExitMenu Texts
						x=40;
						ptr=ptr_array[i];
						while(*ptr!=Char_End)
						{
							Print_Character(x,31+9*i,Character[*ptr],Gray_Planes_BIN);
							x+=5;
							++ptr;
						}
					}
					
					j=0;
					Menu_Key_Released=FALSE;
					Draw_A_Heart(32,31,Graphics16[Heart_Full],Gray_Planes_BIN);
					while(~_rowread(ARROWS_ROW)&SECOND_KEY && ~_rowread(F5_ROW)&ENTER_KEY)
					{
						if(~_rowread(ESC_ROW)&ESC_KEY)
							Menu_Key_Released=TRUE;
						if(Menu_Key_Released && _rowread(ESC_ROW)&ESC_KEY)
						{
							OSContrastUp();
							goto Cleanup;
						}
						
						i=_rowread(ARROWS_ROW);
						if(~i&UP_KEY && ~i&DOWN_KEY)
							Cursor_Key_Released=TRUE;
						if(Cursor_Key_Released==TRUE && ((i&UP_KEY && j>0) || (i&DOWN_KEY && j<2)))
						{
							Cursor_Key_Released=FALSE;
							Clear_Cursor(32,31+9*j,5,0xF800,LG_Plane_BIN);
							if(i&UP_KEY)
								--j;
							else
								++j;
							Draw_A_Heart(32,31+9*j,Graphics16[Heart_Full],Gray_Planes_BIN);
						}
					}
					if(j==0)
					{
						Game_In_Progress=TRUE;
						goto Menu;
					}
					OSContrastUp();
					if(j==1)
					{
						Save_Game=TRUE;
						goto StartMenu;
					}
					else
						goto StartMenu;
				}	//End of ExitMenu Algorithm
				
				
				if(_rowread(ALL_ROWS))
					AutoOff_ClockRef=Global_Clock;
				if(Calc_ID[1]==51 && (_rowread(F1_ROW)&OR_KEY || Global_Clock-AutoOff_ClockRef>=APD_TimeLength))
				{
					asm("trap #4");
					AutoOff_ClockRef=Global_Clock;
					GrayAdjust(Gray_Index);
				}
				if(Global_Clock-Adjust_ClockRef>Adjust_Interval)
				{
					Adjust_ClockRef=Global_Clock;
					Update_Vars(&Sprite_Interval,&Projectile_Interval,&Scroll_Interval,&Adjust_Interval,&Gray_Index,&Current_Shield,
						&Weapons_Possessed,&Heart_Containers,&Hearts,&Rupies_Possessed,&Keys_Possessed,&Bombs_Possessed,&Max_Bombs,&Dungeon_Maps_Compasses[0]);
					if(_rowread(F1_ROW)&STO_KEY||_rowread(F1_ROW)&EE_KEY||_rowread(F2_ROW)&LB_KEY||_rowread(F3_ROW)&RB_KEY)
					{
						Blink_Cursor(Black_Cursor,Cursor_Position);
						Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
						Update_Menu_Weapons(Weapons_Possessed);
						Update_B_Box(Main_Menu,Cursor_Position,Weapons_Possessed);
						if(!World)
							Update_Triforces(Weapons_Possessed,Triforces,OS_Planes_BIN|Menu_Planes_BIN);
						Update_Hearts(Not_Using_Potion,Hearts,Heart_Containers,OS_Planes_BIN|Menu_Planes_BIN);
						Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,
							Character,OS_Planes_BIN|Menu_Planes_BIN);
					}
				}
				Keys_Pressed=_rowread(ARROWS_ROW)&0x0F;	//Accept Only Arrow Keys
				if(!Keys_Pressed)
					Cursor_Key_Released=TRUE;
				if(Cursor_Key_Released && (Keys_Pressed==LEFT_KEY || Keys_Pressed==RIGHT_KEY))
				{
					Cursor_Key_Released=FALSE;
					Blink_Cursor(Black_Cursor,Cursor_Position);
					if(Keys_Pressed==LEFT_KEY)
						i=LEFT;
					else
						i=RIGHT;
					Cursor_Position=Move_Cursor_Position(i,Cursor_Position,Weapons_Possessed);
					Update_B_Box(Main_Menu,Cursor_Position,Weapons_Possessed);
				}
				if(World && Current_Dungeon_Level && Global_Clock-Dungeon_Map_ClockRef>=175)
				{
					Dungeon_Map_ClockRef=Global_Clock;
					if(Inside_Portal)
					{
						i=Previous_World_Index&0x0F;
						j=(Previous_World_Index>>3)&0xFE; //Equivalent to (x/16)*2
					}
					else
					{
						i=World_Index&0x0F;
						j=(World_Index>>3)&0xFE; //Equivalent to (x/8)-x%2
					}
					i+=Level_Offset[Current_Dungeon_Level-1];
					XOR_Menu_Dungeon_Map(Oversized_Buffer[1],11+(i<<2),82+j);
					XOR_Dungeon_Rough_Map(Oversized_Buffer[1],96+i*5,43+(j<<1));
				}
				if(Global_Clock-Cursor_ClockRef>=50)
				{
					Cursor_ClockRef=Global_Clock;
					if(Cursor_Color==Black_Cursor)
						Cursor_Color=White_Cursor;
					else
						Cursor_Color=Black_Cursor;
					Blink_Cursor(Cursor_Color,Cursor_Position);
				}
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Menu_Key_Released=FALSE;
			Update_Menu_Weapons(Weapons_Possessed&0xFF000000);
			Update_B_Box(Main_Menu,Cursor_Position,0x00000000);
			OSContrastUp();
			for(Scroll_Index=0;Scroll_Index<(LCD_h-1);++Scroll_Index)
			{
				while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>Scroll_Interval)) {}
				Scroll_ClockRef=Global_Clock;
				Scroll_From_MainMenu(Action_Scroll_From_MainMenu,Scroll_Index,Current_Screen_Buffer[0],Current_Screen_Buffer[1],Oversized_Buffer);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Game_In_Progress=TRUE;
		}
		
		if(~_rowread(ARROWS_ROW)&DIAMOND_KEY)
			Weapon_Key_Released=TRUE;
		Current_Weapon=Find_Best_Weapon(Find_For_Cursor_Position,Cursor_Position,Weapons_Possessed);
		if(_rowread(ARROWS_ROW)&DIAMOND_KEY && Weapon_Key_Released && !Currently_Using_Sword &&
				!Releasing_Or_Recieving_Weapon && !Warped_By_Recorder && !Lifting_Item && Current_Weapon!=Menu_Weap9_Blank && !Printing_Shop_Text &&
					(((!World || Inside_Portal) &&	((!(Link_Direction&0x01) && Link_y>=5 && Link_y<=85) || (Link_Direction&0x01 && Link_x>=5 && Link_x<=145))) ||
					(Link_y>=14 && Link_x>15 && Link_y<=76 && Link_x<135)))
		{
			Weapon_Key_Released=FALSE;
			switch(Current_Weapon)
			{
				case Normal_Boomerang	:
				{
					if(Boomerang_Present)
						break;
					Boomerang_Present=Boomerang_Released;
					Boomerang_Type=Boomerang_Type_Normal;
					Boomerang_Animation_Counter=0;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Keys_Pressed=_rowread(ARROWS_ROW)&0x0F;
					if(Keys_Pressed&&Keys_Pressed<13&&Boomerang_Direction_From_Keypress[Keys_Pressed]<=North_East)
						Boomerang_Direction=Boomerang_Direction_From_Keypress[Keys_Pressed];
					else
						Boomerang_Direction=Link_Direction<<1;
					Boomerang_Reference_x=Link_x;
					Boomerang_Reference_y=Link_y;
					Boomerang_x=Link_x+Boomerang_x_Offset[Boomerang_Direction];
					Boomerang_y=Link_y+Boomerang_y_Offset[Boomerang_Direction];
					break;
				}
				case Magical_Boomerang	:
				{
					if(Boomerang_Present)
						break;
					Boomerang_Present=Boomerang_Released;
					Boomerang_Type=Boomerang_Type_Magical;
					Boomerang_Animation_Counter=0;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Keys_Pressed=_rowread(ARROWS_ROW)&0x0F;
					if(Keys_Pressed&&Keys_Pressed<13&&Boomerang_Direction_From_Keypress[Keys_Pressed]<=North_East)
						Boomerang_Direction=Boomerang_Direction_From_Keypress[Keys_Pressed];
					else
						Boomerang_Direction=Link_Direction<<1;
					Boomerang_x=Link_x+Boomerang_x_Offset[Boomerang_Direction];
					Boomerang_y=Link_y+Boomerang_y_Offset[Boomerang_Direction];
					break;
				}
				case Bomb_1	:
				{
					if(!Bombs_Possessed||(Bomb_Present && (Current_Bomb_Stage[First_Bomb]<First_Bomb_Stage || Current_Bomb_Stage[Second_Bomb]<First_Bomb_Stage)))
						break;
					--Bombs_Possessed;
					Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
					if(!Bombs_Possessed)
					{
						Weapons_Possessed&=~Bomb_BIN;
						Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
					}
					if(Bomb_Present&First_Bomb_BIN)
					{
						Bomb_Present|=Second_Bomb_BIN;
						Current_Bomb=Second_Bomb;
					}
					else
					{
						Bomb_Present|=First_Bomb_BIN;
						Current_Bomb=First_Bomb;
					}
					Bomb_ClockRef[Current_Bomb]=Game_Clock;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Bomb_Stage[Current_Bomb]=Zeroth_Bomb_Stage;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Bomb_x[Current_Bomb]=Link_x+Bomb_x_Offset[Link_Direction];
					Bomb_y[Current_Bomb]=Link_y+Bomb_y_Offset[Link_Direction];
					Draw_Bomb(Bomb_x[Current_Bomb],Bomb_y[Current_Bomb],Graphics16[Bomb_2],OS_Planes_BIN);
					break;
				}
				case Wooden_Arrow	:
				{
					if(Arrow_Present||!Rupies_Possessed)
						break;
					Arrow_Present=TRUE;
					Arrow_Type=Arrow_Type_Wooden;
					Arrow_Direction=Link_Direction;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Arrow_x=Link_x+Arrow_x_Offset[Link_Direction];
					Arrow_y=Link_y+Arrow_y_Offset[Link_Direction];
					--Rupies_Possessed;
					Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
					break;
				}
				case Silver_Arrow	:
				{
					if(Arrow_Present||!Rupies_Possessed)
						break;
					Arrow_Present=TRUE;
					Arrow_Type=Arrow_Type_Silver;
					Arrow_Direction=Link_Direction;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Arrow_x=Link_x+Arrow_x_Offset[Link_Direction];
					Arrow_y=Link_y+Arrow_y_Offset[Link_Direction];
					--Rupies_Possessed;
					Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
					break;
				}
				case Blue_Candle :
				{
					if(Candle_Present||Candle_Exhausted||!Link_Within_Boundaries(Link_Direction,Link_x,Link_y,Sprite_h*2+1,Sprite_w*2,LCD_h-1-Sprite_h*3-1,LCD_w-Sprite_w*3))
						break;
					Candle_Present=First_Candle;
					Candle_Counter[First_Flame]=0;
					Candle_Direction[First_Flame]=Link_Direction;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Candle_x[First_Flame]=Link_x+Candle_x_Offset[Candle_Direction[First_Flame]];
					Candle_y[First_Flame]=Link_y+Candle_y_Offset[Candle_Direction[First_Flame]];
					Candle_Factor[First_Flame]=Default_Candle_Factor;
					break;
				}
				case Red_Candle :
				{
					if(Candle_Present==Both_Candles||!Link_Within_Boundaries(Link_Direction,Link_x,Link_y,Sprite_h*2+1,Sprite_w*2,LCD_h-1-Sprite_h*3-1,LCD_w-Sprite_w*3))
						break;
					if(Candle_Present&First_Candle)
					{
						Candle_Present|=Second_Candle;
						Current_Flame=Second_Flame;
					}
					else
					{
						Candle_Present|=First_Candle;
						Current_Flame=First_Flame;
					}
					Candle_Counter[Current_Flame]=0;
					Candle_Direction[Current_Flame]=Link_Direction;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Candle_x[Current_Flame]=Link_x+Candle_x_Offset[Candle_Direction[Current_Flame]];
					Candle_y[Current_Flame]=Link_y+Candle_y_Offset[Candle_Direction[Current_Flame]];
					Candle_Factor[Current_Flame]=Default_Candle_Factor;
					break;
				}
				case Recorder :
				{
					if(Tornado_Present)
					{
						///Multiple whistle blows affects destination
						/*
						if(Link_Direction==LEFT || Link_Direction==DOWN)
						{
							Current_Warp_Stage=LEFT;
						}
						else
						{
							Warp_Direction=RIGHT;
						}*/
						break;
					}
					if(World || World_Index==L7_Lake)
						Recorder_Exhausted=TRUE;
					else if(Recorder_Exhausted==FALSE)
						Tornado_Present=TRUE;
					Warped_By_Recorder=FALSE;
					Tornado_x=0;
					Tornado_y=Link_y;
					if(Link_Direction==LEFT||Link_Direction==DOWN)
						Warp_Direction=LEFT;
					else
						Warp_Direction=RIGHT;
					Current_Warp_Stage=Zeroth_Tornado_Stage;
					if(!Recorder_Exhausted)
						Draw_Single_Cloud(Tornado_x,Tornado_y,Graphics16[Cloud_Full],Gray_Planes_BIN);
					Recorder_ClockRef=Game_Clock;
					while(!TimeBypass && Game_Clock-Recorder_ClockRef<256) {}
					if(!Recorder_Exhausted)
						Draw_Single_Cloud(Tornado_x,Tornado_y,Graphics16[Cloud_Half],Gray_Planes_BIN);
					while(!TimeBypass && Game_Clock-Recorder_ClockRef<384) {}
					
					//Reveal Level 7
					if(World_Index==L7_Lake && Collision_Detection_Buffer[86]!=Stair)
					{
						for(i=0;i<24;++i)
						{	
							j=Screen_Map_D[1][74][i];
							Draw_Tile(Sprite_w*(5+i%6),Sprite_h*(3+i/6),Map_Tiles[j],OS_Planes_BIN|BG_Planes_BIN);
							Collision_Detection_Buffer[53+(i/6)*Screen_w+i%6]=j;
						}
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						while(!TimeBypass&&Game_Clock-Recorder_ClockRef<768) {}
						Draw_Tile(Sprite_w*6,Sprite_h*5,Map_Tiles[Stair],OS_Planes_BIN|BG_Planes_BIN);
						Collision_Detection_Buffer[86]=Stair;
					}
					Recorder_Exhausted=TRUE;
					break;
				}
				case Meat_1 :
				{
					if(Meat_Present)
						break;
					Meat_Present=TRUE;
					Meat_ClockRef=Game_Clock;
					Releasing_Or_Recieving_Weapon=TRUE;
					Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
					Meat_x=Link_x+Meat_x_Offset[Link_Direction];
					Meat_y=Link_y+Meat_y_Offset[Link_Direction];
					if(Inside_Shop && Current_Shop==Shop_Hungry_Goriya)
					{
						Weapons_Possessed&=~Meat_BIN;
						Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
						Release_Shop_Boundaries(Collision_Detection_Buffer+64,Cave,14);
						Shopkeeper_Flickering=TRUE;
						Shopkeeper_ClockRef=Game_Clock;
						for(j=0;j<7;++j)
						{
							Clear_Shop(24+(j<<4),20,52,0xFFFF,
								LO_Plane_BIN|DO_Plane_BIN|LB_Plane_BIN|DB_Plane_BIN);
						}
						Inside_Shop=Shop_Inactive;
					}
					break;
				}
				case Letter :
				{
					if(Inside_Shop && Current_Shop==Shop_Potion)
					{
						Letter_Shown=TRUE;
						Inside_Shop=Just_Entered_Shop;
						Weapons_Possessed&=~Letter_BIN;
						Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
					}
					break;
				}
				case Blue_Potion :
				{
					if(Hearts/Heart_Containers==2)
					 break;
					Potion_Present=TRUE;
					Weapons_Possessed&=~Blue_Potion_BIN;
					break;
				}
				case Red_Potion :
				{
					if(Hearts/Heart_Containers==2)
					 break;
					Potion_Present=TRUE;
					Weapons_Possessed&=~(unsigned long)Red_Potion_BIN;
					Weapons_Possessed|=Blue_Potion_BIN;
					break;
				}
				case Magic_Wand :
				{
					if(Currently_Using_Wand)
						break;
					Currently_Using_Wand=TRUE;
					Currently_Using_Sword=TRUE;
					Current_Sword_Stage=Zeroth_Sword_Stage;
					Sword_x=Link_x+Sword_x_Offset[Link_Direction];
					Sword_y=Link_y+Sword_y_Offset[Link_Direction];
					break;
				}
			}
		}
		if(Boomerang_Present && (TimeBypass || Game_Clock-Boomerang_ClockRef>(unsigned char)(Projectile_Interval*Boomerang_Factor)))
		{
			Boomerang_ClockRef=Game_Clock;
			Replenish_Boomerang_BG(Boomerang_x,Boomerang_y,Boomerang[Boomerang_Animation]);
			if(_rowread(F5_ROW)&ENTER_KEY)
				Boomerang_Present=Boomerang_Returning;
			if(Boomerang_Present==Boomerang_Released)
			{
				if(Boomerang_x>0&&Boomerang_x<(LCD_w-Boomerang_w-2)&&Boomerang_y>0&&Boomerang_y<(LCD_h-1-Boomerang_h))
				{
					if(Boomerang_Type==Boomerang_Type_Normal&&(abs(Boomerang_x-Boomerang_Reference_x)>=(Sprite_w*5-Boomerang_w)||
						abs(Boomerang_y-Boomerang_Reference_y)>=(Sprite_h*5-Boomerang_h)))
					{
						Boomerang_Present=Boomerang_Returning;
					}
					if(Boomerang_Animation_Counter%Frames_Per_Boomerang_Animation==0)
					{
						if(Boomerang_Animation<North_East)
							++Boomerang_Animation;
						else	Boomerang_Animation=North;
					}
					++Boomerang_Animation_Counter;
					Boomerang_x+=Boomerang_x_Increment[Boomerang_Direction];
					Boomerang_y+=Boomerang_y_Increment[Boomerang_Direction];
					Draw_Boomerang(Boomerang_x,Boomerang_y,Boomerang_h,Boomerang[Boomerang_Animation],OS_Planes_BIN);
				}
				else
					Boomerang_Present=Boomerang_Returning;
			}
			else if(!Link_Boomerang_Collision(Boomerang_x+2,Boomerang_y+2,Link_x,Link_y))
			{
				if(Boomerang_Animation_Counter%Frames_Per_Boomerang_Animation==0)
				{
					if(Boomerang_Animation<North_East)
						++Boomerang_Animation;
					else	Boomerang_Animation=North;
				}
				++Boomerang_Animation_Counter;
				Relative_Direction=Find_Relative_Direction(Boomerang_x+2,Boomerang_y+1,Link_x+4,Link_y+5);
				Boomerang_x+=Boomerang_x_Increment[Relative_Direction];
				Boomerang_y+=Boomerang_y_Increment[Relative_Direction];
				Draw_Boomerang(Boomerang_x,Boomerang_y,Boomerang_h,Boomerang[Boomerang_Animation],OS_Planes_BIN);
				/*
				MoveTo(0,9);
				printf("%u ", Relative_Direction);
				MoveTo(0,18);
				printf("%u ", Boomerang_x);
				MoveTo(0,27);
				printf("%u ", Boomerang_y);
				MoveTo(0,36);
				printf("%d ", Boomerang_x_Increment[Relative_Direction]);
				MoveTo(0,45);
				printf("%d ", Boomerang_y_Increment[Relative_Direction]);
				*/
			}
			else
			{
				Releasing_Or_Recieving_Weapon=TRUE;
				Current_Weapon_Release_Stage=Zeroth_Weapon_Release_Stage;
				Boomerang_Present=0;
			}
		}
		if(Bomb_Present)
		{
			for(Current_Bomb=First_Bomb;Current_Bomb<=Second_Bomb;++Current_Bomb)
			{
				if(Bomb_Present&1<<Current_Bomb)
				{
					switch(Current_Bomb_Stage[Current_Bomb])
					{
						case Zeroth_Bomb_Stage	:
						{
							Draw_Bomb(Bomb_x[Current_Bomb],Bomb_y[Current_Bomb],Graphics16[Bomb_2],OS_Planes_BIN);
							if(Game_Clock-Bomb_ClockRef[Current_Bomb]>200)
							{
								Replenish_Bomb_BG(Bomb_x[Current_Bomb],Bomb_y[Current_Bomb],Graphics16[Bomb_2]);
								Bomb_x[Current_Bomb]-=1;
								Draw_Bomb_Cloud(Cloud_Full,Bomb_x[Current_Bomb],Bomb_y[Current_Bomb]);
								BombShock_Present=TRUE;
								for(i=0;i<10;++i)
									Draw_Part_Of_The_BombShock(i<<4,0,LCD_h-1,0x0000,DG_Plane_BIN);
								++Current_Bomb_Stage[Current_Bomb];
							}
							break;
						}
						case First_Bomb_Stage	:
						{
							if(Game_Clock-Bomb_ClockRef[Current_Bomb]>220)
							{
								BombShock_Present=FALSE;
								++Current_Bomb_Stage[Current_Bomb];
							}
						}
						case Second_Bomb_Stage	:
						{
							if(Game_Clock-Bomb_ClockRef[Current_Bomb]>240)
							{
								BombShock_Present=TRUE;
								for(i=0;i<10;++i)
									Draw_Part_Of_The_BombShock(i<<4,0,LCD_h-1,0x0000,DG_Plane_BIN);
								++Current_Bomb_Stage[Current_Bomb];
							}
						}
						case Third_Bomb_Stage	:
						{
							if(Game_Clock-Bomb_ClockRef[Current_Bomb]>260)
							{
								BombShock_Present=FALSE;
								++Current_Bomb_Stage[Current_Bomb];
							}
						}
						case Fourth_Bomb_Stage	:
						{
							Draw_Bomb_Cloud(Cloud_Full,Bomb_x[Current_Bomb],Bomb_y[Current_Bomb]);
							if(Game_Clock-Bomb_ClockRef[Current_Bomb]>350)
							{
								Replenish_Bomb_Cloud_BG((signed short)Bomb_x[Current_Bomb],(signed short)Bomb_y[Current_Bomb],Graphics16[Cloud_Full]);
								
								if(World && !Inside_Portal)
								{
									i=NOWHERE;
									if(Bomb_x[Current_Bomb]>=60 && Bomb_x[Current_Bomb]<=90 && Bomb_y[Current_Bomb]<=25 && 
										D_Room_Properties_ROM[World-1][World_Index][0]==DD_Bomb)
									{
										i=UP;
										D_Room_Properties[Current_Save][World-1][World_Index-World_w][2]=DD_Bomb;
									}
									else if(Bomb_x[Current_Bomb]<=25 && Bomb_y[Current_Bomb]>=30 && Bomb_y[Current_Bomb]<=60 && 
										D_Room_Properties_ROM[World-1][World_Index][1]==DD_Bomb)
									{
										i=LEFT;
										D_Room_Properties[Current_Save][World-1][World_Index-1][3]=DD_Bomb;
									}
									else if(Bomb_x[Current_Bomb]>=60 && Bomb_x[Current_Bomb]<=90 && Bomb_y[Current_Bomb]>=65 && D_Room_Properties_ROM[World-1][World_Index][2]==DD_Bomb)
									{
										i=DOWN;
										D_Room_Properties[Current_Save][World-1][World_Index+World_w][0]=DD_Bomb;
									}
									else if(Bomb_x[Current_Bomb]>=125 && Bomb_y[Current_Bomb]>=30 && Bomb_y[Current_Bomb]<=60 &&
										D_Room_Properties_ROM[World-1][World_Index][3]==DD_Bomb)
									{
										i=RIGHT;
										D_Room_Properties[Current_Save][World-1][World_Index+1][1]=DD_Bomb;
									}
									if(i!=NOWHERE)
									{
										D_Room_Properties[Current_Save][World-1][World_Index][i]=DD_Bomb;
										Define_D_Door_Tiles(Link_Direction,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
										Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
										Update_Doors(Dark_Room,D_Room_Properties[Current_Save][World-1][World_Index],Map_Tiles);
									}
								}
								else
								{
									Current_Pathway_x=Overworld_Pathways[World_Index][2];
									Current_Pathway_y=Overworld_Pathways[World_Index][3];
									if((Overworld_Pathways[World_Index][0]&0x7F)==R_0&&
										Bomb_x[Current_Bomb]>Current_Pathway_x-Sprite_w&&Bomb_x[Current_Bomb]<Current_Pathway_x+Sprite_w&&
										Bomb_y[Current_Bomb]>Current_Pathway_y-Sprite_h&&Bomb_y[Current_Bomb]<Current_Pathway_y+Sprite_h)
									{
										Discovered_Pathways[World_Index/World_w]|=1<<(World_Index&0x0F);
										Collision_Detection_Buffer[Overworld_Pathways[World_Index][1]]=Cave;
										Draw_Tile(Current_Pathway_x,Current_Pathway_y,Map_Tiles[Cave],OS_Planes_BIN|BG_Planes_BIN);
									}
								}
								Draw_Bomb_Cloud(Cloud_Half,Bomb_x[Current_Bomb],Bomb_y[Current_Bomb]);
								++Current_Bomb_Stage[Current_Bomb];
							}
							break;
						}
						case Fifth_Bomb_Stage	:
						{
							Draw_Bomb_Cloud(Cloud_Half,Bomb_x[Current_Bomb],Bomb_y[Current_Bomb]);
							if(Game_Clock-Bomb_ClockRef[Current_Bomb]>390)
							{
								Replenish_Bomb_Cloud_BG((signed short)Bomb_x[Current_Bomb],(signed short)Bomb_y[Current_Bomb],Graphics16[Cloud_Full]);
								Bomb_Present&=~(1<<Current_Bomb);
							}
							break;
						}
					}
				}
			}
		}
		if(Arrow_Present && (TimeBypass || Game_Clock-Arrow_ClockRef>Projectile_Interval))
		{
			Arrow_ClockRef=Game_Clock;
			Replenish_Arrow_BG(Arrow_x,Arrow_y,Arrow[Arrow_Type][Arrow_Direction]);
			if(Object_Within_Boundaries(Arrow_Direction,Arrow_x,Arrow_y,1,1,LCD_h-1-Arrow_h-1,LCD_w-Arrow_w-1))
			{
				Arrow_x+=Unit_x_Offset[Arrow_Direction];
				Arrow_y+=Unit_y_Offset[Arrow_Direction];
				Draw_Arrow(Arrow_x,Arrow_y,Arrow[Arrow_Type][Arrow_Direction],OS_Planes_BIN);
			}
			else
				Arrow_Present=FALSE;
		}
		if(Candle_Present)
		{
			for(Current_Flame=First_Flame;Current_Flame<=Second_Flame;++Current_Flame)
			{
				if(Candle_Present&(1<<Current_Flame))
					Draw_Candle(Candle_x[Current_Flame],Candle_y[Current_Flame],Graphics16[Fire+Candle_Animation[Current_Flame]],OS_Planes_BIN);
				if(Candle_Present&1<<Current_Flame &&
					(TimeBypass || Game_Clock-Candle_ClockRef[Current_Flame]>(unsigned char)(Projectile_Interval*Candle_Factor[Current_Flame])))
				{
					Candle_ClockRef[Current_Flame]=Game_Clock;
					Replenish_Candle_BG(Candle_x[Current_Flame],Candle_y[Current_Flame],Graphics16[Fire+Candle_Animation[Current_Flame]]);
					if(Candle_Counter[Current_Flame]<(Sprite_w*3/2))
					{
						if(Candle_Counter[Current_Flame]==Sprite_w-1)
						{
							Candle_Factor[Current_Flame]=20;
							if(Dark_Room)
								Dark_Room=Turning_Lights_On;
						}
						if(Candle_Counter[Current_Flame]<Sprite_w-1)
						{
							Candle_x[Current_Flame]+=Unit_x_Offset[Candle_Direction[Current_Flame]];
							Candle_y[Current_Flame]+=Unit_y_Offset[Candle_Direction[Current_Flame]];
						}
						if(Candle_Counter[Current_Flame]>=Sprite_w-1||Candle_Counter[Current_Flame]%3==0)
							Candle_Animation[Current_Flame]=!Candle_Animation[Current_Flame];
						Draw_Candle(Candle_x[Current_Flame],Candle_y[Current_Flame],Graphics16[Fire+Candle_Animation[Current_Flame]],OS_Planes_BIN);
					}
					else
					{
						Candle_Present&=~(1<<Current_Flame);
						Candle_Exhausted=TRUE;
						Current_Pathway_x=Overworld_Pathways[World_Index][2];
						Current_Pathway_y=Overworld_Pathways[World_Index][3];
						if(Overworld_Pathways[World_Index][0]==Bush&&
							Candle_x[Current_Flame]>Current_Pathway_x-Sprite_w&&Candle_x[Current_Flame]<Current_Pathway_x+Sprite_w&&
							Candle_y[Current_Flame]>Current_Pathway_y-Sprite_h&&Candle_y[Current_Flame]<Current_Pathway_y+Sprite_h)
						{
							Discovered_Pathways[World_Index/World_w]|=(0x01<<(World_Index&0x0F));
							Collision_Detection_Buffer[Overworld_Pathways[World_Index][1]]=Stair;
							Draw_Tile(Current_Pathway_x,Current_Pathway_y,Map_Tiles[Stair],OS_Planes_BIN|BG_Planes_BIN);
						}
					}
					++Candle_Counter[Current_Flame];
				}
			}
		}
		if(Tornado_Present && (TimeBypass || Game_Clock-Tornado_ClockRef>(unsigned char)(Projectile_Interval*Tornado_Factor)))
		{
			Tornado_ClockRef=Game_Clock;
			switch(Current_Warp_Stage)
			{
				case Zeroth_Tornado_Stage :
				{
					Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
					if(Tornado_x<LCD_w-Sprite_w)
					{
						if(!Warped_By_Recorder && Weapons_Possessed&Triforces_BIN && abs(Link_y-Tornado_y)<Sprite_h &&	(abs(Link_x-Tornado_x)<Sprite_w))
						{
							Releasing_Or_Recieving_Weapon=FALSE;
							Replenish_Link_BG(Link_x,Link_y,Current_Link);
							if(Currently_Using_Sword)
							{
								Replenish_Sword_BG(Sword_x,Sword_y,Sword[Current_Sword][Full_Sword][Link_Direction]);
								Currently_Using_Sword=FALSE;
							}
							if(Boomerang_Present)
							{
								Replenish_Boomerang_BG(Boomerang_x,Boomerang_y,Boomerang[Boomerang_Animation]);
								Boomerang_Present=0;
							}
							Warped_By_Recorder=TRUE;
						}
						++Tornado_x;
						Draw_Tornado(Tornado_x,Tornado_y,Graphics16[Tornado],OS_Planes_BIN);
					}
					else if(Warped_By_Recorder)
					{
						Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
						Draw_Candle(Candle_x[Current_Flame],Candle_y[Current_Flame],Graphics16[Fire],OS_Planes_BIN);
						Recorder_ClockRef=Game_Clock;
						while(!TimeBypass&&Game_Clock-Recorder_ClockRef<128) {}
						Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
						do{
							if(Warp_Direction==LEFT)
							{
								if(Current_Warp_Position==Level_1_Warp_Position)
									Current_Warp_Position=Level_8_Warp_Position;
								else
									--Current_Warp_Position;
							}
							else
							{
								if(Current_Warp_Position==Level_8_Warp_Position)
									Current_Warp_Position=Level_1_Warp_Position;
								else
									++Current_Warp_Position;
							}
						}
						while(!(Weapons_Possessed&(Triforce_1_BIN<<Current_Warp_Position)));
						World_Index=Recorder_Warping[0][Current_Warp_Position];
						Link_Direction=RIGHT;
						//Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
						if(Link_as_EnemySprite)
						{
							if(Link_EnemySprite<17)
								Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
							else
								Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
						}
						else
							Current_Link=Link[Current_Shield][Link_Animation][Link_Direction];
						Link_Screen_Index=Recorder_Warping[1][Current_Warp_Position];
						Link_x=(Link_Screen_Index%Screen_w)*Sprite_w;
						Link_y=(Link_Screen_Index/Screen_w)*Sprite_h;
						Tornado_x=0;
						Tornado_y=Link_y;
						++Current_Warp_Stage;
						goto Scroll_Prep;
					}
					else
						Tornado_Present=FALSE;
					break;
				}
				case First_Tornado_Stage :
				{
					Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
					if(Tornado_x==0)
					{
						Draw_Single_Cloud(Tornado_x,Tornado_y,Graphics16[Cloud_Full],Gray_Planes_BIN);
						Recorder_ClockRef=Game_Clock;
						while(!TimeBypass&&Game_Clock-Recorder_ClockRef<192) {}
						Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
						Draw_Single_Cloud(Tornado_x,Tornado_y,Graphics16[Cloud_Half],Gray_Planes_BIN);
						while(!TimeBypass&&Game_Clock-Recorder_ClockRef<256) {}
						Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
					}
					if(Tornado_x==Link_x)
					{
						Warped_By_Recorder=FALSE;
						Tornado_Present=FALSE;
					}
					else
					{
						++Tornado_x;
						Draw_Tornado(Tornado_x,Tornado_y,Graphics16[Tornado],OS_Planes_BIN);
					}
				}
			}
		}
		if(Meat_Present)
		{
			Draw_Meat(Meat_x,Meat_y,Graphics16[Meat_2],OS_Planes_BIN);
			if(TimeBypass||Game_Clock-Meat_ClockRef>3328)
			{
				Replenish_Meat_BG(Meat_x,Meat_y,Graphics16[Meat_2]);
				Meat_Present=FALSE;
			}
		}
		if(Potion_Present)
		{
			Game_In_Progress=FALSE;
			Store_Current_Screen(Current_Screen_Buffer);
			for(i=0;i<SubMenu_h;++i)
			{
				while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>(unsigned char)(Scroll_Interval+3))) {}
				Scroll_ClockRef=Global_Clock;
				Scroll_SubMenu(Action_Scroll_Submenu,i,Menu_Buffer[0],Menu_Buffer[1],Oversized_Buffer);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Update_B_Box(Sub_Menu,Cursor_Position,Weapons_Possessed);
			Update_A_Box(A_SubBox_x,A_SubBox_y,Graphics16[Find_Best_Sword(Weapons_Possessed)],OS_Planes_BIN);
			FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
			FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>128)) {}
			while(Hearts/Heart_Containers<2)
			{
				if(TimeBypass||_rowread(F4_ROW)&BKSPC_KEY||Global_Clock-Potion_ClockRef>100)
				{
					Potion_ClockRef=Global_Clock;
					++Hearts;
					Update_Hearts(Not_Using_Potion,Hearts,Heart_Containers,Menu_Planes_BIN);
					Update_Hearts(Using_Potion,Hearts,Heart_Containers,OS_Planes_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
				}
			}
			while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Potion_ClockRef>128)) {}
			Update_B_Box(Sub_Menu,Cursor_Position,0x00000000);
			Update_A_Box(A_SubBox_x,A_SubBox_y,Graphics16[Menu_Weap8_Blank],OS_Planes_BIN);
			FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
			FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			for(Scroll_Index=0;Scroll_Index<SubMenu_h;++Scroll_Index)
			{
				while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>(unsigned char)(Scroll_Interval+3))) {}
				Scroll_ClockRef=Global_Clock;
				Scroll_From_SubMenu(Action_Scroll_From_SubMenu,Scroll_Index,
					Current_Screen_Buffer[0],Current_Screen_Buffer[1],Oversized_Buffer);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Game_In_Progress=TRUE;
			Potion_Present=FALSE;
		}
		if(WandWave_Present && (TimeBypass || Game_Clock-WandWave_ClockRef>Projectile_Interval))
		{
			WandWave_ClockRef=Game_Clock;
			Replenish_WandWave_BG(WandWave_x,WandWave_y,Graphics16[WandWave+WandWave_Direction]);
			if(Object_Within_Boundaries(WandWave_Direction,WandWave_x,WandWave_y,1,1,LCD_h-1-WandWave_h-1,LCD_w-WandWave_w-1))
			{
				WandWave_x+=Unit_x_Offset[WandWave_Direction];
				WandWave_y+=Unit_y_Offset[WandWave_Direction];
				Draw_WandWave(WandWave_x,WandWave_y,Graphics16[WandWave+WandWave_Direction],OS_Planes_BIN);
			}
			else
			{
				WandWave_Present=FALSE;
				if(Weapons_Possessed&Magical_Book_BIN&&Candle_Present!=Both_Candles)
				{
					if(Candle_Present&First_Candle)
					{
						Candle_Present|=Second_Candle;
						Current_Flame=Second_Flame;
					}
					else
					{
						Candle_Present|=First_Candle;
						Current_Flame=First_Flame;
					}
					Candle_Counter[Current_Flame]=Sprite_w-1;
					Candle_x[Current_Flame]=WandWave_x;
					Candle_y[Current_Flame]=WandWave_y;
					Candle_Factor[Current_Flame]=20;
				}
			}
		}
		
		if(~_rowread(ARROWS_ROW)&SECOND_KEY)
			Sword_Key_Released=TRUE;
		if(_rowread(ARROWS_ROW)&SECOND_KEY && Sword_Key_Released && !Currently_Using_Sword && !Warped_By_Recorder && !Lifting_Item && !Printing_Shop_Text &&
			(Find_Best_Sword(Weapons_Possessed) != Menu_Weap8_Blank) &&
				(((!World || Inside_Portal) &&	((!(Link_Direction&0x01) && Link_y>=5 && Link_y<=85) || (Link_Direction&0x01 && Link_x>=5 && Link_x<=145))) ||
				(Link_y>=14 && Link_x>15 && Link_y<=76 && Link_x<135)))
		{
			Currently_Using_Sword=TRUE;
			Sword_Key_Released=FALSE;
			Current_Sword=Find_Best_Sword(Weapons_Possessed);
			Current_Sword_Stage=Zeroth_Sword_Stage;
			Sword_x=Link_x+Sword_x_Offset[Link_Direction];
			Sword_y=Link_y+Sword_y_Offset[Link_Direction];
		}
		if(Currently_Using_Sword)
		{
			if(!Already_Switched_Sword_Direction && Current_Sword_Stage==Second_Sword_Stage)
			{
				Keys_Pressed=_rowread(ARROWS_ROW)&0x0F;	//Accept Only Arrow Keys
				if(Keys_Pressed)
				{
					Replenish_Link_BG(Link_x,Link_y,Current_Link);
					if(Currently_Using_Wand)
						Replenish_Wand_BG(Sword_x,Sword_y,Sword[Sword_Wand][Full_Sword][Link_Direction]);
					else
						Replenish_Sword_BG(Sword_x,Sword_y,Sword[Current_Sword][Full_Sword][Link_Direction]);
					switch(Keys_Pressed)
					{
						case UP_KEY :
						{
							Link_Direction=UP;
							break;
						}
						case LEFT_KEY :
						{
							Link_Direction=LEFT;
							break;
						}
						case DOWN_KEY :
						{
							Link_Direction=DOWN;
							break;
						}
						case RIGHT_KEY :
						{
							Link_Direction=RIGHT;
							break;
						}
					}
					Sword_x=Link_x+Sword_x_Offset[Link_Direction];
					Sword_y=Link_y+Sword_y_Offset[Link_Direction];
					if(!Link_as_EnemySprite)
						Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
					Already_Switched_Sword_Direction=TRUE;
					--Current_Sword_Stage;
				}
			}
			switch(Current_Sword_Stage)
			{
				case(Zeroth_Sword_Stage)	:
				{
					Sword_ClockRef=Game_Clock;
					Replenish_Link_BG(Link_x,Link_y,Current_Link);
					if(!Link_as_EnemySprite)
						Current_Link=Link_Strike[Link_Direction];
					++Current_Sword_Stage;
					break;
				}
				case(First_Sword_Stage)		:
				{
					if(Game_Clock-Sword_ClockRef>20)
						++Current_Sword_Stage;
					break;
				}
				case(Second_Sword_Stage)	:
				{
					if(Currently_Using_Wand)
						Draw_Magical_Wand(Sword_x,Sword_y,Sword[Sword_Wand][Full_Sword][Link_Direction],OS_Planes_BIN);
					else
						Draw_Sword(Sword_x,Sword_y,Sword[Current_Sword][Full_Sword][Link_Direction],OS_Planes_BIN);
					if(Game_Clock-Sword_ClockRef>70)
					{
						if(Currently_Using_Wand)
							Replenish_Wand_BG(Sword_x,Sword_y,Sword[Sword_Wand][Full_Sword][Link_Direction]);
						else
							Replenish_Sword_BG(Sword_x,Sword_y,Sword[Current_Sword][Full_Sword][Link_Direction]);
						if(Currently_Using_Wand && !WandWave_Present && Link_Within_Boundaries(Link_Direction,Link_x,Link_y,
							Wand_h/2+Sprite_h+1,Wand_w/2+Sprite_w+1,LCD_h-1-Sprite_h-Wand_h/2-Sprite_h-1,LCD_w-Sprite_w-Wand_w/2-Sprite_w-1))
						{
							WandWave_Present=TRUE;
							WandWave_Direction=Link_Direction;
							WandWave_x=Link_x+WandWave_x_Offset[WandWave_Direction];
							WandWave_y=Link_y+WandWave_y_Offset[WandWave_Direction];
						}
						else if(!Shooting_Sword_Present&&!Sword_Shards_Present&&Hearts/Heart_Containers==2&&
							Link_Within_Boundaries(Link_Direction,Link_x,Link_y,Sword_h*3/2+1,Sword_w*3/2+1,LCD_h-1-Sprite_h-Sword_h*3/2-1,LCD_w-Sprite_w-Sword_w*3/2-1))
						{
							Shooting_Sword_Present=TRUE;
							Shooting_Sword_Direction=Link_Direction;
							Shooting_Sword_x=Link_x+Shooting_Sword_x_Offset[Shooting_Sword_Direction];
							Shooting_Sword_y=Link_y+Shooting_Sword_y_Offset[Shooting_Sword_Direction];
						}
						++Current_Sword_Stage;
					}
					break;
				}
				case(Third_Sword_Stage)		:
				{
					if(Currently_Using_Wand)
						Draw_Magical_Wand(Sword_x,Sword_y,Sword[Sword_Wand][Half_Sword][Link_Direction],OS_Planes_BIN);
					else
						Draw_Sword(Sword_x,Sword_y,Sword[Current_Sword][Half_Sword][Link_Direction],OS_Planes_BIN);
					if(Game_Clock-Sword_ClockRef>90)
					{
						Replenish_Link_BG(Link_x,Link_y,Current_Link);
						if(Currently_Using_Wand)
							Replenish_Wand_BG(Sword_x,Sword_y,Sword[Sword_Wand][Half_Sword][Link_Direction]);
						else
							Replenish_Sword_BG(Sword_x,Sword_y,Sword[Current_Sword][Half_Sword][Link_Direction]);
						
						Link_Animation=Static;
						if(!Link_as_EnemySprite)
							Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
						Already_Switched_Sword_Direction=FALSE;
						Currently_Using_Sword=FALSE;
						Currently_Using_Wand=FALSE;
						
						//Temporary fix for DD_Kill type doors and items until enemies are implemented
						if(World && !Inside_Portal)
						{
							for(i=0;i<4;++i)
							{
								if(D_Room_Properties[Current_Save][World-1][World_Index][i]==DD_Kill)
									D_Room_Properties[Current_Save][World-1][World_Index][i]=DD_Open;
							}
							Define_D_Door_Tiles(Link_Direction,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
							Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
							Update_Doors(Dark_Room,&D_Room_Properties[Current_Save][World-1][World_Index][0],Map_Tiles);
								
							Current_Item=D_Room_Properties[Current_Save][World-1][World_Index][4];
							if(Current_Item && !(D_Room_Properties[Current_Save][World-1][World_Index][7]&Auto_Appear))
							{
								++Total_Items;
								Load_Item(&Active_Items[Total_Items-1],Item_Data[Current_Item],Size_of_Item_Struct);
								Item_x[Total_Items-1]=D_Room_Properties[Current_Save][World-1][World_Index][5];
								Item_y[Total_Items-1]=D_Room_Properties[Current_Save][World-1][World_Index][6];
								Item_Price[Total_Items-1]=0;
								Item_Animation_Time[Total_Items-1]=128;
		  					Item_Expire_Time[Total_Items-1]=0;
							}
						}
					}
					break;
				}
			}
		}
		if(Shooting_Sword_Present && (TimeBypass || Game_Clock-Shooting_Sword_ClockRef>Projectile_Interval))
		{
			Shooting_Sword_ClockRef=Game_Clock;
			Replenish_Shooting_Sword_BG(Shooting_Sword_x,Shooting_Sword_y,Sword[Shooting_Sword_Animation][Full_Sword][Shooting_Sword_Direction]);
			if(Object_Within_Boundaries(Shooting_Sword_Direction,Shooting_Sword_x,Shooting_Sword_y,Sword_h/2,Sword_w/2,LCD_h-1-Sword_h*3/2,LCD_w-Sword_w*3/2)&&
			~_rowread(F1_ROW)&F1_KEY)
			{
				Shooting_Sword_x+=Unit_x_Offset[Shooting_Sword_Direction];
				Shooting_Sword_y+=Unit_y_Offset[Shooting_Sword_Direction];
				Draw_Shooting_Sword(Shooting_Sword_x,Shooting_Sword_y,Sword[Shooting_Sword_Animation][Full_Sword][Shooting_Sword_Direction],OS_Planes_BIN);
				Shooting_Sword_Animation=!Shooting_Sword_Animation;
			}
			else
			{
				Shooting_Sword_Present=FALSE;
				switch(Shooting_Sword_Direction)	///Use an array?
				{
					case	UP		:
					{
						Shooting_Sword_x+=Sword_w/2;
						break;
					}
					case	LEFT	:
					{
						Shooting_Sword_y+=Sword_h/2;
						break;
					}
					case	DOWN	:
					{
						Shooting_Sword_x+=Sword_w/2;
						Shooting_Sword_y+=Sword_h;
						break;
					}
					case	RIGHT	:
					{
						Shooting_Sword_x+=Sword_w;
						Shooting_Sword_y+=Sword_h/2;
						break;
					}
				}
				Sword_Shards_Present=TRUE;
				Current_Sword_Shards_Stage=0;
			}
		}
		if(Sword_Shards_Present && (TimeBypass || (Game_Clock-Shooting_Sword_ClockRef)>(unsigned char)(Projectile_Interval<<2)))
		{
			Shooting_Sword_ClockRef=Game_Clock;
			if(Current_Sword_Shards_Stage<Sprite_w*3/2)
			{
				Replenish_Sword_Shards_BG((signed short)Shooting_Sword_x,(signed short)Shooting_Sword_y,Current_Sword_Shards_Stage,Sword_Shards);
				++Current_Sword_Shards_Stage;
				Draw_Sword_Shards((signed short)Shooting_Sword_x,(signed short)Shooting_Sword_y,
					Current_Sword_Shards_Stage,Current_Sword_Shards_Stage%2,Sword_Shards);
			}
			else
			{
				Replenish_Sword_Shards_BG((signed short)Shooting_Sword_x,(signed short)Shooting_Sword_y,Current_Sword_Shards_Stage,Sword_Shards);
				Sword_Shards_Present=FALSE;
			}
		}
		if(Releasing_Or_Recieving_Weapon)
		{
			switch(Current_Weapon_Release_Stage)
			{
				case(Zeroth_Weapon_Release_Stage)	:
				{
					Weapon_Release_ClockRef=Game_Clock;
					Replenish_Link_BG(Link_x,Link_y,Current_Link);
					if(!Link_as_EnemySprite)
						Current_Link=Link_Strike[Link_Direction];
					++Current_Weapon_Release_Stage;
					break;
				}
				case(First_Weapon_Release_Stage)	:
				{
					if(Game_Clock-Weapon_Release_ClockRef>40)
					{
						Replenish_Link_BG(Link_x,Link_y,Current_Link);
						if(!Link_as_EnemySprite)
							Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
						++Current_Weapon_Release_Stage;
					}
					break;
				}
				case(Second_Weapon_Release_Stage)		:
				{
					if(Game_Clock-Weapon_Release_ClockRef>70)
					{
						Replenish_Link_BG(Link_x,Link_y,Current_Link);
						Link_Animation=Static;
						if(!Link_as_EnemySprite)
							Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
						Releasing_Or_Recieving_Weapon=FALSE;
					}
					break;
				}
			}
		}
		
		if(Unlock_Door && Game_Clock-D_Door_ClockRef>64)
		{
			Define_D_Door_Tiles(Link_Direction,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
			Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
			Update_Doors(Dark_Room,&D_Room_Properties[Current_Save][World-1][World_Index][0],Map_Tiles);
			Unlock_Door=Finished_Unlock;
		}
					
		if(Dark_Room==Turning_Lights_On)
		{
			Draw_Link(Link_x,Link_y,Current_Link,Gray_Planes_BIN);
			if(Candle_Present)
				Draw_Candle(Candle_x[First_Flame],Candle_y[First_Flame],Graphics16[Fire+Candle_Animation[First_Flame]],Gray_Planes_BIN);
			Scroll_ClockRef=Global_Clock;
			while(!(Global_Clock-Scroll_ClockRef>64)) {}
			
			Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
			Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,DO_Plane_BIN);
			Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
			FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
			FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			if(Candle_Present)
				Draw_Candle(Candle_x[First_Flame],Candle_y[First_Flame],Graphics16[Fire+Candle_Animation[First_Flame]],Gray_Planes_BIN);
			while(!(Global_Clock-Scroll_ClockRef>128)) {}
			
			Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
			Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
			Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
			FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
			FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			if(Candle_Present)
				Draw_Candle(Candle_x[First_Flame],Candle_y[First_Flame],Graphics16[Fire+Candle_Animation[First_Flame]],Gray_Planes_BIN);
			while(!(Global_Clock-Scroll_ClockRef>192)) {}
			
			Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN|BG_Planes_BIN);
			Dark_Room=Lights_On;
		}
		
		if(PushBlock_Present==PushBlock_Pushed&&Game_Clock-Scroll_ClockRef>10)
		{
			Scroll_ClockRef=Game_Clock;
			if(PushBlock_Index<Push_Distance)
			{
				Replenish_PushBlock_BG(PushBlock_x,PushBlock_y,Graphics16[Shop_Stair]);
				PushBlock_x=PushBlock_x+Unit_x_Offset[PushBlock_Direction];
				PushBlock_y=PushBlock_y+Unit_y_Offset[PushBlock_Direction];
				Draw_PushBlock(PushBlock_x,PushBlock_y,Map_Tiles[PushBlock_Type],OS_Planes_BIN);
				++PushBlock_Index;
			}
			else
			{
				Discovered_Pathways[(World_Index)/World_w]|=(0x01<<(World_Index&0x0F));
				Draw_PushBlock(PushBlock_x,PushBlock_y,Map_Tiles[PushBlock_Type],BG_Planes_BIN);
				if(Stair_Index)
				{
					Collision_Detection_Buffer[Stair_Index]=Stair;
					Draw_Tile(Stair_Index%Screen_w*Sprite_w,Stair_Index/Screen_w*Sprite_h,Map_Tiles[Stair],OS_Planes_BIN|BG_Planes_BIN);
				}
				if(World)
				{
					for(i=0;i<4;++i)
					{
						if(D_Room_Properties[Current_Save][World-1][World_Index][i]==DD_Push)
							D_Room_Properties[Current_Save][World-1][World_Index][i]=DD_Open;
					}
					Define_D_Door_Tiles(Link_Direction,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
					Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
					Update_Doors(Dark_Room,D_Room_Properties[Current_Save][World-1][World_Index],Map_Tiles);
				}
				PushBlock_Present=0;
				Sprite_Interval>>=1;
			}
		}
		
		if(Lifting_Item && Game_Clock-Lifted_Item_ClockRef>512)
		{
			Replenish_Item_BG(Lifted_Item_x,Lifted_Item_y,Graphics16[Current_Item_Graphics]);
			Replenish_Link_BG(Link_x,Link_y,Current_Link);
			if(!Link_as_EnemySprite)
				Current_Link=Link[Current_Shield][DOWN][Static];
			Lifting_Item=FALSE;
		}
		
		if(Game_Clock-Rupy_Animation_ClockRef>128)
		{
			Rupy_Animation_ClockRef=Game_Clock;
			Rupy_Animation_Flag=!Rupy_Animation_Flag;
		}
		
		if(Shopkeeper_Flickering)
		{
			if(Game_Clock-Shopkeeper_Flicker_ClockRef>32)
			{
				Shopkeeper_Flicker_ClockRef=Game_Clock;
				Shopkeeper_Animation=!Shopkeeper_Animation;
				++Shopkeeper_Flicker_Counter;
			}
			if(Shopkeeper_Animation)
				Draw_Shopkeeper(75,36,Graphics16[Shop_Info[Current_Shop][Shopkeeper]],OS_Planes_BIN);
			else
			{
				if(Shopkeeper_Flicker_Counter>8)
				{
					Shopkeeper_Flickering=FALSE;
					Browsing_Shops=TRUE;
				}
				Clear_Shopkeeper(75,36,9,0xFFFF,LO_Plane_BIN|DO_Plane_BIN|LB_Plane_BIN|DB_Plane_BIN);
			}
		}
		
		if(Flash_Submenu && (!Printing_Shop_Text || Current_Shop==Shop_Waterfall_Pay_Talk || Current_Shop==Shop_Tree_Pay_Talk))
		{
			
			 ///Interference with Scroll_Index possible?
			if(Flash_Submenu==Open_Flash_Submenu && (TimeBypass || _rowread(F4_ROW)&BKSPC_KEY || (Game_Clock-Flash_Submenu_ClockRef>(unsigned char)(Scroll_Interval+1))))
			{
				Flash_Submenu_ClockRef=Game_Clock;
				Scroll_SubMenu(Action_Scroll_Submenu,Scroll_Index,Menu_Buffer[0],Menu_Buffer[1],Oversized_Buffer);
				++Scroll_Index;
				if(Scroll_Index==SubMenu_h)
				{
					i=A_SubBox_x;
					j=Find_Best_Sword(Weapons_Possessed);
					if(j<2)
						++i;
					Update_A_Box(i,A_SubBox_y,Graphics16[j],OS_Planes_BIN);
					Update_B_Box(Sub_Menu,Cursor_Position,Weapons_Possessed);
					Flash_Submenu=Flash_Submenu_Active;
				}
			}
			else if(Flash_Submenu==Flash_Submenu_Active && Game_Clock-Flash_Submenu_ClockRef>13)
			{
				if(Rupies_Spent )
				{
					Flash_Submenu_ClockRef=Game_Clock;
					if(Rupies_Spent>0)
					{
						--Rupies_Spent;
						--Rupies_Possessed;
					}
					else
					{
						++Rupies_Spent;
						++Rupies_Possessed;
					}
					Split_Number[0]=Rupies_Possessed/100;
					Split_Number[1]=(Rupies_Possessed%100)/10;
					Split_Number[2]=Rupies_Possessed%10;
					Split_Number[0]=Rupies_Possessed/100;
					Split_Number[1]=(Rupies_Possessed%100)/10;
					Split_Number[2]=Rupies_Possessed%10;
					for(i=0;i<3;++i)
					{
						if(i==0 && !Split_Number[0])				//Print "X" only if <100
							j=Char_X;
						else if(i==1 && Rupies_Possessed<10)	//Shift print to middle if <10
							j=Char_0+Split_Number[2];
						else if(i==2 && Rupies_Possessed<10)	//Needed with above
							j=Char_Space;
						else 																//Default print algorithm
							j=Char_0+Split_Number[i];
						Print_Character(57+5*i,5,Character[j],OS_Planes_BIN);
					}
				}
				else if(Game_Clock-Flash_Submenu_ClockRef>256)
				{
					Update_B_Box(Sub_Menu,Cursor_Position,0x00000000);
					Update_A_Box(A_SubBox_x,A_SubBox_y,Graphics16[Menu_Weap8_Blank],OS_Planes_BIN);
					Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
					if(Current_Shop==Shop_Waterfall_Pay_Talk || Current_Shop==Shop_Tree_Pay_Talk)
						Printing_Shop_Text=TRUE;
					Flash_Submenu=Close_Flash_Submenu;
					Scroll_Index=0;
				}
			}
			else if(Flash_Submenu==Close_Flash_Submenu && (TimeBypass || _rowread(F4_ROW)&BKSPC_KEY || (Game_Clock-Flash_Submenu_ClockRef>(unsigned char)(Scroll_Interval+1))))
			{
				Flash_Submenu_ClockRef=Game_Clock;
				Scroll_From_SubMenu(Action_Scroll_From_SubMenu,Scroll_Index,Current_Screen_Buffer[0],Current_Screen_Buffer[1],Oversized_Buffer);
				++Scroll_Index;
				if(Scroll_Index==SubMenu_h)
					Flash_Submenu=Flash_Submenu_Inactive;
			}
		}	//End of Flash_Submenu
			
			
		if(Triforce_Curtains)
		{
			while(Game_Clock-Scroll_ClockRef<200) {}
			for(i=6;i;--i)
			{
				for(j=0;j<10;++j)
					Draw_Part_Of_The_BombShock(j<<4,0,LCD_h-1,0x0000,DG_Plane_BIN);
				Draw_Link(Link_x,Link_y,Current_Link,Gray_Planes_BIN);
				Draw_Item(Lifted_Item_x,Lifted_Item_y,Graphics16[Current_Item_Graphics],Gray_Planes_BIN);
				while(Game_Clock-Scroll_ClockRef<64) {}
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
				Draw_Link(Link_x,Link_y,Current_Link,Gray_Planes_BIN);
				Draw_Item(Lifted_Item_x,Lifted_Item_y,Graphics16[Current_Item_Graphics],Gray_Planes_BIN);
				while(Game_Clock-Scroll_ClockRef<128) {}
				Scroll_ClockRef=Game_Clock;
			}
			while(Game_Clock-Scroll_ClockRef<256) {}
			Scroll_ClockRef=Game_Clock;
			for(i=0;i<LCD_w/2;++i)
			{
				while(Game_Clock-Scroll_ClockRef<8) {}
				Scroll_ClockRef=Game_Clock;
				Draw_Curtain(i,0,LCD_h-1,0x8000,LO_Plane_BIN|DO_Plane_BIN);
				Draw_Curtain(LCD_w-16-i,0,LCD_h-1,1,LO_Plane_BIN|DO_Plane_BIN);
				Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
				Draw_Item(Lifted_Item_x,Lifted_Item_y,Graphics16[Current_Item_Graphics],OS_Planes_BIN);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
			}
			Scroll_ClockRef=Game_Clock;
			while(Game_Clock-Scroll_ClockRef<256) {}
			Draw_Curtain(75,42,16,0xFFFF,LG_Plane_BIN|DG_Plane_BIN);
			while(Game_Clock-Scroll_ClockRef<512) {}
			Triforce_Curtains=FALSE;
			
			Previous_World=World;
			Previous_World_Index=Dungeon_Entrance_Locations[Current_Dungeon_Level-1];
			Link_Direction=DOWN;
			Potion_Present=TRUE;	//Refill Link hearts
			Portal_Open=FALSE;
			goto Dungeon_Completed; //Warp out of dungeon
		}
		
		//Beginning of Sprite_Interval executions. Major loop in program.
		if(TimeBypass || Game_Clock-Link_ClockRef>Sprite_Interval)
		{
				
			///Info keys
			if(_rowread(F5_ROW)&CARET_KEY)
			{
				MoveTo(0,0);
				printf("%u-%u",World,Previous_World);
				MoveTo(0,8);
				printf("%u-%u",World_Index,Previous_World_Index);
				MoveTo(0,16);
				printf("%u ",Link_Screen_Index);
				MoveTo(0,25);
				printf("%u ",Link_x);
				MoveTo(0,33);
				printf("%u",Link_y);
				MoveTo(0,41);
				printf("%u",Link_x_RMNDR);
				MoveTo(0,49);
				printf("%u",Link_y_RMNDR);
			}
			if(World)
			{
				///D_Room_Properties Testing
				if(_rowread(F4_ROW)&F4_KEY)
				{
					MoveTo(0,0);
					printf("%u",D_Room_Properties[Current_Save][World-1][World_Index][0]);
					MoveTo(0,8);
					printf("%u",D_Room_Properties[Current_Save][World-1][World_Index][1]);
					MoveTo(0,16);
					printf("%u",D_Room_Properties[Current_Save][World-1][World_Index][2]);
					MoveTo(0,24);
					printf("%u",D_Room_Properties[Current_Save][World-1][World_Index][3]);
					MoveTo(0,33);
					printf("%u ",D_Room_Properties[Current_Save][World-1][World_Index][4]);
				}
				if(_rowread(F5_ROW)&F5_KEY)
				{
					MoveTo(0,0);
					printf("%u",D_Room_Properties_ROM[World-1][World_Index][0]);
					MoveTo(0,8);
					printf("%u",D_Room_Properties_ROM[World-1][World_Index][1]);
					MoveTo(0,16);
					printf("%u",D_Room_Properties_ROM[World-1][World_Index][2]);
					MoveTo(0,24);
					printf("%u",D_Room_Properties_ROM[World-1][World_Index][3]);
					MoveTo(0,33);
					printf("%u ",D_Room_Properties_ROM[World-1][World_Index][4]);
				}
			}
			
			Link_ClockRef=Game_Clock;
			Effective_Direction=Arrow_Key_CleanUp(_rowread(ARROWS_ROW)&0x0F,Effective_Direction);	//Only Accept Arrow Keys
			if(Effective_Direction!=NOWHERE && !Currently_Using_Sword && !Releasing_Or_Recieving_Weapon && !Warped_By_Recorder && !Lifting_Item && !Printing_Shop_Text)
			{
				Link_Direction=Effective_Direction;
				Replenish_Link_BG(Link_x,Link_y,Current_Link);
				
				if(Link_as_EnemySprite)
				{
					if(Link_EnemySprite<17)
						Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
					else
						Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
				}
				else
					Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
				
				//Align_Link_x
				Link_x_RMNDR=Link_x%Sprite_w;
				if((Link_Direction==UP || Link_Direction==DOWN) && Link_x%(Sprite_w/2))
				{
					if(Link_x_RMNDR<=2)
						Link_x-=Link_x_RMNDR;
					else if(Link_x_RMNDR>=7)
						Link_x=Link_x+Sprite_w-Link_x_RMNDR;
					else
						Link_x=Link_x+5-Link_x_RMNDR;
				}
				Link_x_RMNDR=Link_x%Sprite_w;
				
				//Align Link y
				Link_y_RMNDR=Link_y%Sprite_h;
				if((Link_Direction==LEFT || Link_Direction==RIGHT) && Link_y_RMNDR && Link_y_RMNDR!=Sprite_h-4)
				{
					if(Link_y_RMNDR<=2)
						Link_y-=Link_y_RMNDR;
					else if(Link_y_RMNDR>=7)
						Link_y=Link_y+Sprite_h-Link_y_RMNDR;
					else
						Link_y=Link_y+5-Link_y_RMNDR;
				}
				Link_y_RMNDR=Link_y%Sprite_h;
				Link_Screen_Index=Link_x/Sprite_w+Link_y/Sprite_h*Screen_w;
				
				//Algorithms for unlocking dungeon doors and walking through bombed walls.
				if(World && Link_x==Link_x_Dungeon_Door[Link_Direction] && Link_y==Link_y_Dungeon_Door[Link_Direction])
				{
					if(D_Room_Properties[Current_Save][World-1][World_Index][Link_Direction]==DD_Lock&&(Keys_Possessed||Weapons_Possessed&Magical_Key_BIN))
					{	//Unlock door
						Unlock_Door=Link_Direction+1;
						D_Door_ClockRef=Game_Clock;
						if(Keys_Possessed)
							--Keys_Possessed;
						Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
						D_Room_Properties[Current_Save][World-1][World_Index][Link_Direction]=DD_Open;
						D_Room_Properties[Current_Save][World-1][World_Index+World_Index_Offset[Link_Direction]][Link_Direction^0x02]=DD_Open;	//( ^0x02 inverts the direction)
					}
					if(D_Room_Properties[Current_Save][World-1][World_Index][Link_Direction]==DD_Bomb)
					{	//Slide Into Bombed Wall
						Slide_Link(Link_Slide,Link_Direction,Link_x,Link_y,Sprite_Interval,&Game_Clock,Current_Link);
						Link_x+=Sprite_x_Offset[Link_Direction];
						Link_y+=Sprite_y_Offset[Link_Direction];
						Slide_Link(Link_Hide,Link_Direction,Link_x,Link_y,Sprite_Interval,&Game_Clock,Current_Link);
						Link_x+=Sprite_x_Offset[Link_Direction];
						Link_y+=Sprite_y_Offset[Link_Direction];
						goto Scroll_Prep;
					}
				}
				
				//Move link when not at screen boundary
				if((Link_Direction==UP&&Link_y>0) || (Link_Direction==LEFT&&Link_x>0) ||
					(Link_Direction==DOWN&&Link_y<LCD_h-Sprite_h-1) || (Link_Direction==RIGHT&&Link_x<LCD_w-Sprite_w))
				{
					++Animation_Counter;
					if(Animation_Counter>=Frames_Per_Animation)
					{
						Animation_Counter=0;
						Link_Animation=!Link_Animation;
						if(Link_as_EnemySprite)
						{
							if(Link_EnemySprite<17)
								Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
							else
								Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
						}
						else
							Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
					}
					
					if(((Link_Direction==UP || Link_Direction==DOWN) && Link_y_RMNDR && Link_y_RMNDR!=5) ||
						((Link_Direction==LEFT || Link_Direction==RIGHT) && Link_x_RMNDR && Link_x_RMNDR!=5) ||
						Walkthrough||!Collision_Detected(Link_Direction,Link_Screen_Index,Link_x_RMNDR/5,Link_y_RMNDR/5,Collision_Detection_Buffer))	///Why can't a BOOL typecast work instead of /5?
					{
						Link_x+=Unit_x_Offset[Link_Direction];
						Link_y+=Unit_y_Offset[Link_Direction];
					}
				}
				else if(World_Index!=Shop_Room && World_Index!=Dungeon_Underpass && World_Index!=Treasure_Room	&&
				((Link_Direction==UP && World_Index>15) || (Link_Direction==LEFT&&(World_Index&0x0F)) ||
					(Link_Direction==DOWN && World_Index<112) || (Link_Direction==RIGHT && (World_Index&0x0F)<(World_w-1))))
				{	//Scroll to next screen when boundary is touched
					
					//Cover Level 7 Lake if required
					if(!World && World_Index==L7_Lake && Collision_Detection_Buffer[86]==Stair)
					{
						for(i=0;i<24;++i)	//Drying lake tiles defined in a hole in Dungeon_2 map (screen 74)
							Draw_Tile(Sprite_w*(5+i%6),Sprite_h*(3+i/6),Map_Tiles[Screen_Map_D[1][74][24+i]],OS_Planes_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						Recorder_ClockRef=Game_Clock;
						while(Game_Clock-Recorder_ClockRef<256) {}
					}
					
					//Clean up before scrolling
					Scroll_Prep:
					Total_Items=0;
					if(Shooting_Sword_Present)
					{
						Replenish_Shooting_Sword_BG(Shooting_Sword_x,Shooting_Sword_y,Sword[Shooting_Sword_Animation][Full_Sword][Shooting_Sword_Direction]);
						Shooting_Sword_Present=FALSE;
					}
					if(Sword_Shards_Present)
					{
						Replenish_Sword_Shards_BG((signed short)Shooting_Sword_x,(signed short)Shooting_Sword_y,Current_Sword_Shards_Stage,Sword_Shards);
						Sword_Shards_Present=FALSE;
					}
					if(Boomerang_Present)
					{
						Replenish_Boomerang_BG(Boomerang_x,Boomerang_y,Boomerang[Boomerang_Animation]);
						Boomerang_Present=0;
					}
					if(Bomb_Present)	{
						for(Current_Bomb=First_Bomb;Current_Bomb<=Second_Bomb;++Current_Bomb)
						{
							if(Bomb_Present&(1<<Current_Bomb))
							{
								if(Current_Bomb_Stage[Current_Bomb]==Zeroth_Bomb_Stage)
									Replenish_Bomb_BG(Bomb_x[Current_Bomb],Bomb_y[Current_Bomb],Graphics16[Bomb_2]);
								else
									Replenish_Bomb_Cloud_BG((signed short)Bomb_x[Current_Bomb],(signed short)Bomb_y[Current_Bomb],Graphics16[Cloud_Full]);
							}
						}
						Bomb_Present=0;
					}
					if(Arrow_Present)
					{
						Replenish_Arrow_BG(Arrow_x,Arrow_y,Arrow[Arrow_Type][Arrow_Direction]);
						Arrow_Present=FALSE;
					}
					if(Candle_Present)
					{
						for(Current_Flame=First_Flame;Current_Flame<=Second_Flame;++Current_Flame)
						{
							if(Candle_Present&(1<<Current_Flame))
							{
								Replenish_Candle_BG(Candle_x[Current_Flame],Candle_y[Current_Flame],Graphics16[Fire+Candle_Animation[Current_Flame]]);
							}
						}
						Candle_Present=0;
					}
					if(Tornado_Present&&!Warped_By_Recorder)
					{
						Replenish_Tornado_BG(Tornado_x,Tornado_y,Graphics16[Tornado]);
						Tornado_Present=FALSE;
					}
					if(Meat_Present)
					{
						Replenish_Meat_BG(Meat_x,Meat_y,Graphics16[Meat_2]);
						Meat_Present=FALSE;
					}
					if(WandWave_Present)
					{
						Replenish_WandWave_BG(WandWave_x,WandWave_y,Graphics16[WandWave+WandWave_Direction]);
						WandWave_Present=FALSE;
					}
					Releasing_Or_Recieving_Weapon=FALSE;
					Candle_Exhausted=FALSE;
					Recorder_Exhausted=FALSE;
					PushBlock_Present=FALSE;
					Inside_Shop=FALSE;
					Shopkeeper_Flickering=FALSE;
					Browsing_Shops=FALSE;	
					Flash_Submenu=Flash_Submenu_Inactive;
					if(Rupies_Spent)
					{
						Rupies_Possessed-=Rupies_Spent;
						Rupies_Spent=0;
					}
					Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
					if(World)
					{
						for(i=0;i<4;++i)
						{	//Reset dungeon rooms that require enemy kills or pushblocks to open doors
							if(D_Room_Properties_ROM[World-1][World_Index][i]==DD_Kill)
								D_Room_Properties[Current_Save][World-1][World_Index][i]=DD_Kill;
							if(D_Room_Properties_ROM[World-1][World_Index][i]==DD_Push)
								D_Room_Properties[Current_Save][World-1][World_Index][i]=DD_Push;
						}
					}
					
					for(i=0;i<8;++i)
						Enemies[i]=Enemy_Dead;
					for(i=0;i<12;i++)
						Enemy_Projectile[i]=No_Projectile;
					if(!Portal_Open && !Warped_By_Recorder)
						goto Portal;
					if(Return_to_StartMenu)
					{
						Return_to_StartMenu=FALSE;
						goto StartMenu;
					}
					//End of Scroll_Prep
					
					//Mountain/forest maze algorithm
					if(World_Index==27)
					{
						if(Link_Direction==UP)
							++Mountain_Maze_Index;
						else
							Mountain_Maze_Index=0;
					}
					else
						Mountain_Maze_Index=0;
					if(World_Index==97)
					{
						if(Link_Direction==Forest_Maze[Forest_Maze_Index])
							++Forest_Maze_Index;
						else
							Forest_Maze_Index=0;
					}
					else
						Forest_Maze_Index=0;
					
					//Modify World_Index, unless lost in a maze
					if(World || (World_Index!=27 && World_Index!=97) || (World_Index==27 && (Mountain_Maze_Index==4 || Link_Direction==LEFT)) ||
						(World_Index==97 && (Forest_Maze_Index==4 || Link_Direction==RIGHT)))
					{
						World_Index+=World_Index_Offset[Link_Direction];
					}
					
					//Prepare Menu
					Update_Menu_SubTemplates(World,World_Index,Dungeon_Maps_Compasses,Dungeon_Tracker,
						D_Room_Properties[Current_Save],Dungeon_Levels,Character,Triforce_Template,Dungeon_Rough_Map_Template);
					if(!World)
					{
						Update_Triforces(Weapons_Possessed,Triforces,Menu_Planes_BIN);
						XOR_Menu_Map(Menu_Buffer[1],Menu_Map_x+((World_Index&0x0F)<<1),Menu_Map_y+((World_Index>>3)&0xFE));
					}
					
					//Darken screen before scrolling if required. (for dungeons)
					if(World && !Dark_Room && D_Room_Properties[Current_Save][World-1][World_Index][7]&D_Dark_Room)
					{
						Scroll_ClockRef=Global_Clock;
						Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						while(!(Global_Clock-Scroll_ClockRef>64)) {}
						Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
						Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,DO_Plane_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						while(!(Global_Clock-Scroll_ClockRef>128)) {}
						Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
						Darken_Room(Battle_Area_Luminosity|Synchronize_OpenDoors,Screen_Tiles_Buffer,DO_Plane_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						Dark_Room=Lights_Off;
					}
					
					//Define the Screen_Tiles_Buffer
					if(World)	//Apply Dungeon Template
						ptr=Screen_Map_Special[3];
					else	//Use Overworld tile data
						ptr=Screen_Map_Over[World_Index];
					Update_Screen_Tiles_Buffer(Screen_Tiles_Buffer,ptr,Size_of_Screen_Tiles_Buffer);
					
					//Define the central 12x7 tiles of a dungeon room.
					if(World)
					{
						ptr=&Screen_Tiles_Buffer[34];
						for(i=0;i<84;++i)
						{
							*ptr++=Screen_Map_D[World-1][World_Index][i];
							if((i+1)%12==0)
								ptr+=4;
						}
					}
					
					//Define the dungeon door tiles
					if(World)
						Define_D_Door_Tiles(Link_Direction,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
						
					//Copy the Screen_Tiles_Buffer to the Collision_Detection_Buffer
					Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
					
					//Execute dungeon specific preparation instructions: define current level definition, define items
					if(World)
					{
						Current_Dungeon_Level=Dungeon_Levels[World-1][World_Index];
						Current_Item=D_Room_Properties[Current_Save][World-1][World_Index][4];
						if(Current_Item && D_Room_Properties[Current_Save][World-1][World_Index][7]&Auto_Appear)
						{	
							if(Current_Item==DI_Rupies)
							{
								Total_Items=10;
								for(i=0;i<Total_Items;++i)
								{
									Load_Item(&Active_Items[i],Item_Data[Item_Rupy],Size_of_Item_Struct);
									Item_x[i]=DI_Rupies_x[i];
									Item_y[i]=DI_Rupies_y[i];
									Item_Price[i]=0;
									Item_Animation_Time[i]=128;
			  					Item_Expire_Time[i]=7680;
									Item_Animation_ClockRef[i]=Game_Clock;
									Item_Expire_ClockRef[i]=Game_Clock;
								}
								D_Room_Properties[Current_Save][World-1][World_Index][4]=0;
							}
							else if(Current_Item!=DI_Power)
							{
								Total_Items=1;
								Load_Item(&Active_Items[0],Item_Data[Current_Item],Size_of_Item_Struct);
								Item_x[0]=D_Room_Properties[Current_Save][World-1][World_Index][5];
								Item_y[0]=D_Room_Properties[Current_Save][World-1][World_Index][6];
								Item_Price[0]=0;
								Item_Animation_Time[i]=128;
		  					Item_Expire_Time[0]=0;
								Item_Animation_ClockRef[0]=Game_Clock;
							}
						}
					}
					else
					{	//Execute overworld specific preparation instructions: Cover_Undiscovered_Pathways, 
						Cover_Undiscovered_Pathways(World_Index,Discovered_Pathways,Overworld_Pathways,Push_Blocks,Collision_Detection_Buffer,Screen_Tiles_Buffer);
						if(World_Index==26)
							Collision_Detection_Buffer[70]=Stair;
						if(World_Index==31)
						{
							Collision_Detection_Buffer[8]=Null;
							Collision_Detection_Buffer[24]=Null;
						}
					}
					
					//Prepare new background screen with updated Screen_Tiles_Buffer.
					Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,BG_Planes_BIN);
					
					//Apply dungeon darkness if last room was dark when leaving.
					if(Dark_Room)
					{
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LB_Plane_BIN);
						Darken_Room(Battle_Area_Luminosity|Synchronize_OpenDoors,Screen_Tiles_Buffer,DB_Plane_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					}
					
					//Link flash while scrolling error... not very visible though (requires new implementation)
					/*
					for(i=0;i<Sprite_h;++i)	//Save Link Background Before Entering Loop
					{
						Link_Buffer[0][i]=*(unsigned long*)(&Current_Background_Buffer[0][(Link_y+i)*30+(Link_x>>3)]);
						Link_Buffer[1][i]=*(unsigned long*)(&Current_Background_Buffer[1][(Link_y+i)*30+(Link_x>>3)]);
					}
					Replenish_Link_BG(Link_x,Link_y,Current_Link);
					*/
					
					
					//Begin scrolling
					for(Scroll_Index=0;Scroll_Index<Scroll_Index_Offset[Link_Direction];++Scroll_Index)
					{
						Scroll_ClockRef=Global_Clock;
						/*
						for(i=0;i<Sprite_h;++i)	//Replace Link's Background
						{
							*(unsigned long*)(&Oversized_Buffer[0][(Link_y+i)*30+(Link_x>>3)])=Link_Buffer[0][i];
							*(unsigned long*)(&Oversized_Buffer[1][(Link_y+i)*30+(Link_x>>3)])=Link_Buffer[1][i];
							FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
							FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
							while(~_rowread(ARROWS_ROW)&UP_KEY) {}
							while(_rowread(ARROWS_ROW)&UP_KEY) {}
						}
							*/
						++Animation_Counter;
						//if((++Animation_Counter)%(Frames_Per_Animation<<2)==0)
						if(Animation_Counter>=(Frames_Per_Animation<<2))
						{
							Animation_Counter=0;
							Link_Animation=!Link_Animation;
							if(Link_as_EnemySprite)
							{
								if(Link_EnemySprite<17)
									Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
								else
									Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
							}
							else
								Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
						}
						Scroll_Screen(Link_Direction,Scroll_Index);
						if(!Warped_By_Recorder)
						{
							if(((Link_Direction==UP||Link_Direction==DOWN)&&Scroll_Index<LCD_h-1-Sprite_h) ||
								((Link_Direction==LEFT||Link_Direction==RIGHT)&&Scroll_Index<LCD_w-Sprite_w))
							{
								Link_x+=Scroll_x_Offset[Link_Direction];
								Link_y+=Scroll_y_Offset[Link_Direction];
							}
							/*
							for(i=0;i<Sprite_h;++i)	//Save Link's Background
							{
								Link_Buffer[0][i]=*(unsigned long*)(&Oversized_Buffer[0][(Link_y+i)*30+(Link_x>>3)]);
								Link_Buffer[1][i]=*(unsigned long*)(&Oversized_Buffer[1][(Link_y+i)*30+(Link_x>>3)]);
							}
							*/
						}
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						if(!World && !Warped_By_Recorder)
							Draw_Link(Link_x,Link_y,Current_Link,Gray_Planes_BIN);
						while(!TimeBypass && ~_rowread(F4_ROW)&BKSPC_KEY && !(Global_Clock-Scroll_ClockRef>Scroll_Interval)) {}
					}	//End of Scroll_Screen
					
					
					//Slide Link out of door way in dungeon after scrolling.
					if(World)
					{
						//Normal Sliding Between Dungeon Walls
						Slide_Link(Link_Appear,Link_Direction,Link_x,Link_y,Sprite_Interval,&Game_Clock,Current_Link);
						Link_x+=Sprite_x_Offset[Link_Direction];
						Link_y+=Sprite_y_Offset[Link_Direction];
						i=D_Room_Properties[Current_Save][World-1][World_Index][Link_Direction^0x02];	//( ^0x02 inverts the direction)
						if(i<=DD_LOut || i==DD_Bomb )
						{	//Additional Sliding For Closing Doors Or Bombed Walls
							Replenish_Link_BG(Link_x,Link_y,Current_Link);
							Link_Animation=!Link_Animation;
							if(Link_as_EnemySprite)
							{
								if(Link_EnemySprite<17)
									Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
								else
									Current_Link=Enemies1D[Link_EnemySprite-17][Link_Animation];
							}
							else
								Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
							Slide_Link(Link_Slide,Link_Direction,Link_x,Link_y,Sprite_Interval,&Game_Clock,Current_Link);
							Link_x+=Sprite_x_Offset[Link_Direction];
							Link_y+=Sprite_y_Offset[Link_Direction];
							Define_D_Door_Tiles(NOWHERE,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
							Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
							Update_Doors(Dark_Room,D_Room_Properties[Current_Save][World-1][World_Index],Map_Tiles);
						}
					}
					
					//Remove dungeon darkness if going from a dark room to a light room.
					if(Dark_Room&&!(D_Room_Properties[Current_Save][World-1][World_Index][7]&D_Dark_Room))
						Dark_Room=Turning_Lights_On;
					
					//Trigger shop initialization if conditions are met.
					if(World&&(Current_Shop=Shop_From_World_Index[World][World_Index]))
					{
						Inside_Shop=Just_Entered_Shop;
						Shop_World=World;
						Shop_World_Index=World_Index;
					}
					
					//Add various auto-appear items to Overworld
					if(!World)
					{
						if(!World && (World_Index==57 || World_Index==67))
						{	//Pond Fairy
							++Total_Items;
							Load_Item(&Active_Items[Total_Items-1],Item_Data[Item_Fairy],Size_of_Item_Struct);
							Item_x[Total_Items-1]=77;
							Item_y[Total_Items-1]=40;
							Item_Price[Total_Items-1]=256;
							Item_Animation_Time[Total_Items-1]=64;
	  					Item_Expire_Time[Total_Items-1]=0;
						}
						if(!World && World_Index==36 && ~Weapons_Possessed&Power_Bracelet_BIN)
						{	//Power Bracelet
							++Total_Items;
							Load_Item(&Active_Items[Total_Items-1],Item_Data[Item_Bracelet],Size_of_Item_Struct);
							Item_x[Total_Items-1]=142;
							Item_y[Total_Items-1]=36;
							Item_Price[Total_Items-1]=0;
	  					Item_Expire_Time[Total_Items-1]=0;
						}
						if(!World && World_Index==95 && !Beach_HrtCntnr_Taken)
						{	//Beach Heart Container
							++Total_Items;
							Load_Item(&Active_Items[Total_Items-1],Item_Data[Item_Hrt_Cntnr_Add],Size_of_Item_Struct);
							Item_x[Total_Items-1]=120;
							Item_y[Total_Items-1]=45;
							Item_Price[Total_Items-1]=0;
	  					Item_Expire_Time[Total_Items-1]=0;
						}
					}
					
					Post_Scroll:
					
					//Initialize Push_Blocks if conditions are met.
					PushBlock_Index=Push_Blocks[World][World_Index][0];
					if(PushBlock_Index)
					{
						PushBlock_Present=PushBlock_Detectable;
						PushBlock_x=Push_Blocks[World][World_Index][1];
						PushBlock_y=Push_Blocks[World][World_Index][2];
						Stair_Index=Push_Blocks[World][World_Index][3];
						PushBlock_Floor=Push_Blocks[World][World_Index][5];
						PushBlock_Direction=Push_Blocks[World][World_Index][6];
						PushBlock_Type=Screen_Tiles_Buffer[PushBlock_Index];
					}
					
					
					//Enemy initialization routine $$
					
					///Refresh list once finalized	
					/* REPEATED HERE FOR REFERENCE
					//Enemy_Data[Current_Item] gets loaded into STRUCT Active_Enemies[8]
					struct ENEMY
					{
						unsigned char Life;
						unsigned char Movement;
						unsigned char Movement_Interval;
						unsigned char Enemy_Damage_to_Link;
						unsigned char Projectile_Type;	//Works as sprite def'n as well
						unsigned char Projectile_Release_Time;	//is shifted left by 8 after being loaded
						unsigned char Projectile_Damage_to_Link;
						unsigned char Special;	//Defines weaknesses, immunities
						unsigned char Dropable_Items;
					} Active_Enemies[8];
					*/
					if(!World && World_Index!=Shop_Room)	///Causes crash if execution permitted in dungeon and link scrolls into all D_Sand room. See D_Sand_Crash.txt.
					{
						//Identify valid "birth squares" for enemies.
						Total_Land_Tiles=0;
						ptr=Screen_Tiles_Buffer+34;
						ptr2=Current_Screen_Buffer[0];	//Used to store the locations of land tiles
						for(i=34;i<=141;++i)	//Scans only the middle 7 rows, while ignoring 2 left columns at top row and 2 right columns at bottome row
						{
							j=*ptr++;	//Grab current tile and increment ptr
							Meat_x= i&0x0F;	//Meat_x= i%16 (dummy variable)
							if(Meat_x>=2 && Meat_x<=13 && (j==D_Tile || j==Null || j==Dark || j==Cave || j==Sand))
							{
								*ptr2++=i;	//record the number of the tile that has been identified
								++Total_Land_Tiles;	//increment the land squares counter
							}
						}
						ptr2-=Total_Land_Tiles;	//Reset land pointer
						
						//Define enemies for current screen and, if required, load the enemies on to valid "birth squares"
						Load_Enemies(Enemies,Overworld_Enemies_ROM[World_Index],8);	//Loads number and type of enemies
						for(i=0;i<8;++i)
						{
							Meat_x=Enemies[i];	//New definition for Meat_x dummy
							if(Meat_x!=Enemy_Dead)
							{
								Load_Enemy_Data(&Active_Enemies[i],Enemy_Data[Meat_x],10);	//Loads specific info for current enemy initialization
								Enemy_Direction[i]=DOWN;
								Enemy_Animate[i]=TRUE;
								Enemy_Animation[i]=0;
								Enemy_Anim_Counter[i]=0;
								Enemy_Move_ClockRef[i]=0;
								Enemy_Event_ClockRef[i]=Game_Clock;
								Enemy_ProjRelease_Interval[i]=(Active_Enemies[i].ProjRelease_Interval+(Game_Clock%3))<<8;
								Enemy_ProjRelease_ClockRef[i]=Game_Clock;
								Current_Movement=Active_Enemies[i].Movement;
								
								/*
									if(Enemy_ProjRelease_ClockRef[i]-Game_Clock>Enemy_ProjRelease_Interval[i])
									{
										if((Game_Clock&3)==0)	//Randomize the possibility of firing a projectile after a certain time has passed
										{	//Fire a projectile
											Enemy_Projectile[i]=Active_Enemies[i].Projectile_Type;
											Enemy_Proj_Sprite[i]=Enemy_Proj_Sprites[Enemy_Projectile[i]-1];
											Enemy_Projectile_x[i]=Enemy_x[i]+Sprite_x_Offset[Enemy_Direction[i]];
											Enemy_Projectile_y[i]=Enemy_y[i]+Sprite_y_Offset[Enemy_Direction[i]];
											Enemy_Proj_Direction[i]=Enemy_Direction[i];
		  								Enemy_ProjMove_Interval[i]=Enemy_ProjMove_Intervals[Enemy_Projectile[i]-1];
											Enemy_ProjRelease_ClockRef[i]=Game_Clock;
										}
								*/
								
								if(Current_Movement<=On_Land)
								{
									if(i<4)
										Meat_x=(Game_Clock>>i)%Total_Land_Tiles;	//Generate random seed for 0<=i<4
									else
										Meat_x=(Global_Clock>>(i-4))%Total_Land_Tiles;	//Generate random seed for 4<=i<8
									j=ptr2[Meat_x];	//Grab a random On_Land tile
									Enemy_x[i]=(j&0x0F)*Sprite_w;
									Enemy_y[i]=(j>>4)*Sprite_h;
									Enemy_State[i]=Enemy_Appearing;
									Enemy_Sprite[i]=Graphics16[Cloud_Full];
									if(i&1)
										Enemy_Event_Interval[i]=(1+(Game_Clock>>i)%3)<<7;	//Randomly select "birth duration" between 0.5-1.5 seconds
									else
										Enemy_Event_Interval[i]=(1+(Global_Clock>>i)%3)<<7;	//Randomly select "birth duration" between 0.5-1.5 seconds
								}
								else
								{
									Enemy_Sprite[i]=Graphics16[Enemy_Invisible];
									switch(Current_Movement)
									{
										case Zola_Water:
										{
											Enemy_State[i]=Enemy_Submerged;
											break;
										}
										case LeeverLight_Dive:
										{
											++LeeverLight_Count;
											Enemy_State[i]=Enemy_Submerged;
											Enemy_Event_Interval[i]=(1+i)<<8;
											if(LeeverLight_Count>2)
												Enemies[i]=Enemy_Dead;
											break;
										}
										case LeeverDark_Dive:
										{
											Enemy_State[i]=Enemy_Submerged;
											Enemy_Event_Interval[i]=(1+(Game_Clock>>i)%3)<<7;	//Randomly define 0.5-1.5 seconds before emerging
											break;
										}
										case Rock_Fall:
										{	//Puts Rock into the right part of the loop for auto-initialization
											Enemy_State[i]=Enemy_Move;
											Enemy_Counter[i]=1;
											Enemy_y[i]=90;
											break;
										}
										case Gate_Glide:
										{
											Gates_Present=TRUE;
											Gate_x[0]=20;
											Gate_y[0]=18;
											Gate_x[1]=20;
											Gate_y[1]=72;
											Gate_x[2]=130;
											Gate_y[2]=72;
											Gate_x[3]=130;
											Gate_y[3]=18;
											break;
										}
										case Patra_Revolve:
										{
											//Implement later
											break;
										}
										case Statue_Frozen:
										{
											for(j=34;j<=141;++j)
											{
												Meat_x=Screen_Tiles_Buffer[j];
												if(Meat_x==H_C || Meat_x==H_O)
												{
													Statue_x[Statues_Present]=(j&0x0F)*Sprite_w;
													Statue_y[Statues_Present]=(j>>4)*Sprite_h;
													++Statues_Present;
												}
											}
											break;
										}
									}
								}	//End of if(Current_Movement<=On_Land)
							}	//End of initialize single enemy algorithm
						}	//End of for loop for enemy initialization
					}
				}	//End of screen to screen scrolling routine
			}	//End of Sprite time check
			
			//Compute Link's positional variables
			Link_Screen_Index=(Link_y/Sprite_h)*Screen_w+Link_x/Sprite_w;
			Link_x_RMNDR=Link_x%Sprite_w;
			Link_y_RMNDR=Link_y%Sprite_h;
			
			//Raft usage algorithm
			if(!World&&(World_Index==85||World_Index==63)&&Link_y<33&&Weapons_Possessed&Raft_BIN)
			{
				Scroll_ClockRef=Game_Clock;
				Replenish_Link_BG(Link_x,Link_y,Current_Link);
				for(i=0;i<32+Link_Direction;++i)
				{
					Draw_Raft(Link_x,Link_y+3,Graphics16[Raft_2],OS_Planes_BIN);
					Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(!(Game_Clock-Scroll_ClockRef>(unsigned char)(Sprite_Interval<<1))) {}
					Scroll_ClockRef=Game_Clock;
					Replenish_Raft_BG(Link_x,Link_y+3,Graphics16[Raft_2]);
					Replenish_Link_BG(Link_x,Link_y,Current_Link);
					if(Link_Direction)
						++Link_y;
					else
						--Link_y;
				}
				if(!Link_Direction)
					goto Scroll_Prep;
			}
			
			//Ladder usage algorithm
			if(Using_Ladder)
			{	//Ladder in use. Draw it.
				Draw_Step_Ladder(Ladder_x,Ladder_y,Graphics16[Ladder_2],OS_Planes_BIN);
				if((Ladder_Direction==UP_DOWN&&((Link_Direction!=UP&&Link_y>Ladder_y+5)||(Link_Direction!=DOWN&&Link_y<=Ladder_y-Sprite_h)))||
					(Ladder_Direction==LEFT_RIGHT&&((Link_Direction!=LEFT&&Link_x>=Ladder_x+Sprite_w)||(Link_Direction!=RIGHT&&Link_x<=Ladder_x-Sprite_w))))
				{	//Remove Ladder if conditions are met.
					for(i=0;i<3;++i)
						Collision_Detection_Buffer[Ladder_Index+Ladder_Tile_Offset[Ladder_Direction][i]]=Ladder_Tiles_Backup[i];
					Replenish_Ladder_BG(Ladder_x,Ladder_y,Graphics16[Ladder_2]);
					Using_Ladder=FALSE;
				}
			}
			else if(Weapons_Possessed&Ladder_BIN)
			{	//Test if ladder should be used.
				if((Link_Direction==UP && Link_y_RMNDR==5 &&
						(Collision_Detection_Buffer[Link_Screen_Index]==D_W ||
						(Link_x_RMNDR && Collision_Detection_Buffer[Link_Screen_Index+1]==D_W)))
					||
					(Link_Direction==DOWN && !Link_y_RMNDR &&
						(Collision_Detection_Buffer[Link_Screen_Index+Screen_w]==D_W ||
						(Link_x_RMNDR && Collision_Detection_Buffer[Link_Screen_Index+Screen_w+1]==D_W)))
					||
					(Link_Direction==LEFT && !Link_x_RMNDR && 
						((!Link_y_RMNDR && Collision_Detection_Buffer[Link_Screen_Index-1]==D_W) ||
						(Link_y_RMNDR && Collision_Detection_Buffer[Link_Screen_Index+Screen_w-1]==D_W)))
					||
					(Link_Direction==RIGHT && !Link_x_RMNDR && 
						((!Link_y_RMNDR && Collision_Detection_Buffer[Link_Screen_Index+1]==D_W) ||
						(Link_y_RMNDR && Collision_Detection_Buffer[Link_Screen_Index+Screen_w+1]==D_W))))
				{	
					Using_Ladder=TRUE;
					Ladder_Direction=Link_Direction&0x01;
					Ladder_x=Link_x+Ladder_x_Offset[Link_Direction];
					Ladder_y=Link_y+Ladder_y_Offset[Link_Direction];
					
					if(Link_x_RMNDR)
						Ladder_x_Aligned=FALSE;
					else
						Ladder_x_Aligned=TRUE;
					if(Link_y_RMNDR)
						Ladder_y_Aligned=FALSE;
					else
						Ladder_y_Aligned=TRUE;
					if(Ladder_Direction)
						Current_Ladder_Alignment=Ladder_y_Aligned;
					else
						Current_Ladder_Alignment=Ladder_x_Aligned;
					Ladder_Index=Link_Screen_Index+Ladder_Index_Offset[Ladder_y_Aligned][Link_Direction];
						
					for(i=0;i<3;++i)
					{
						Ladder_Tiles_Backup[i]=Collision_Detection_Buffer[Ladder_Index+Ladder_Tile_Offset[Ladder_Direction][i]];
						Collision_Detection_Buffer[Ladder_Index+Ladder_Tile_Offset[Ladder_Direction][i]]=Ladder_Tiles[Ladder_Direction][Current_Ladder_Alignment][i];
					}
				}
			}
			
			//Pushblock present algorithm. Check if link pushes it.
			if(PushBlock_Present==PushBlock_Detectable)
			{	//Detect if Link has pressed against the PushBlock for long enough.
				if((World||Weapons_Possessed&Power_Bracelet_BIN)&&
					((PushBlock_Direction&0x01&&Link_y==PushBlock_y&&
						((_rowread(ARROWS_ROW)&LEFT_KEY&&Link_Direction==LEFT&&Link_x==PushBlock_x+Sprite_w)||
						(_rowread(ARROWS_ROW)&RIGHT_KEY&&Link_Direction==RIGHT&&Link_x==PushBlock_x-Sprite_w)))||
					(PushBlock_Direction&0x02&&Link_x==PushBlock_x&&
						((_rowread(ARROWS_ROW)&UP_KEY&&Link_Direction==UP&&Link_y==PushBlock_y+5)||
						(_rowread(ARROWS_ROW)&DOWN_KEY&&Link_Direction==DOWN&&Link_y==PushBlock_y-Sprite_h)))))
				{
					if(Game_Clock-Scroll_ClockRef>128||!World)
					{	//PushBlock pushed. Trigger Pushblock movement and trigger application of pushblock effects (doors, stairwells etc.).
						PushBlock_Present=PushBlock_Pushed;
						PushBlock_Direction=Link_Direction;
						Screen_Tiles_Buffer[PushBlock_Index+Screen_Index_Offset[PushBlock_Direction]]=Screen_Tiles_Buffer[PushBlock_Index];
						Screen_Tiles_Buffer[PushBlock_Index]=PushBlock_Floor;
						Screen_Tiles_Buffer[Stair_Index]=Stair;
						Collision_Detection_Buffer[PushBlock_Index]=Null;
						Collision_Detection_Buffer[PushBlock_Index+Screen_Index_Offset[PushBlock_Direction]]=Block;
						Push_Distance=Sprite_h+(PushBlock_Direction&0x01);
						Draw_Tile(PushBlock_x,PushBlock_y,Map_Tiles[PushBlock_Floor],BG_Planes_BIN);
						PushBlock_Index=0;
						Sprite_Interval<<=1;
					}
				}
				else
					Scroll_ClockRef=Game_Clock;
			}
		
		
			if(Total_Items)
			{
				for(i=0;i<Total_Items;++i)
				{
					if((Active_Items[i].Item)!=Item_Not_Present)
					{
						Current_Item=Active_Items[i].Item;
						Current_Item_Price=Item_Price[i];
						Current_Item_Graphics=Active_Items[i].Item_Graphics[Item_Animation_Flag[i]];
						if(Item_Expire_Time[i]&&Game_Clock-Item_Expire_ClockRef[i]>Item_Expire_Time[i])
						{
							Replenish_Item_BG(Item_x[i],Item_y[i],Graphics16[Current_Item_Graphics]);
							Active_Items[i].Item=Item_Not_Present;
						}
						else if((Current_Item_Price<=0||Rupies_Possessed>=Current_Item_Price) &&
								(Current_Item!=White_Sword||Heart_Containers>=6) && (Current_Item!=Magical_Sword||Heart_Containers>=12) &&
								(Link_Object_Collision(Item_x[i]+Active_Items[i].Item_w_half,Item_y[i]+Active_Items[i].Item_h_half,Link_x,Link_y) ||
								((Current_Item==Item_Black_Bomb || (Current_Item>=Item_Heart && Current_Item<=Item_5xRupy)) && Current_Sword_Stage==Second_Sword_Stage &&
									Sword_Object_Collision(Item_x[i]+Active_Items[i].Item_w_half,Item_y[i]+Active_Items[i].Item_h_half,Sword_x,Sword_y)))
							)
						{
							if(Inside_Shop && Current_Shop==Shop_Gamble)
							{
								Shop_Gamble_SEED=Game_Clock%24;
								for(j=0;j<3;++j)
								{	//Gamble_Prices[4][5] defines digits [10,40,-20,-50] for each case of Gamble_Permutations[24][3]
									Update_Shop_Prices(Current_Shop_Prices[j+1],Gamble_Prices[Gamble_Permutations[Shop_Gamble_SEED][j]],10);
								}
								Current_Item_Price=Current_Shop_Prices[i+1][0];
							}
							
							if(Current_Item_Price<0 && Rupies_Possessed-Current_Item_Price>255)
								Rupies_Spent=Rupies_Possessed-255;
							else
								Rupies_Spent=Current_Item_Price;
							if(Current_Item<=Item_Bracelet)
								Weapons_Possessed|=(unsigned long)1<<Current_Item;	//typecast for bugfix
							switch(Current_Item)
							{
								case (Item_Bomb) :
								{
									if(Bombs_Possessed<Max_Bombs-4)
										Bombs_Possessed+=4;
									else
										Bombs_Possessed=Max_Bombs;
									break;
								}
								case (Item_Black_Bomb) :
								{
									Weapons_Possessed|=Bomb_BIN;
									if(Bombs_Possessed<Max_Bombs-4)
										Bombs_Possessed+=4;
									else
										Bombs_Possessed=Max_Bombs;
									break;
								}
								case (Item_Heart) :
								{
									Hearts+=2;
									break;
								}
								case (Item_Hrt_Cntnr_Add) :
								{
									if(!World && World_Index==95)
										Beach_HrtCntnr_Taken=TRUE;
									if(Heart_Containers<16)
										++Heart_Containers;
									if(Heart_Containers*2-Hearts>2)
										Hearts+=2;
									else
										Hearts=Heart_Containers*2;
									break;
								}
								case (Item_Hrt_Cntnr_Sub) :
								{
									if(Heart_Containers>3)
										--Heart_Containers;
									break;
								}
								case (Item_Fairy) :
								{
									Hearts+=6;
									break;
								}
								case (Item_Clock) :
								{
									///Wait For Enemies
									break;
								}
								case (Item_Rupy) :
								{
									if(!Inside_Shop && Rupies_Possessed<255)
										++Rupies_Possessed;
									break;
								}
								case (Item_5xRupy) :
								{
									if(!Inside_Shop)
									{
										if(Rupies_Possessed<250)
											Rupies_Possessed+=5;
										else
											Rupies_Possessed=255;
									}
									break;
								}
								case (Item_Key) :
								{
									if(Keys_Possessed<99)
										++Keys_Possessed;
									break;
								}
								case (Item_Map) :
								{
									Dungeon_Maps_Compasses[0]|=1<<(Current_Dungeon_Level-1);
									break;
								}
								case (Item_Compass) :
								{
									Dungeon_Maps_Compasses[1]|=1<<(Current_Dungeon_Level-1);
									break;
								}
								case (Item_Triforce) :
								{
									Weapons_Possessed|=Triforce_1_BIN<<(Current_Dungeon_Level-1);
									break;
								}
								case (Item_More_Bombs) :
								{
									Max_Bombs+=4;
									Bombs_Possessed+=4;
									break;
								}
								case (Item_Magical_Shield) :
								{
									Current_Shield=Magical_Shield;
									if(!Link_as_EnemySprite)
										Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];
									break;
								}
							}
							if(Hearts>Heart_Containers<<1)
								Hearts=Heart_Containers<<1;
							Update_Hearts(Not_Using_Potion,Hearts,Heart_Containers,Menu_Planes_BIN);
							Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
							Cursor_Position=Move_Cursor_Position(NOWHERE,Cursor_Position,Weapons_Possessed);
							if(World && !Inside_Portal)	//In dungeon but not treasure room
								Update_Menu_SubTemplates(World,World_Index,Dungeon_Maps_Compasses,Dungeon_Tracker,D_Room_Properties[Current_Save],Dungeon_Levels,Character,
									Triforce_Template,Dungeon_Rough_Map_Template);
							Replenish_Item_BG(Item_x[i],Item_y[i],Graphics16[Current_Item_Graphics]);
							if(D_Room_Properties[Current_Save][World-1][World_Index][4])
							{	//Item appears only once for Auto_Appear items or items appearing after enemies are killed
								j=D_Room_Properties[Current_Save][World-1][World_Index][7]&Auto_Appear;
								if((j && i==0) || (!j && i==Total_Items-1))
									D_Room_Properties[Current_Save][World-1][World_Index][4]=0;
							}
							if(World_Index==Treasure_Room)
								D_Room_Properties[Current_Save][Previous_World-1][Previous_World_Index][7]&=0xC0;	//Preserve Dark_Room and Auto_Appear features when deleting item
							
							//When item is picked up
							if(Inside_Shop)
							{
								if(Current_Shop!=Shop_Gamble)	//Keep flashing "0x" rupy icon in Shop Gamble
									Inside_Shop=Shop_Inactive;
								if(Current_Shop>=Shop_More_Bombs && !Browsing_Shops) //For one-time shops
									Shop_Activity_Record[Shop_World][(Shop_World_Index)>>4] &= ~((unsigned short)1<<(Shop_World_Index&0x0F));
								if(Current_Shop>=Shop_Free_10 && Current_Shop<=Shop_Free_100)
								{
									Item_Price[1]=256;
									for(j=0;j<4;++j)
										Draw_Shop_Prices(29+40+5*j,67,Character[Current_Shop_Prices[2][j+1]],OS_Planes_BIN|BG_Planes_BIN);
								}
								else if(Current_Shop==Shop_Gamble)
								{
									for(i=0;i<3;++i)
									{
										for(j=0;j<4;++j)
											Draw_Shop_Prices(49+20*i+5*j,65,Character[Current_Shop_Prices[i+1][j+1]],
												Gray_Planes_BIN|OS_Planes_BIN|BG_Planes_BIN);
									}
									Item_Price[0]=256;
									Item_Price[1]=256;
									Item_Price[2]=256;
								}
								else if(Current_Shop==Shop_Waterfall_Pay_Talk || Current_Shop==Shop_Tree_Pay_Talk)
								{
									Item_Price[0]=256;
									Item_Price[1]=256;
									Item_Price[2]=256;
									for(j=0;j<7;++j)
										Clear_Shop_Text(25+(j<<4),20,11,0xFFFF,
											LO_Plane_BIN|DO_Plane_BIN|LB_Plane_BIN|DB_Plane_BIN);
									for(j=0;j<5;++j)
										Clear_Shop_Prices(32+(j<<4),63,9,0xFFFF,
											LO_Plane_BIN|DO_Plane_BIN|LB_Plane_BIN|DB_Plane_BIN);
									if(Current_Shop==Shop_Waterfall_Pay_Talk)
									{
										if(Current_Item_Price==20)
											i=Shop_Text_Mountain_Maze;
										else
											i=Shop_Text_Poor;
									}
									if(Current_Shop==Shop_Tree_Pay_Talk)
									{
										if(Current_Item_Price==10)
											i=Shop_Text_Poor;
										else if(Current_Item_Price==30)
											i=Shop_Text_Forest_Maze;
										else
											i=Shop_Text_Rich;
									}
									Shop_Text_ClockRef=Game_Clock;
									Current_Shop_Characters=Shop_Characters[i];
									Shop_Text_x=*Current_Shop_Characters;
									Shop_Text_y=20;
									++Current_Shop_Characters;
								}
								else
									Total_Items=0;
								if((Current_Shop>=Shop_Items_1 && Current_Shop<=Shop_More_Bombs) || Current_Shop>=Shop_Hungry_Goriya)
								{
									Shopkeeper_Flickering=TRUE;
									Shopkeeper_ClockRef=Game_Clock;
									Shopkeeper_Flicker_Counter=0;
									for(j=0;j<7;++j)
										Clear_Shop(24+(j<<4),20,52,0xFFFF,LO_Plane_BIN|DO_Plane_BIN|LB_Plane_BIN|DB_Plane_BIN);
								}
								if(Current_Shop<=Shop_Free_100)
								{
									Flash_Submenu=Open_Flash_Submenu;
									Flash_Submenu_ClockRef=Game_Clock;
									Store_Current_Screen(Current_Screen_Buffer);
									Scroll_Index=0;	//Used as dummy for Flash_Submenu scroll-out counter
								}
							}
							else
								Active_Items[i].Item=Item_Not_Present;
								
								
							//Initialization for lifting items after pick up.
							if(World_Index==Treasure_Room || Current_Item==Item_Triforce || 
								(Inside_Shop && ((Current_Shop>=Shop_Items_1 && Current_Shop<=Shop_Potion) || Current_Shop>=Shop_Wooden_Sword)))
							{
								Lifting_Item=TRUE;
								Lifted_Item_ClockRef=Game_Clock;
								Lifted_Item_y=Link_y-Sprite_h;
								Replenish_Link_BG(Link_x,Link_y,Current_Link);
								if(Current_Item==Item_Triforce)
								{
									Link_x=75;
									Link_y=49;
									Lifted_Item_x=76;
									Lifted_Item_y=42;
									Current_Item_Graphics=Triforce_Dark;
									if(!Link_as_EnemySprite)
										Current_Link=Link_Strike[Lift_Triforce];
									Triforce_Curtains=TRUE;
									Scroll_ClockRef=Game_Clock;
								}
								else
								{
									Lifted_Item_x=Link_x;
									if(!Link_as_EnemySprite)
										Current_Link=Link_Strike[Lift_Item];
								}
								Draw_Item(Lifted_Item_x,Lifted_Item_y,Graphics16[Current_Item_Graphics],OS_Planes_BIN);
							}
						}
						else
						{
							Replenish_Item_BG(Item_x[i],Item_y[i],Graphics16[Current_Item_Graphics]);
							if(Current_Item!=Item_Rupy && Item_Animation_Time[i] && Game_Clock-Item_Animation_ClockRef[i]>Item_Animation_Time[i])
							{
								Item_Animation_Flag[i]=!Item_Animation_Flag[i];
								Item_Animation_ClockRef[i]=Game_Clock;
								Current_Item_Graphics=Active_Items[i].Item_Graphics[Item_Animation_Flag[i]];
							}
							else if(Current_Item==Item_Rupy)
								Current_Item_Graphics=Active_Items[i].Item_Graphics[Rupy_Animation_Flag];
							Draw_Item(Item_x[i],Item_y[i],Graphics16[Current_Item_Graphics],OS_Planes_BIN);
						}
					}
				}
			}
			
			if(Inside_Shop && Dark_Room!=Turning_Lights_On)
			{
				if(Game_Clock-Shop_Candle_ClockRef>40)
				{
					Shop_Candle_ClockRef=Game_Clock;
					Shop_Candle_Animation=!Shop_Candle_Animation;
				}
				for(i=0;i<2;++i)
					Draw_Candle(40+70*i,36,Graphics16[Shop_Fire+Shop_Candle_Animation],OS_Planes_BIN|BG_Planes_BIN);
				if(Inside_Shop==Shop_Active && Current_Shop<=Shop_More_Bombs && (Current_Shop!=Shop_Potion || Letter_Shown))
					Draw_Shop_Rupy(32,63,Graphics16[Rupy_Light+Rupy_Animation_Flag],OS_Planes_BIN|BG_Planes_BIN);
				if(Inside_Shop==Just_Entered_Shop)
				{
					if(Shop_Activity_Record[Shop_World][(Shop_World_Index)>>4] & ((unsigned short)1<<(Shop_World_Index&0x0F)))
						Inside_Shop=Shop_Active;
					else
						Inside_Shop=Shop_Inactive;
					
					if((Current_Shop!=Shop_Hungry_Goriya && Current_Shop!=Shop_L9A) || Inside_Shop==Shop_Active)
						Set_Shop_Boundaries(Collision_Detection_Buffer+64,N_1,14); //Walking past candles or shopkeeper not permitted
					
					if(Inside_Shop==Shop_Active)
					{	//Initialize active shop
						Draw_Shopkeeper(75,36,Graphics16[Shop_Info[Current_Shop][Shopkeeper]],OS_Planes_BIN|BG_Planes_BIN);
						if(Current_Shop!=Shop_Potion || Letter_Shown)	//No Medicine for sale if Old Woman has not been shown the Letter
						{
							Update_Shop_Prices(Current_Shop_Prices,Shop_Prices[Current_Shop],40);
							for(i=0;i<3;++i)
							{
								Load_Item(&Active_Items[i],Item_Data[Shop_Info[Current_Shop][i]],Size_of_Item_Struct);
							  Item_Expire_Time[i]=0;
							  Item_x[i]=57+20*i;
							  Item_y[i]=54;
							  Item_Animation_Flag[i]=0;
							  Item_Animation_Time[i]=128;
							  Item_Expire_Time[i]=0;
							  Item_Animation_ClockRef[i]=Game_Clock;
							  if(Active_Items[i].Item!=Item_Not_Present)
									Draw_Item(Item_x[i],Item_y[i],Graphics16[Active_Items[i].Item_Graphics[0]],Gray_Planes_BIN);
							  Item_Price[i]=Current_Shop_Prices[i+1][0];
							  if(Current_Shop>Shop_Free_100)
							  	Item_Price[i]=0;
								++Total_Items;
							}
							if(Current_Shop<=Shop_More_Bombs)
							{
								for(i=0;i<4;++i)
								{
									for(j=0;j<4;++j)
										Draw_Shop_Prices(29+20*i+5*j,65,Character[Current_Shop_Prices[i][j+1]],Gray_Planes_BIN|OS_Planes_BIN|BG_Planes_BIN);
								}
							}
							Printing_Shop_Text=TRUE;
							Shop_Text_ClockRef=Game_Clock;
							Current_Shop_Characters=Shop_Characters[Shop_Info[Current_Shop][Shop_Text]];
							Shop_Text_x=*Current_Shop_Characters;
							Shop_Text_y=20;
							++Current_Shop_Characters;
						}
						
						//Shop_Door_Repair
						if(Current_Shop==Shop_Door_Repair)
						{
							if(Rupies_Possessed>=20)
								Rupies_Spent=20;
							else
								Rupies_Spent=Rupies_Possessed;
							Update_Countable_Items(Rupies_Possessed,Keys_Possessed,Bombs_Possessed,(Weapons_Possessed&Magical_Key_BIN)>>22,Character,Menu_Planes_BIN);
							if(!Browsing_Shops)
								Shop_Activity_Record[Shop_World][(Shop_World_Index)>>4] &= ~((unsigned short)1<<(Shop_World_Index&0x0F));
							
							//Initialize Flash_Submenu
							Flash_Submenu=Open_Flash_Submenu;
							Flash_Submenu_ClockRef=Game_Clock;
							Store_Current_Screen(Current_Screen_Buffer);
							Scroll_Index=0;	//Used as dummy for Flash_Submenu scroll-out counter
						}
						
						//Shop_Warp
						if(Current_Shop==Shop_Warp)
						{
							for(i=0;i<3;++i)
							{
								Draw_Tile(50+25*i,54,Map_Tiles[Stair_G],OS_Planes_BIN|BG_Planes_BIN);
							}
						}
					}	//End of active shop initialization
				}	//End of if(Inside_Shop==Just_Entered_Shop)
				
				//Loop shop text printing
				if(Printing_Shop_Text && (TimeBypass || Game_Clock-Shop_Text_ClockRef>24))
				{
					Shop_Text_ClockRef=Game_Clock;
					if(*Current_Shop_Characters==Char_Return)
					{
						Shop_Text_y+=6;
						++Current_Shop_Characters;
						Shop_Text_x=*Current_Shop_Characters;
						++Current_Shop_Characters;
					}
					
					Print_Character(Shop_Text_x,Shop_Text_y,Character[*Current_Shop_Characters],OS_Planes_BIN|BG_Planes_BIN);
					Shop_Text_x+=5;
					++Current_Shop_Characters;
					
					if(*Current_Shop_Characters==Char_End)
						Printing_Shop_Text=FALSE;
				}	
				
				//Complete triforce needed to enter L9
				if(Current_Shop==Shop_L9A && Inside_Shop==Shop_Active && !Printing_Shop_Text && (Weapons_Possessed&Triforces_BIN)==Triforces_BIN)
				{
					if(!Browsing_Shops)
						Shop_Activity_Record[Shop_World][(Shop_World_Index)>>4] &= ~((unsigned short)1<<(Shop_World_Index&0x0F));
					Release_Shop_Boundaries(Collision_Detection_Buffer+64,Cave,14);
					Shopkeeper_Flickering=TRUE;
					Shopkeeper_ClockRef=Game_Clock;
					for(j=0;j<12;++j)
					{
						Clear_Shop_Text(20+10*j,20,11,0xFFC0,
							LO_Plane_BIN|DO_Plane_BIN|LB_Plane_BIN|DB_Plane_BIN);
					}
					Inside_Shop=Shop_Inactive;
					
					D_Room_Properties[Current_Save][World-1][World_Index][UP]=DD_Open;
					D_Room_Properties[Current_Save][World-1][World_Index][LEFT]=DD_Open;
					Define_D_Door_Tiles(Link_Direction,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
					Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
					Update_Doors(Dark_Room,&D_Room_Properties[Current_Save][World-1][World_Index][0],Map_Tiles);
				}
			}	//End of if(Inside_Shop)
			
			//Beginning of Portals
			if(Link_y_RMNDR||(Link_x_RMNDR&&Link_x_RMNDR!=Sprite_w/2)||(_rowread(ARROWS_ROW)&DOWN_KEY&&Link_y==90))
				Portal_Open=TRUE;
			if(Portal_Open&&(
				(Inside_Portal && ((Link_y==90 && Link_Direction==DOWN) || (Link_y==0 && Link_Direction==UP))) ||	//Exit dungeon underpass, dungeon treasure room or overworld shop
				(!Link_y_RMNDR && (
					(!World && World_Index!=Shop_Room && Collision_Detection_Buffer[Link_Screen_Index]==Cave && (!Link_x_RMNDR || Link_x_RMNDR==Sprite_w/2)) ||	//Overworld cave/dungeon entrance
					(Collision_Detection_Buffer[Link_Screen_Index]==Stair && Link_x_RMNDR==0))) ||		//Overworld staircase
				(Inside_Shop && Current_Shop==Shop_Warp && Link_y==54 && (Link_x==50 || Link_x==75 || Link_x==100)) ||	//Enter shop warp
				(Link_x==75 && Collision_Detection_Buffer[Link_Screen_Index]==SS_7_D && (World_Index)>111)))	//Dungeon exit
			{
				/*
				DEFINED ALREADY. REPEATED HERE FOR REFERENCE.
					static unsigned char Portals[3][128][4]= {
				//[0] unsigned char World;					 &0x03=World (Overworld, Dungeon_1, Dungeon_2)			&0x80=Link is on the right side of a dungeon underpass
				//[1] unsigned char World_Index;
				//[2] unsigned char Link_x;
				//[3] unsigned char Link_y;
				*/
				
				Portal_Open=FALSE;
				goto Scroll_Prep;
				Portal:	//Execution returns here immediately after Scroll_Prep
				Replenish_Link_BG(Link_x,Link_y,Current_Link);
				FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
				
				//Slide Link into portal entrance if required.
				if(Collision_Detection_Buffer[Link_Screen_Index]==Cave && Link_y!=54)	//Entering overworld cave but not using Shop_Warp
					Slide_Link(Link_Hide,DOWN,Link_x,Link_y,Sprite_Interval<<1,&Game_Clock,Current_Link);
				///Link sliding out of dungeon underground passage screen. Creates Error By Writing Outside Of Boundaries. Needs to be implemented some day.
				//This type of function will likely be needed in the future for enemies coming from outside the screen. Implement with enemies.
				//if(Collision_Detection_Buffer[Link_Screen_Index]==L_D)	
				//	Slide_Link(Link_Slide,UP,Link_Direction,Link_x,Link_y,Link_Animation,Current_Shield,Sprite_Interval,&Game_Clock,Link);
				
				//Determine whether a portal is being entered or exited and what type of portal is currently active.
				if(!Inside_Portal)
				{	//Entering portal
					
					//Save Link's previous location when entering a portal.
					Previous_World=World;
					Previous_World_Index=World_Index;
					Previous_Link_x=Link_x;
					Previous_Link_y=Link_y;
					
					//Obtain the World_Index being pointed to from Portals[] and determine which portal has been entered based on this.
					i=Portals[World][World_Index][1];
					if(i==Shop_Room)
					{	//Entering Overworld Shop
						Inside_Portal=TRUE;
						///World=Overworld; not needed since Shop room is always in overworld?
						World_Index=Shop_Room;
						Link_x=75;
						Link_y=90;
					}
					else if(i==Treasure_Room)
					{	//Entering Dungeon Treasure Room
						Inside_Portal=TRUE;
						Current_Item=D_Room_Properties[Current_Save][World-1][World_Index][7]&0x3F;
						if(Current_Item)
						{
							Total_Items=1;
							Load_Item(&Active_Items[0],Item_Data[Current_Item],Size_of_Item_Struct);
							Item_x[0]=80;
							Item_y[0]=45;
							Item_Price[0]=0;
	  					Item_Expire_Time[0]=0;
						}
						World=Dungeon_1;
						World_Index=Treasure_Room;
						Link_x=Sprite_w*3;
						Link_y=0;
					}
					else if(World && Collision_Detection_Buffer[Link_Screen_Index]==Stair)
					{	//Entering Dungeon Underpass
						Inside_Portal=TRUE;
						if(Portals[World][World_Index][0]&0x80)
							Link_x=LCD_w-Sprite_w*4;
						else
							Link_x=Sprite_w*3;
						Tornado_x=Link_x;	//Used temporarily to determine which exit was used in underpass.
						Link_y=0;
						World=Dungeon_1;
						World_Index=Dungeon_Underpass;
					}
					else
					{	//Entering/exiting a dungeon
						Dungeon_Completed:	//Jump here after a triforce is obtained.
						World=Portals[Previous_World][Previous_World_Index][0]&0x03;	///Previous used for "calculation order". Possible to not use previous in some cases.
						World_Index=Portals[Previous_World][Previous_World_Index][1];
						Link_x=Portals[Previous_World][Previous_World_Index][2];
						Link_y=Portals[Previous_World][Previous_World_Index][3];
					}
				}	//End of if(!Inside_Portal)
				else
				{ //Inside_Portal==TRUE ("Previous" locations are available from "Portal Entry")
					if(World_Index==Shop_Room)
					{	//Either exiting overworld shop or using a shop warp
						if(Link_y==54)
						{	//Warped in Shop_Warp
							World=Overworld;
							j=Link_x/25-2;
							switch(Previous_World_Index)
							{	//Determine the warp map based on which warp location was entered
								case (Beach_Warp_World_Index) :
								{	//then compute the warp destination based on staircase entered
									World_Index=Beach_Warp[j];
									break;
								}
								case (Fairy_Warp_World_Index) :
								{
									World_Index=Fairy_Warp[j];
									break;
								}
								case (L5_Warp_World_Index) :
								{
									World_Index=L5_Warp[j];
									break;
								}
								case (L6_Warp_World_Index) :
								{
									World_Index=L6_Warp[j];
									break;
								}
							}
							switch(World_Index)
							{	//Determine Link's position after warping
								case (Beach_Warp_World_Index) :
								{
									Link_x=60;
									Link_y=27;
									break;
								}
								case (Fairy_Warp_World_Index) :
								{
									Link_x=30;
									Link_y=27;
									break;
								}
								case (L5_Warp_World_Index) :
								{
									Link_x=20;
									Link_y=27;
									break;
								}
								case (L6_Warp_World_Index) :
								{
									Link_x=40;
									Link_y=18;
									break;
								}
							}
							Discovered_Pathways[World_Index/World_w]|=(0x01<<(World_Index&0x0F));
						}
						else
						{	//Exiting an overworld shop
							World=Overworld;
							World_Index=Previous_World_Index;
							Link_x=Portals[Previous_World][Previous_World_Index][2];
							Link_y=Portals[Previous_World][Previous_World_Index][3];
						}
					}	//End of if(World_Index==Shop_Room)
					else if(World_Index==Treasure_Room)
					{	//Exiting Underworld Treasure Room
						World=Previous_World;
						World_Index=Previous_World_Index;
						Link_x=Portals[World][World_Index][2];
						Link_y=Portals[World][World_Index][3];
					}
					else
					{	//Exiting Dungeon Underpass
						if((Link_x<LCD_w/2&&Tornado_x<LCD_w/2)||(Link_x>LCD_w/2&&Tornado_x>LCD_w/2))
						{	//Link returned where he entered from. Revert back to previous location.
							World=Previous_World;
							World_Index=Previous_World_Index;
							i=Portals[World][World_Index][1];
							Link_x=Portals[Previous_World][i][2];
							Link_y=Portals[Previous_World][i][3];
						}
						else
						{	//Link went through the underpass and the new screen is determined from Portals[].
							World=Portals[Previous_World][Previous_World_Index][0]&0x03;
							World_Index=Portals[Previous_World][Previous_World_Index][1];
							Link_x=Portals[Previous_World][Previous_World_Index][2];
							Link_y=Portals[Previous_World][Previous_World_Index][3];
						}
					}
					Inside_Portal=FALSE;
				}
				//End of initialization for travelling through portals (World, World_Index, Link_x, Link_y etc. are all now known)
				
				Link_Screen_Index=((Link_y/Sprite_h)<<4)+Link_x/Sprite_w;
					
				
				//Algorithm to darken dungeon rooms/underpasses/treasure rooms while leaving previous screen.
				if(World && Previous_World)
				{	//Entered/exited a dungeon treasure room or dungeon underpass.
					Scroll_ClockRef=Global_Clock;
					if(Inside_Portal)	//Exiting dungeon treasure room or dungeon underpass.
						Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
					else	//Entering dungeon treasure room or dungeon underpass.
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(!(Global_Clock-Scroll_ClockRef>64)) {}
					
					if(Inside_Portal)
					{	//Exiting dungeon treasure room or dungeon underpass.
						Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
						Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,DO_Plane_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						while(!(Global_Clock-Scroll_ClockRef>128)) {}
					}
					
					Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
					if(Inside_Portal)
					{	//Exiting dungeon treasure room or dungeon underpass.
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
						Darken_Room(Battle_Area_Luminosity|Synchronize_OpenDoors,Screen_Tiles_Buffer,DO_Plane_BIN);
					}
					else	//Entering dungeon treasure room or dungeon underpass.
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,DO_Plane_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(!(Global_Clock-Scroll_ClockRef>192)) {}
						
					Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
					Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN|DO_Plane_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(!(Global_Clock-Scroll_ClockRef>255)) {}
				}
				//End of algorithm to modify dungeon room darkness.
				
				//Define the Screen_Tiles_Buffer.
				if(World_Index==Shop_Room)
					ptr=Screen_Map_Special[0];
				else if(World_Index==Dungeon_Underpass)
					ptr=Screen_Map_Special[1];
				else if(World_Index==Treasure_Room)
					ptr=Screen_Map_Special[2];
				else if(World)
					ptr=Screen_Map_Special[3];
				else
					ptr=Screen_Map_Over[World_Index];
				Update_Screen_Tiles_Buffer(Screen_Tiles_Buffer,ptr,Size_of_Screen_Tiles_Buffer);
				
				//Define the central 12x7 tiles of a dungeon room.
				if(World && !Inside_Portal)
				{
					ptr=&Screen_Tiles_Buffer[34];
					for(i=0;i<84;++i)
					{
						*ptr++=Screen_Map_D[World-1][World_Index][i];
						if((i+1)%12==0)
							ptr+=4;
					}
				}
				
				//Define the dungeon door tiles (applies when exiting dungeon treasure room or dungeon underpass)
				if(World && !Inside_Portal)
					Define_D_Door_Tiles(NOWHERE,D_Room_Properties[Current_Save][World-1][World_Index],Screen_Tiles_Buffer);
				
				//Copy the Screen_Tiles_Buffer to the Collision_Detection_Buffer
				Update_Collision_Detection_Buffer(Collision_Detection_Buffer,Screen_Tiles_Buffer,Size_of_Collision_Detection_Buffer);
				
				//Make sure Link "stays on the ground" in Dungeon_Underpass and Treasure_Room
				if(World_Index==Dungeon_Underpass || World_Index==Treasure_Room)
				{
					for(i=0;i<176;++i)
					{
						if(Collision_Detection_Buffer[i]==Cave && Collision_Detection_Buffer[i+16]==Cave)
							Collision_Detection_Buffer[i]=N_1;
					}
				}
				
				//Make adjustments to collision detection for overworld secret "walkthrough" paths.
				if(!World && World_Index!=Shop_Room)
				{
					Cover_Undiscovered_Pathways(World_Index,Discovered_Pathways,Overworld_Pathways,Push_Blocks,Collision_Detection_Buffer,Screen_Tiles_Buffer);
					if(World_Index==26)	//Waterfall
						Collision_Detection_Buffer[70]=Stair;
					if(World_Index==31)
					{	//Top-Right Corner
						Collision_Detection_Buffer[8]=Null;
						Collision_Detection_Buffer[24]=Null;
					}
					if(Collision_Detection_Buffer[Link_Screen_Index]==Cave)
						Collision_Detection_Buffer[Link_Screen_Index-Screen_w]=N_1;	//Ensure Link can only go down after exiting to the overworld from a cave.
				}
				
				Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN|BG_Planes_BIN);
				
						
				//Open curtains if entering/exiting dungeon
				if( (!World && Previous_World) || Screen_Tiles_Buffer[Link_Screen_Index]==S_6_D)	//Note: Previous_World=0 when inside shops (key difference)
					Open_Curtains(&Global_Clock);	//When entering/exiting dungeons
				else if(World)
				{	//Algorithm to lighten dungeon rooms/underpasses/treasure rooms while entering new screen.
					Scroll_ClockRef=Global_Clock;	//Scroll_ClockRef used as dummy here
					if(Inside_Portal)
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,DO_Plane_BIN);
					else
					{
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
						Darken_Room(Battle_Area_Luminosity|Synchronize_OpenDoors,Screen_Tiles_Buffer,DO_Plane_BIN);
					}
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(!(Global_Clock-Scroll_ClockRef>64)) {}
					
					Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
					if(Inside_Portal)
						Darken_Room(Screen_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
					else
						Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,DO_Plane_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(!(Global_Clock-Scroll_ClockRef>128)) {}
					
					if(!Inside_Portal)
					{
						Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
						Darken_Room(Battle_Area_Luminosity,Screen_Tiles_Buffer,LO_Plane_BIN);
						FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
						FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
						while(!(Global_Clock-Scroll_ClockRef>192)) {}
					}
					Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
				}	//End of algorithm to lighten dungeon rooms/underpasses/treasure rooms while entering new screen.
				else 
				{	//Show black screen briefly when entering/exiting shop or going through a shop portal
					memset(Oversized_Buffer[0],0xFF,2970);
					memset(Oversized_Buffer[1],0xFF,2970);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					Scroll_ClockRef=Game_Clock;
					while(Game_Clock-Scroll_ClockRef<128) {}
					Draw_Screen(Map_Tiles,Screen_Tiles_Buffer,OS_Planes_BIN);
					FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
					FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
					while(Game_Clock-Scroll_ClockRef<192) {}
				}	//End of Lighten Dungeon Room / Open Curtains
				
				//Determine whether "current" or "previous" information should be used for Update_Menu_SubTemplates() and XOR_Menu_Map() below.
				if(World_Index==Shop_Room)
				{	//Update menu when in shop from overworld
					i=Previous_World;
					j=Previous_World_Index;
				}
				else if(!World)
				{	//Update menu when in overworld
					i=World;
					j=World_Index;
				}
				else if(!Inside_Portal)
				{	//Update menu when in dungeon but not in Treasure_Room or Dungeon_Underpass
					i=World;
					j=World_Index;
					Current_Dungeon_Level=Dungeon_Levels[World-1][World_Index];	//Required for dungeon entrances
					Dungeon_Tracker[World-1][World_Index>>4]|=(1<<(15-(World_Index&0x0F)));
				}
				else
				{	//Update menu when in Treasure_Room or Dungeon_Underpass
					i=Previous_World;
					j=Previous_World_Index;
					Current_Dungeon_Level=Dungeon_Levels[Previous_World-1][Previous_World_Index];
				}
				Update_Menu_SubTemplates(i,j,Dungeon_Maps_Compasses,Dungeon_Tracker,D_Room_Properties[Current_Save],Dungeon_Levels,Character,
					Triforce_Template,Dungeon_Rough_Map_Template);
				if(!World)
				{
					XOR_Menu_Map(Menu_Buffer[1],Menu_Map_x+((j&0x0F)<<1),Menu_Map_y+((j>>3)&0xFE));	//Need j value but must be executed after Update_Menu_SubTemplates()
					Update_Triforces(Weapons_Possessed,Triforces,Menu_Planes_BIN);
				}
				//End of menu updates.
				
				//Adjust Link_Direction and Slide_Link if necessary.
				Link_Direction=DOWN;
				if(World_Index==Shop_Room || Collision_Detection_Buffer[Link_Screen_Index]==S_6_D)	//Face Link up if entering dungeon or shop
					Link_Direction=UP;	
				if(!Link_as_EnemySprite)
					Current_Link=Link[Current_Shield][Link_Direction][Link_Animation];	//Update Link graphics
				else if(Link_EnemySprite<17)
					Current_Link=Enemies4D[Link_EnemySprite][Link_Direction][Link_Animation];
				if(Collision_Detection_Buffer[Link_Screen_Index]==Cave)	//Slide Link if exiting to the overworld.
					Slide_Link(Link_Appear,UP,Link_x,Link_y+9,Sprite_Interval+10,&Game_Clock,Current_Link);
				if(Collision_Detection_Buffer[Link_Screen_Index]==S_6_D)	//Slide Link if entering dungeon.
					Slide_Link(Link_Appear,UP,Link_x,Link_y+9,Sprite_Interval,&Game_Clock,Current_Link);
				
				//Trigger shop initialization if required.
				if(World_Index==Shop_Room)
				{
					Inside_Shop=Just_Entered_Shop;
					Shop_World=Previous_World;
					Shop_World_Index=Previous_World_Index;
					Current_Shop=Shop_From_World_Index[Previous_World][Previous_World_Index];
				}
				
				goto Post_Scroll;
				/*
				
				//Initialize PushBlocks if present.
				PushBlock_Index=Push_Blocks[World][World_Index][0];
				if(PushBlock_Index)
				{
					PushBlock_Present=PushBlock_Detectable;
					PushBlock_x=Push_Blocks[World][World_Index][1];
					PushBlock_y=Push_Blocks[World][World_Index][2];
					Stair_Index=Push_Blocks[World][World_Index][3];
					PushBlock_Floor=Push_Blocks[World][World_Index][5];
					PushBlock_Direction=Push_Blocks[World][World_Index][6];
					PushBlock_Type=Screen_Tiles_Buffer[PushBlock_Index];
				}
				*/
			}	//End of Portals
		}	//End Of Sprite_Interval executions
		
		if(Game_In_Progress && !Warped_By_Recorder)
			Draw_Link(Link_x,Link_y,Current_Link,OS_Planes_BIN);
		if(World)	//Appear Under Doorframes Effect
		{
			if(Link_y<Sprite_h)
				Replenish_Link_BG(75,0,Graphics16[Shop_Stair]);
			else if(Link_x<Sprite_w)
				Replenish_Link_BG(0,45,Graphics16[Shop_Stair]);
			else if(Link_y>LCD_h-1-Sprite_h*2)
				Replenish_Link_BG(75,90,Graphics16[Shop_Stair]);
			else if(Link_x>LCD_w-Sprite_w*2)
				Replenish_Link_BG(150,45,Graphics16[Shop_Stair]);
		}
		
		if(TimeBypass)
		{
			++Refresh_Counter;
			if(Refresh_Counter==4)
				Refresh_Counter=0;
		}
		if(!TimeBypass || Refresh_Counter==3)
		{
			FastCopyScreen_M(Oversized_Buffer[0],Light_Plane);
			if(!BombShock_Present)
				FastCopyScreen_M(Oversized_Buffer[1],Dark_Plane);
		}
	}	//End of Game Loop. Biggest Loop.
	
	
				
	Cleanup:	//Shut Off Grayscale,Correct Redirected HANDLERS,Restore LCD Content,Free Allocated Memory
	PortSet((void *)0x4C00,239,127);
	GrayAdjust(Default_Plane_Freq);
	if(Calc_ID[1]==51)
	{
		OSContrastUp();
		OSContrastUp();
		OSContrastUp();
		OSContrastUp();
	}
	GrayOff();
	SetIntVec(AUTO_INT_1,save_int_1);
	SetIntVec(AUTO_INT_5,save_int_5);
  LCD_restore(LCD);
	ST_helpMsg("Legend of Zelda 0.7-alpha");
	
	Not_Enough_Memory:	//Just Free Allocated Memory
	if(Oversized_Buffer)						free((unsigned char*)Oversized_Buffer-272);
	if(Current_Screen_Buffer)				free(Current_Screen_Buffer);
	if(Current_Background_Buffer) 	free(Current_Background_Buffer);
	if(Menu_Buffer)									free(Menu_Buffer);
	if(Screen_Tiles_Buffer)					free(Screen_Tiles_Buffer);
	if(Collision_Detection_Buffer)	free(Collision_Detection_Buffer);
	if(D_Room_Properties)						free(D_Room_Properties);
	UnloadDLL();
	
	if(Decompress&Decompress_Data1)
	{
		EM_moveSymFromExtMem(SYMSTR("LoZ_Dat1"),HS_NULL);
		SymDel(SYMSTR("LoZ_Dat1"));
	}
	if(Decompress&Decompress_Data2)
	{
		EM_moveSymFromExtMem(SYMSTR("LoZ_Dat2"),HS_NULL);
		SymDel(SYMSTR("LoZ_Dat2"));
	}
	if(Decompress&Decompress_Data3)
	{
		EM_moveSymFromExtMem(SYMSTR("LoZ_Dat3"),HS_NULL);
		SymDel(SYMSTR("LoZ_Dat3"));
	}
	if(Decompress&Decompress_DLL)
	{
		EM_moveSymFromExtMem(SYMSTR("LofZ_DLL"),HS_NULL);
		SymDel(SYMSTR("LofZ_DLL"));
	}
	
	//HS_freeAll();	//Clears the TIOS history
	return;
}
